/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.validator;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.codeplayer.util.X;
import me.codeplayer.validator.PropertyAccessor;

public class Pipeline<T, R>
implements PropertyAccessor<T, R> {
    public static final Object OK = new Object();
    protected transient T bean;
    protected transient Function<? super T, R> getter;
    protected transient BiConsumer<? super T, R> setter;
    protected transient R val;
    protected transient Object result = OK;
    protected transient boolean silent;

    public Pipeline(T bean) {
        this.bean = bean;
    }

    public <N, E> Pipeline<N, E> begin(N newBean, Function<? super N, E> getter, @Nullable BiConsumer<? super N, E> setter) {
        this.bean = X.castType(newBean);
        this.getter = (Function)X.castType(getter);
        this.setter = (BiConsumer)X.castType(setter);
        this.resetForNewProperty();
        return (Pipeline)X.castType(this);
    }

    public <N, E> Pipeline<N, E> begin(N newBean, Function<? super N, E> getter) {
        return this.begin(newBean, getter, null);
    }

    public Pipeline<T, R> begin(T newBean) {
        this.bean = newBean;
        return this;
    }

    public <N, E> Pipeline<N, E> begin(Function<? super N, E> getter, @Nullable BiConsumer<? super N, E> setter) {
        this.getter = (Function)X.castType(getter);
        this.setter = (BiConsumer)X.castType(setter);
        this.resetForNewProperty();
        return (Pipeline)X.castType(this);
    }

    public <N, E> Pipeline<N, E> begin(PropertyAccessor<? super N, E> accessor) {
        return this.begin(accessor.getGetter(), accessor.getSetter());
    }

    public <E> Pipeline<T, E> begin(Function<? super T, E> getter) {
        return this.begin(getter, (BiConsumer)null);
    }

    public Pipeline<T, R> silent(boolean silent) {
        this.silent = silent;
        return this;
    }

    public Pipeline<T, R> silent() {
        return this.silent(true);
    }

    protected boolean canNext() {
        if (!this.isOK()) {
            return false;
        }
        if (this.silent && this.bean == null) {
            this.result = null;
            return false;
        }
        return true;
    }

    protected void resetForNewProperty() {
        this.result = OK;
        this.val = this.getter == null || this.bean == null && this.silent ? null : this.getter.apply((T)this.bean);
    }

    public Pipeline<T, R> apply(Function<? super R, R> validator) {
        if (this.canNext()) {
            R val = this.val;
            if (this.silent) {
                try {
                    val = validator.apply(val);
                }
                catch (Throwable e) {
                    this.result = e;
                }
            } else {
                val = validator.apply(val);
            }
            if (this.setter != null) {
                this.setter.accept(this.bean, val);
            }
        }
        return this;
    }

    public Pipeline<T, R> applyIf(Predicate<? super R> precondition, Function<? super R, R> validator) {
        return this.apply((? super R val) -> precondition.test((Object)val) ? validator.apply((Object)val) : val);
    }

    public Pipeline<T, R> apply(Consumer<? super T> validator) {
        if (this.canNext()) {
            if (this.silent) {
                try {
                    validator.accept(this.bean);
                }
                catch (Throwable e) {
                    this.result = e;
                }
            } else {
                validator.accept(this.bean);
            }
            if (this.getter != null) {
                this.val = this.getter.apply(this.bean);
            }
        }
        return this;
    }

    public Pipeline<T, R> applyIf(Predicate<? super T> precondition, Consumer<? super T> validator) {
        return this.apply((? super T t) -> {
            if (precondition.test(t)) {
                validator.accept(t);
            }
        });
    }

    public Pipeline<T, R> applyIfValue(Consumer<? super T> validator, Predicate<? super R> precondition) {
        return this.apply((? super T t) -> {
            R val = this.getter.apply(t);
            if (precondition.test((R)val)) {
                validator.accept(t);
            }
        });
    }

    public Pipeline<T, R> applyValueIf(Predicate<? super R> precondition, Consumer<? super R> validator) {
        return this.apply((? super R val) -> {
            if (precondition == null || precondition.test((Object)val)) {
                validator.accept((Object)val);
            }
            return val;
        });
    }

    public Pipeline<T, R> applyValue(Consumer<? super R> validator) {
        return this.applyValueIf(null, validator);
    }

    protected Pipeline<T, R> assertInternal(Supplier<Boolean> validator, @Nullable Object throwsError) {
        if (this.canNext()) {
            boolean matches;
            if (this.silent) {
                try {
                    matches = validator.get();
                }
                catch (Throwable e) {
                    this.result = e;
                    matches = false;
                }
            } else {
                matches = validator.get();
            }
            if (!matches && this.isOK()) {
                this.result = throwsError;
                throwsError = null;
            }
            if (!this.silent && !this.isOK()) {
                Pipeline.tryThrow(throwsError, this.result);
            }
        }
        return this;
    }

    public Pipeline<T, R> asserts(Predicate<? super R> validator, @Nullable Supplier<?> throwsError) {
        return this.assertInternal(() -> validator.test((R)this.getter.apply(this.bean)), throwsError);
    }

    public Pipeline<T, R> asserts(Predicate<? super R> validator, @Nullable CharSequence charSequence) {
        return this.assertInternal(() -> validator.test((R)this.getter.apply(this.bean)), charSequence);
    }

    public Pipeline<T, R> asserts(Predicate<? super R> validator) {
        return this.asserts(validator, (Supplier)null);
    }

    public Pipeline<T, R> assertsNot(Predicate<? super R> validator, @Nullable Supplier<?> throwsError) {
        return this.assertInternal(() -> !validator.test((R)this.getter.apply(this.bean)), throwsError);
    }

    public Pipeline<T, R> assertsNot(Predicate<? super R> validator, @Nullable CharSequence charSequence) {
        return this.assertInternal(() -> !validator.test((R)this.getter.apply(this.bean)), charSequence);
    }

    public Pipeline<T, R> assertsNot(Predicate<? super R> validator) {
        return this.assertsNot(validator, (Supplier)null);
    }

    public Pipeline<T, R> assertBean(Predicate<? super T> validator, @Nullable Supplier<?> throwsError) {
        return this.assertInternal(() -> validator.test((T)this.bean), throwsError);
    }

    public Pipeline<T, R> assertBean(Predicate<? super T> validator, @Nullable CharSequence charSequence) {
        return this.assertInternal(() -> validator.test((T)this.bean), charSequence);
    }

    public Pipeline<T, R> assertBean(Predicate<? super T> validator) {
        return this.assertBean(validator, (Supplier)null);
    }

    public Pipeline<T, R> assertBeanNot(Predicate<? super T> validator, @Nullable Supplier<?> throwsError) {
        return this.assertInternal(() -> !validator.test((T)this.bean), throwsError);
    }

    public Pipeline<T, R> assertBeanNot(Predicate<? super T> validator, @Nullable CharSequence charSequence) {
        return this.assertInternal(() -> !validator.test((T)this.bean), charSequence);
    }

    public Pipeline<T, R> assertBeanNot(Predicate<? super T> validator) {
        return this.assertBeanNot(validator, (Supplier)null);
    }

    public Pipeline<T, R> tryThrow(@Nullable Supplier<?> toThrow) {
        if (!this.isOK()) {
            Pipeline.tryThrow(toThrow, this.result);
        }
        return this;
    }

    public Pipeline<T, R> tryThrow(@Nullable CharSequence errorMsg) {
        if (!this.isOK()) {
            Pipeline.tryThrow(errorMsg, this.result);
        }
        return this;
    }

    public Pipeline<T, R> tryThrow() {
        if (!this.isOK()) {
            Pipeline.tryThrow(this.result, null);
        }
        return this;
    }

    public static void tryThrow(@Nullable Object toThrow, @Nullable Object result) {
        String message;
        if ((toThrow = X.tryUnwrap(toThrow)) instanceof Throwable) {
            throw X.wrapException(null, (Throwable)toThrow);
        }
        String string = message = toThrow == null ? null : toThrow.toString();
        if (result != null) {
            if ((result = X.tryUnwrap(result)) instanceof Throwable) {
                throw X.wrapException(message, (Throwable)result);
            }
            if (message == null) {
                message = result.toString();
            }
        }
        throw X.wrapException(message, null);
    }

    public boolean isOK() {
        return this.result == OK;
    }

    public Object getResult() {
        Object error = this.result;
        if (error instanceof Supplier) {
            error = ((Supplier)error).get();
        }
        return error;
    }

    public <E> E getResult(Class<E> expectType) {
        Object error = this.result;
        if (error == OK) {
            return null;
        }
        if (Supplier.class == expectType) {
            if (!(error instanceof Supplier)) {
                Object ref = error;
                Supplier<Object> wrapper = () -> ref;
                return (E)X.castType(wrapper);
            }
            return (E)X.castType(error);
        }
        if (error instanceof Supplier) {
            error = ((Supplier)error).get();
        }
        if (String.class == expectType) {
            return (E)X.castType(String.valueOf(error));
        }
        return expectType.cast(error);
    }

    @Override
    public Function<? super T, R> getGetter() {
        return this.getter;
    }

    @Override
    public BiConsumer<? super T, R> getSetter() {
        return this.setter;
    }
}

