/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util.scan;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import me.codeplayer.util.X;
import org.slf4j.Logger;

public class ClassPathScanHandler {
    static final Logger LOGGER = X.getLogger();
    private boolean excludeInner = true;
    private boolean checkInOrEx = true;
    private List<String> classNameFilters = null;

    public ClassPathScanHandler() {
    }

    public ClassPathScanHandler(boolean excludeInner, boolean checkInOrEx, List<String> classNameFilters) {
        this.excludeInner = excludeInner;
        this.checkInOrEx = checkInOrEx;
        this.classNameFilters = classNameFilters;
    }

    public Set<Class<?>> getAllClassesFromPackage(String basePackage, boolean recursive) {
        LinkedHashSet classes = new LinkedHashSet();
        String packageName = basePackage;
        if (packageName.endsWith(".")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        String package2Path = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(package2Path);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    LOGGER.debug("Scanning class files in {}", (Object)url);
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    this.doScanPackageClassesByFile(classes, packageName, filePath, recursive);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                LOGGER.debug("Scanning class files in {}", (Object)url);
                this.doScanPackageClassesByJar(packageName, url, recursive, classes);
            }
        }
        catch (IOException e) {
            LOGGER.error("An error occurs when scanning class files", (Throwable)e);
        }
        return classes;
    }

    private void doScanPackageClassesByJar(String basePackage, URL url, boolean recursive, Set<Class<?>> classes) {
        String package2Path = basePackage.replace('.', '/');
        try {
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(package2Path) || entry.isDirectory() || !recursive && name.lastIndexOf(47) != package2Path.length()) continue;
                if (this.excludeInner && name.lastIndexOf(36) != -1) {
                    LOGGER.debug("exclude inner class with name: {}", (Object)name);
                    continue;
                }
                String classSimpleName = name.substring(name.lastIndexOf(47) + 1);
                if (!this.filterClassName(classSimpleName)) continue;
                String className = name.replace('/', '.');
                className = className.substring(0, className.length() - 6);
                try {
                    classes.add(Thread.currentThread().getContextClassLoader().loadClass(className));
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Class.forName() error:", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException error:", (Throwable)e);
        }
    }

    private void doScanPackageClassesByFile(Set<Class<?>> classes, String packageName, String packagePath, final boolean recursive) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return recursive;
                }
                String filename = file.getName();
                if (ClassPathScanHandler.this.excludeInner && filename.indexOf(36) != -1) {
                    LOGGER.debug("exclude inner class with name:{}", (Object)filename);
                    return false;
                }
                return ClassPathScanHandler.this.filterClassName(filename);
            }
        })) {
            if (file.isDirectory()) {
                this.doScanPackageClassesByFile(classes, packageName + '.' + file.getName(), file.getAbsolutePath(), recursive);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("IOException error:", (Throwable)e);
            }
        }
    }

    private boolean filterClassName(String className) {
        if (!className.endsWith(".class")) {
            return false;
        }
        if (null == this.classNameFilters || this.classNameFilters.isEmpty()) {
            return true;
        }
        String tmpName = className.substring(0, className.length() - 6);
        boolean flag = false;
        for (String str : this.classNameFilters) {
            String tmpreg = '^' + str.replace("*", ".*") + '$';
            Pattern p = Pattern.compile(tmpreg);
            if (!p.matcher(tmpName).find()) continue;
            flag = true;
            break;
        }
        return this.checkInOrEx && flag || !this.checkInOrEx && !flag;
    }

    public Set<Method> getMethodsFromPackage(String basePackage, boolean recursive, Predicate<Method> methodMatcher) {
        Set<Class<?>> classes = this.getAllClassesFromPackage(basePackage, recursive);
        LinkedHashSet<Method> finalMethods = new LinkedHashSet<Method>();
        for (Class<?> clazz : classes) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (methodMatcher != null && !methodMatcher.test(method)) continue;
                finalMethods.add(method);
            }
        }
        return finalMethods;
    }

    public boolean isExcludeInner() {
        return this.excludeInner;
    }

    public boolean isCheckInOrEx() {
        return this.checkInOrEx;
    }

    public List<String> getClassNameFilters() {
        return this.classNameFilters;
    }

    public void setExcludeInner(boolean pExcludeInner) {
        this.excludeInner = pExcludeInner;
    }

    public void setCheckInOrEx(boolean pCheckInOrEx) {
        this.checkInOrEx = pCheckInOrEx;
    }

    public void setClassNameFilters(List<String> pClassFilters) {
        this.classNameFilters = pClassFilters;
    }
}

