/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.codeplayer.util.CharConverter;
import me.codeplayer.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class Words {
    protected final List<Segment> segments;
    public static final WordCase SNAKE_CASE = new WordCase('_', (seg, i, ref) -> {
        ref[0] = false;
        return CharConverter.CharCase.LOWER;
    });
    public static final WordCase CAMEL_CASE = new WordCase((seg, i, ref) -> {
        if (seg.wordIndex > 0 && i == 0) {
            return CharConverter.CharCase.UPPER;
        }
        if (seg.abbr) {
            return CharConverter.CharCase.NONE;
        }
        return CharConverter.CharCase.LOWER;
    });
    public static final WordCase PASCAL_CASE = new WordCase((seg, i, ref) -> {
        if (i == 0) {
            return CharConverter.CharCase.UPPER;
        }
        if (seg.abbr) {
            return CharConverter.CharCase.NONE;
        }
        return CharConverter.CharCase.LOWER;
    });
    public static final WordCase KEBAB_CASE = new WordCase('-', (seg, i, ref) -> {
        ref[0] = false;
        return CharConverter.CharCase.LOWER;
    });

    Words(List<Segment> segments) {
        this.segments = segments;
    }

    public static Words from(String source, @Nullable FromWordCase fromCase) {
        int len = source.length();
        ArrayList<Segment> segments = new ArrayList<Segment>();
        WordSplitter splitter = new WordSplitter();
        int wordIndex = 0;
        for (int i = 0; i < len; ++i) {
            char ch = source.charAt(i);
            Segment seg = fromCase == null ? (ch == '_' || ch == '-' || Character.isSpaceChar(ch) ? splitter.splitAtSep(i, 1, splitter.prevUpperCount > 0) : splitter.trySplitSpecial(ch, source, i)) : fromCase.trySplit(ch, source, i, splitter);
            if (seg == null) continue;
            if (seg != Segment.EMPTY) {
                segments.add(seg.attach(source, wordIndex++));
            }
            splitter.begin = splitter.nextBegin;
        }
        if (splitter.begin < len) {
            segments.add(new Segment(splitter.begin, len, splitter.prevUpperCount > 0).attach(source, wordIndex));
        }
        return new Words(segments);
    }

    public static Words from(Iterable<String> words) {
        ArrayList<Segment> segments = words instanceof Collection ? new ArrayList<Segment>(((Collection)words).size()) : new ArrayList();
        int i = 0;
        for (String word : words) {
            if (StringUtil.isEmpty(word)) continue;
            segments.add(new Segment(0, word.length(), StringUtils.isAllUpperCase((CharSequence)word)).attach(word, i++));
        }
        return new Words(segments);
    }

    public static Words from(String ... words) {
        return Words.from(Arrays.asList(words));
    }

    public static Words from(String source) {
        return Words.from(source, null);
    }

    public int count() {
        return this.segments.size();
    }

    public Stream<String> stream() {
        return this.segments.stream().map(Segment::toString);
    }

    public StringBuilder forEachAppend(@Nullable StringBuilder sb, BiConsumer<StringBuilder, Segment> appender) {
        int size = this.segments.size();
        if (size == 0) {
            return new StringBuilder(0);
        }
        if (sb == null) {
            sb = new StringBuilder(this.segments.get((int)0).source.length() + size);
        }
        for (Segment seg : this.segments) {
            appender.accept(sb, seg);
        }
        return sb;
    }

    public StringBuilder join(@Nullable StringBuilder builder, CharSequence delimiter) {
        return this.forEachAppend(builder, (sb, seg) -> {
            if (seg.wordIndex > 0) {
                sb.append(delimiter);
            }
            sb.append(seg.source, seg.begin, seg.end);
        });
    }

    public String join(CharSequence delimiter) {
        return this.join(null, delimiter).toString();
    }

    public StringBuilder convertCase(@Nullable WordSeparator ws, WordCaseDescriptor descriptor, @Nullable CharConverter.CharCase preprocessor) {
        return this.forEachAppend(null, (sb, seg) -> {
            if (ws != null) {
                ws.appendSeparator((StringBuilder)sb, (Segment)seg);
            }
            descriptor.formatWord((StringBuilder)sb, (Segment)seg, preprocessor);
        });
    }

    public StringBuilder convertCaseWithSep(char sep, WordCaseDescriptor descriptor, @Nullable CharConverter.CharCase preprocessor) {
        return this.forEachAppend(null, (sb, seg) -> {
            if (seg.wordIndex > 0) {
                sb.append(sep);
            }
            descriptor.formatWord((StringBuilder)sb, (Segment)seg, preprocessor);
        });
    }

    public StringBuilder convertCaseWithSep(char sep, WordCaseDescriptor descriptor) {
        return this.convertCaseWithSep(sep, descriptor, null);
    }

    public StringBuilder convertCaseWithSep(String sep, WordCaseDescriptor descriptor, @Nullable CharConverter.CharCase preprocessor) {
        return this.forEachAppend(null, (sb, seg) -> {
            if (seg.wordIndex > 0) {
                sb.append(sep);
            }
            descriptor.formatWord((StringBuilder)sb, (Segment)seg, preprocessor);
        });
    }

    public StringBuilder convertCaseWithSep(String sep, WordCaseDescriptor descriptor) {
        return this.convertCaseWithSep(sep, descriptor, null);
    }

    public String to(@Nullable WordSeparator ws, WordCaseDescriptor descriptor, @Nullable CharConverter.CharCase preprocessor) {
        return this.convertCase(ws, descriptor, preprocessor).toString();
    }

    public String to(ToWordCase wordCase, @Nullable CharConverter.CharCase preprocessor) {
        return wordCase.toString(this.convertCase(wordCase, wordCase.getDescriptor(), preprocessor));
    }

    public String to(ToWordCase wordCase) {
        return this.to(wordCase, null);
    }

    public static class WordCase
    implements FromWordCase,
    ToWordCase {
        public final char sep;
        public final boolean hasSep;
        public final WordCaseDescriptor descriptor;

        public WordCase(char sep, boolean hasSep, WordCaseDescriptor descriptor) {
            this.sep = sep;
            this.hasSep = hasSep;
            this.descriptor = descriptor;
        }

        public WordCase(char sep, WordCaseDescriptor descriptor) {
            this(sep, true, descriptor);
        }

        public WordCase(WordCaseDescriptor descriptor) {
            this(' ', false, descriptor);
        }

        @Override
        public Segment trySplit(char ch, String source, int charIndex, WordSplitter ref) {
            return ref.trySplit(this.sep, ch, source, charIndex);
        }

        @Override
        public WordCaseDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public void appendSeparator(StringBuilder sb, Segment seg) {
            if (this.hasSep && seg.wordIndex > 0) {
                sb.append(this.sep);
            }
        }
    }

    public static class WordSplitter {
        private int begin;
        private int end;
        private int nextBegin;
        private int prevUpperCount;

        public int getBegin() {
            return this.begin;
        }

        public int getEnd() {
            return this.end;
        }

        public int getNextBegin() {
            return this.nextBegin;
        }

        public int getPrevUpperCount() {
            return this.prevUpperCount;
        }

        public void setBegin(int begin) {
            this.begin = begin;
        }

        protected Segment splitAt(int endIndex, int nextBegin, int prevUpperCount, boolean abbr) {
            this.end = endIndex;
            this.nextBegin = nextBegin;
            this.prevUpperCount = prevUpperCount;
            return this.toSegment(abbr);
        }

        public Segment splitAt(int endIndex, int prevUpperCount, boolean abbr) {
            return this.splitAt(endIndex, endIndex, prevUpperCount, abbr);
        }

        public Segment splitAtSep(int charIndex, int sepCharLength, boolean abbr) {
            int nextBegin = charIndex + 1;
            return this.splitAt(nextBegin - sepCharLength, nextBegin, 0, abbr);
        }

        public Segment toSegment(boolean abbr) {
            return Segment.of(this.begin, this.end, abbr);
        }

        public Segment trySplitSpecial(char ch, String source, int charIndex) {
            if (Character.isUpperCase(ch)) {
                if (this.prevUpperCount == 0) {
                    return this.splitAt(charIndex, 1, false);
                }
                ++this.prevUpperCount;
            } else {
                if (this.prevUpperCount > 1) {
                    return this.splitAt(charIndex - 1, 0, true);
                }
                this.prevUpperCount = 0;
            }
            return null;
        }

        public Segment trySplit(char sep, char ch, String source, int charIndex) {
            if (sep == ch || Character.isSpaceChar(ch)) {
                return this.splitAtSep(charIndex, 1, false);
            }
            return this.trySplitSpecial(ch, source, charIndex);
        }
    }

    public static interface ToWordCase
    extends WordSeparator {
        public WordCaseDescriptor getDescriptor();

        default public String toString(StringBuilder sb) {
            return sb.toString();
        }
    }

    public static interface WordCaseDescriptor {
        public CharConverter.CharCase getCharCase(Segment var1, int var2, boolean[] var3);

        default public void formatWord(StringBuilder sb, Segment seg, CharConverter.CharCase preprocessor) {
            CharConverter.CharCase charCase = null;
            int end = seg.end;
            boolean[] continueFlagRef = new boolean[]{true};
            int begin = seg.begin;
            String source = seg.source;
            int i = 0;
            while (begin < end) {
                if ((charCase = this.getCharCase(seg, i++, continueFlagRef)) == null) {
                    charCase = preprocessor;
                    break;
                }
                if (charCase == CharConverter.CharCase.NONE && preprocessor != null) {
                    charCase = preprocessor;
                }
                if (!continueFlagRef[0]) break;
                sb.append(charCase.apply(source.charAt(begin++)));
            }
            if (begin < end) {
                if (charCase == null || charCase == CharConverter.CharCase.NONE) {
                    sb.append(source, begin, end);
                } else {
                    for (i = begin; i < end; ++i) {
                        sb.append(charCase.apply(source.charAt(i)));
                    }
                }
            }
        }
    }

    public static interface WordSeparator {
        public void appendSeparator(StringBuilder var1, Segment var2);
    }

    public static interface FromWordCase {
        public Segment trySplit(char var1, String var2, int var3, WordSplitter var4);
    }

    public static class Segment {
        public transient String source;
        public transient int wordIndex;
        public final int begin;
        public final int end;
        public final boolean abbr;
        static final Segment EMPTY = new Segment(-1, -1, false);

        public Segment(int begin, int end, boolean abbr) {
            this.begin = begin;
            this.end = end;
            this.abbr = abbr;
        }

        public Segment attach(String source, int wordIndex) {
            this.source = source;
            this.wordIndex = wordIndex;
            return this;
        }

        public static Segment of(int begin, int end, boolean abbr) {
            return begin < end ? new Segment(begin, end, abbr) : EMPTY;
        }

        public String toString() {
            return this.source.substring(this.begin, this.end);
        }
    }
}

