/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.util.function.Supplier;
import me.codeplayer.util.Assert;
import me.codeplayer.util.CacheLoader;

public class LazyCacheLoader<E>
implements CacheLoader<E> {
    public static final Object uninitialized = new Object();
    protected volatile transient Object value = uninitialized;
    protected final Supplier<E> loader;

    public LazyCacheLoader(Supplier<E> loader) {
        Assert.notNull(loader);
        this.loader = loader;
    }

    public LazyCacheLoader(boolean initialize, Supplier<E> loader) {
        this(loader);
        if (initialize) {
            this.value = loader.get();
        }
    }

    @Override
    public E get() {
        if (this.flushRequired()) {
            this.value = this.loader.get();
        }
        return (E)this.value;
    }

    @Override
    public boolean flushRequired() {
        return this.value == uninitialized;
    }

    @Override
    public E flush(boolean lazy) {
        if (lazy) {
            this.value = uninitialized;
            return null;
        }
        E val = this.loader.get();
        this.value = val;
        return val;
    }
}

