/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.math.BigDecimal;
import java.util.ArrayList;

public class ChineseNumber {
    static final char[] BIG_UNITS = new char[]{'\u4ebf', '\u4e07'};
    static final char[] CURRENCY_UNITS = new char[]{'\u5706', '\u89d2', '\u5206'};
    protected final String number;
    protected final String fraction;
    protected final FormatStyle style;
    protected transient String text;

    protected ChineseNumber(String val, String fraction, FormatStyle style) {
        this.number = val;
        this.fraction = fraction;
        this.style = style;
    }

    public ChineseNumber(long val, FormatStyle style) {
        this(Long.toString(val), null, style);
    }

    public ChineseNumber(String fullVal, FormatStyle style) {
        int point = fullVal.indexOf(46);
        this.number = point == -1 ? fullVal : fullVal.substring(0, point);
        this.fraction = point == -1 ? null : fullVal.substring(point + 1);
        this.style = style;
    }

    public ChineseNumber(double val, FormatStyle style) {
        this(new BigDecimal(Double.toString(val)).toString(), style);
    }

    public ChineseNumber(BigDecimal d, FormatStyle style) {
        this(d.toPlainString(), style);
    }

    protected StringBuilder appendIntValue(StringBuilder sb) {
        if ("0".equals(this.number)) {
            return sb.append(this.style.getNumbersText()[0]);
        }
        int length = this.number.length();
        int size = length >> 2;
        if (length % 4 != 0) {
            ++size;
        }
        ArrayList<Cell> cells = new ArrayList<Cell>(size);
        do {
            int startIndex;
            if ((startIndex = length - 4) < 0) {
                startIndex = 0;
            }
            Cell cell = new Cell(this.number.substring(startIndex, length), this.style);
            cells.add(cell);
        } while ((length -= 4) > 0);
        int index = size;
        boolean leftEndWithZero = false;
        while (index-- > 0) {
            Cell cell = (Cell)cells.get(index);
            if (cell.chinese.length() > 0) {
                if (leftEndWithZero || cell.startWithZero) {
                    sb.append(this.style.getNumbersText()[0]);
                }
                sb.append(cell.chinese);
                if (index > 0) {
                    sb.append(BIG_UNITS[index & 1]);
                }
            }
            leftEndWithZero = cell.endWithZero;
        }
        return sb;
    }

    protected StringBuilder appendDecimalValue(StringBuilder sb) {
        int len;
        int n = len = this.fraction == null ? 0 : this.fraction.length();
        if (this.style == FormatStyle.MONEY) {
            boolean empty;
            sb.append(CURRENCY_UNITS[0]);
            boolean bl = empty = len == 0;
            if (!empty) {
                char ch = this.fraction.charAt(0);
                if (ch != '0') {
                    sb.append(this.style.getNumberChar(ch)).append(CURRENCY_UNITS[1]);
                } else {
                    empty = true;
                }
                if (len > 1 && (ch = this.fraction.charAt(1)) != '0') {
                    if (empty) {
                        sb.append('\u96f6');
                        empty = false;
                    }
                    sb.append(this.style.getNumberChar(ch)).append(CURRENCY_UNITS[2]);
                }
            }
            if (empty) {
                sb.append('\u6574');
            }
        } else if (len > 0) {
            sb.append('\u70b9');
            for (int i = 0; i < len; ++i) {
                sb.append(this.style.getNumberChar(this.fraction.charAt(i)));
            }
        }
        return sb;
    }

    public String toString() {
        if (this.text == null) {
            StringBuilder sb = new StringBuilder();
            this.appendIntValue(sb);
            this.appendDecimalValue(sb);
            this.text = sb.toString();
        }
        return this.text;
    }

    public static String formatNumber(double d, boolean ignoreDecimal, FormatStyle style) {
        if (ignoreDecimal) {
            return new ChineseNumber((long)d, style).toString();
        }
        return new ChineseNumber(d, style).toString();
    }

    public static String formatNumber(BigDecimal d, boolean ignoreDecimal, FormatStyle style) {
        if (ignoreDecimal) {
            return new ChineseNumber(d.longValue(), style).toString();
        }
        return new ChineseNumber(d, style).toString();
    }

    public static String formatNumber(long d, FormatStyle style) {
        return new ChineseNumber(d, style).toString();
    }

    public static enum FormatStyle {
        LOWER_CASE(new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'}, new char[]{'\u5343', '\u767e', '\u5341'}),
        UPPER_CASE(new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'}, new char[]{'\u4edf', '\u4f70', '\u62fe'}),
        MONEY(UPPER_CASE.getNumbersText(), UPPER_CASE.getUnitsText());

        final char[] numbersText;
        final char[] unitsText;

        private FormatStyle(char[] numbersText, char[] unitsText) {
            this.numbersText = numbersText;
            this.unitsText = unitsText;
        }

        public char[] getNumbersText() {
            return this.numbersText;
        }

        public char[] getUnitsText() {
            return this.unitsText;
        }

        public char getNumberChar(char ch) {
            return this.numbersText[Character.digit(ch, 10)];
        }
    }

    public static class Cell {
        private String chinese = "";
        private final String source;
        private final FormatStyle style;
        private boolean startWithZero;
        private boolean endWithZero;

        public Cell(String moneyCell, FormatStyle style) {
            this.source = moneyCell;
            this.style = style;
            this.init();
        }

        public void init() {
            int length;
            if (this.source != null && (length = this.source.length()) > 0) {
                StringBuilder money = new StringBuilder();
                boolean preHasValidValue = false;
                boolean lastIsZero = false;
                int index = length - 1;
                for (int i = 0; i < length; ++i) {
                    char ch = this.source.charAt(i);
                    int currentInt = Character.digit(ch, 10);
                    if (i == index && currentInt == 0) {
                        this.endWithZero = true;
                    }
                    if (currentInt > 0) {
                        if (preHasValidValue && lastIsZero) {
                            money.append(this.style.getNumbersText()[0]);
                        }
                        money.append(this.style.getNumbersText()[currentInt]);
                        if (i < index) {
                            money.append(this.style.getUnitsText()[4 + i - length]);
                        }
                        preHasValidValue = true;
                        lastIsZero = false;
                        continue;
                    }
                    if (i == 0) {
                        this.startWithZero = true;
                    }
                    lastIsZero = true;
                }
                this.chinese = money.toString();
            }
        }
    }
}

