/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.codeplayer.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class X {
    public static Logger getLogger() {
        String className = new Throwable().getStackTrace()[1].getClassName();
        return LoggerFactory.getLogger((String)className);
    }

    public static boolean isEmpty(String str) {
        return StringUtil.isEmpty(str);
    }

    public static boolean isEmpty(Object obj) {
        return StringUtil.isEmpty(obj);
    }

    public static boolean isBlank(String str) {
        return StringUtil.isBlank(str);
    }

    public static boolean isBlank(Object obj) {
        return StringUtil.isBlank(obj);
    }

    public static <T> T expectNotNull(T v1, T v2, T v3, T v4) {
        if (v1 != null) {
            return v1;
        }
        if (v2 != null) {
            return v2;
        }
        if (v3 != null) {
            return v3;
        }
        return v4;
    }

    public static <T> T expectNotNull(T v1, T v2, T v3) {
        return v1 != null ? v1 : (v2 != null ? v2 : v3);
    }

    public static <T> T expectNotNull(T v1, T v2) {
        return v1 != null ? v1 : v2;
    }

    public static String expectNotEmpty(String v1, String v2, String v3, String v4) {
        if (v1 != null && v1.length() > 0) {
            return v1;
        }
        if (v2 != null && v2.length() > 0) {
            return v2;
        }
        if (v3 != null && v3.length() > 0) {
            return v3;
        }
        if (v4 != null && v4.length() > 0) {
            return v4;
        }
        return "";
    }

    public static String expectNotEmpty(String v1, String v2, String v3) {
        return X.expectNotEmpty(v1, v2, v3, null);
    }

    public static String expectNotEmpty(String v1, String v2) {
        if (v1 != null && v1.length() > 0) {
            return v1;
        }
        return StringUtil.notEmpty(v2) ? v2 : "";
    }

    public static boolean isValid(Boolean b) {
        return b != null && b != false;
    }

    public static boolean isValid(Number number) {
        return number != null && number.doubleValue() != 0.0;
    }

    public static boolean isValid(CharSequence sequence) {
        return StringUtil.notEmpty(sequence);
    }

    public static boolean isValid(Map<?, ?> map) {
        return map != null && map.size() > 0;
    }

    public static boolean isValid(Collection<?> collection) {
        return collection != null && collection.size() > 0;
    }

    public static boolean isValid(byte[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isValid(int[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isValid(long[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isValid(char[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isValid(float[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isValid(double[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isValid(Object[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isValid(Object arg) {
        if (arg == null) {
            return false;
        }
        if (arg instanceof CharSequence) {
            return ((CharSequence)arg).length() > 0;
        }
        if (arg instanceof Number) {
            return ((Number)arg).doubleValue() != 0.0;
        }
        if (arg instanceof Map) {
            return ((Map)arg).size() > 0;
        }
        if (arg instanceof Collection) {
            return ((Collection)arg).size() > 0;
        }
        if (arg.getClass().isArray()) {
            return Array.getLength(arg) > 0;
        }
        if (arg instanceof Boolean) {
            return (Boolean)arg;
        }
        return true;
    }

    public static <T> T decode(Object input, Object ... expressions) {
        int length;
        if (expressions == null || (length = expressions.length) == 0) {
            throw new IllegalArgumentException("decode\u7684\u8868\u8fbe\u5f0f\u53c2\u6570\u4e2a\u6570\u4e0d\u80fd\u5c0f\u4e8e1!");
        }
        Object val = null;
        int endIndex = length - 1;
        for (int i = 0; i < length; ++i) {
            Object key;
            if (i == endIndex) {
                val = expressions[i];
                break;
            }
            if (input != (key = expressions[i++]) && (input == null || !input.equals(key))) continue;
            val = expressions[i];
            break;
        }
        return (T)val;
    }

    public static String trim4Html(String str) {
        return StringUtil.isBlank(str) ? "&nbsp;" : str.trim();
    }

    public static int getCapacity(int capacity) {
        return X.getCapacity(capacity, 0.75f);
    }

    public static int getCapacity(int capacity, float loadFactor) {
        int initCapacity = 16;
        while ((float)capacity > (float)initCapacity * loadFactor) {
            initCapacity <<= 1;
        }
        return initCapacity;
    }

    public static <T> T castType(Object obj) {
        return (T)obj;
    }

    public static <T> void use(@Nullable T obj, Consumer<? super T> consumer) {
        if (obj != null) {
            consumer.accept(obj);
        }
    }

    public static <T> void use(@Nullable T obj, Predicate<T> filter, Consumer<? super T> consumer) {
        if (obj != null && filter.test(obj)) {
            consumer.accept(obj);
        }
    }

    public static <T, R> R map(@Nullable T obj, Function<? super T, R> mapper) {
        if (obj == null || mapper == null) {
            return null;
        }
        return mapper.apply(obj);
    }

    public static <T, R, E> E map(@Nullable T obj, Function<? super T, R> mapper, Function<R, E> nestedMapper) {
        return X.map(X.map(obj, mapper), nestedMapper);
    }

    public static <T, R> R mapElse(@Nullable T obj, Function<? super T, R> mapper, R other) {
        R val = X.map(obj, mapper);
        return val == null ? other : val;
    }

    public static <T, R> R mapElseGet(@Nullable T obj, Function<? super T, R> mapper, Supplier<R> other) {
        R val = X.map(obj, mapper);
        return val == null ? other.get() : val;
    }

    public static <E> E tryUnwrap(@Nullable Object supplier) {
        if (supplier instanceof Supplier) {
            return (E)((Supplier)supplier).get();
        }
        return (E)supplier;
    }

    public static <T> T getElse(@Nullable T val, Supplier<T> other) {
        return val == null ? other.get() : val;
    }

    public static <T, R> boolean isMatch(@Nullable T bean, Function<? super T, R> mapper, Predicate<? super R> matcher) {
        R val = X.map(bean, mapper);
        return matcher.test(val);
    }

    public static RuntimeException wrapException(@Nullable String msg, boolean forceUseMsg, @Nullable Throwable ex, @Nullable Throwable cause) {
        if (ex == null) {
            return cause == null ? new IllegalArgumentException(msg) : new IllegalArgumentException(msg, cause);
        }
        if (ex instanceof RuntimeException) {
            return forceUseMsg && msg != null ? new IllegalArgumentException(msg, ex) : (RuntimeException)ex;
        }
        return msg == null ? new IllegalArgumentException(ex) : new IllegalArgumentException(msg, ex);
    }

    public static RuntimeException wrapException(@Nullable String msg, @Nullable Throwable ex, @Nullable Throwable cause) {
        return X.wrapException(msg, false, ex, cause);
    }

    public static RuntimeException wrapException(@Nullable String msg, boolean forceUseMsg, @Nullable Throwable ex) {
        return X.wrapException(msg, forceUseMsg, ex, null);
    }

    public static RuntimeException wrapException(@Nullable String msg, @Nullable Throwable ex) {
        return X.wrapException(msg, false, ex, null);
    }

    public static <T> T getRecursively(T root, Function<T, T> recursion, Predicate<T> untilMatch) {
        T t = root;
        while (t != null) {
            if (untilMatch.test(t)) {
                return t;
            }
            t = recursion.apply(t);
        }
        return null;
    }

    public static <T> int eqLax(@Nullable T inputVal, @Nullable T currentVal) {
        if (inputVal == currentVal) {
            return 1;
        }
        if (inputVal == null || currentVal == null) {
            return 0;
        }
        return inputVal.equals(currentVal) ? 1 : -1;
    }

    public static <T, R> int eqLax(@Nullable T input, @Nullable T current, Function<T, R> getter) {
        R inputVal = X.map(input, getter);
        R currentVal = X.map(current, getter);
        return X.eqLax(inputVal, currentVal);
    }

    public static <T, R> R expectEquals(@Nullable T input, @Nullable T current, Function<T, R> getter, BiConsumer<T, R> setIfNull, @Nullable Object error) throws IllegalArgumentException {
        R currentVal;
        R inputVal = X.map(input, getter);
        if (inputVal == (currentVal = X.map(current, getter))) {
            return currentVal;
        }
        if (inputVal == null) {
            setIfNull.accept(input, currentVal);
            return currentVal;
        }
        if (currentVal == null) {
            setIfNull.accept(current, inputVal);
            return inputVal;
        }
        if (inputVal.equals(currentVal)) {
            return currentVal;
        }
        String errorMsg = (String)X.tryUnwrap(error);
        throw new IllegalArgumentException(errorMsg);
    }

    public static <T, R> R expectEquals(@Nullable T input, @Nullable T current, Function<T, R> getter, BiConsumer<T, R> setIfNull) throws IllegalArgumentException {
        return X.expectEquals(input, current, getter, setIfNull, null);
    }

    public static <T, R> R expectEqualsBasedOld(@Nullable T input, @Nullable T old, Function<T, R> getter, Consumer<R> setOldIfInputNull, @Nullable Object error) throws IllegalArgumentException {
        R currentVal = X.map(old, getter);
        if (input == old) {
            return currentVal;
        }
        R inputVal = X.map(input, getter);
        if (inputVal == currentVal) {
            return currentVal;
        }
        if (inputVal == null) {
            setOldIfInputNull.accept(currentVal);
            return currentVal;
        }
        if (inputVal.equals(currentVal)) {
            return currentVal;
        }
        String errorMsg = (String)X.tryUnwrap(error);
        throw new IllegalArgumentException(errorMsg);
    }

    public static <T, R> R expectEqualsBasedOld(@Nullable T input, @Nullable T old, Function<T, R> getter, Consumer<R> setOldIfInputNul) throws IllegalArgumentException {
        return X.expectEqualsBasedOld(input, old, getter, setOldIfInputNul, null);
    }

    public static int size(Collection<?> c) {
        return c == null ? 0 : c.size();
    }

    public static int size(Map<?, ?> map) {
        return map == null ? 0 : map.size();
    }

    public static int size(Object[] array) {
        return array == null ? 0 : array.length;
    }

    public static int sizeOfArray(Object array) throws IllegalArgumentException {
        return array == null ? 0 : Array.getLength(array);
    }

    public static int size(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static boolean matchAllOrNone(boolean a, boolean b) {
        return a == b;
    }

    public static boolean matchAllOrNone(boolean a, boolean b, boolean c) {
        return a == b && a == c;
    }

    public static boolean isMutex(boolean a, boolean b) {
        return a ^ b;
    }

    public static <T> boolean matchAny(Predicate<T> matcher, T ... values) {
        for (T val : values) {
            if (!matcher.test(val)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean matchAll(Predicate<T> matcher, T ... values) {
        for (T val : values) {
            if (matcher.test(val)) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] emptyToNull(T[] array) {
        return X.isValid(array) ? array : null;
    }

    public static <T extends Collection<?>> T emptyToNull(T c) {
        return (T)(X.isValid(c) ? c : null);
    }

    public static <T extends Map<?, ?>> T emptyToNull(T map) {
        return (T)(X.isValid(map) ? map : null);
    }

    public static <T, R> R mapAny(Function<? super T, ? extends R> mapper, Predicate<R> matcher, T ... args) {
        for (T t : args) {
            R val = mapper.apply(t);
            if (!matcher.test(val)) continue;
            return val;
        }
        return null;
    }
}

