/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.util.function.Supplier;
import me.codeplayer.util.LazyCacheLoader;

public class TimeBasedCacheLoader<E>
extends LazyCacheLoader<E> {
    protected long internal;
    protected volatile transient long nextUpdateTime;

    public TimeBasedCacheLoader(long internal, Supplier<E> loader) {
        super(loader);
        this.internal = internal;
    }

    @Override
    public boolean flushRequired() {
        return this.flushRequired(this.value, System.currentTimeMillis());
    }

    protected boolean flushRequired(Object val, long baseTime) {
        return this.isUninitialized(val) || this.nextUpdateTime == 0L || this.internal > 0L && this.nextUpdateTime < baseTime;
    }

    @Override
    public E flush(boolean lazy) {
        E val;
        if (lazy) {
            this.nextUpdateTime = 0L;
            val = null;
        } else {
            E e = this.load(System.currentTimeMillis());
            val = e;
            this.value = e;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get() {
        Object val = this.value;
        long now = System.currentTimeMillis();
        if (this.flushRequired(val, now)) {
            TimeBasedCacheLoader timeBasedCacheLoader = this;
            synchronized (timeBasedCacheLoader) {
                val = this.value;
                if (this.flushRequired(val, now)) {
                    return this.load(now);
                }
            }
        }
        return (E)val;
    }

    protected E load(long now) {
        Object val = this.loader.get();
        this.value = val;
        this.nextUpdateTime = now + this.internal;
        return (E)val;
    }
}

