/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import java.util.Collections;
import java.util.List;
import me.codeplayer.util.X;

public abstract class JSONUtil {
    public static int DEFAULT_SERIALIZER_FEATURES = JSON.DEFAULT_GENERATE_FEATURE | SerializerFeature.DisableCircularReferenceDetect.getMask();

    public static int mergeFeatures(int base, SerializerFeature extra) {
        return base | extra.getMask();
    }

    public static int mergeFeatures(int base, SerializerFeature ... extra) {
        for (SerializerFeature feature : extra) {
            base |= feature.getMask();
        }
        return base;
    }

    public static String encode(Object obj) {
        return JSON.toJSONString((Object)obj, (int)DEFAULT_SERIALIZER_FEATURES, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String encodeKeepNull(Object obj) {
        return JSON.toJSONString((Object)obj, (int)JSONUtil.mergeFeatures(DEFAULT_SERIALIZER_FEATURES, SerializerFeature.WriteMapNullValue), (SerializerFeature[])SerializerFeature.EMPTY);
    }

    public static String encodeWithExclude(Object obj, String ... excludeProperties) {
        SimplePropertyPreFilter filter = new SimplePropertyPreFilter(new String[0]);
        Collections.addAll(filter.getExcludes(), excludeProperties);
        return JSONUtil.serialize(obj, null, new SerializeFilter[]{filter});
    }

    public static String serialize(Object obj, String dateFormat, SerializeFilter ... filters) {
        return JSON.toJSONString((Object)obj, (SerializeConfig)SerializeConfig.globalInstance, (SerializeFilter[])filters, (String)dateFormat, (int)DEFAULT_SERIALIZER_FEATURES, (SerializerFeature[])SerializerFeature.EMPTY);
    }

    public static String encodeWithInclude(Object obj, String ... includeProperties) {
        return JSONUtil.serialize(obj, null, new SerializeFilter[]{new SimplePropertyPreFilter(includeProperties)});
    }

    public static String encodeWithDateFormat(Object obj, String pattern) {
        return JSONUtil.serialize(obj, pattern, new SerializeFilter[]{null});
    }

    public static String encodeWithReferenceDetect(Object obj) {
        return JSON.toJSONString((Object)obj);
    }

    public static Object parse(String text) {
        return JSON.parse((String)text);
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        return (T)JSON.parseObject((String)text, clazz);
    }

    public static JSONObject parseObject(String text) {
        return JSON.parseObject((String)text, (Feature[])new Feature[]{Feature.OrderedField});
    }

    public static JSONArray parseArray(String text) {
        return JSON.parseArray((String)text);
    }

    public static <T> List<T> parseArray(String text, Class<T> clazz) {
        return JSON.parseArray((String)text, clazz);
    }

    public static String serialize(Object obj) {
        return JSON.toJSONString((Object)obj, (int)JSONUtil.mergeFeatures(DEFAULT_SERIALIZER_FEATURES, SerializerFeature.WriteClassName), (SerializerFeature[])SerializerFeature.EMPTY);
    }

    public static <T> T deserialize(String text) {
        return X.castType(JSON.parse((String)text, (Feature[])new Feature[]{Feature.SupportAutoType}));
    }
}

