/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import me.codeplayer.util.RandomUtil;
import me.codeplayer.util.X;
import org.apache.commons.lang3.time.FastDateFormat;

public abstract class FileUtil {
    private static final String[] FILE_UNITS = new String[]{"Byte", "KB", "MB", "GB", "TB", "PB"};
    public static final int UNIT_AUTO = 0;
    public static final int UNIT_BYTE = 1;
    public static final int UNIT_KB = 2;
    public static final int UNIT_MB = 3;
    public static final int UNIT_GB = 4;
    public static final int UNIT_TB = 5;
    public static final int UNIT_PB = 6;

    public static int indexOfExtension(String filename) {
        int pos = filename.lastIndexOf(46);
        if (pos != -1) {
            if (filename.indexOf(47, pos + 1) != -1) {
                return -1;
            }
            if (filename.indexOf(92, pos + 1) != -1) {
                return -1;
            }
        }
        return pos;
    }

    public static String getExtension(String path, boolean removeDot) throws NullPointerException {
        int pos = FileUtil.indexOfExtension(path);
        if (pos == -1) {
            return "";
        }
        return path.substring(removeDot ? pos + 1 : pos);
    }

    public static String getExtension(String path) {
        return FileUtil.getExtension(path, false);
    }

    public static String getFileName(String path) {
        return FileUtil.getFileName(path, false);
    }

    public static String getFileName(String path, boolean withoutExt) {
        int pos;
        String str = new File(path).getName();
        if (withoutExt && (pos = FileUtil.indexOfExtension(path)) > -1) {
            str = str.substring(0, pos);
        }
        return str;
    }

    public static File getRandomFile(String path, String prefix, String suffix, Date now) {
        String fileName = FastDateFormat.getInstance((String)"yyyyMMdd-HHmmssSSS").format(now);
        if (prefix != null) {
            fileName = prefix + fileName;
        }
        if (suffix == null) {
            suffix = "";
        } else if (suffix.length() > 0 && suffix.charAt(0) != '.') {
            suffix = '.' + suffix;
        }
        String destFileName = fileName + suffix;
        File file = new File(path, destFileName);
        while (file.exists()) {
            destFileName = fileName + '-' + RandomUtil.getIntString(4) + suffix;
            file = new File(path, destFileName);
        }
        return file;
    }

    public static File getRandomFile(String path, String prefix, String suffix) {
        return FileUtil.getRandomFile(path, prefix, suffix, new Date());
    }

    public static File getRandomFile(String path, String suffix) {
        return FileUtil.getRandomFile(path, null, suffix);
    }

    public static String calcFileSize(long fileSize, int unit, int scale, RoundingMode roundingMode) {
        if (fileSize < 0L) {
            throw new IllegalArgumentException("Argument 'fileSize' can not less than 0:" + fileSize);
        }
        if (unit < 0 || unit > 6) {
            throw new IllegalArgumentException(String.valueOf(unit));
        }
        if (unit != 0) {
            int shift = unit - 1;
            return FileUtil.divide(fileSize, 1L << 10 * shift, scale) + FILE_UNITS[shift];
        }
        int shift = 0;
        long unitBytes = 1L;
        long nextUnitBytes = unitBytes << 10;
        while (fileSize >= nextUnitBytes) {
            unitBytes = nextUnitBytes;
            nextUnitBytes <<= 10;
            ++shift;
        }
        return FileUtil.divide(fileSize, unitBytes, scale, roundingMode) + FILE_UNITS[shift];
    }

    public static String calcFileSize(long fileSize, int unit, int scale) {
        return FileUtil.calcFileSize(fileSize, unit, scale, RoundingMode.HALF_UP);
    }

    public static String calcFileSize(long fileSize, int unit) {
        return FileUtil.calcFileSize(fileSize, unit, 2);
    }

    public static String divide(long fileSize, long divisor, int scale, RoundingMode roundingMode) {
        return new BigDecimal(fileSize).divide(new BigDecimal(divisor), scale, roundingMode).toString();
    }

    public static String divide(long fileSize, long divisor, int scale) {
        return FileUtil.divide(fileSize, divisor, scale, RoundingMode.HALF_UP);
    }

    public static int deleteFile(String filePath) {
        return FileUtil.deleteFile(new File(filePath));
    }

    public static int deleteFile(String directoryPath, String fileName) {
        return FileUtil.deleteFile(new File(directoryPath, fileName));
    }

    private static int deleteFile(File file) {
        int result = -1;
        if (file.exists()) {
            if (file.delete()) {
                result = 1;
            }
        } else {
            result = 0;
        }
        return result;
    }

    public static void checkReadable(File toRead) {
        if (!toRead.exists()) {
            throw new IllegalArgumentException(new FileNotFoundException("File not found:" + toRead.getAbsolutePath()));
        }
        if (toRead.isDirectory()) {
            throw new IllegalArgumentException("File is a directory:" + toRead.getAbsolutePath());
        }
        if (!toRead.canRead()) {
            throw new IllegalStateException(new AccessDeniedException("Unable to read file:" + toRead.getAbsolutePath()));
        }
    }

    public static void checkWritable(File toWrite, boolean override) {
        if (toWrite.exists()) {
            if (toWrite.isDirectory()) {
                throw new IllegalArgumentException("File is a directory:" + toWrite);
            }
            if (!toWrite.canWrite()) {
                throw new IllegalStateException(new IOException("Unable to write to file:" + toWrite));
            }
            if (!override) {
                throw new IllegalStateException("File already exists:" + toWrite);
            }
        }
    }

    public static void checkAndPrepareForWrite(File target, boolean override) {
        FileUtil.checkWritable(target, override);
        FileUtil.ensureParentDirExists(target);
    }

    static void copyInternal(InputStream is, File dest) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(dest);
            FileUtil.writeStream(is, (OutputStream)fos);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            FileUtil.closeSilently(is, fos);
        }
    }

    public static void copyFile(InputStream is, File dest, boolean override) {
        FileUtil.checkAndPrepareForWrite(dest, override);
        FileUtil.copyInternal(is, dest);
    }

    public static void copyFile(File src, File dest, boolean override) {
        FileUtil.checkReadable(src);
        FileUtil.checkAndPrepareForWrite(dest, override);
        FileUtil.copyFileInternal(src, dest);
    }

    static void copyFileInternal(File src, File dest) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(src);
            FileUtil.copyInternal(fis, dest);
        }
        catch (FileNotFoundException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                FileUtil.closeSilently(fis);
                throw throwable;
            }
        }
        FileUtil.closeSilently(fis);
    }

    public static void copyFile(File src, File dest) {
        FileUtil.copyFile(src, dest, false);
    }

    public static void copyFile(String src, String dest, boolean override) {
        FileUtil.copyFile(new File(src), new File(dest), override);
    }

    public static void copyFile(String src, String dest) {
        FileUtil.copyFile(src, dest, false);
    }

    public static void copyFileToDirectory(File file, File destDiretory, boolean override) {
        if (destDiretory.exists()) {
            if (!destDiretory.isDirectory()) {
                throw new IllegalStateException("It's not a directory:" + destDiretory);
            }
            if (!destDiretory.canWrite()) {
                throw new IllegalStateException(new AccessDeniedException("Unable to write to file\uff1a" + destDiretory));
            }
        }
        FileUtil.copyFile(file, new File(destDiretory, file.getName()), override);
    }

    public static void copyFileToDirectory(File file, File diretory) {
        FileUtil.copyFileToDirectory(file, diretory, false);
    }

    public static void copyFileToDirectory(String file, String destDiretory, boolean override) {
        FileUtil.copyFileToDirectory(new File(file), new File(destDiretory), override);
    }

    public static void copyFileToDirectory(String file, String destDiretory) {
        FileUtil.copyFileToDirectory(file, destDiretory, false);
    }

    public static void moveFile(File src, File dest, boolean override) {
        FileUtil.checkReadable(src);
        FileUtil.checkAndPrepareForWrite(dest, override);
        FileUtil.moveFileInternal(src, dest, override);
    }

    public static void ensureParentDirExists(File target) {
        File parent = target.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IllegalStateException(new IOException("Unable to create directory:" + parent));
        }
    }

    public static void moveFile(File src, File dest) {
        FileUtil.moveFile(src, dest, false);
    }

    public static void moveFile(String path, String destPath, boolean override) {
        FileUtil.moveFile(new File(path), new File(destPath), override);
    }

    public static void moveFile(String path, String dest) {
        FileUtil.moveFile(new File(path), new File(dest), false);
    }

    public static void moveFileToDirectory(File file, File destDirectory, boolean override) throws IllegalArgumentException {
        FileUtil.checkReadable(file);
        File dest = new File(destDirectory, file.getName());
        FileUtil.checkAndPrepareForWrite(dest, override);
        FileUtil.moveFileInternal(file, dest, override);
    }

    static void moveFileInternal(File src, File dest, boolean override) {
        if (!src.renameTo(dest)) {
            if (override) {
                FileUtil.copyFileInternal(src, dest);
                src.delete();
            } else {
                throw new IllegalArgumentException("Move file failed:[" + src + "] => [" + dest + ']');
            }
        }
    }

    public static void moveFileToDirectory(File file, File directory) {
        FileUtil.moveFileToDirectory(file, directory, false);
    }

    public static void moveFileToDirectory(String path, String directory, boolean override) {
        FileUtil.moveFileToDirectory(new File(path), new File(directory), override);
    }

    public static void moveFileToDirectory(String path, String directory) {
        FileUtil.moveFileToDirectory(path, directory, false);
    }

    public static void writeStream(InputStream in, OutputStream out) throws IOException {
        int length;
        if (in instanceof FileInputStream && out instanceof FileOutputStream) {
            FileUtil.writeStream((FileInputStream)in, (FileOutputStream)out);
            return;
        }
        byte[] buffer = new byte[8192];
        while ((length = in.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStream(FileInputStream fis, FileOutputStream fos) throws IOException {
        FileChannel inChannel = fis.getChannel();
        FileChannel outChannel = fos.getChannel();
        long total = inChannel.size();
        long copied = 0L;
        try {
            while ((copied += inChannel.transferTo(copied, total, outChannel)) < total) {
            }
        }
        finally {
            FileUtil.closeSilently(outChannel);
            FileUtil.closeSilently(inChannel);
        }
    }

    public static void close(@Nullable InputStream in, @Nullable OutputStream out) throws IOException {
        try {
            FileUtil.close(out);
        }
        finally {
            FileUtil.close(in);
        }
    }

    public static void close(@Nullable Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void closeSilently(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(@Nullable InputStream in, @Nullable OutputStream out) {
        FileUtil.closeSilently(out);
        FileUtil.closeSilently(in);
    }

    public static File copyFileToDirectoryWithRandomFileName(File file, String destDir) {
        File dest = FileUtil.getRandomFile(destDir, FileUtil.getExtension(file.getName()));
        FileUtil.copyFile(file, dest);
        return dest;
    }

    public static File moveFileToDirectoryWithRandomFileName(File file, String destDir) {
        File dest = FileUtil.getRandomFile(destDir, FileUtil.getExtension(file.getName()));
        FileUtil.moveFile(file, dest);
        return dest;
    }

    public static File copyFileToDirectoryWithRandomFileName(File file, String destDir, String prefix, String suffix) {
        File dest = FileUtil.getRandomFile(destDir, prefix, suffix);
        FileUtil.copyFile(file, dest);
        return dest;
    }

    public static File copyFileToDirectoryWithRandomFileName(File file, String destDir, String suffix) {
        return FileUtil.copyFileToDirectoryWithRandomFileName(file, destDir, null, suffix);
    }

    public static File moveFileToDirectoryWithRandomFileName(File file, String destDir, String prefix, String suffix) {
        File dest = FileUtil.getRandomFile(destDir, prefix, suffix);
        FileUtil.moveFile(file, dest);
        return dest;
    }

    public static File moveFileToDirectoryWithRandomFileName(File file, String destDir, String suffix) {
        return FileUtil.moveFileToDirectoryWithRandomFileName(file, destDir, null, suffix);
    }

    public static File parseClassPathFile(String pathname) {
        char char0 = pathname.charAt(0);
        if (char0 != '/' && char0 != '\\') {
            pathname = '/' + pathname;
        }
        return new File(FileUtil.class.getResource(pathname).getPath());
    }

    public static File getFile(String pathname, boolean inClassPath) {
        return inClassPath ? FileUtil.parseClassPathFile(pathname) : new File(pathname);
    }

    public static File parseFile(String pathname, boolean checkExists) {
        File file;
        String classPathPrefix = "classpath:";
        File file2 = file = pathname.startsWith("classpath:") ? FileUtil.parseClassPathFile(pathname.substring("classpath:".length())) : new File(pathname);
        if (checkExists && !file.exists()) {
            throw new IllegalArgumentException("File not found\uff1a[" + file.getPath() + ']');
        }
        return file;
    }

    public static String readContent(File file) {
        FileUtil.checkReadable(file);
        BufferedReader reader = null;
        long length = (file.length() >>> 3) + 1L;
        StringBuilder sb = new StringBuilder((int)length);
        boolean lineBreak = false;
        try {
            String str;
            reader = new BufferedReader(new FileReader(file));
            while ((str = reader.readLine()) != null) {
                if (lineBreak) {
                    sb.append('\n');
                } else {
                    lineBreak = true;
                }
                sb.append(str);
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                FileUtil.closeSilently(reader);
                throw throwable;
            }
        }
        FileUtil.closeSilently(reader);
        return sb.toString();
    }

    public static String readContent(String pathname, boolean inClassPath) {
        return FileUtil.readContent(FileUtil.getFile(pathname, inClassPath));
    }

    public static void writeContent(File file, InputStream is, boolean append) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file, append);){
            FileUtil.writeStream(is, (OutputStream)fos);
        }
    }

    public static void writeContent(File file, byte[] data, boolean append) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file, append);){
            fos.write(data);
        }
    }

    public static void writeContent(File file, String data, boolean append) throws IOException {
        FileUtil.ensureParentDirExists(file);
        try (FileWriter writer = new FileWriter(file, append);){
            writer.write(data);
        }
    }

    public static Map<String, String> readProperties(File file) {
        Map map;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            Properties prop = new Properties();
            prop.load(inputStream);
            map = (Map)X.castType(prop);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException fe) {
                return null;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        ((InputStream)inputStream).close();
        return map;
    }

    public static Map<String, String> readProperties(String pathname, boolean inClassPath) {
        return FileUtil.readProperties(FileUtil.getFile(pathname, inClassPath));
    }
}

