/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.codeplayer.util.X;

public abstract class CollectionUtil {
    protected static void checkPairs(Object ... pairs) {
        if ((pairs.length & 1) != 0) {
            throw new IllegalArgumentException("The length of the Array must be even:" + pairs.length);
        }
    }

    public static int mapInitialCapacity(int realCapacity, float loadFactor) {
        float size = (float)realCapacity / loadFactor;
        return size > (float)((int)size) ? (int)size + 1 : (int)size;
    }

    public static int mapInitialCapacity(int realCapacity) {
        return realCapacity * 4 / 3 + (realCapacity % 3 == 0 ? 0 : 1);
    }

    public static <E> Collection<E> addAll(Collection<E> target, @Nullable Predicate<? super E> filter, E ... elements) {
        for (E e : elements) {
            if (filter != null && !filter.test(e)) continue;
            target.add(e);
        }
        return target;
    }

    public static <E> Collection<E> addAll(Collection<E> target, E ... elements) {
        return CollectionUtil.addAll(target, null, elements);
    }

    public static <K, V> Map<K, V> addAll(Map<K, V> map, Object ... kvPairs) {
        CollectionUtil.checkPairs(kvPairs);
        Map m = (Map)X.castType(map);
        int i = 0;
        while (i < kvPairs.length) {
            m.put(kvPairs[i++], kvPairs[i++]);
        }
        return map;
    }

    public static <E, S extends Collection<E>> S ofSize(IntFunction<S> newList, E ... elements) {
        Collection list = (Collection)newList.apply(elements.length);
        CollectionUtil.addAll(list, elements);
        return (S)list;
    }

    public static <E, S extends Collection<E>> S of(Supplier<S> newList, E ... elements) {
        Collection list = (Collection)newList.get();
        CollectionUtil.addAll(list, elements);
        return (S)list;
    }

    public static <E, S extends Set<E>> S ofSet(IntFunction<S> newSet, E ... elements) {
        Set list = (Set)newSet.apply(CollectionUtil.mapInitialCapacity(elements.length));
        CollectionUtil.addAll(list, elements);
        return (S)list;
    }

    public static <E> HashSet<E> ofHashSet(E ... elements) {
        return CollectionUtil.ofSet(HashSet::new, elements);
    }

    public static <E> ArrayList<E> ofArrayList(E ... elements) {
        return CollectionUtil.ofSize(ArrayList::new, elements);
    }

    public static <E> List<E> filter(Collection<E> c, Predicate<? super E> matcher) {
        ArrayList<E> list;
        int size = c.size();
        ArrayList<E> arrayList = list = size >= 10 ? new ArrayList<E>() : new ArrayList(size);
        if (size > 0) {
            for (E e : c) {
                if (!matcher.test(e)) continue;
                list.add(e);
            }
        }
        return list;
    }

    public static <K, V, M extends Map<K, V>> M toMap(IntFunction<M> newMap, Object ... elements) {
        Map map = (Map)newMap.apply(CollectionUtil.mapInitialCapacity(elements.length));
        CollectionUtil.addAll(map, elements);
        return (M)map;
    }

    public static <K, V> HashMap<K, V> ofHashMap(Object ... elements) {
        return CollectionUtil.toMap(HashMap::new, elements);
    }

    public static <E, K, V, M extends Map<K, V>> M toMap(IntFunction<M> newMap, Iterable<E> items, Function<? super E, K> keyMapper, Function<? super E, V> valueMapper) {
        int size = items instanceof Collection ? ((Collection)items).size() : 0;
        Map map = (Map)newMap.apply(size > 0 ? CollectionUtil.mapInitialCapacity(size) : 16);
        if (items != null) {
            for (E e : items) {
                map.put(keyMapper.apply(e), valueMapper.apply(e));
            }
        }
        return (M)map;
    }

    public static <E, K, V> HashMap<K, V> toHashMap(Iterable<E> items, Function<? super E, K> keyMapper, Function<? super E, V> valueMapper) {
        return CollectionUtil.toMap(HashMap::new, items, keyMapper, valueMapper);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return new HashMap(CollectionUtil.mapInitialCapacity(size));
    }

    public static <K> HashSet<K> newHashSet(int size) {
        return new HashSet(CollectionUtil.mapInitialCapacity(size));
    }

    public static <K, V, M extends Map<K, V>> M toMap(IntFunction<M> newMap, Iterable<V> items, Function<? super V, K> keyMapper) {
        return CollectionUtil.toMap(newMap, items, keyMapper, Function.identity());
    }

    public static <K, V> HashMap<K, V> toHashMap(Iterable<V> items, Function<? super V, K> keyMapper) {
        return CollectionUtil.toMap(HashMap::new, items, keyMapper);
    }

    public static <K, V> V[] mapValues(Map<K, V> map, Class<V> valueClass, K ... keys) {
        Object[] results = (Object[])X.castType(Array.newInstance(valueClass, keys.length));
        for (int i = 0; i < keys.length; ++i) {
            results[i] = map.get(keys[i]);
        }
        return results;
    }

    public static <T> T findFirst(Collection<T> range, @Nullable Predicate<? super T> filter) {
        if (range != null && !range.isEmpty()) {
            for (T t : range) {
                if (filter != null && !filter.test(t)) continue;
                return t;
            }
        }
        return null;
    }

    public static <T> T getAny(Collection<T> range) {
        if (range != null && !range.isEmpty()) {
            if (range instanceof List) {
                return (T)((List)range).get(0);
            }
            Iterator<T> iterator = range.iterator();
            if (iterator.hasNext()) {
                T t = iterator.next();
                return t;
            }
        }
        return null;
    }

    public static <T, R> R[] mapField(Collection<T> list, Class<R> fieldType, Function<? super T, ? extends R> mapper) {
        if (list == null) {
            return null;
        }
        int size = list.size();
        Object[] arrays = (Object[])Array.newInstance(fieldType, size);
        if (size > 0) {
            int index = 0;
            for (T t : list) {
                arrays[index++] = mapper.apply(t);
            }
        }
        return arrays;
    }
}

