/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.codeplayer.util.ArrayUtil;
import me.codeplayer.util.CharConverter;
import me.codeplayer.util.Charsets;
import me.codeplayer.util.X;
import org.apache.commons.lang3.ArrayUtils;

public abstract class StringUtil {
    protected static final char[] digits = "0123456789ABCDEF".toCharArray();

    public static String unicode(String source) {
        byte[] bytes = source.getBytes(Charsets.UTF_16);
        int length = bytes.length;
        if (length > 2) {
            int i;
            StringBuilder sb = new StringBuilder((length - i) * 3);
            boolean isOdd = false;
            for (i = 2; i < length; ++i) {
                if (isOdd = !isOdd) {
                    sb.append("\\u");
                }
                sb.append(digits[bytes[i] >> 4 & 0xF]);
                sb.append(digits[bytes[i] & 0xF]);
            }
            return sb.toString();
        }
        return source;
    }

    public static String fastUnicode(String source) {
        byte[] bytes = source.getBytes(Charsets.UTF_16);
        int length = bytes.length;
        if (length > 2) {
            int i;
            char[] chars = new char[(length - i) * 3];
            int index = 0;
            boolean isOdd = false;
            for (i = 2; i < length; ++i) {
                if (isOdd = !isOdd) {
                    chars[index++] = 92;
                    chars[index++] = 117;
                }
                chars[index++] = digits[bytes[i] >> 4 & 0xF];
                chars[index++] = digits[bytes[i] & 0xF];
            }
            return new String(chars);
        }
        return "";
    }

    public static StringBuilder getBuilder(int size, int shift) {
        int capacity = size << shift;
        if (capacity < 16) {
            capacity = 16;
        }
        return new StringBuilder(capacity);
    }

    public static int length(@Nullable CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static StringBuilder getBuilder(int extraCapacity, @Nullable CharSequence s1, @Nullable CharSequence s2, @Nullable CharSequence s3, @Nullable CharSequence s4) {
        return new StringBuilder(extraCapacity + StringUtil.length(s1) + StringUtil.length(s2) + StringUtil.length(s3) + StringUtil.length(s4));
    }

    public static StringBuilder getBuilder(int extraCapacity, @Nullable CharSequence s1, @Nullable CharSequence s2, @Nullable CharSequence s3) {
        return new StringBuilder(extraCapacity + StringUtil.length(s1) + StringUtil.length(s2) + StringUtil.length(s3));
    }

    public static StringBuilder getBuilder(int extraCapacity, @Nullable CharSequence s1, @Nullable CharSequence s2) {
        return new StringBuilder(extraCapacity + StringUtil.length(s1) + StringUtil.length(s2));
    }

    public static StringBuilder getBuilder(int extraCapacity, @Nullable CharSequence s1) {
        return new StringBuilder(extraCapacity + StringUtil.length(s1));
    }

    public static String concat(@Nullable String a, @Nullable String b) {
        if (a == null || a.isEmpty()) {
            return b == null ? "" : b;
        }
        if (b == null || b.isEmpty()) {
            return a;
        }
        return a.concat(b);
    }

    public static String concat(@Nullable String a, @Nullable String b, @Nullable String c) {
        int aSize = StringUtil.length(a);
        if (aSize == 0) {
            return StringUtil.concat(b, c);
        }
        int bSize = StringUtil.length(b);
        if (bSize == 0) {
            return StringUtil.concat(a, c);
        }
        int cSize = StringUtil.length(c);
        if (cSize == 0) {
            return StringUtil.concat(a, b);
        }
        return new StringBuilder(aSize + bSize + cSize).append(a).append(b).append(c).toString();
    }

    public static StringBuilder append(@Nullable StringBuilder sb, String ... parts) {
        int size = 0;
        for (String str : parts) {
            size += StringUtil.length(str);
        }
        sb = StringUtil.initBuilder(sb, size);
        for (String str : parts) {
            if (str == null) continue;
            sb.append(str);
        }
        return sb;
    }

    public static String concats(String ... parts) {
        return StringUtil.append(null, parts).toString();
    }

    public static StringBuilder initBuilder(@Nullable StringBuilder sb, int appendLength) {
        if (sb == null) {
            sb = new StringBuilder(appendLength);
        } else {
            sb.ensureCapacity(sb.length() + appendLength);
        }
        return sb;
    }

    public static boolean isEmpty(@Nullable CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean notEmpty(@Nullable CharSequence cs) {
        return cs != null && cs.length() > 0;
    }

    public static boolean isAnyNotEmpty(CharSequence ... css) {
        if (css != null && css.length > 0) {
            for (CharSequence cs : css) {
                if (!StringUtil.notEmpty(cs)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEmpty(@Nullable Object obj) {
        return obj == null || obj.toString().length() == 0;
    }

    public static boolean notEmpty(@Nullable Object obj) {
        return obj != null && obj.toString().length() > 0;
    }

    public static boolean hasEmpty(Object ... values) {
        int length = ArrayUtil.getLength(values, true);
        do {
            if (!StringUtil.isEmpty(values[--length])) continue;
            return true;
        } while (length > 0);
        return false;
    }

    public static boolean isBlank(CharSequence str) {
        if (str == null) {
            return true;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean notBlank(CharSequence cs) {
        return !StringUtil.isBlank(cs);
    }

    public static boolean isBlank(Object obj) {
        return obj == null || StringUtil.isBlank(obj.toString());
    }

    public static boolean notBlank(Object obj) {
        return !StringUtil.isBlank(obj);
    }

    public static boolean hasBlank(Object ... values) {
        int length = ArrayUtil.getLength(values, true);
        do {
            if (!StringUtil.isBlank(values[--length])) continue;
            return true;
        } while (length > 0);
        return false;
    }

    public static String toString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    @Nullable
    public static String nullSafeGet(@Nullable Supplier<? extends CharSequence> msgSupplier) {
        return msgSupplier == null ? null : StringUtil.nullSafeGet(msgSupplier.get());
    }

    @Nullable
    public static String nullSafeGet(@Nullable CharSequence cs) {
        return cs == null ? null : cs.toString();
    }

    public static String toString(Object obj, String defaultValIfNull) {
        return obj == null ? defaultValIfNull : obj.toString();
    }

    public static String trim(Object obj) {
        return obj == null ? "" : obj.toString().trim();
    }

    public static String limitChars(String str, int maxLength, String suffix) {
        if (str == null) {
            return "";
        }
        int length = (str = str.trim()).length();
        if (length <= maxLength) {
            return str;
        }
        str = str.substring(0, maxLength);
        return suffix == null ? str : str.concat(suffix);
    }

    public static String limitChars(String str, int maxLength) {
        return StringUtil.limitChars(str, maxLength, "...");
    }

    public static String zeroFill(String str, int minLength) {
        return StringUtil.pad(str, '0', minLength, true);
    }

    static String pad(String str, char ch, int minLength, boolean leftOrRight) {
        if (str == null) {
            return "";
        }
        if (minLength < 1) {
            throw new IllegalArgumentException("Argument 'minLength' can not be less than 1:" + minLength);
        }
        int length = str.length();
        if (minLength > length) {
            int diffSize = minLength - length;
            char[] chars = new char[minLength];
            if (leftOrRight) {
                for (int i = 0; i < diffSize; ++i) {
                    chars[i] = ch;
                }
                System.arraycopy(str.toCharArray(), 0, chars, diffSize, length);
            } else {
                for (int i = diffSize; i < minLength; ++i) {
                    chars[i] = ch;
                }
                System.arraycopy(str.toCharArray(), 0, chars, 0, length);
            }
            str = new String(chars);
        }
        return str;
    }

    public static StringBuilder zeroFill(@Nullable StringBuilder sb, long val, int minLength) {
        if (sb == null) {
            sb = new StringBuilder(val < 0L ? 16 : Math.max(minLength, val < 100L ? 2 : (val < 10000L ? 4 : 8)));
        }
        int before = sb.length();
        sb.append(val);
        int len = sb.length() - before;
        if (len < minLength) {
            sb.ensureCapacity(before + minLength);
            do {
                sb.append('0');
            } while (++len < minLength);
        }
        return sb;
    }

    public static String zeroFill(long val, int minLength) {
        return StringUtil.zeroFill(null, val, minLength).toString();
    }

    public static String zeroFill(int val, int minLength) {
        return StringUtil.zeroFill(null, val, minLength).toString();
    }

    public static String leftPad(String str, char ch, int minLength) {
        return StringUtil.pad(str, ch, minLength, true);
    }

    public static String rightPad(String str, char ch, int maxLength) {
        return StringUtil.pad(str, ch, maxLength, false);
    }

    public static String trim(String str) {
        return str == null ? "" : str.trim();
    }

    public static String trimAll(String str) {
        if (StringUtil.isEmpty(str)) {
            return "";
        }
        int len = str.length();
        char[] chars = null;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (chars != null) continue;
                chars = new char[len - 1];
                str.getChars(0, i, chars, 0);
                continue;
            }
            if (chars == null) continue;
            chars[count++] = ch;
        }
        if (count == len) {
            return str;
        }
        if (count == 0) {
            return "";
        }
        return new String(chars, 0, count);
    }

    public static String replaceChars(String str, char ch, int beginIndex, int endIndex) {
        int length = str.length();
        int[] range = StringUtil.ensureRangeSafe(beginIndex, endIndex, length);
        if (range == null) {
            return str;
        }
        char[] chars = str.toCharArray();
        for (int i = range[0]; i < range[1]; ++i) {
            chars[i] = ch;
        }
        return new String(chars);
    }

    public static int[] ensureRangeSafe(int beginIndex, int endIndex, int length) {
        if (length <= 0 || beginIndex == endIndex) {
            return null;
        }
        if (beginIndex < 0) {
            if ((beginIndex += length) < 0) {
                beginIndex = 0;
            }
        } else if (beginIndex >= length) {
            return null;
        }
        if (endIndex < 0) {
            if ((endIndex += length) < 0) {
                return null;
            }
        } else if (endIndex > length) {
            endIndex = length;
        }
        int[] range = new int[]{beginIndex, endIndex};
        if (beginIndex > endIndex) {
            range[0] = endIndex;
            range[1] = beginIndex;
        }
        return range;
    }

    public static String replaceChars(String str, char ch, int beginIndex) {
        return StringUtil.replaceChars(str, ch, beginIndex, str.length());
    }

    public static String replaceSubstring(String str, String replacement, int beginIndex, int endIndex) {
        if (replacement == null || replacement.length() == 0) {
            return str;
        }
        int length = str.length();
        int[] range = StringUtil.ensureRangeSafe(beginIndex, endIndex, length);
        if (range == null) {
            return str;
        }
        beginIndex = range[0];
        endIndex = range[1];
        StringBuilder sb = new StringBuilder(replacement.length() + length - endIndex + beginIndex);
        if (beginIndex > 0) {
            sb.append(str, 0, beginIndex);
        }
        sb.append(replacement);
        if (endIndex < length) {
            sb.append(str, endIndex, length);
        }
        return sb.toString();
    }

    public static String replaceSubstring(String str, String replacement, int beginIndex) {
        return StringUtil.replaceSubstring(str, replacement, beginIndex, str.length());
    }

    public static String convertCharset(String str, Charset originalCharset, Charset targetCharset) {
        return new String(str.getBytes(originalCharset), targetCharset);
    }

    public static String convertCharsetForURI(String str, Charset targetCharset) {
        return StringUtil.convertCharset(str, Charsets.ISO_8859_1, targetCharset);
    }

    public static String reverse(CharSequence str) {
        if (str == null) {
            return "";
        }
        return new StringBuilder(str).reverse().toString();
    }

    public static boolean startsWith(String str, char firstChar) {
        return str != null && str.length() > 0 && str.charAt(0) == firstChar;
    }

    public static boolean endsWith(String str, char lastChar) {
        return str != null && str.length() > 0 && str.charAt(str.length() - 1) == lastChar;
    }

    public static StringBuilder escape(@Nullable StringBuilder sb, String str, char escapeChar, char[] escapedChars) {
        sb = StringUtil.initBuilder(sb, str.length() + 4);
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == escapeChar || ArrayUtils.contains((char[])escapedChars, (char)ch)) {
                sb.append(escapeChar);
            }
            sb.append(ch);
        }
        return sb;
    }

    public static String escape(String str, char escapeChar, char[] escapedChars) {
        return StringUtil.escape(null, str, escapeChar, escapedChars).toString();
    }

    public static StringBuilder unescape(@Nullable StringBuilder sb, String escapedStr, char escapeChar, char[] escapedChars) {
        int length = escapedStr.length();
        sb = StringUtil.initBuilder(sb, length);
        int i = 0;
        while (i < length) {
            char next;
            char ch;
            if ((ch = escapedStr.charAt(i++)) == escapeChar && i < length && ((next = escapedStr.charAt(i)) == escapeChar || ArrayUtils.contains((char[])escapedChars, (char)next))) {
                sb.append(next);
                ++i;
                continue;
            }
            sb.append(ch);
        }
        return sb;
    }

    public static String unescape(String escapedStr, char escapeChar, char[] escapedChars) {
        return StringUtil.unescape(null, escapedStr, escapeChar, escapedChars).toString();
    }

    @Nullable
    public static StringBuilder escapeSQLLike(@Nullable StringBuilder sb, String likeStr, char escapeChar, boolean appendWildcardAtStart, boolean appendWildcardAtEnd) {
        if (StringUtil.isEmpty(likeStr)) {
            return sb;
        }
        char[] strChars = likeStr.toCharArray();
        int length = strChars.length + 2;
        if (appendWildcardAtStart || appendWildcardAtEnd) {
            length += 2;
        }
        sb = StringUtil.initBuilder(sb, length);
        String searchChars = "\\'_%;";
        if (appendWildcardAtStart) {
            sb.append('%');
        }
        for (char ch : strChars) {
            if ("\\'_%;".indexOf(ch, 0) != -1) {
                sb.append(escapeChar);
            }
            sb.append(ch);
        }
        if (appendWildcardAtEnd) {
            sb.append('%');
        }
        return sb;
    }

    public static String escapeSQLLike(String likeStr, char escapeChar, boolean appendWildcardAtStart, boolean appendWildcardAtEnd) {
        StringBuilder sb = StringUtil.escapeSQLLike(null, likeStr, escapeChar, appendWildcardAtStart, appendWildcardAtEnd);
        if (sb == null || sb.length() == likeStr.length()) {
            return likeStr;
        }
        return sb.toString();
    }

    public static String escapeSQLLike(String likeStr, boolean appendWildcardAtStart, boolean appendWildcardAtEnd) {
        return StringUtil.escapeSQLLike(likeStr, '\\', appendWildcardAtStart, appendWildcardAtEnd);
    }

    public static String escapeSQLLike(String likeStr, char escapeChar, boolean appendWildcardAtBoth) {
        return StringUtil.escapeSQLLike(likeStr, escapeChar, appendWildcardAtBoth, appendWildcardAtBoth);
    }

    public static String escapeSQLLike(String likeStr, boolean appendLikeWildcard) {
        return StringUtil.escapeSQLLike(likeStr, '\\', appendLikeWildcard);
    }

    public static String escapeSQLLike(String likeStr) {
        return StringUtil.escapeSQLLike(likeStr, '\\', false);
    }

    public static boolean containsWord(String container, String search, String separatorChars, boolean fastMode) {
        int sLength;
        if (container == null || search == null) {
            return false;
        }
        int cLength = container.length();
        if (cLength == (sLength = search.length())) {
            return container.equals(search);
        }
        if (cLength > sLength) {
            int startIndex;
            int fromIndex = 0;
            while ((startIndex = container.indexOf(search, fromIndex)) != -1) {
                fromIndex = startIndex + sLength;
                if (!(startIndex != 0 && separatorChars.indexOf(container.charAt(startIndex - 1)) == -1 || fromIndex != cLength && separatorChars.indexOf(container.charAt(fromIndex)) == -1)) {
                    return true;
                }
                if (!fastMode && fromIndex + sLength <= cLength) continue;
                break;
            }
        }
        return false;
    }

    public static boolean containsWord(String container, String searchedWord, String separatorChars) {
        return StringUtil.containsWord(container, searchedWord, separatorChars, false);
    }

    public static String capitalize(String str) {
        return StringUtil.replaceChar(str, 0, CharConverter.CharCase.UPPER);
    }

    public static String decapitalize(String str) {
        return StringUtil.replaceChar(str, 0, CharConverter.CharCase.LOWER);
    }

    public static String replaceChar(String str, int charIndex, CharConverter converter) throws IndexOutOfBoundsException {
        char replaced;
        if (str == null || str.length() == 0) {
            return str;
        }
        char ch = str.charAt(charIndex);
        if (ch == (replaced = converter.apply(ch))) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[charIndex] = replaced;
        return new String(chars);
    }

    public static <E> StringBuilder joinAppend(@Nonnull StringBuilder sb, Collection<E> items, BiConsumer<StringBuilder, E> itemAppender, String delimiter) {
        if (X.isValid(items)) {
            int size = items.size();
            sb.ensureCapacity(sb.length() + size * (6 + delimiter.length()) + 4);
            boolean appendSep = false;
            for (E e : items) {
                if (appendSep) {
                    sb.append(delimiter);
                } else {
                    appendSep = true;
                }
                itemAppender.accept(sb, e);
            }
        }
        return sb;
    }

    public static <E> String join(Collection<E> items, BiConsumer<StringBuilder, E> itemAppender, String delimiter) {
        if (X.isValid(items)) {
            int size = items.size();
            StringBuilder sb = new StringBuilder(size * (6 + delimiter.length()) + 4);
            boolean appendSep = false;
            for (E e : items) {
                if (appendSep) {
                    sb.append(delimiter);
                } else {
                    appendSep = true;
                }
                itemAppender.accept(sb, e);
            }
            return sb.toString();
        }
        return "";
    }

    public static <E> String join(Collection<E> c, Function<? super E, Object> getter, String delimiter) {
        return StringUtil.join(c, (StringBuilder sb, E t) -> sb.append(getter.apply((Object)t)), delimiter);
    }

    public static <T> String joinNumber(Collection<T> c, Function<? super T, Number> mapper, String delimiter) {
        return StringUtil.join(c, (StringBuilder sb, E t) -> sb.append(((Number)mapper.apply(t)).longValue()), delimiter);
    }

    public static <T> String joinLong(Collection<T> c, ToLongFunction<? super T> mapper, String delimiter) {
        return StringUtil.join(c, (StringBuilder sb, E t) -> sb.append(mapper.applyAsLong(t)), delimiter);
    }

    public static <T> String joinInt(Collection<T> c, ToIntFunction<? super T> mapper, String delimiter) {
        return StringUtil.join(c, (StringBuilder sb, E t) -> sb.append(mapper.applyAsInt(t)), delimiter);
    }

    public static <T> List<T> split(String str, String sep, @Nullable Predicate<? super String> filter, Function<? super String, T> mapper) {
        if (StringUtil.notEmpty(str)) {
            int pos;
            ArrayList list = new ArrayList();
            int start = 0;
            while ((pos = str.indexOf(sep, start)) != -1) {
                StringUtil.addPartToList(str, mapper, filter, list, start, pos);
                start = pos + 1;
            }
            if (start <= str.length()) {
                StringUtil.addPartToList(str, mapper, filter, list, start, str.length());
            }
            return list;
        }
        return null;
    }

    public static <T> List<T> split(String toSplit, String sep, Function<? super String, T> mapper, boolean ignoreEmpty) {
        if (StringUtil.notEmpty(toSplit)) {
            Predicate<String> filter = ignoreEmpty ? StringUtil::notEmpty : null;
            return StringUtil.split(toSplit, sep, filter, mapper);
        }
        return null;
    }

    public static <T> List<T> split(String toSplit, String sep, Function<String, T> mapper) {
        return StringUtil.split(toSplit, sep, mapper, true);
    }

    private static <T> void addPartToList(String str, Function<? super String, T> mapper, @Nullable Predicate<? super String> filter, List<T> toList, int start, int end) {
        String substr;
        String string = substr = start == end ? "" : str.substring(start, end);
        if (filter == null || filter.test(substr)) {
            T part = mapper.apply(str.substring(start, end));
            toList.add(part);
        }
    }
}

