/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.commons.lang3.time.FastDateFormat;

public class EasyDate
implements Comparable<Object>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DATE = "yyyy-MM-dd";
    public static final String DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String SHORT_DATE = "yyyyMMdd";
    public static final String YM_DATE = "yyyyMM";
    public static final String GMT_DATE = "d MMM yyyy HH:mm:ss 'GMT'";
    public static final String GMT_NET_DATE = "EEE, d MMM yyyy HH:mm:ss 'GMT'";
    public static final long MILLIS_OF_MINUTE = 60000L;
    public static final long MILLIS_OF_HOUR = 3600000L;
    public static final long MILLIS_OF_DAY = 86400000L;
    private Calendar calendar;

    protected void initCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.calendar.setLenient(false);
        this.calendar.setFirstDayOfWeek(2);
    }

    public EasyDate(java.util.Date date) {
        this(date.getTime());
    }

    public EasyDate() {
        this.initCalendar(new GregorianCalendar());
    }

    public EasyDate(long date) {
        this();
        this.setTime(date);
    }

    private EasyDate(@Nullable Object date, int offsetYear, int offsetMonth, int offsetDay) {
        this(EasyDate.getTimeOfDate(date));
        if (offsetYear != 0) {
            this.calendar.add(1, offsetYear);
        }
        if (offsetMonth != 0) {
            this.calendar.add(2, offsetMonth);
        }
        if (offsetDay != 0) {
            this.calendar.add(5, offsetDay);
        }
    }

    public EasyDate(java.util.Date date, int offsetYear, int offsetMonth, int offsetDay) {
        this((Object)date, offsetYear, offsetMonth, offsetDay);
    }

    public EasyDate(EasyDate date, int offsetYear, int offsetMonth, int offsetDay) {
        this((Object)date, offsetYear, offsetMonth, offsetDay);
    }

    public EasyDate(Calendar date, int offsetYear, int offsetMonth, int offsetDay) {
        this((Object)date, offsetYear, offsetMonth, offsetDay);
    }

    public static long getTimeOfDate(@Nullable Object date) {
        long theTime;
        if (date == null) {
            theTime = System.currentTimeMillis();
        } else if (date instanceof java.util.Date) {
            theTime = ((java.util.Date)date).getTime();
        } else if (date instanceof EasyDate) {
            theTime = ((EasyDate)date).getTime();
        } else if (date instanceof Calendar) {
            theTime = ((Calendar)date).getTimeInMillis();
        } else {
            throw new ClassCastException(date.getClass().getName());
        }
        return theTime;
    }

    public EasyDate(int year, int month, int day, int ... args) {
        this();
        this.resetAs(year, month, day, args);
    }

    public EasyDate resetAs(int year, int month, int day, int ... args) {
        int size = args == null ? 0 : args.length;
        return this.setYear(year).setMonth(month).setDay(day).setHour(size > 0 ? args[0] : 0).setMinute(size > 1 ? args[1] : 0).setSecond(size > 2 ? args[2] : 0).setMillisecond(size > 3 ? args[3] : 0);
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public EasyDate setYear(int year) {
        this.calendar.set(1, year);
        return this;
    }

    public EasyDate addYear(int year) {
        this.calendar.add(1, year);
        return this;
    }

    public int getMonth() {
        return this.calendar.get(2) + 1;
    }

    public EasyDate setMonth(int month) {
        this.calendar.set(2, month - 1);
        return this;
    }

    public EasyDate addMonth(int month) {
        this.calendar.add(2, month);
        return this;
    }

    public EasyDate set(int year, int month, int day, int ... args) {
        this.calendar.set(1, year);
        this.calendar.set(2, month - 1);
        this.calendar.set(5, day);
        if (args.length > 0) {
            int[] fields = new int[]{11, 12, 13, 14};
            int i = 0;
            do {
                this.calendar.set(fields[i], args[i]);
            } while (++i < args.length);
        }
        return this;
    }

    public int getDay() {
        return this.calendar.get(5);
    }

    public int getDayOfYear() {
        return this.calendar.get(6);
    }

    public EasyDate setDay(int day) {
        this.calendar.set(5, day);
        return this;
    }

    public EasyDate addDay(int day) {
        this.calendar.add(5, day);
        return this;
    }

    public int getWeekDay() {
        int weekday = this.calendar.get(7);
        return weekday == 1 ? 7 : --weekday;
    }

    public int getHour() {
        return this.calendar.get(11);
    }

    public EasyDate setHour(int hour) {
        this.calendar.set(11, hour);
        return this;
    }

    public EasyDate addHour(int hour) {
        this.calendar.add(11, hour);
        return this;
    }

    public int getMinute() {
        return this.calendar.get(12);
    }

    public EasyDate setMinute(int minute) {
        this.calendar.set(12, minute);
        return this;
    }

    public EasyDate addMinute(int minute) {
        this.calendar.add(12, minute);
        return this;
    }

    public int getSecond() {
        return this.calendar.get(13);
    }

    public EasyDate setSecond(int second) {
        this.calendar.set(13, second);
        return this;
    }

    public EasyDate addMillisecond(int ms) {
        this.calendar.add(14, ms);
        return this;
    }

    public int getMillisecond() {
        return this.calendar.get(14);
    }

    public EasyDate setMillisecond(int ms) {
        this.calendar.set(14, ms);
        return this;
    }

    public EasyDate addSecond(int second) {
        this.calendar.add(13, second);
        return this;
    }

    public long getTime() {
        return this.calendar.getTimeInMillis();
    }

    public EasyDate setTime(long date) {
        this.calendar.setTimeInMillis(date);
        return this;
    }

    public EasyDate addTime(long time) {
        this.calendar.setTimeInMillis(this.calendar.getTimeInMillis() + time);
        return this;
    }

    public EasyDate setDate(java.util.Date date) {
        this.calendar.setTime(date);
        return this;
    }

    public int getWeeksOfMonth() {
        return this.calendar.get(4);
    }

    public int getWeeksOfYear() {
        return this.calendar.get(3);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public static java.util.Date smartParseDate(String date) {
        String format;
        if (date == null) {
            throw new NullPointerException();
        }
        int length = date.length();
        switch (length) {
            case 10: {
                format = DATE;
                break;
            }
            case 19: {
                format = DATETIME;
                break;
            }
            case 8: {
                format = SHORT_DATE;
                break;
            }
            case 6: {
                format = YM_DATE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unable to parse the date string because of unexpected format:" + date);
            }
        }
        return EasyDate.parseDate(format, date);
    }

    public static EasyDate smartParse(String date) {
        return new EasyDate(EasyDate.smartParseDate(date));
    }

    public static EasyDate valueOf(Object dateObj) {
        if (dateObj == null) {
            throw new NullPointerException();
        }
        if (dateObj instanceof EasyDate) {
            return (EasyDate)dateObj;
        }
        return new EasyDate(EasyDate.getTimeOfDate(dateObj));
    }

    public static EasyDate valueOf(String date) {
        if (date == null) {
            return null;
        }
        return EasyDate.smartParse(date);
    }

    public static EasyDate parse(DateFormat format, String date) {
        try {
            return new EasyDate(format.parse(date));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static java.util.Date parseDate(String format, String dateStr) {
        java.util.Date date;
        FastDateFormat formatter = FastDateFormat.getInstance((String)format);
        try {
            date = formatter.parse(dateStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        return date;
    }

    public static EasyDate parse(String format, String dateStr) {
        return new EasyDate(EasyDate.parseDate(format, dateStr));
    }

    public java.util.Date toDate() {
        return new java.util.Date(this.calendar.getTimeInMillis());
    }

    public Date toSqlDate() {
        return new Date(this.calendar.getTimeInMillis());
    }

    public Timestamp toTimestamp() {
        return new Timestamp(this.calendar.getTimeInMillis());
    }

    public Time toTime() {
        return new Time(this.calendar.getTimeInMillis());
    }

    @Override
    public int compareTo(Object date) {
        if (this == date) {
            return 0;
        }
        if (date == null) {
            throw new NullPointerException();
        }
        long diff = this.calendar.getTimeInMillis() - EasyDate.getTimeOfDate(date);
        if (diff == 0L) {
            return 0;
        }
        return diff > 0L ? 1 : -1;
    }

    public long calcDifference(Object date, int field, RoundingMode roundingMode) {
        if (date == null) {
            throw new NullPointerException();
        }
        long theMillis = EasyDate.getTimeOfDate(date);
        long diff = this.getTime() - theMillis;
        if (diff == 0L) {
            return 0L;
        }
        switch (field) {
            case 1: 
            case 2: {
                long suffix;
                boolean isMax = diff > 0L;
                EasyDate me = new EasyDate(this.getTime());
                EasyDate other = new EasyDate(theMillis);
                EasyDate min = isMax ? other : me;
                EasyDate max = isMax ? me : other;
                int diffOfYear = max.getYear() - min.getYear();
                if (diffOfYear > 0) {
                    min.addYear(diffOfYear);
                }
                if (field == 2) {
                    int diffOfMonth = max.getMonth() - min.getMonth();
                    if (diffOfMonth != 0) {
                        min.addMonth(diffOfMonth);
                    }
                    diff = (long)diffOfYear * 12L + (long)diffOfMonth;
                } else {
                    diff = diffOfYear;
                }
                long prefix = max.getTime() - min.getTime();
                if (prefix == 0L) {
                    return diff;
                }
                if (prefix > 0L) {
                    min.calendar.add(field, 1);
                    suffix = min.getTime() - max.getTime();
                } else {
                    suffix = -prefix;
                    --diff;
                    min.calendar.add(field, -1);
                    prefix = max.getTime() - min.getTime();
                }
                double base = suffix > prefix ? 0.1 : 0.9;
                diff = new BigDecimal((double)diff + base).setScale(0, roundingMode).longValue();
                return isMax ? diff : -diff;
            }
        }
        long unit = EasyDate.getMillisOfUnit(field);
        return BigDecimal.valueOf(diff).divide(BigDecimal.valueOf(unit), roundingMode).longValue();
    }

    public long calcDifference(Object date, int field) {
        return this.calcDifference(date, field, RoundingMode.CEILING);
    }

    public int calcDifference(Object dateObj) {
        return (int)this.calcDifference(dateObj, 5, RoundingMode.CEILING);
    }

    public boolean isLeapYear(int year) {
        return ((GregorianCalendar)this.calendar).isLeapYear(year);
    }

    public boolean isLeapYear() {
        return ((GregorianCalendar)this.calendar).isLeapYear(this.getYear());
    }

    public static long getMillisOfUnit(int field) {
        switch (field) {
            case 5: 
            case 6: {
                return 86400000L;
            }
            case 10: 
            case 11: {
                return 3600000L;
            }
            case 12: {
                return 60000L;
            }
            case 13: {
                return 1000L;
            }
            case 14: {
                return 1L;
            }
        }
        throw new IllegalArgumentException(String.valueOf(field));
    }

    public static boolean isSameAs(long a, long b, int inField) {
        if (a == b) {
            return true;
        }
        if (inField > 4) {
            long diff = a - b;
            long unit = EasyDate.getMillisOfUnit(inField);
            if (diff > -unit && diff < unit) {
                long offset = (a + (long)TimeZone.getDefault().getRawOffset()) % unit - diff;
                return 0L <= offset && offset < unit;
            }
        } else {
            Calendar ac = Calendar.getInstance();
            ac.setTimeInMillis(a);
            Calendar bc = Calendar.getInstance();
            bc.setTimeInMillis(b);
            switch (inField) {
                case 3: 
                case 4: {
                    if (ac.get(4) != bc.get(4)) break;
                }
                case 2: {
                    if (ac.get(2) != bc.get(2)) break;
                }
                case 1: {
                    return ac.get(0) == bc.get(0) && ac.get(1) == bc.get(1);
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(inField));
                }
            }
        }
        return false;
    }

    public boolean isSameAs(Object date, int inField) {
        return EasyDate.isSameAs(this.getTime(), EasyDate.getTimeOfDate(date), inField);
    }

    public static boolean isSameAs(Object a, Object b, int inField) {
        return EasyDate.isSameAs(EasyDate.getTimeOfDate(a), EasyDate.getTimeOfDate(b), inField);
    }

    public boolean after(Object date) {
        return this.compareTo(date) > 0;
    }

    public int getLastDayOfMonth() {
        return this.calendar.getActualMaximum(5);
    }

    public EasyDate beginOf(int field) {
        switch (field) {
            case 1: {
                this.calendar.set(2, 0);
            }
            case 2: {
                this.calendar.set(5, 1);
            }
            case 5: {
                this.calendar.set(11, 0);
            }
            case 11: {
                this.calendar.set(12, 0);
            }
            case 12: {
                this.calendar.set(13, 0);
            }
            case 13: {
                this.calendar.set(14, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(field));
            }
        }
        return this;
    }

    public static java.util.Date beginOf(java.util.Date d, int field) {
        switch (field) {
            case 1: {
                d.setMonth(0);
            }
            case 2: {
                d.setDate(1);
            }
            case 5: {
                d.setHours(0);
            }
            case 10: 
            case 11: {
                d.setMinutes(0);
            }
            case 12: {
                d.setSeconds(0);
            }
            case 13: {
                d.setTime(d.getTime() / 1000L * 1000L);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(field));
            }
        }
        return d;
    }

    public EasyDate setTimeZone(TimeZone timeZone) {
        this.calendar.getTimeInMillis();
        this.calendar.setTimeZone(timeZone);
        return this;
    }

    public TimeZone getTimeZone() {
        return this.calendar.getTimeZone();
    }

    public EasyDate setTimeZoneOffset(int inMinutes) {
        StringBuilder timeZoneID = new StringBuilder(10).append("GMT").append(inMinutes > 0 ? (char)'+' : '-').append(inMinutes / 60);
        int min = inMinutes % 60;
        if (min > 0) {
            timeZoneID.append(':');
            if (min < 10) {
                timeZoneID.append('0');
            }
            timeZoneID.append(min);
        }
        return this.setTimeZone(TimeZone.getTimeZone(timeZoneID.toString()));
    }

    public int getTimeZoneOffset() {
        TimeZone timeZone = this.calendar.getTimeZone();
        return timeZone.getOffset(this.calendar.getTimeInMillis()) / 60000;
    }

    public EasyDate endOf(int field) {
        switch (field) {
            case 1: {
                this.calendar.set(2, 11);
            }
            case 2: {
                this.calendar.set(5, this.calendar.getActualMaximum(5));
            }
            case 5: {
                this.calendar.set(11, 23);
            }
            case 10: 
            case 11: {
                this.calendar.set(12, 59);
            }
            case 12: {
                this.calendar.set(13, 59);
            }
            case 13: {
                this.calendar.set(14, 999);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(field));
            }
        }
        return this;
    }

    public static java.util.Date endOf(java.util.Date d, int field) {
        switch (field) {
            case 1: {
                d.setMonth(11);
            }
            case 2: {
                d.setDate(EasyDate.getMaxDayOfMonth(d));
            }
            case 5: {
                d.setHours(23);
            }
            case 10: 
            case 11: {
                d.setMinutes(59);
            }
            case 12: {
                d.setSeconds(59);
            }
            case 13: {
                d.setTime(d.getTime() / 1000L * 1000L + 999L);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(field));
            }
        }
        return d;
    }

    public static int getMaxDayOfMonth(java.util.Date d) {
        int month = d.getMonth();
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 1: {
                int year = d.getYear() + 1900;
                if (year % 4 == 0 && (year % 400 == 0 || year % 100 != 0)) {
                    return 29;
                }
                return 28;
            }
        }
        return 30;
    }

    public boolean before(Object date) {
        return this.compareTo(date) < 0;
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.calendar == null ? 0 : this.calendar.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EasyDate) {
            EasyDate other = (EasyDate)obj;
            return this.calendar != null && this.calendar.equals(other.calendar);
        }
        return false;
    }

    public String toString() {
        return EasyDate.toString(this.getYear(), this.getMonth(), this.getDay());
    }

    public static String toString(java.util.Date d) {
        return EasyDate.toString(d.getYear() + 1900, d.getMonth() + 1, d.getDate());
    }

    static String toString(int year, int month, int day) {
        char[] chars = new char[]{'0', '0', '0', '0', '-', '0', '0', '-', '0', '0'};
        EasyDate.formatNormalDate(chars, 0, year, month, day);
        return new String(chars);
    }

    public String toDateString() {
        return EasyDate.toDateString(this.getYear(), this.getMonth(), this.getDay());
    }

    public static String toDateString(int year, int month, int day) {
        char[] chars = new char[]{'0', '0', '0', '0', '\u5e74', '0', '0', '\u6708', '0', '0', '\u65e5'};
        EasyDate.formatNormalDate(chars, 0, year, month, day);
        return new String(chars);
    }

    public static String toDateString(java.util.Date d) {
        return EasyDate.toDateString(d.getYear() + 1900, d.getMonth() + 1, d.getDate());
    }

    public String toString(Format format) {
        TimeZone timeZone;
        if (format instanceof DateFormat && (timeZone = this.calendar.getTimeZone()).getRawOffset() != TimeZone.getDefault().getRawOffset()) {
            ((DateFormat)format).setTimeZone(timeZone);
        }
        return format.format(this.toDate());
    }

    public String toDateTimeString() {
        return EasyDate.toDateTimeString(this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond());
    }

    public static String toDateTimeString(java.util.Date d) {
        return EasyDate.toDateTimeString(d.getYear() + 1900, d.getMonth() + 1, d.getDate(), d.getHours(), d.getMinutes(), d.getSeconds());
    }

    public static String toDateTimeString(int year, int month, int day, int hour, int minute, int second) {
        char[] chars = "0000-00-00 00:00:00".toCharArray();
        EasyDate.formatNormalDateTime(chars, year, month, day, hour, minute, second);
        return new String(chars);
    }

    public String toShortString() {
        return EasyDate.toShortString(this.getYear(), this.getMonth(), this.getDay());
    }

    public static String toShortString(java.util.Date d) {
        return EasyDate.toShortString(d.getYear() + 1900, d.getMonth() + 1, d.getDate());
    }

    public static String toShortString(int year, int month, int day) {
        char[] chars = "00000000".toCharArray();
        EasyDate.fillNumberToChars(chars, year, 0, 4);
        EasyDate.fillNumberToChars(chars, month, 4, 2);
        EasyDate.fillNumberToChars(chars, day, 6, 2);
        return new String(chars);
    }

    public String toLongString() {
        return EasyDate.toLongString(this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond());
    }

    public static String toLongString(java.util.Date d) {
        return EasyDate.toLongString(d.getYear() + 1900, d.getMonth() + 1, d.getDate(), d.getHours(), d.getMinutes(), d.getSeconds(), (int)(d.getTime() % 1000L));
    }

    public static String toLongString(int year, int month, int day, int hour, int minute, int second, int ms) {
        char[] chars = "0000-00-00 00:00:00.000".toCharArray();
        EasyDate.formatNormalDateTime(chars, year, month, day, hour, minute, second);
        EasyDate.fillNumberToChars(chars, ms, 20, 3);
        return new String(chars);
    }

    protected static void formatNormalDateTime(char[] chars, int year, int month, int day, int hour, int minute, int second) {
        EasyDate.formatNormalDate(chars, 0, year, month, day);
        EasyDate.formatNormalTime(chars, 11, hour, minute, second);
    }

    public static void formatNormalDate(char[] chars, int offset, int year, int month, int day) {
        EasyDate.fillNumberToChars(chars, year, offset, 4);
        EasyDate.fillNumberToChars(chars, month, offset + 5, 2);
        EasyDate.fillNumberToChars(chars, day, offset + 8, 2);
    }

    public static void formatNormalTime(char[] chars, int offset, int hour, int minute, int second) {
        EasyDate.fillNumberToChars(chars, hour, offset, 2);
        EasyDate.fillNumberToChars(chars, minute, offset + 3, 2);
        EasyDate.fillNumberToChars(chars, second, offset + 6, 2);
    }

    public String toGMTString() {
        return FastDateFormat.getInstance((String)GMT_DATE).format(this.toDate());
    }

    public String toGMTNetString() {
        return FastDateFormat.getInstance((String)GMT_NET_DATE).format(this.toDate());
    }

    public Object clone() {
        EasyDate date = null;
        try {
            date = (EasyDate)super.clone();
            if (this.calendar != null) {
                date.calendar = (Calendar)this.calendar.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return date;
    }

    public static void setNumberToChars(char[] chars, int number, int start, int length) {
        int end = start + length;
        while (length-- > 0) {
            chars[--end] = (char)(48 + number % 10);
            number /= 10;
        }
    }

    public static void fillNumberToChars(char[] chars, int number, int start, int length) {
        int end = start + length;
        while (number > 0 && length-- > 0) {
            chars[--end] = (char)(48 + number % 10);
            number /= 10;
        }
    }

    public static boolean isSameDay(java.util.Date a, java.util.Date b) {
        if (a == null || b == null) {
            return false;
        }
        return a == b || Math.abs(a.getTime() - b.getTime()) < 86400000L && a.getYear() == b.getYear() && a.getMonth() == b.getMonth() && a.getDate() == b.getDate();
    }
}

