/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.util.function.Supplier;
import me.codeplayer.util.LazyCacheLoader;

public class TimeBasedCacheLoader<E>
extends LazyCacheLoader<E> {
    protected long internal;
    protected volatile transient long nextUpdateTime;

    public TimeBasedCacheLoader(long internal, Supplier<E> loader) {
        super(loader);
        this.internal = internal;
    }

    @Override
    public boolean flushRequired() {
        return this.flushRequired(System.currentTimeMillis());
    }

    protected boolean flushRequired(long baseTime) {
        return this.nextUpdateTime == 0L || this.internal > 0L && this.nextUpdateTime < baseTime;
    }

    @Override
    public E flush(boolean lazy) {
        E val;
        if (lazy) {
            this.nextUpdateTime = 0L;
            val = null;
        } else {
            E e = this.load(System.currentTimeMillis());
            val = e;
            this.value = e;
        }
        return val;
    }

    @Override
    public E get() {
        long now = System.currentTimeMillis();
        if (this.flushRequired(now)) {
            return this.load(now);
        }
        return (E)this.value;
    }

    protected E load(long now) {
        Object val = this.loader.get();
        this.value = val;
        this.nextUpdateTime = now + this.internal;
        return (E)val;
    }
}

