/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.util.Arrays;
import java.util.Random;

public abstract class RandomUtil {
    public static final int getInt(int min, int max) {
        return new Random().nextInt(max - min + 1) + min;
    }

    public static final String getIntString(int length) {
        if (length <= 0) {
            return "";
        }
        String str = Double.toString(Math.random()).substring(2);
        int realLen = str.length();
        if (length > realLen) {
            StringBuilder sb = new StringBuilder(length).append(str);
            for (int remain = length - realLen; remain > 0; remain -= realLen) {
                str = Double.toString(Math.random()).substring(2);
                realLen = str.length();
                if (remain >= realLen) {
                    sb.append(str);
                    continue;
                }
                sb.append(str.substring(0, remain));
            }
            return sb.toString();
        }
        return str.substring(0, length);
    }

    public static final double getDouble() {
        return Math.random();
    }

    public static final float getFloat() {
        return new Random().nextFloat();
    }

    public static final long getLong() {
        return new Random().nextLong();
    }

    public static final boolean getBoolean() {
        return new Random().nextBoolean();
    }

    public static final char getChar(char[] chars) {
        switch (chars.length) {
            case 0: {
                return ' ';
            }
            case 1: {
                return chars[0];
            }
        }
        return chars[new Random().nextInt(chars.length)];
    }

    public static final char getChar(String str) {
        return RandomUtil.getChar(str.toCharArray());
    }

    public static final String getString(char[] chars, int length) {
        if (length < 1) {
            return "";
        }
        char[] newChars = new char[length];
        if (chars.length == 1) {
            Arrays.fill(newChars, chars[0]);
        } else {
            Random random = new Random();
            for (int i = 0; i < length; ++i) {
                newChars[i] = chars[random.nextInt(chars.length)];
            }
        }
        return new String(newChars);
    }

    public static final String getString(String str, int length) {
        return RandomUtil.getString(str.toCharArray(), length);
    }
}

