/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import java.util.Collections;
import java.util.List;
import me.codeplayer.util.X;

public abstract class JSONUtil {
    public static final String encode(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public static final String encodeKeepNull(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteMapNullValue});
    }

    public static final String encodeWithExclude(Object obj, String ... excludeProperties) {
        SimplePropertyPreFilter filter = new SimplePropertyPreFilter(new String[0]);
        Collections.addAll(filter.getExcludes(), excludeProperties);
        return JSON.toJSONString((Object)obj, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public static final String encodeWithInclude(Object obj, String ... includeProperties) {
        return JSON.toJSONString((Object)obj, (SerializeFilter)new SimplePropertyPreFilter(includeProperties), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public static final String encodeWithDateFormat(Object obj, String pattern) {
        return JSON.toJSONStringWithDateFormat((Object)obj, (String)pattern, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public static final String encodeWithReferenceDetect(Object obj) {
        return JSON.toJSONString((Object)obj);
    }

    public static final Object parse(String text) {
        return JSON.parse((String)text);
    }

    public static final <T> T parseObject(String text, Class<T> clazz) {
        return (T)JSON.parseObject((String)text, clazz);
    }

    public static final JSONObject parseObject(String text) {
        return JSON.parseObject((String)text);
    }

    public static final JSONArray parseArray(String text) {
        return JSON.parseArray((String)text);
    }

    public static final <T> List<T> parseArray(String text, Class<T> clazz) {
        return JSON.parseArray((String)text, clazz);
    }

    public static final String serialize(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName});
    }

    public static final <T> T deserialize(String text) {
        return X.castType(JSON.parse((String)text));
    }
}

