/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.lang.reflect.Array;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import me.codeplayer.util.StringUtil;

public abstract class EnumUtil {
    @Nullable
    public static final <T extends Enum<T>> T enumOf(Class<T> clazz, @Nullable String name) {
        if (StringUtil.notEmpty(name)) {
            try {
                return Enum.valueOf(clazz, name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static final <E extends Enum<?>> E[] getMatchedEnums(Class<E> enumClass, @Nullable E[] values, Predicate<E> matcher) {
        Enum[] newAarray = values == null ? (Enum[])enumClass.getEnumConstants() : (Enum[])values.clone();
        int count = 0;
        for (Enum e : newAarray) {
            if (!matcher.test(e)) continue;
            newAarray[count++] = e;
        }
        if (count == newAarray.length) {
            return newAarray;
        }
        Enum[] result = (Enum[])Array.newInstance(enumClass, count);
        if (count > 0) {
            System.arraycopy(newAarray, 0, result, 0, count);
        }
        return result;
    }
}

