/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Predicate;
import me.codeplayer.util.StringUtil;
import me.codeplayer.util.X;

public abstract class ArrayUtil {
    public static final Object[] EMPTY_OBJECTS = new Object[0];
    public static final String[] EMPTY_STRINGS = new String[0];
    public static final int[] EMPTY_INTS = new int[0];
    public static final Integer[] EMPTY_INTEGERS = new Integer[0];

    public static final boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static StringBuilder join(StringBuilder sb, Object array, String delimiter) {
        if (array == null) {
            throw new NullPointerException();
        }
        int length = Array.getLength(array);
        if (sb == null) {
            sb = new StringBuilder(length << 4);
        }
        if (length == 0) {
            return sb;
        }
        sb.append(Array.get(array, 0));
        for (int i = 1; i < length; ++i) {
            sb.append(delimiter);
            sb.append(Array.get(array, i));
        }
        return sb;
    }

    public static String join(Object array, String delimiter) {
        return ArrayUtil.join(null, array, delimiter).toString();
    }

    public static StringBuilder getInSQL(StringBuilder sb, Object array, boolean isInclude, boolean isString) {
        if (array == null) {
            throw new NullPointerException();
        }
        int length = Array.getLength(array);
        if (sb == null && length > 0) {
            sb = StringUtil.getBuilder(length, 3);
        }
        switch (length) {
            case 0: {
                throw new IllegalArgumentException("Array can not be empty:" + array);
            }
            case 1: {
                if (!isInclude) {
                    sb.append('!');
                }
                if (isString) {
                    sb.append("='").append(Array.get(array, 0)).append('\'');
                    break;
                }
                sb.append('=').append(Array.get(array, 0));
                break;
            }
            default: {
                sb.append(isInclude ? " IN (" : " NOT IN (");
                if (isString) {
                    sb.append('\'');
                    ArrayUtil.join(sb, array, "', '");
                    sb.append("')");
                    break;
                }
                ArrayUtil.join(sb, array, ", ");
                sb.append(')');
            }
        }
        return sb;
    }

    public static String getInSQL(Object array, boolean isInclude, boolean isString) {
        return ArrayUtil.getInSQL(null, array, isInclude, isString).toString();
    }

    public static String getInSQL(Object array, boolean isString) {
        return ArrayUtil.getInSQL(null, array, true, isString).toString();
    }

    public static String toString(Object array) {
        if (array == null || !array.getClass().isArray()) {
            return String.valueOf(array);
        }
        int length = Array.getLength(array);
        if (length == 0) {
            return "[]";
        }
        int capacity = length << 3;
        if (capacity < 16) {
            capacity = 16;
        }
        StringBuilder sb = new StringBuilder(capacity);
        sb.append('[').append(Array.get(array, 0));
        for (int i = 1; i < length; ++i) {
            sb.append(", ").append(Array.get(array, i));
        }
        sb.append(']');
        return sb.toString();
    }

    public static StringBuilder toFinalString(StringBuilder sb, Object array) {
        if (array == null || !array.getClass().isArray()) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(array);
        } else {
            int length = Array.getLength(array);
            if (length == 0) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append("[]");
            } else {
                if (sb == null) {
                    sb = StringUtil.getBuilder(length, 3);
                }
                sb.append('[');
                ArrayUtil.toFinalString(sb, Array.get(array, 0));
                for (int i = 1; i < length; ++i) {
                    sb.append(", ");
                    ArrayUtil.toFinalString(sb, Array.get(array, i));
                }
                sb.append(']');
            }
        }
        return sb;
    }

    public static String toFinalString(Object array) {
        return ArrayUtil.toFinalString(null, array).toString();
    }

    public static final boolean hasLength(Object array) {
        return array != null && Array.getLength(array) > 0;
    }

    public static final int getLength(Object array, boolean triggerError) {
        int length = ArrayUtil.getLength(array);
        if (length == 0 && triggerError) {
            throw new IllegalArgumentException("Array can not be empty:" + array);
        }
        return length;
    }

    public static final int getLength(Object array) {
        if (array == null) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static final int getDimension(Object array) {
        Class<?> clazz;
        if (array != null && (clazz = array.getClass()).isArray()) {
            String className = clazz.getName();
            int len = className.length();
            for (int i = 0; i < len; ++i) {
                if (className.charAt(i) == '[') continue;
                return i;
            }
        }
        return -1;
    }

    public static final boolean isPrimitiveArray(Object array) {
        Class<?> clazz;
        if (array != null && (clazz = array.getClass()).isArray()) {
            String className = array.getClass().getName();
            return className.length() == 2 && className.charAt(0) == '[';
        }
        return false;
    }

    public static final boolean in(int value, int ... array) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return true;
        }
        return false;
    }

    public static final <T> boolean ins(T value, T ... array) {
        if (value == null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                if (!value.equals(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final <T extends Comparable<T>> int indexOfInterval(T[] array, T toCompare, Boolean ascOrDesc) throws IllegalArgumentException {
        boolean orderByAsc;
        if (array == null) return -1;
        if (array.length == 0) {
            return -1;
        }
        if (ascOrDesc == null) {
            if (array.length <= 1) throw new IllegalArgumentException("Unable to determine the sort order");
            int result = array[0].compareTo(array[1]);
            if (result == 0) throw new IllegalArgumentException("Unable to determine the sort order");
            orderByAsc = result < 0;
        } else {
            orderByAsc = ascOrDesc;
        }
        int index = -1;
        if (orderByAsc) {
            int i = array.length - 1;
            while (i >= 0) {
                if (toCompare.compareTo(array[i]) >= 0) {
                    return i;
                }
                --i;
            }
            return index;
        }
        int i = 0;
        while (i < array.length) {
            if (toCompare.compareTo(array[i]) >= 0) {
                return i;
            }
            ++i;
        }
        return index;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int indexOfInterval(Object array, double toCompare, Boolean ascOrDesc) throws IllegalArgumentException {
        boolean orderByAsc;
        if (array == null) {
            return -1;
        }
        int len = Array.getLength(array);
        if (len == 0) {
            return -1;
        }
        if (ascOrDesc == null) {
            if (len <= 1) throw new IllegalArgumentException("Unable to determine the sort order");
            double result = Array.getDouble(array, 0) - Array.getDouble(array, 1);
            if (result == 0.0) throw new IllegalArgumentException("Unable to determine the sort order");
            orderByAsc = result < 0.0;
        } else {
            orderByAsc = ascOrDesc;
        }
        int index = -1;
        if (orderByAsc) {
            int i = len - 1;
            while (i >= 0) {
                if (toCompare >= Array.getDouble(array, i)) {
                    return i;
                }
                --i;
            }
            return index;
        }
        int i = 0;
        while (i < len) {
            if (toCompare >= Array.getDouble(array, i)) {
                return i;
            }
            ++i;
        }
        return index;
    }

    public static Object unique(Object array, boolean forceNewCopy) {
        int length = Array.getLength(array);
        if (!forceNewCopy && length < 2) {
            return array;
        }
        Class<?> componentType = array.getClass().getComponentType();
        Object copy = Array.newInstance(componentType, length);
        System.arraycopy(array, 0, copy, 0, length);
        if (length < 2) {
            return copy;
        }
        HashMap map = new HashMap(length * 4 / 3 + 1);
        int size = 0;
        for (int i = 0; i < length; ++i) {
            Object ele = Array.get(array, i);
            if (map.containsKey(ele)) continue;
            map.put(ele, null);
            Array.set(copy, size++, ele);
        }
        if (size < length) {
            array = Array.newInstance(componentType, size);
            if (size > 0) {
                System.arraycopy(copy, 0, array, 0, size);
            }
            return array;
        }
        return copy;
    }

    public static Object unique(Object array) {
        return ArrayUtil.unique(array, true);
    }

    public static final <T> T[] toArray(Collection<? extends T> collection, Class<T> type) {
        if (collection == null) {
            return null;
        }
        int size = collection.size();
        Object[] array = (Object[])X.castType(Array.newInstance(type, size));
        if (size > 0) {
            collection.toArray(array);
        }
        return array;
    }

    public static final Object[] of(Object ... elements) {
        return elements;
    }

    public static final <E> E[] filter(E[] array, Predicate<E> matcher) {
        Object[] newAarray = (Object[])array.clone();
        int count = 0;
        for (Object e : newAarray) {
            if (!matcher.test(e)) continue;
            newAarray[count++] = e;
        }
        if (count == newAarray.length) {
            return newAarray;
        }
        return Arrays.copyOf(array, count);
    }

    public static final <E> E[] ofNullable(E element) {
        if (element == null) {
            return null;
        }
        Object array = Array.newInstance(element.getClass(), 1);
        Array.set(array, 0, element);
        return (Object[])array;
    }
}

