/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.codeplayer.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class X {
    public static final Logger getLogger() {
        String className = new Throwable().getStackTrace()[1].getClassName();
        return LoggerFactory.getLogger((String)className);
    }

    public static final boolean isEmpty(String str) {
        return StringUtil.isEmpty(str);
    }

    public static final boolean isEmpty(Object obj) {
        return StringUtil.isEmpty(obj);
    }

    public static final boolean isBlank(String str) {
        return StringUtil.isBlank(str);
    }

    public static final boolean isBlank(Object obj) {
        return StringUtil.isBlank(obj);
    }

    public static final <T> T expectNotNull(T v1, T v2, T v3, T v4) {
        if (v1 != null) {
            return v1;
        }
        if (v2 != null) {
            return v2;
        }
        if (v3 != null) {
            return v3;
        }
        if (v4 != null) {
            return v4;
        }
        return null;
    }

    public static final <T> T expectNotNull(T v1, T v2, T v3) {
        return X.expectNotNull(v1, v2, v3, null);
    }

    public static final <T> T expectNotNull(T v1, T v2) {
        return X.expectNotNull(v1, v2, null, null);
    }

    public static final String expectNotEmpty(String v1, String v2, String v3, String v4) {
        if (v1 != null && v1.length() > 0) {
            return v1;
        }
        if (v2 != null && v2.length() > 0) {
            return v2;
        }
        if (v3 != null && v3.length() > 0) {
            return v3;
        }
        if (v4 != null && v4.length() > 0) {
            return v4;
        }
        return "";
    }

    public static final String expectNotEmpty(String v1, String v2, String v3) {
        return X.expectNotEmpty(v1, v2, v3, null);
    }

    public static final String expectNotEmpty(String v1, String v2) {
        return X.expectNotEmpty(v1, v2, null, null);
    }

    public static final boolean isValid(Boolean b) {
        return b != null && b != false;
    }

    public static final boolean isValid(Number number) {
        return number != null && number.doubleValue() != 0.0;
    }

    public static final boolean isValid(CharSequence sequence) {
        return StringUtil.notEmpty(sequence);
    }

    public static final boolean isValid(Map<?, ?> map) {
        return map != null && map.size() > 0;
    }

    public static final boolean isValid(Collection<?> collection) {
        return collection != null && collection.size() > 0;
    }

    public static final boolean isValid(byte[] array) {
        return array != null && array.length > 0;
    }

    public static final boolean isValid(int[] array) {
        return array != null && array.length > 0;
    }

    public static final boolean isValid(long[] array) {
        return array != null && array.length > 0;
    }

    public static final boolean isValid(char[] array) {
        return array != null && array.length > 0;
    }

    public static final boolean isValid(float[] array) {
        return array != null && array.length > 0;
    }

    public static final boolean isValid(double[] array) {
        return array != null && array.length > 0;
    }

    public static final boolean isValid(Object[] array) {
        return array != null && array.length > 0;
    }

    public static final boolean isValid(Object arg) {
        if (arg == null) {
            return false;
        }
        if (arg instanceof CharSequence) {
            return ((CharSequence)arg).length() > 0;
        }
        if (arg instanceof Number) {
            return ((Number)arg).doubleValue() != 0.0;
        }
        if (arg instanceof Map) {
            return ((Map)arg).size() > 0;
        }
        if (arg instanceof Collection) {
            return ((Collection)arg).size() > 0;
        }
        if (arg.getClass().isArray()) {
            return Array.getLength(arg) > 0;
        }
        if (arg instanceof Boolean) {
            return (Boolean)arg;
        }
        return true;
    }

    public static final <T> T decode(T value, T ... expressions) {
        int i;
        int length;
        if (expressions == null || (length = expressions.length) == 0) {
            throw new IllegalArgumentException("decode\u7684\u8868\u8fbe\u5f0f\u53c2\u6570\u4e2a\u6570\u4e0d\u80fd\u5c0f\u4e8e1!");
        }
        if ((length & 1) == 1) {
            int index = length - 1;
            for (i = 0; !(i >= index || value == expressions[i] || value != null && value.equals(expressions[i])); i += 2) {
            }
            return i < index ? expressions[i + 1] : expressions[index];
        }
        while (!(value == expressions[i] || value != null && value.equals(expressions[i]) || (i += 2) >= length)) {
        }
        return i < length ? expressions[i + 1] : value;
    }

    public static final String trim4Html(String str) {
        return StringUtil.isBlank(str) ? "&nbsp;" : str.trim();
    }

    public static final int getCapacity(int capacity) {
        return X.getCapacity(capacity, 0.75f);
    }

    public static final int getCapacity(int capacity, float loadFactor) {
        int initCapacity = 16;
        while ((float)capacity > (float)initCapacity * loadFactor) {
            initCapacity <<= 1;
        }
        return initCapacity;
    }

    public static final <T> T castType(Object obj) {
        return (T)obj;
    }

    public static final <T, R> R map(@Nullable T obj, Function<? super T, R> mapper) {
        if (obj == null) {
            return null;
        }
        return mapper.apply(obj);
    }

    public static final <T, R, E> E map(@Nullable T obj, Function<? super T, R> mapper, Function<R, E> chainedMapper) {
        return X.map(X.map(obj, mapper), chainedMapper);
    }

    public static final <T, R> R mapElse(@Nullable T obj, Function<? super T, R> mapper, R other) {
        R val = X.map(obj, mapper);
        return val == null ? other : val;
    }

    public static final <T, R> R mapElse(@Nullable T obj, Function<? super T, R> mapper, Supplier<R> other) {
        R val = X.map(obj, mapper);
        return val == null ? other.get() : val;
    }

    public static final Object tryUnwrap(@Nullable Object supplier) {
        if (supplier instanceof Supplier) {
            return ((Supplier)supplier).get();
        }
        return supplier;
    }

    public static <T> T getElse(@Nullable T val, Supplier<T> other) {
        return val == null ? other.get() : val;
    }

    public static final <T, R> boolean isMatch(@Nullable T bean, Function<? super T, R> mapper, Predicate<? super R> matcher) {
        R val = X.map(bean, mapper);
        return matcher.test(val);
    }

    public static final RuntimeException wrapException(@Nullable String msg, boolean forceUseMsg, @Nullable Throwable ex, @Nullable Throwable cause) {
        if (ex == null) {
            return cause == null ? new IllegalArgumentException(msg) : new IllegalArgumentException(msg, cause);
        }
        if (ex instanceof RuntimeException) {
            return forceUseMsg && msg != null ? new IllegalArgumentException(msg, ex) : (RuntimeException)ex;
        }
        return msg == null ? new IllegalArgumentException(ex) : new IllegalArgumentException(msg, ex);
    }

    public static final RuntimeException wrapException(@Nullable String msg, @Nullable Throwable ex, @Nullable Throwable cause) {
        return X.wrapException(msg, false, ex, cause);
    }

    public static final RuntimeException wrapException(@Nullable String msg, boolean forceUseMsg, @Nullable Throwable ex) {
        return X.wrapException(msg, forceUseMsg, ex, null);
    }

    public static final RuntimeException wrapException(@Nullable String msg, @Nullable Throwable ex) {
        return X.wrapException(msg, false, ex, null);
    }
}

