/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.codeplayer.util.StringUtil;
import me.codeplayer.util.X;

public abstract class Assert {
    public static final void isTrue(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static final void isTrue(boolean expression, @Nullable CharSequence errorMsg) {
        if (!expression) {
            throw new IllegalArgumentException(X.map(errorMsg, CharSequence::toString));
        }
    }

    public static final void isTrue(boolean expression, @Nullable Supplier<CharSequence> msger) {
        if (!expression) {
            if (msger != null) {
                throw new IllegalArgumentException(X.map(msger.get(), CharSequence::toString));
            }
            throw new IllegalArgumentException();
        }
    }

    public static final void notTrue(boolean expression, @Nullable CharSequence message) {
        Assert.isTrue(!expression, message);
    }

    public static final void notTrue(boolean expression, @Nullable Supplier<CharSequence> msger) {
        Assert.isTrue(!expression, msger);
    }

    public static final void isNull(Object object) {
        Assert.isTrue(object == null);
    }

    public static final void isNull(Object object, @Nullable CharSequence message) {
        Assert.isTrue(object == null, message);
    }

    public static final <T> T notNull(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    public static final void notNull(Object object, @Nullable CharSequence errorMsg) {
        if (object == null) {
            throw new NullPointerException(X.map(errorMsg, CharSequence::toString));
        }
    }

    public static final void notNull(Object object, @Nullable Supplier<CharSequence> msger) {
        if (object == null) {
            if (msger != null) {
                throw new NullPointerException(X.map(msger.get(), CharSequence::toString));
            }
            throw new NullPointerException();
        }
    }

    public static final void isEmpty(Object str, @Nullable CharSequence message) {
        Assert.isTrue(StringUtil.isEmpty(str), message);
    }

    public static final <T> T notEmpty(T str) {
        Assert.isTrue(StringUtil.notEmpty(str));
        return str;
    }

    public static final void notEmpty(Object str, @Nullable CharSequence message) {
        Assert.isTrue(StringUtil.notEmpty(str), message);
    }

    public static final void notEmpty(Object str, @Nullable Supplier<CharSequence> message) {
        Assert.isTrue(StringUtil.notEmpty(str), message);
    }

    public static final void isBlank(Object obj, String message) {
        Assert.isTrue(StringUtil.isBlank(obj), message);
    }

    public static final void notBlank(Object obj, String message) {
        Assert.isTrue(!StringUtil.isBlank(obj), message);
    }

    public static final void equals(Object obj, Object another, String message) {
        Assert.isTrue(obj == null && another == null || obj != null && obj.equals(another), message);
    }

    public static final void notEquals(Object obj, Object another, String message) {
        Assert.isTrue(obj == null && another != null || obj != null && obj.equals(another), message);
    }

    public static final void isSame(Object obj, Object another, String message) {
        Assert.isTrue(obj == another, message);
    }

    public static final void notSame(Object obj, Object another, String message) {
        Assert.isTrue(obj != another, message);
    }
}

