/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import me.codeplayer.util.RandomUtil;
import me.codeplayer.util.X;

public abstract class FileUtil {
    private static final String[] FILE_UNITS = new String[]{"Byte", "KB", "MB", "GB", "TB", "PB"};
    public static final int UNIT_AUTO = 0;
    public static final int UNIT_BYTE = 1;
    public static final int UNIT_KB = 2;
    public static final int UNIT_MB = 3;
    public static final int UNIT_GB = 4;
    public static final int UNIT_TB = 5;
    public static final int UNIT_PB = 6;

    public static final int indexOfExtension(String filename) {
        int pos = filename.lastIndexOf(46);
        if (pos != -1) {
            if (filename.lastIndexOf(47, pos + 1) != -1) {
                return -1;
            }
            if (filename.lastIndexOf(92, pos + 1) != -1) {
                return -1;
            }
        }
        return pos;
    }

    public static final String getExtension(String path, boolean removeDot) throws NullPointerException {
        int pos = FileUtil.indexOfExtension(path);
        if (pos == -1) {
            return "";
        }
        return path.substring(removeDot ? pos + 1 : pos);
    }

    public static final String getExtension(String path) {
        return FileUtil.getExtension(path, false);
    }

    public static final String getFileName(String path) {
        return FileUtil.getFileName(path, false);
    }

    public static final String getFileName(String path, boolean withoutExt) {
        int pos;
        String str = new File(path).getName();
        if (withoutExt && (pos = FileUtil.indexOfExtension(path)) > -1) {
            str = str.substring(0, pos);
        }
        return str;
    }

    public static final File getRandomFile(String path, String prefix, String suffix) {
        String fileName = new SimpleDateFormat("yyyyMMdd-HHmmssSSS").format(new Date());
        if (prefix != null) {
            fileName = prefix + fileName;
        }
        if (suffix == null) {
            suffix = "";
        } else if (suffix.length() > 0 && suffix.charAt(0) != '.') {
            suffix = '.' + suffix;
        }
        String destFileName = fileName + suffix;
        File file = new File(path, destFileName);
        while (file.exists()) {
            destFileName = fileName + '-' + RandomUtil.getIntString(4) + suffix;
            file = new File(path, destFileName);
        }
        return file;
    }

    public static final File getRandomFile(String path, String suffix) {
        return FileUtil.getRandomFile(path, null, suffix);
    }

    public static String calcFileSize(long fileSize, int unit, int scale) {
        if (fileSize < 0L) {
            throw new IllegalArgumentException("Argument 'fileSize' can not less than 0:" + fileSize);
        }
        if (unit < 0 || unit > 6) {
            throw new IllegalArgumentException(String.valueOf(unit));
        }
        if (unit != 0) {
            int shift = unit - 1;
            return FileUtil.divide(fileSize, 1 << 10 * shift, scale) + FILE_UNITS[shift];
        }
        int shift = 0;
        long unitBytes = 1L;
        long nextUnitBytes = unitBytes << 10;
        while (fileSize >= nextUnitBytes) {
            unitBytes = nextUnitBytes;
            nextUnitBytes <<= 10;
            ++shift;
        }
        return FileUtil.divide(fileSize, unitBytes, scale) + FILE_UNITS[shift];
    }

    public static String calcFileSize(long fileSize, int unit) {
        return FileUtil.calcFileSize(fileSize, unit, 2);
    }

    public static String divide(long fileSize, long divisor, int scale) {
        return new BigDecimal(fileSize).divide(new BigDecimal(divisor), scale, RoundingMode.HALF_UP).toString();
    }

    public static int deleteFile(String filePath) {
        return FileUtil.deleteFile(new File(filePath));
    }

    public static int deleteFile(String directoryPath, String fileName) {
        return FileUtil.deleteFile(new File(directoryPath, fileName));
    }

    private static int deleteFile(File file) {
        int result = -1;
        if (file.exists()) {
            if (file.delete()) {
                result = 1;
            }
        } else {
            result = 0;
        }
        return result;
    }

    private static final void copy(InputStream is, File target) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(target);
            FileUtil.writeStream(is, (OutputStream)fos);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            FileUtil.closeResources(is, fos);
        }
    }

    public static final void copyFile(InputStream is, File target, boolean override) {
        if (!FileUtil.checkTargetFileCanBeRewrite(target, override)) {
            FileUtil.ensureParentDirExists(target);
        }
        FileUtil.copy(is, target);
    }

    public static final void copyFile(File src, File target, boolean override) {
        if (!src.exists()) {
            throw new IllegalArgumentException(new FileNotFoundException(src.toString()));
        }
        if (!src.canRead()) {
            throw new IllegalStateException(new IOException("Unable to read file\uff1a" + src));
        }
        try {
            FileUtil.copyFile(new FileInputStream(src), target, override);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final void copyFile(File src, File target) {
        FileUtil.copyFile(src, target, false);
    }

    public static final void copyFile(String src, String target, boolean override) {
        try {
            FileUtil.copyFile(new FileInputStream(src), new File(target), override);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final void copyFile(String src, String target) {
        FileUtil.copyFile(src, target, false);
    }

    public static final void copyFileToDirectory(File file, File directory, boolean override) {
        File target = null;
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalStateException("Target is not a directory:" + directory);
            }
            if (!directory.canWrite()) {
                throw new IllegalStateException(new IOException("Unable to write to file\uff1a" + directory));
            }
            target = new File(directory, file.getName());
            if (target.exists() && !override) {
                throw new IllegalStateException("File already exists:" + target);
            }
        } else {
            target = new File(directory, file.getName());
        }
        FileUtil.copyFile(file, target, true);
    }

    public static final void copyFileToDirectory(File file, File diretory) {
        FileUtil.copyFileToDirectory(file, diretory, false);
    }

    public static final void copyFileToDirectory(String file, String diretory, boolean override) {
        FileUtil.copyFileToDirectory(new File(file), new File(diretory), override);
    }

    public static final void copyFileToDirectory(String file, String diretory) {
        FileUtil.copyFileToDirectory(file, diretory, false);
    }

    public static final void moveFile(File file, File target, boolean override) {
        if (!file.canWrite()) {
            throw new IllegalStateException(new AccessDeniedException(file.toString()));
        }
        if (!FileUtil.checkTargetFileCanBeRewrite(target, override)) {
            FileUtil.ensureParentDirExists(target);
        }
        file.renameTo(target);
    }

    public static final boolean checkTargetFileCanBeRewrite(File target, boolean override) {
        if (target.exists()) {
            if (target.isDirectory()) {
                throw new IllegalArgumentException("File is a directory:" + target);
            }
            if (!target.canWrite()) {
                throw new IllegalStateException(new IOException("Unable to write to file:" + target));
            }
            if (!override) {
                throw new IllegalStateException("File already exists:" + target);
            }
            return true;
        }
        return false;
    }

    public static final void ensureParentDirExists(File target) {
        File parent = target.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IllegalStateException(new IOException("Unable to create directory:" + parent));
        }
    }

    public static final void moveFile(File file, File target) {
        FileUtil.moveFile(file, target, false);
    }

    public static final void moveFile(String path, String target, boolean override) {
        FileUtil.moveFile(new File(path), new File(target), override);
    }

    public static final void moveFile(String path, String target) {
        FileUtil.moveFile(new File(path), new File(target), false);
    }

    public static final void moveFileToDirectory(File file, File directory, boolean override) {
        if (!file.canWrite()) {
            throw new IllegalStateException(new IOException("Unable to write to file:" + file));
        }
        FileUtil.copyFileToDirectory(file, directory, override);
        file.delete();
    }

    public static final void moveFileToDirectory(File file, File directory) {
        FileUtil.moveFileToDirectory(file, directory, false);
    }

    public static final void moveFileToDirectory(String path, String directory, boolean override) {
        FileUtil.moveFileToDirectory(new File(path), new File(directory), override);
    }

    public static final void moveFileToDirectory(String path, String directory) {
        FileUtil.moveFileToDirectory(path, directory, false);
    }

    public static final void writeStream(InputStream in, OutputStream out) throws IOException {
        if (in instanceof FileInputStream && out instanceof FileOutputStream) {
            FileUtil.writeStream((FileInputStream)in, (FileOutputStream)out);
            return;
        }
        int length = 0;
        byte[] buffer = new byte[8192];
        while ((length = in.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeStream(FileInputStream fis, FileOutputStream fos) throws IOException {
        FileChannel inChannel = fis.getChannel();
        FileChannel outChannel = fos.getChannel();
        try {
            inChannel.transferTo(0L, Long.MAX_VALUE, outChannel);
        }
        finally {
            try {
                outChannel.close();
            }
            catch (IOException iOException) {}
            try {
                inChannel.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static final void closeResources(InputStream in, OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    public static final File copyFileToDirectoryWithRandomFileName(File file, String targetDir) {
        File target = FileUtil.getRandomFile(targetDir, FileUtil.getExtension(file.getName()));
        FileUtil.copyFile(file, target);
        return target;
    }

    public static final File moveFileToDirectoryWithRandomFileName(File file, String targetDir) {
        File target = FileUtil.getRandomFile(targetDir, FileUtil.getExtension(file.getName()));
        FileUtil.moveFile(file, target);
        return target;
    }

    public static final File copyFileToDirectoryWithRandomFileName(File file, String targetDir, String prefix, String suffix) {
        File target = FileUtil.getRandomFile(targetDir, prefix, suffix);
        FileUtil.copyFile(file, target);
        return target;
    }

    public static final File copyFileToDirectoryWithRandomFileName(File file, String targetDir, String suffix) {
        return FileUtil.copyFileToDirectoryWithRandomFileName(file, targetDir, null, suffix);
    }

    public static final File moveFileToDirectoryWithRandomFileName(File file, String targetDir, String prefix, String suffix) {
        File target = FileUtil.getRandomFile(targetDir, prefix, suffix);
        FileUtil.moveFile(file, target);
        return target;
    }

    public static final File moveFileToDirectoryWithRandomFileName(File file, String targetDir, String suffix) {
        return FileUtil.moveFileToDirectoryWithRandomFileName(file, targetDir, null, suffix);
    }

    public static final File getFile(String pathname, boolean inClassPath) {
        if (inClassPath) {
            char char0 = pathname.charAt(0);
            if (char0 != '/' && char0 != '\\') {
                pathname = '/' + pathname;
            }
            return new File(FileUtil.class.getResource(pathname).getPath());
        }
        return new File(pathname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String readContent(File file) throws IOException {
        BufferedReader reader = null;
        long length = (file.length() >>> 3) + 1L;
        StringBuilder sb = new StringBuilder((int)length);
        try {
            reader = new BufferedReader(new FileReader(file));
            String str = null;
            while ((str = reader.readLine()) != null) {
                sb.append(str).append('\n');
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return sb.toString();
    }

    public static final String readContent(String pathname, boolean inClassPath) throws IOException {
        return FileUtil.readContent(FileUtil.getFile(pathname, inClassPath));
    }

    public static final Map<String, String> readProperties(String pathname, boolean inClassPath) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(FileUtil.getFile(pathname, inClassPath));
            Properties prop = new Properties();
            prop.load(inputStream);
            Map map = (Map)X.castType(prop);
            return map;
        }
        catch (FileNotFoundException fe) {
            Map<String, String> map = null;
            return map;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

