/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import me.codeplayer.util.DES;

public abstract class Encrypter {
    public static final MessageDigest getMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Unexpected algorithm:" + algorithm, e);
        }
    }

    public static final String md5(String input) {
        return Encrypter.encode(input, "MD5");
    }

    public static final String md5For16(String input) {
        byte[] bytes;
        try {
            bytes = Encrypter.encode(input.getBytes("UTF-8"), "MD5");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        return Encrypter.bytes2Hex(bytes, 4, 12);
    }

    public static final byte[] md5(byte[] buf) {
        return Encrypter.encode(buf, "MD5");
    }

    public static final String sha1(String input) {
        return Encrypter.encode(input, "SHA");
    }

    public static final byte[] sha1(byte[] buf) {
        return Encrypter.encode(buf, "SHA");
    }

    public static final String desEncode(String key, String input) {
        DES des = new DES(key);
        return des.encode(input);
    }

    public static final String desDecode(String key, String dest) {
        DES des = new DES(key);
        return des.decode(dest);
    }

    public static final byte[] desEncode(String key, byte[] input) {
        DES des = new DES(key);
        return des.encode(input);
    }

    public static final byte[] desDecode(String key, byte[] dest) {
        DES des = new DES(key);
        return des.decode(dest);
    }

    public static final byte[] encode(byte[] buf, String algorithm) {
        return Encrypter.getMessageDigest(algorithm).digest(buf);
    }

    public static final String encode(String input, String algorithm) {
        try {
            return Encrypter.bytes2Hex(Encrypter.getMessageDigest(algorithm).digest(input.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final String bytes2Hex(byte[] bytes) {
        return Encrypter.bytes2Hex(bytes, 0, bytes.length);
    }

    public static final String bytes2Hex(byte[] bytes, int start, int end) {
        int length = end - start;
        if (start < 0 || end > bytes.length || length < 0) {
            throw new ArrayIndexOutOfBoundsException(end);
        }
        char[] chars = new char[length << 1];
        int c = 0;
        for (int i = start; i < end; ++i) {
            chars[c++] = Character.forDigit(bytes[i] >> 4 & 0xF, 16);
            chars[c++] = Character.forDigit(bytes[i] & 0xF, 16);
        }
        return new String(chars);
    }
}

