/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import me.codeplayer.util.StringUtil;
import me.codeplayer.util.X;

public abstract class CollectionUtil {
    public static final int IGNORE_NONE = 0;
    public static final int IGNORE_NULL = 1;
    public static final int IGNORE_EMPTY = 2;
    public static final int IGNORE_BLANK = 3;

    public static final <K, V> HashMap<K, V> asHashMap(Object ... kvPairs) {
        CollectionUtil.checkPairs(kvPairs);
        int size = kvPairs.length >> 1;
        HashMap map = size > 12 ? new HashMap(X.getCapacity(size)) : new HashMap();
        CollectionUtil.addToMap(map, kvPairs);
        return map;
    }

    public static final <K, V> ConcurrentHashMap<K, V> asConcurrentHashMap(Object ... kvPairs) {
        CollectionUtil.checkPairs(kvPairs);
        int size = kvPairs.length >> 1;
        ConcurrentHashMap map = size > 12 ? new ConcurrentHashMap(X.getCapacity(size)) : new ConcurrentHashMap();
        CollectionUtil.addToMap(map, kvPairs);
        return map;
    }

    public static final <K, V> LinkedHashMap<K, V> asLinkedHashMap(Object ... kvPairs) {
        CollectionUtil.checkPairs(kvPairs);
        int size = kvPairs.length >> 1;
        LinkedHashMap map = size > 12 ? new LinkedHashMap(X.getCapacity(size)) : new LinkedHashMap();
        CollectionUtil.addToMap(map, kvPairs);
        return map;
    }

    public static final <K, V> ConcurrentHashMap<K, V> createConcurrentHashMap(Object ... kvPairs) {
        CollectionUtil.checkPairs(kvPairs);
        int size = kvPairs.length >> 1;
        ConcurrentHashMap map = size > 12 ? new ConcurrentHashMap(X.getCapacity(size)) : new ConcurrentHashMap();
        CollectionUtil.addToMap(map, kvPairs);
        return map;
    }

    protected static final void checkPairs(Object ... pairs) {
        if ((pairs.length & 1) != 0) {
            throw new IllegalArgumentException("The length of the Array must be even:" + pairs.length);
        }
    }

    public static final <E> ArrayList<E> createArrayList(E ... elements) {
        ArrayList list = new ArrayList(elements.length);
        CollectionUtil.addToCollection(list, elements);
        return list;
    }

    public static final <E> LinkedList<E> asLinkedList(E ... elements) {
        LinkedList list = new LinkedList();
        CollectionUtil.addToCollection(list, elements);
        return list;
    }

    public static final <E> Vector<E> asVector(E ... elements) {
        Vector list = new Vector();
        CollectionUtil.addToCollection(list, elements);
        return list;
    }

    public static final <E> HashSet<E> asHashSet(E ... elements) {
        HashSet list = new HashSet();
        CollectionUtil.addToCollection(list, elements);
        return list;
    }

    public static final <E> LinkedHashSet<E> asLinkedHashSet(E ... elements) {
        LinkedHashSet list = new LinkedHashSet();
        CollectionUtil.addToCollection(list, elements);
        return list;
    }

    public static final <K, V> Map<K, V> addToMap(int ignore, Map<K, V> map, Object ... kvPairs) {
        CollectionUtil.checkPairs(kvPairs);
        Map m = (Map)X.castType(map);
        if (ignore == 0) {
            int i = 0;
            while (i < kvPairs.length) {
                m.put(kvPairs[i++], kvPairs[i++]);
            }
        } else {
            int i = 0;
            while (i < kvPairs.length) {
                Object value;
                Object key = kvPairs[i++];
                if (!CollectionUtil.notIgnore(value = kvPairs[i++], ignore)) continue;
                m.put(key, value);
            }
        }
        return map;
    }

    public static final <K, V> Map<K, V> addToMap(Map<K, V> map, Object ... kvPairs) {
        return CollectionUtil.addToMap(0, map, kvPairs);
    }

    public static final <E> Collection<E> addToCollection(int ignore, Collection<? super E> collection, E ... elements) {
        if (ignore == 0) {
            for (int i = 0; i < elements.length; ++i) {
                collection.add(elements[i]);
            }
        } else {
            for (int i = 0; i < elements.length; ++i) {
                if (!CollectionUtil.notIgnore(elements[i], ignore)) continue;
                collection.add(elements[i]);
            }
        }
        return (Collection)X.castType(collection);
    }

    public static final <E> Collection<E> addToCollection(Collection<? super E> collection, E ... elements) {
        return CollectionUtil.addToCollection(0, collection, elements);
    }

    protected static final boolean notIgnore(Object value, int ignore) {
        if (ignore > 0) {
            switch (ignore) {
                case 1: {
                    return value != null;
                }
                case 2: {
                    return value != null && value.toString().length() > 0;
                }
                case 3: {
                    return value != null && StringUtil.notEmpty(value.toString());
                }
            }
        }
        return true;
    }

    public static final <K, V> V[] mapValues(Map<K, V> map, Class<V> valueClass, K ... keys) {
        Object[] results = (Object[])X.castType(Array.newInstance(valueClass, keys.length));
        for (int i = 0; i < keys.length; ++i) {
            results[i] = map.get(keys[i]);
        }
        return results;
    }

    public static <E> List<E> removeDuplicate(List<E> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<E> singleList = new ArrayList<E>(list.size());
        for (E e : list) {
            if (singleList.contains(e)) continue;
            singleList.add(e);
        }
        return singleList;
    }
}

