/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import me.codeplayer.util.ChineseNumber;

public class Arith {
    public static final BigDecimal ZERO = BigDecimal.ZERO;
    public static final BigDecimal ONE = BigDecimal.ONE;
    public static final BigDecimal TEN = BigDecimal.TEN;
    public static final BigDecimal HANDRED = new BigDecimal(100);
    public static final BigDecimal THOUSAND = new BigDecimal(1000);
    public static final BigDecimal MYRIAD = new BigDecimal(10000);
    public static final BigDecimal HANDRED_MILLION = new BigDecimal(100000000);
    protected BigDecimal value;

    public Arith(double d) {
        this(Double.toString(d));
    }

    public Arith(String d) {
        this.value = new BigDecimal(d);
    }

    public Arith(BigDecimal d) {
        if (d == null) {
            throw new NullPointerException();
        }
        this.value = d;
    }

    public Arith(long d) {
        this.value = new BigDecimal(d);
    }

    public Arith(int d) {
        this.value = new BigDecimal(d);
    }

    public Arith(boolean d) {
        this(d ? 1 : 0);
    }

    public Arith(Object d) {
        Number n;
        long val;
        if (d == null) {
            throw new NullPointerException();
        }
        this.value = d instanceof BigDecimal ? (BigDecimal)d : (d instanceof Number ? ((double)(val = (n = (Number)d).longValue()) == n.doubleValue() ? new BigDecimal(val) : new BigDecimal(d.toString())) : new BigDecimal(d.toString()));
    }

    public Arith() {
        this.value = BigDecimal.ZERO;
    }

    public Arith add(BigDecimal d) {
        this.value = this.value.add(d);
        return this;
    }

    public Arith add(String d) {
        return this.add(new BigDecimal(d));
    }

    public Arith add(double d) {
        return this.add(Double.toString(d));
    }

    public Arith add(long d) {
        return this.add(BigDecimal.valueOf(d));
    }

    public Arith minus(BigDecimal d) {
        this.value = this.value.subtract(d);
        return this;
    }

    public Arith minus(String d) {
        return this.minus(new BigDecimal(d));
    }

    public Arith minus(double d) {
        return this.minus(Double.toString(d));
    }

    public Arith minus(long d) {
        return this.minus(BigDecimal.valueOf(d));
    }

    public Arith multiply(BigDecimal d) throws ArithmeticException {
        this.value = this.value.multiply(d);
        return this;
    }

    public Arith multiply(String d) {
        return this.multiply(new BigDecimal(d));
    }

    public Arith multiply(double d) {
        return this.multiply(Double.toString(d));
    }

    public Arith multiply(long d) {
        return this.multiply(BigDecimal.valueOf(d));
    }

    public Arith divide(BigDecimal d) throws ArithmeticException {
        this.value = this.value.divide(d);
        return this;
    }

    public Arith divide(String d) throws ArithmeticException {
        return this.divide(new BigDecimal(d));
    }

    public Arith divide(double d) {
        return this.divide(Double.toString(d));
    }

    public Arith divide(long d) {
        return this.divide(BigDecimal.valueOf(d));
    }

    public Arith divide(BigDecimal d, int scale, RoundingMode roundingMode) {
        this.value = this.value.divide(d, scale, roundingMode);
        return this;
    }

    public Arith divide(String d, int scale, RoundingMode roundingMode) {
        return this.divide(new BigDecimal(d), scale, roundingMode);
    }

    public Arith divide(double d, int scale, RoundingMode roundingMode) {
        return this.divide(Double.toString(d), scale, roundingMode);
    }

    public Arith divide(long d, int scale, RoundingMode roundingMode) {
        return this.divide(BigDecimal.valueOf(d), scale, roundingMode);
    }

    public Arith divideRound(BigDecimal d, int scale) {
        return this.divide(d, scale, RoundingMode.HALF_UP);
    }

    public Arith divideRound(String d, int scale) {
        return this.divide(d, scale, RoundingMode.HALF_UP);
    }

    public Arith divideRound(double d, int scale) {
        return this.divide(Double.toString(d), scale, RoundingMode.HALF_UP);
    }

    public Arith divideRound(long d, int scale) {
        return this.divide(BigDecimal.valueOf(d), scale, RoundingMode.HALF_UP);
    }

    public Arith setScale(int newScale, RoundingMode roundingMode) {
        this.value = this.value.setScale(newScale, roundingMode);
        return this;
    }

    public Arith round(int newScale) {
        return this.setScale(newScale, RoundingMode.HALF_UP);
    }

    public static final double roundFast(double value, int newScale) {
        double factor = Math.pow(10.0, newScale + 1);
        double target = value * factor;
        if (newScale > 10 || target < -9.223372036854776E18 || target > 9.223372036854776E18 || Math.abs(target) > Double.MAX_VALUE) {
            return Arith.round(value, newScale);
        }
        double adjust = 1.0E-12;
        long val = (long)(target + 1.0E-12);
        long remainder = val % 10L;
        val = remainder >= 5L ? (val += 10L - remainder) : (val -= remainder);
        return (double)val / factor;
    }

    public Arith ceil() {
        return this.setScale(0, RoundingMode.CEILING);
    }

    public Arith floor() {
        return this.setScale(0, RoundingMode.FLOOR);
    }

    public BigDecimal toBigDecimal() {
        return this.value;
    }

    public BigInteger toBigInteger() {
        return this.value.toBigInteger();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public double doubleValue(int scale) {
        return this.value.setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    public int intValue() {
        return this.value.intValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public byte byteValue() {
        return this.value.byteValue();
    }

    public short shortValue() {
        return this.value.shortValue();
    }

    public static final double add(double a, double b) {
        return new BigDecimal(Double.toString(a)).add(new BigDecimal(Double.toString(b))).doubleValue();
    }

    public static final double minus(double a, double b) {
        return new BigDecimal(Double.toString(a)).add(new BigDecimal(Double.toString(-b))).doubleValue();
    }

    public static final double multiply(double a, double b) {
        return new BigDecimal(Double.toString(a)).multiply(new BigDecimal(Double.toString(b))).doubleValue();
    }

    public static final double multiply(double a, double b, int scale, RoundingMode roundingMode) {
        return new BigDecimal(Double.toString(a)).multiply(new BigDecimal(Double.toString(b))).setScale(scale, roundingMode).doubleValue();
    }

    public static final double multiply(double a, double b, int scale) {
        return Arith.multiply(a, b, scale, RoundingMode.HALF_UP);
    }

    public static final double multiply(double a, double b, long precision) {
        MathContext context = new MathContext((int)precision, RoundingMode.HALF_UP);
        return new BigDecimal(Double.toString(a)).multiply(new BigDecimal(Double.toString(b)), context).doubleValue();
    }

    public static final double divide(double a, double b, int scale) {
        Arith.checkScale(scale);
        return new BigDecimal(Double.toString(a)).divide(new BigDecimal(Double.toString(b)), scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static final double round(double d, int scale) {
        return Arith.scale(d, scale, RoundingMode.HALF_UP);
    }

    public static final double even(double d, int scale) {
        return Arith.scale(d, scale, RoundingMode.HALF_EVEN);
    }

    public static final double scale(double d, int scale, RoundingMode mode) {
        Arith.checkScale(scale);
        return new BigDecimal(Double.toString(d)).setScale(scale, mode).doubleValue();
    }

    public static final long ceil(double d) {
        return (long)Math.ceil(d);
    }

    public static final long floor(double d) {
        return (long)Math.floor(d);
    }

    public static final double truncate(double d, int scale, RoundingMode mode) {
        Arith.checkScale(scale);
        return new BigDecimal(Double.toString(d)).setScale(scale, mode).doubleValue();
    }

    static final void checkScale(int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("Argument 'scale' can not less than 0:" + scale);
        }
    }

    public static final int compareTo(BigDecimal a, BigDecimal b) {
        return a == b ? 0 : a.compareTo(b);
    }

    public static final int compareTo(BigDecimal a, double b) {
        return a.compareTo(BigDecimal.valueOf(b));
    }

    public static final int compareTo(BigDecimal a, long b) {
        return a.compareTo(BigDecimal.valueOf(b));
    }

    public static final int compareTo(BigDecimal a, String b) {
        return a.compareTo(new BigDecimal(b));
    }

    public static final boolean isIntegral(BigDecimal d) {
        return d != null && (d.scale() == 0 || d.setScale(0, RoundingMode.FLOOR).compareTo(d) == 0);
    }

    public static final boolean canDivideExactly(BigDecimal d, BigDecimal divisor) {
        return divisor.compareTo(BigDecimal.ZERO) != 0 && d.remainder(divisor).compareTo(BigDecimal.ZERO) == 0;
    }

    public String toString() {
        return this.value.toString();
    }

    public String toString(int scale) {
        return this.value.setScale(scale, RoundingMode.HALF_UP).toString();
    }

    public String toChineseString(boolean ignoreFractionalPart, boolean upperCase) {
        return new ChineseNumber(ignoreFractionalPart ? this.value.setScale(0).toString() : this.value.toString(), upperCase ? ChineseNumber.ChineseNumberStyle.UPPER_CASE : ChineseNumber.ChineseNumberStyle.LOWER_CASE).toString();
    }

    public String toChineseUpperCase(boolean ignoreFractionalPart) {
        return this.toChineseString(ignoreFractionalPart, true);
    }

    public String toMoneyUpperCase() {
        return new ChineseNumber(this.value.setScale(2).toString(), ChineseNumber.ChineseNumberStyle.MONEY).toString();
    }
}

