/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.io.UnsupportedEncodingException;
import me.codeplayer.util.ArrayUtil;

public abstract class StringUtil {
    protected static final char[] digits = "0123456789ABCDEF".toCharArray();

    public static String unicode(String src) {
        byte[] bytes;
        try {
            bytes = src.getBytes("UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        int length = bytes.length;
        if (length > 2) {
            int i;
            StringBuilder sb = new StringBuilder((length - i) * 3);
            boolean isOdd = false;
            for (i = 2; i < length; ++i) {
                if (isOdd = !isOdd) {
                    sb.append("\\u");
                }
                sb.append(digits[bytes[i] >> 4 & 0xF]);
                sb.append(digits[bytes[i] & 0xF]);
            }
            return sb.toString();
        }
        return "";
    }

    public static String fastUnicode(String str) {
        byte[] bytes;
        try {
            bytes = str.getBytes("UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        int length = bytes.length;
        if (length > 2) {
            int i;
            char[] chars = new char[(length - i) * 3];
            int index = 0;
            boolean isOdd = false;
            for (i = 2; i < length; ++i) {
                if (isOdd = !isOdd) {
                    chars[index++] = 92;
                    chars[index++] = 117;
                }
                chars[index++] = digits[bytes[i] >> 4 & 0xF];
                chars[index++] = digits[bytes[i] & 0xF];
            }
            return new String(chars);
        }
        return "";
    }

    public static final StringBuilder getBuilder(int size, int shift) {
        int capacity = size << shift;
        if (capacity < 16) {
            capacity = 16;
        }
        return new StringBuilder(capacity);
    }

    public static final int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static final StringBuilder getBuilder(int extra, CharSequence s1, CharSequence s2, CharSequence s3, CharSequence s4) {
        return new StringBuilder(extra + StringUtil.length(s1) + StringUtil.length(s2) + StringUtil.length(s3) + StringUtil.length(s4));
    }

    public static final StringBuilder getBuilder(int extra, CharSequence s1, CharSequence s2, CharSequence s3) {
        return new StringBuilder(extra + StringUtil.length(s1) + StringUtil.length(s2) + StringUtil.length(s3));
    }

    public static final StringBuilder getBuilder(int extra, CharSequence s1, CharSequence s2) {
        return new StringBuilder(extra + StringUtil.length(s1) + StringUtil.length(s2));
    }

    public static final StringBuilder getBuilder(int extra, CharSequence s1) {
        return new StringBuilder(extra + StringUtil.length(s1));
    }

    public static final boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static final boolean notEmpty(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static final boolean isAnyNotEmpty(CharSequence ... css) {
        if (css != null && css.length > 0) {
            for (CharSequence cs : css) {
                if (!StringUtil.notEmpty(cs)) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean isEmpty(Object obj) {
        return obj == null || obj.toString().length() == 0;
    }

    public static final boolean notEmpty(Object obj) {
        return obj != null && obj.toString().length() > 0;
    }

    public static final boolean hasEmpty(Object ... values) {
        int length = ArrayUtil.getLength(values, true);
        do {
            if (!StringUtil.isEmpty(values[--length])) continue;
            return true;
        } while (length > 0);
        return false;
    }

    public static final boolean isBlank(CharSequence str) {
        if (str == null) {
            return true;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static final boolean notBlank(String str) {
        return !StringUtil.isBlank(str);
    }

    public static final boolean isBlank(Object obj) {
        return obj == null || StringUtil.isBlank(obj.toString());
    }

    public static final boolean notBlank(Object obj) {
        return !StringUtil.isBlank(obj);
    }

    public static final boolean hasBlank(Object ... values) {
        int length = ArrayUtil.getLength(values, true);
        do {
            if (!StringUtil.isBlank(values[--length])) continue;
            return true;
        } while (length > 0);
        return false;
    }

    public static final String toString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static final String trim(Object obj) {
        return obj == null ? "" : obj.toString().trim();
    }

    public static final String trim4Html(Object obj) {
        String str;
        return obj != null && (str = obj.toString().trim()).length() > 0 ? str : "&nbsp;";
    }

    public static final String limitChars(String str, int maxLength, String suffix) {
        if (str == null) {
            return "";
        }
        int length = (str = str.trim()).length();
        if (length <= maxLength) {
            return str;
        }
        str = str.substring(0, maxLength);
        return suffix == null ? suffix : str + suffix;
    }

    public static final String limitChars(String str, int maxLength) {
        return StringUtil.limitChars(str, maxLength, "...");
    }

    public static final String zeroFill(String str, int maxLength) {
        return StringUtil.pad(str, '0', maxLength, true);
    }

    private static final String pad(String str, char ch, int maxLength, boolean left) {
        if (str == null) {
            return "";
        }
        if (maxLength < 1) {
            throw new IllegalArgumentException("Argument 'maxLength' can not be less than 1:" + maxLength);
        }
        int length = str.length();
        if (maxLength > length) {
            int diffSize = maxLength - length;
            char[] chars = new char[maxLength];
            if (left) {
                for (int i = 0; i < diffSize; ++i) {
                    chars[i] = ch;
                }
                System.arraycopy(str.toCharArray(), 0, chars, diffSize, length);
            } else {
                for (int i = diffSize; i < maxLength; ++i) {
                    chars[i] = ch;
                }
                System.arraycopy(str.toCharArray(), 0, chars, 0, length);
            }
            str = new String(chars);
        }
        return str;
    }

    public static final String leftPad(String str, char ch, int maxLength) {
        return StringUtil.pad(str, ch, maxLength, true);
    }

    public static final String rightPad(String str, char ch, int maxLength) {
        return StringUtil.pad(str, ch, maxLength, false);
    }

    public static final String trim(String str) {
        return str == null ? "" : str.trim();
    }

    public static final String replaceChars(String str, char ch, int beginIndex, int endIndex) {
        int length = str.length();
        int[] range = StringUtil.ensureRangeSafe(beginIndex, endIndex, length);
        if (range == null) {
            return str;
        }
        char[] chars = str.toCharArray();
        for (int i = range[0]; i < range[1]; ++i) {
            chars[i] = ch;
        }
        return new String(chars);
    }

    public static final int[] ensureRangeSafe(int beginIndex, int endIndex, int length) {
        if (length <= 0 || beginIndex == endIndex) {
            return null;
        }
        if (beginIndex < 0) {
            if ((beginIndex += length) < 0) {
                beginIndex = 0;
            }
        } else if (beginIndex >= length) {
            return null;
        }
        if (endIndex < 0) {
            if ((endIndex += length) < 0) {
                return null;
            }
        } else if (endIndex > length) {
            endIndex = length;
        }
        int[] range = new int[]{beginIndex, endIndex};
        if (beginIndex > endIndex) {
            range[0] = endIndex;
            range[1] = beginIndex;
        }
        return range;
    }

    public static final String replaceChars(String str, char ch, int beginIndex) {
        return StringUtil.replaceChars(str, ch, beginIndex, str.length());
    }

    public static final String replaceSubstring(String str, String replacement, int beginIndex, int endIndex) {
        if (replacement == null || replacement.length() == 0) {
            return str;
        }
        int length = str.length();
        int[] range = StringUtil.ensureRangeSafe(beginIndex, endIndex, length);
        if (range == null) {
            return str;
        }
        beginIndex = range[0];
        endIndex = range[1];
        StringBuilder sb = new StringBuilder(replacement.length() + length - endIndex + beginIndex);
        if (beginIndex > 0) {
            sb.append(str, 0, beginIndex);
        }
        sb.append(replacement);
        if (endIndex < length) {
            sb.append(str, endIndex, length);
        }
        return sb.toString();
    }

    public static final String replaceSubstring(String str, String replacement, int beginIndex) {
        return StringUtil.replaceSubstring(str, replacement, beginIndex, str.length());
    }

    public static final String transEncoding(String str, String originalCharset, String targetCharset) {
        try {
            return new String(str.getBytes(originalCharset), targetCharset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final String transEncodingForURI(String str, String targetCharset) {
        return StringUtil.transEncoding(str, "ISO-8859-1", targetCharset);
    }

    public static final String reverse(CharSequence str) {
        if (str == null) {
            return "";
        }
        return new StringBuilder(str).reverse().toString();
    }

    public static final boolean startsWith(String str, char firstChar) {
        return str != null && str.length() > 0 && str.charAt(0) == firstChar;
    }

    public static final boolean endsWith(String str, char lastChar) {
        return str != null && str.length() > 0 && str.charAt(str.length() - 1) == lastChar;
    }

    public static final String escapeSQLLike(String likeStr, char escapeChar, boolean appendLikeWildcard) {
        if (StringUtil.isEmpty(likeStr)) {
            return "";
        }
        boolean modified = false;
        char[] strChars = likeStr.toCharArray();
        int length = strChars.length + 2;
        if (appendLikeWildcard) {
            length += 2;
        }
        StringBuilder sb = new StringBuilder(length);
        String searchChars = "\\'_%;";
        if (appendLikeWildcard) {
            sb.append('%');
        }
        for (int i = 0; i < strChars.length; ++i) {
            if (searchChars.indexOf(strChars[i], 0) != -1) {
                modified = true;
                sb.append(escapeChar);
            }
            sb.append(strChars[i]);
        }
        if (appendLikeWildcard) {
            sb.append('%');
        }
        return appendLikeWildcard || modified ? sb.toString() : likeStr;
    }

    public static final String escapeSQLLike(String likeStr, boolean appendLikeWildcard) {
        return StringUtil.escapeSQLLike(likeStr, '\\', appendLikeWildcard);
    }

    public static final String escapeSQLLike(String likeStr) {
        return StringUtil.escapeSQLLike(likeStr, '\\', false);
    }

    public static final boolean containsWord(String container, String searchedWord, String seperatorChars, boolean fastMode) {
        int sLength;
        if (container == null || searchedWord == null) {
            return false;
        }
        int cLength = container.length();
        if (cLength == (sLength = searchedWord.length())) {
            return container.equals(searchedWord);
        }
        if (cLength > sLength) {
            int startIndex;
            int fromIndex = 0;
            while ((startIndex = container.indexOf(searchedWord, fromIndex)) != -1) {
                fromIndex = startIndex + sLength;
                if (!(startIndex != 0 && seperatorChars.indexOf(container.charAt(startIndex - 1)) == -1 || fromIndex != cLength && seperatorChars.indexOf(container.charAt(fromIndex)) == -1)) {
                    return true;
                }
                if (!fastMode && fromIndex + sLength <= cLength) continue;
                break;
            }
        }
        return false;
    }

    public static final boolean containsWord(String container, String searchedWord, String seperatorChars) {
        return StringUtil.containsWord(container, searchedWord, seperatorChars, true);
    }
}

