/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class EasyDate
implements Comparable<Object>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DATE = "yyyy-MM-dd";
    public static final String DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String SHORT_DATE = "yyyyMMdd";
    public static final String YM_DATE = "yyyyMM";
    public static final String GMT_DATE = "d MMM yyyy HH:mm:ss 'GMT'";
    public static final String GMT_NET_DATE = "EEE, d MMM yyyy HH:mm:ss 'GMT'";
    public static final long MILLIS_OF_MINUTE = 60000L;
    public static final long MILLIS_OF_HOUR = 3600000L;
    public static final long MILLIS_OF_DAY = 86400000L;
    private Calendar calendar;

    protected void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.calendar.setLenient(false);
        this.calendar.setFirstDayOfWeek(2);
    }

    public EasyDate(java.util.Date date) {
        this(date.getTime());
    }

    public EasyDate() {
        this.setCalendar(new GregorianCalendar());
    }

    public EasyDate(long date) {
        this.setCalendar(new GregorianCalendar());
        this.calendar.setTimeInMillis(date);
    }

    private EasyDate(Object date, int offsetYear, int offsetMonth, int offsetDay) {
        this(EasyDate.getTimeOfDate(date));
        if (offsetYear != 0) {
            this.calendar.add(1, offsetYear);
        }
        if (offsetMonth != 0) {
            this.calendar.add(2, offsetMonth);
        }
        if (offsetDay != 0) {
            this.calendar.add(5, offsetDay);
        }
    }

    public EasyDate(java.util.Date date, int offsetYear, int offsetMonth, int offsetDay) {
        this((Object)date, offsetYear, offsetMonth, offsetDay);
    }

    public EasyDate(EasyDate date, int offsetYear, int offsetMonth, int offsetDay) {
        this((Object)date, offsetYear, offsetMonth, offsetDay);
    }

    public EasyDate(Calendar date, int offsetYear, int offsetMonth, int offsetDay) {
        this((Object)date, offsetYear, offsetMonth, offsetDay);
    }

    private static final long getTimeOfDate(Object date) {
        long theTime;
        if (date == null) {
            theTime = System.currentTimeMillis();
        } else if (date instanceof java.util.Date) {
            theTime = ((java.util.Date)date).getTime();
        } else if (date instanceof EasyDate) {
            theTime = ((EasyDate)date).getTime();
        } else if (date instanceof Calendar) {
            theTime = ((Calendar)date).getTimeInMillis();
        } else {
            throw new ClassCastException(date.getClass().getName());
        }
        return theTime;
    }

    public EasyDate(int year, int month, int day, int ... args) {
        int[] theArgs = new int[]{0, 0, 0, 0};
        for (int i = 0; i < args.length; ++i) {
            theArgs[i] = args[i];
        }
        this.setCalendar(new GregorianCalendar(year, month - 1, day, theArgs[0], theArgs[1], theArgs[2]));
        this.calendar.set(14, theArgs[3]);
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public EasyDate setYear(int year) {
        this.calendar.set(1, year);
        return this;
    }

    public EasyDate addYear(int year) {
        this.calendar.add(1, year);
        return this;
    }

    public int getMonth() {
        return this.calendar.get(2) + 1;
    }

    public EasyDate setMonth(int month) {
        this.calendar.set(2, month - 1);
        return this;
    }

    public EasyDate addMonth(int month) {
        this.calendar.add(2, month);
        return this;
    }

    public EasyDate set(int year, int month, int day, int ... args) {
        this.calendar.set(1, year);
        this.calendar.set(2, month - 1);
        this.calendar.set(5, day);
        if (args.length > 0) {
            int[] fields = new int[]{11, 12, 13, 14};
            int i = 0;
            do {
                this.calendar.set(fields[i], args[i]);
            } while (++i < args.length);
        }
        return this;
    }

    public int getDay() {
        return this.calendar.get(5);
    }

    public int getDayOfYear() {
        return this.calendar.get(6);
    }

    public EasyDate setDay(int day) {
        this.calendar.set(5, day);
        return this;
    }

    public EasyDate addDay(int day) {
        this.calendar.add(5, day);
        return this;
    }

    public int getWeekDay() {
        int weekday = this.calendar.get(7);
        return weekday == 1 ? 7 : --weekday;
    }

    public int getHour() {
        return this.calendar.get(11);
    }

    public EasyDate setHour(int hour) {
        this.calendar.set(11, hour);
        return this;
    }

    public EasyDate addHour(int hour) {
        this.calendar.add(11, hour);
        return this;
    }

    public int getMinute() {
        return this.calendar.get(12);
    }

    public EasyDate setMinute(int minute) {
        this.calendar.set(12, minute);
        return this;
    }

    public EasyDate addMinute(int minute) {
        this.calendar.add(12, minute);
        return this;
    }

    public int getSecond() {
        return this.calendar.get(13);
    }

    public EasyDate setSecond(int second) {
        this.calendar.set(13, second);
        return this;
    }

    public EasyDate addMillisecond(int ms) {
        this.calendar.add(14, ms);
        return this;
    }

    public int getMillisecond() {
        return this.calendar.get(14);
    }

    public EasyDate setMillisecond(int ms) {
        this.calendar.set(14, ms);
        return this;
    }

    public EasyDate addSecond(int second) {
        this.calendar.add(13, second);
        return this;
    }

    public long getTime() {
        return this.calendar.getTimeInMillis();
    }

    public EasyDate setTime(long date) {
        this.calendar.setTimeInMillis(date);
        return this;
    }

    public EasyDate addTime(long time) {
        this.calendar.setTimeInMillis(this.calendar.getTimeInMillis() + time);
        return this;
    }

    public EasyDate setDate(java.util.Date date) {
        this.calendar.setTime(date);
        return this;
    }

    public int getWeeksOfMonth() {
        return this.calendar.get(4);
    }

    public int getWeeksOfYear() {
        return this.calendar.get(3);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public static EasyDate smartParse(String date) {
        if (date == null) {
            throw new NullPointerException();
        }
        int length = date.length();
        String format = null;
        switch (length) {
            case 10: {
                format = DATE;
                break;
            }
            case 19: {
                format = DATETIME;
                break;
            }
            case 8: {
                format = SHORT_DATE;
                break;
            }
            case 6: {
                format = YM_DATE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unable to parse the date string because of unexpected format:" + date);
            }
        }
        return EasyDate.parse(format, date);
    }

    public static final EasyDate valueOf(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return new EasyDate(date.getTime());
    }

    public static final EasyDate valueOf(Calendar date) {
        if (date == null) {
            return null;
        }
        return new EasyDate(date.getTime());
    }

    public static final EasyDate valueOf(String date) {
        if (date == null) {
            return null;
        }
        return EasyDate.smartParse(date);
    }

    public static EasyDate parse(DateFormat format, String date) {
        try {
            return new EasyDate(format.parse(date).getTime());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static EasyDate parse(String format, String dateStr) {
        java.util.Date date;
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            date = dateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        return new EasyDate(date);
    }

    public java.util.Date toDate() {
        return new java.util.Date(this.calendar.getTimeInMillis());
    }

    public Date toSqlDate() {
        return new Date(this.calendar.getTimeInMillis());
    }

    public Timestamp toTimestamp() {
        return new Timestamp(this.calendar.getTimeInMillis());
    }

    public Time toTime() {
        return new Time(this.calendar.getTimeInMillis());
    }

    @Override
    public int compareTo(Object date) {
        if (date == null) {
            throw new NullPointerException();
        }
        if (this == date) {
            return 0;
        }
        long diff = this.calendar.getTimeInMillis() - EasyDate.getTimeOfDate(date);
        if (diff == 0L) {
            return 0;
        }
        return diff > 0L ? 1 : -1;
    }

    public long calcDifference(Object date, int field, RoundingMode roundingMode) {
        long theMillis;
        if (date instanceof java.util.Date) {
            theMillis = ((java.util.Date)date).getTime();
        } else if (date instanceof EasyDate) {
            theMillis = ((EasyDate)date).getTime();
        } else if (date instanceof Calendar) {
            theMillis = ((Calendar)date).getTimeInMillis();
        } else {
            throw new ClassCastException(date.getClass().getName());
        }
        long diff = this.getTime() - theMillis;
        if (diff == 0L) {
            return 0L;
        }
        switch (field) {
            case 1: 
            case 2: {
                boolean isMax = diff > 0L;
                EasyDate me = new EasyDate(this.getTime());
                EasyDate other = new EasyDate(theMillis);
                EasyDate min = isMax ? other : me;
                EasyDate max = isMax ? me : other;
                int diffOfYear = max.getYear() - min.getYear();
                if (diffOfYear > 0) {
                    min.addYear(diffOfYear);
                }
                if (field == 2) {
                    int diffOfMonth = max.getMonth() - min.getMonth();
                    if (diffOfMonth != 0) {
                        min.addMonth(diffOfMonth);
                    }
                    diff = diffOfYear * 12 + diffOfMonth;
                } else {
                    diff = diffOfYear;
                }
                long prefix = max.getTime() - min.getTime();
                if (prefix == 0L) {
                    return diff;
                }
                long suffix = 0L;
                if (prefix > 0L) {
                    min.calendar.add(field, 1);
                    suffix = min.getTime() - max.getTime();
                } else {
                    suffix = -prefix;
                    --diff;
                    min.calendar.add(field, -1);
                    prefix = max.getTime() - min.getTime();
                }
                double base = suffix > prefix ? 0.1 : 0.9;
                diff = new BigDecimal((double)diff + base).setScale(0, roundingMode).longValue();
                return isMax ? diff : -diff;
            }
        }
        long unit = EasyDate.getMillisOfUnit(field);
        return BigDecimal.valueOf(diff).divide(BigDecimal.valueOf(unit), roundingMode).longValue();
    }

    public long calcDifference(Object date, int field) {
        return this.calcDifference(date, field, RoundingMode.CEILING);
    }

    public int calcDifference(Object date) {
        return (int)this.calcDifference(date, 5, RoundingMode.CEILING);
    }

    public boolean isLeapYear(int year) {
        return ((GregorianCalendar)this.calendar).isLeapYear(year);
    }

    public boolean isLeapYear() {
        return ((GregorianCalendar)this.calendar).isLeapYear(this.getYear());
    }

    public static final long getMillisOfUnit(int field) {
        switch (field) {
            case 5: 
            case 6: {
                return 86400000L;
            }
            case 10: 
            case 11: {
                return 3600000L;
            }
            case 12: {
                return 60000L;
            }
            case 13: {
                return 1000L;
            }
            case 14: {
                return 1L;
            }
        }
        throw new IllegalArgumentException(String.valueOf(field));
    }

    public static boolean isSameAs(long a, long b, int inField) {
        if (a == b) {
            return true;
        }
        if (inField > 4) {
            long diff = a - b;
            long unit = EasyDate.getMillisOfUnit(inField);
            if (diff > -unit && diff < unit) {
                long offset = (a + (long)TimeZone.getDefault().getRawOffset()) % unit - diff;
                return 0L <= offset && offset < unit;
            }
        } else {
            Calendar ac = Calendar.getInstance();
            ac.setTimeInMillis(a);
            Calendar bc = Calendar.getInstance();
            bc.setTimeInMillis(b);
            switch (inField) {
                case 3: 
                case 4: {
                    if (ac.get(4) != bc.get(4)) break;
                }
                case 2: {
                    if (ac.get(2) != bc.get(2)) break;
                }
                case 1: {
                    return ac.get(0) == bc.get(0) && ac.get(1) == bc.get(1);
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(inField));
                }
            }
        }
        return false;
    }

    public boolean isSameAs(Object date, int inField) {
        return EasyDate.isSameAs(this.getTime(), EasyDate.getTimeOfDate(date), inField);
    }

    public static boolean isSameAs(Object a, Object b, int inField) {
        return EasyDate.isSameAs(EasyDate.getTimeOfDate(a), EasyDate.getTimeOfDate(b), inField);
    }

    public boolean after(Object date) {
        return this.compareTo(date) > 0;
    }

    public int getLastDayOfMonth() {
        return this.calendar.getActualMaximum(5);
    }

    public EasyDate beginOf(int field) {
        switch (field) {
            case 1: {
                this.calendar.set(2, 0);
            }
            case 2: {
                this.calendar.set(5, 1);
            }
            case 5: {
                this.calendar.set(11, 0);
            }
            case 11: {
                this.calendar.set(12, 0);
            }
            case 12: {
                this.calendar.set(13, 0);
            }
            case 13: {
                this.calendar.set(14, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(field));
            }
        }
        return this;
    }

    public EasyDate setTimeZoneOffset(int minutes) {
        StringBuilder timeZoneID = new StringBuilder().append("GMT").append(minutes > 0 ? (char)'+' : '-').append(minutes / 60);
        int min = minutes % 60;
        if (min > 0) {
            timeZoneID.append(':');
            if (min < 10) {
                timeZoneID.append('0');
            }
            timeZoneID.append(min);
        }
        this.calendar.getTimeInMillis();
        this.calendar.setTimeZone(TimeZone.getTimeZone(timeZoneID.toString()));
        return this;
    }

    public int getTimeZoneOffset() {
        TimeZone timeZone = this.calendar.getTimeZone();
        return timeZone.getOffset(this.calendar.getTimeInMillis()) / 60000;
    }

    public EasyDate endOf(int field) {
        switch (field) {
            case 1: {
                this.calendar.set(2, 11);
            }
            case 2: {
                this.calendar.set(5, this.calendar.getActualMaximum(5));
            }
            case 5: {
                this.calendar.set(11, 23);
            }
            case 11: {
                this.calendar.set(12, 59);
            }
            case 12: {
                this.calendar.set(13, 59);
            }
            case 13: {
                this.calendar.set(14, 999);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(field));
            }
        }
        return this;
    }

    public boolean before(Object date) {
        return this.compareTo(date) < 0;
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.calendar == null ? 0 : this.calendar.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EasyDate)) {
            return false;
        }
        EasyDate other = (EasyDate)obj;
        if (this.calendar == null && other.calendar != null) {
            return false;
        }
        return this.calendar.equals(other.calendar);
    }

    public String toString() {
        char[] chars = new char[]{'0', '0', '0', '0', '-', '0', '0', '-', '0', '0'};
        EasyDate.setNumberToTheRight(chars, this.getYear(), 0, 4);
        EasyDate.setNumberToTheRight(chars, this.getMonth(), 5, 2);
        EasyDate.setNumberToTheRight(chars, this.getDay(), 8, 2);
        return new String(chars);
    }

    public String toDateString() {
        char[] chars = new char[]{'0', '0', '0', '0', '\u5e74', '0', '0', '\u6708', '0', '0', '\u65e5'};
        EasyDate.setNumberToTheRight(chars, this.getYear(), 0, 4);
        EasyDate.setNumberToTheRight(chars, this.getMonth(), 5, 2);
        EasyDate.setNumberToTheRight(chars, this.getDay(), 8, 2);
        return new String(chars);
    }

    public String toString(Format format) {
        TimeZone timeZone;
        if (format instanceof DateFormat && (timeZone = this.calendar.getTimeZone()).getRawOffset() != TimeZone.getDefault().getRawOffset()) {
            ((DateFormat)format).setTimeZone(timeZone);
        }
        return format.format(this.toDate());
    }

    public String toDateTimeString() {
        char[] chars = new char[]{'0', '0', '0', '0', '-', '0', '0', '-', '0', '0', ' ', '0', '0', ':', '0', '0', ':', '0', '0'};
        EasyDate.setNumberToTheRight(chars, this.getYear(), 0, 4);
        EasyDate.setNumberToTheRight(chars, this.getMonth(), 5, 2);
        EasyDate.setNumberToTheRight(chars, this.getDay(), 8, 2);
        EasyDate.setNumberToTheRight(chars, this.getHour(), 11, 2);
        EasyDate.setNumberToTheRight(chars, this.getMinute(), 14, 2);
        EasyDate.setNumberToTheRight(chars, this.getSecond(), 17, 2);
        return new String(chars);
    }

    public String toShortString() {
        char[] chars = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
        EasyDate.setNumberToTheRight(chars, this.getYear(), 0, 4);
        EasyDate.setNumberToTheRight(chars, this.getMonth(), 4, 2);
        EasyDate.setNumberToTheRight(chars, this.getDay(), 6, 2);
        return new String(chars);
    }

    public String toLongString() {
        char[] chars = new char[]{'0', '0', '0', '0', '-', '0', '0', '-', '0', '0', ' ', '0', '0', ':', '0', '0', ':', '0', '0', ' ', '0', '0', '0'};
        EasyDate.setNumberToTheRight(chars, this.getYear(), 0, 4);
        EasyDate.setNumberToTheRight(chars, this.getMonth(), 5, 2);
        EasyDate.setNumberToTheRight(chars, this.getDay(), 8, 2);
        EasyDate.setNumberToTheRight(chars, this.getHour(), 11, 2);
        EasyDate.setNumberToTheRight(chars, this.getMinute(), 14, 2);
        EasyDate.setNumberToTheRight(chars, this.getSecond(), 17, 2);
        EasyDate.setNumberToTheRight(chars, this.getMillisecond(), 20, 3);
        return new String(chars);
    }

    public String toGMTString() {
        return new SimpleDateFormat(GMT_DATE).format(this.toDate());
    }

    public String toGMTNetString() {
        return new SimpleDateFormat(GMT_NET_DATE).format(this.toDate());
    }

    public Object clone() throws CloneNotSupportedException {
        EasyDate date = null;
        try {
            date = (EasyDate)super.clone();
            if (this.calendar != null) {
                date.calendar = (Calendar)this.calendar.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return date;
    }

    public static final void setNumberToChars(char[] chars, int number, int start, int length) {
        int end = start + length;
        while (length-- > 0) {
            chars[--end] = (char)(48 + number % 10);
            number /= 10;
        }
    }

    protected static final void setNumberToTheRight(char[] chars, int number, int start, int length) {
        int end = start + length;
        while (number > 0 && length-- > 0) {
            chars[--end] = (char)(48 + number % 10);
            number /= 10;
        }
    }
}

