/*
 * Decompiled with CFR 0.152.
 */
package me.chyxion.tigon.mybatis;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import me.chyxion.tigon.mybatis.Criterion;
import me.chyxion.tigon.mybatis.ProcArg;
import me.chyxion.tigon.mybatis.SqlFragment;
import me.chyxion.tigon.mybatis.util.StrUtils;

public class Search
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Criterion> criteria = new LinkedList<Criterion>();
    private String table;
    private Integer offset;
    private Integer limit;
    private final Map<String, String> orders = new LinkedHashMap<String, String>();
    private final Map<String, Object> attrs = new HashMap<String, Object>();
    private static final Map<Criterion.Type, Consumer<ProcArg>> PROCESSORS = new HashMap<Criterion.Type, Consumer<ProcArg>>(16);

    public Search() {
    }

    public Search(Object value) {
        this("id", value);
    }

    public Search(String col, Object value) {
        this.eq(col, value);
    }

    public Search(String col, Collection<?> values) {
        this.in(col, values);
    }

    public Search(String col, Object[] values) {
        this.in(col, values);
    }

    public Search table(String table) {
        this.table = table;
        return this;
    }

    public Search clearCriteria() {
        this.criteria.clear();
        return this;
    }

    public Search clearOrders() {
        this.orders.clear();
        return this;
    }

    public Search eq(String col, Object value) {
        if (value == null) {
            return this.isNull(col);
        }
        if (value instanceof Collection) {
            return this.in(col, (Collection)value);
        }
        if (value.getClass().isArray()) {
            return this.in(col, this.arrayToList(value));
        }
        this.criteria.add(new Criterion(Criterion.Type.EQ, col, value));
        return this;
    }

    public Search isNull(String col) {
        this.criteria.add(new Criterion(Criterion.Type.IS_NULL, col, Collections.emptyList()));
        return this;
    }

    public Search isTrue(String col) {
        return this.eq(col, Boolean.TRUE);
    }

    public Search isFalse(String col) {
        return this.eq(col, Boolean.FALSE);
    }

    public Search in(String col, Object[] values) {
        this.criteria.add(new Criterion(Criterion.Type.IN, col, values));
        return this;
    }

    public Search in(String col, Collection<?> values) {
        this.criteria.add(new Criterion(Criterion.Type.IN, col, values));
        return this;
    }

    public Search like(String col, String value) {
        this.criteria.add(new Criterion(Criterion.Type.LIKE, col, value));
        return this;
    }

    public Search like(String col, String value, boolean wrapValue) {
        return this.like(col, wrapValue ? "%" + value + "%" : value);
    }

    public Search notLike(String col, String value) {
        this.criteria.add(new Criterion(Criterion.Type.NOT_LIKE, col, value));
        return this;
    }

    public Search notLike(String col, String value, boolean wrapValue) {
        return this.notLike(col, wrapValue ? "%" + value + "%" : value);
    }

    public Search contains(String col, String value) {
        return this.like(col, value, true);
    }

    public Search notContains(String col, String value) {
        return this.notLike(col, value, true);
    }

    public Search startsWith(String col, String value) {
        return this.like(col, value + "%");
    }

    public Search notStartsWith(String col, String value) {
        return this.notLike(col, value + "%");
    }

    public Search endsWith(String col, String value) {
        return this.like(col, "%" + value);
    }

    public Search notEndsWith(String col, String value) {
        return this.notLike(col, "%" + value);
    }

    public Search between(String col, Object bottom, Object top) {
        this.criteria.add(new Criterion(Criterion.Type.BETWEEN, col, Arrays.asList(bottom, top)));
        return this;
    }

    public Search notBetween(String col, Object bottom, Object top) {
        this.criteria.add(new Criterion(Criterion.Type.NOT_BETWEEN, col, Arrays.asList(bottom, top)));
        return this;
    }

    public Search ne(String col, Object value) {
        if (value == null) {
            return this.notNull(col);
        }
        if (value instanceof Collection) {
            return this.notIn(col, (Collection)value);
        }
        if (value.getClass().isArray()) {
            return this.notIn(col, this.arrayToList(value));
        }
        this.criteria.add(new Criterion(Criterion.Type.NE, col, value));
        return this;
    }

    public Search notNull(String col) {
        this.criteria.add(new Criterion(Criterion.Type.IS_NOT_NULL, col, (Object)null));
        return this;
    }

    public Search notIn(String col, Object[] values) {
        return this.notIn(col, Arrays.asList(values));
    }

    public Search notIn(String col, Collection<?> values) {
        this.criteria.add(new Criterion(Criterion.Type.NOT_IN, col, values));
        return this;
    }

    public Search lt(String col, Object value) {
        this.criteria.add(new Criterion(Criterion.Type.LT, col, value));
        return this;
    }

    public Search lte(String col, Object value) {
        this.criteria.add(new Criterion(Criterion.Type.LTE, col, value));
        return this;
    }

    public Search gt(String col, Object value) {
        this.criteria.add(new Criterion(Criterion.Type.GT, col, value));
        return this;
    }

    public Search gte(String col, Object value) {
        this.criteria.add(new Criterion(Criterion.Type.GTE, col, value));
        return this;
    }

    public Search and(Search search) {
        if (StrUtils.isBlank(search.table)) {
            search.table = this.table;
        }
        this.criteria.add(new Criterion(Criterion.Type.AND, search));
        return this;
    }

    public Search or(Search search) {
        if (StrUtils.isBlank(search.table)) {
            search.table = this.table;
        }
        this.criteria.add(new Criterion(Criterion.Type.OR, search));
        return this;
    }

    public Search or(String col, Object value) {
        return this.or(new Search(col, value).table(this.table));
    }

    public Search build(Consumer<ProcArg> builder) {
        this.criteria.add(new Criterion(Criterion.Type.BUILDER, builder));
        return this;
    }

    public Search asc(String col) {
        return this.orderBy(col, Order.ASC);
    }

    public Search desc(String col) {
        return this.orderBy(col, Order.DESC);
    }

    public Search orderBy(String col, Order order) {
        this.orders.put(ProcArg.col(this.table, col), order.name());
        return this;
    }

    public Search offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public Integer offset() {
        return this.offset;
    }

    public Search limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Integer limit() {
        return this.limit;
    }

    public Map<String, String> orders() {
        LinkedHashMap<String, String> ordersRtn = new LinkedHashMap<String, String>(this.orders.size());
        boolean hasTable = StrUtils.isNotBlank(this.table);
        for (Map.Entry<String, String> order : this.orders.entrySet()) {
            String col = order.getKey();
            ordersRtn.put(hasTable && !col.contains(".") ? this.table + "." + col : col, order.getValue());
        }
        return ordersRtn;
    }

    public List<Object> assemble() {
        return this.assemble(false);
    }

    public boolean hasCriterion() {
        return !this.criteria.isEmpty();
    }

    public boolean hasCriterion(String col) {
        for (Criterion criterion : this.criteria) {
            if (!col.equals(criterion.getCol())) continue;
            return true;
        }
        return false;
    }

    public boolean hasNoCriterion() {
        return this.criteria.isEmpty();
    }

    public boolean hasOrder() {
        return !this.orders.isEmpty();
    }

    public boolean hasNoOrder() {
        return this.orders.isEmpty();
    }

    public boolean hasAttr(String name) {
        return this.attrs.containsKey(name);
    }

    public boolean trueAttr(String name) {
        Object val = this.attr(name);
        return val instanceof Boolean && (Boolean)val != false;
    }

    public <T> T getAttr(String name) {
        return this.attr(name);
    }

    public <T> T attr(String name) {
        return (T)this.attrs.get(name);
    }

    public Search setAttr(String name, Object value) {
        return this.attr(name, value);
    }

    public Search attr(String name, Object value) {
        this.attrs.put(name, value);
        return this;
    }

    String table() {
        return this.table;
    }

    List<Object> assemble(boolean subSearch) {
        LinkedList<Object> result = new LinkedList<Object>();
        ProcArg arg = new ProcArg(this.table, result);
        for (Criterion criterion : this.criteria) {
            arg.setCriterion(criterion);
            Criterion.Type type = criterion.getType();
            if (type == Criterion.Type.OR) {
                if (arg.isHasPrevCol()) {
                    arg.addSql(" or ");
                } else {
                    arg.setHasPrevOrCol(true);
                }
            } else if (arg.isHasPrevOrCol()) {
                arg.addSql(" or ");
                arg.setHasPrevOrCol(false);
            } else if (arg.isHasPrevCol()) {
                arg.addSql(" and ");
            }
            PROCESSORS.get((Object)type).accept(arg);
            if (arg.isHasPrevCol()) continue;
            arg.setHasPrevCol(true);
        }
        if (subSearch && this.criteria.size() > 1) {
            result.add(0, new SqlFragment("("));
            result.add(new SqlFragment(")"));
        }
        return result;
    }

    List<Object> arrayToList(Object array) {
        int length = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }

    static {
        PROCESSORS.put(Criterion.Type.EQ, arg -> arg.addSql(arg.getCol() + " = ").addParam());
        PROCESSORS.put(Criterion.Type.NE, arg -> arg.addSql(arg.getCol() + " <> ").addParam());
        PROCESSORS.put(Criterion.Type.LIKE, arg -> arg.addSql(arg.getCol() + " like ").addParam());
        PROCESSORS.put(Criterion.Type.NOT_LIKE, arg -> arg.addSql(arg.getCol() + " not like ").addParam());
        PROCESSORS.put(Criterion.Type.LT, arg -> arg.addSql(arg.getCol() + " < ").addParam());
        PROCESSORS.put(Criterion.Type.LTE, arg -> arg.addSql(arg.getCol() + " <= ").addParam());
        PROCESSORS.put(Criterion.Type.GT, arg -> arg.addSql(arg.getCol() + " > ").addParam());
        PROCESSORS.put(Criterion.Type.GTE, arg -> arg.addSql(arg.getCol() + " >= ").addParam());
        PROCESSORS.put(Criterion.Type.IS_NULL, arg -> arg.addSql(arg.getCol() + " is null"));
        PROCESSORS.put(Criterion.Type.IS_NOT_NULL, arg -> arg.addSql(arg.getCol() + " is not null"));
        PROCESSORS.put(Criterion.Type.BETWEEN, arg -> {
            Iterator<?> valIt = arg.getCriterion().getValues().iterator();
            arg.addSql(arg.getCol() + " between ").addParam(valIt.next()).addSql(" and ").addParam(valIt.next());
        });
        PROCESSORS.put(Criterion.Type.NOT_BETWEEN, arg -> {
            Iterator<?> valIt = arg.getCriterion().getValues().iterator();
            arg.addSql(arg.getCol() + " not between ").addParam(valIt.next()).addSql(" and ").addParam(valIt.next());
        });
        PROCESSORS.put(Criterion.Type.IN, arg -> arg.addSql(arg.getCol() + " in ").addParamList());
        PROCESSORS.put(Criterion.Type.NOT_IN, arg -> arg.addSql(arg.getCol() + " not in ").addParamList());
        PROCESSORS.put(Criterion.Type.AND, arg -> arg.addSubsearch());
        PROCESSORS.put(Criterion.Type.OR, arg -> arg.addSubsearch());
        PROCESSORS.put(Criterion.Type.BUILDER, arg -> ((Consumer)arg.getCriterion().getAttr()).accept(arg));
    }

    public static enum Order {
        ASC,
        DESC;

    }
}

