/*
 * Decompiled with CFR 0.152.
 */
package me.chyxion.tigon.mybatis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import lombok.NonNull;
import me.chyxion.tigon.mybatis.Criterion;
import me.chyxion.tigon.mybatis.Search;
import me.chyxion.tigon.mybatis.SqlFragment;
import me.chyxion.tigon.mybatis.util.StrUtils;

public class ProcArg
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String table;
    @NonNull
    private final List<Object> result;
    private Criterion criterion;
    private boolean hasPrevCol;
    private boolean hasPrevOrCol;

    public ProcArg addSql(String sql) {
        this.result.add(new SqlFragment(sql));
        return this;
    }

    ProcArg addParam() {
        return this.addParam(this.getValue());
    }

    public ProcArg addParam(Object value) {
        this.result.add(value);
        return this;
    }

    ProcArg addParamList() {
        return this.addParamList(this.criterion.getValues());
    }

    public ProcArg addParamList(Object param, Object ... params) {
        ArrayList<Object> paramsList = new ArrayList<Object>(params.length + 1);
        paramsList.add(param);
        Stream.of(params).forEach(paramsList::add);
        return this.addParamList(paramsList);
    }

    public ProcArg addParamList(Collection<?> values) {
        this.addSql("(");
        int size = values.size();
        int i = 0;
        for (Object value : values) {
            this.addParam(value);
            if (++i >= size) continue;
            this.addSql(", ");
        }
        this.addSql(")");
        return this;
    }

    ProcArg addSubsearch() {
        Search search = (Search)this.criterion.getAttr();
        if (StrUtils.isBlank(search.table())) {
            search.table(this.table);
        }
        this.result.addAll(search.assemble(true));
        return this;
    }

    String getCol() {
        return ProcArg.col(this.table, this.criterion.getCol());
    }

    <T> T getValue() {
        return this.criterion.getValue();
    }

    static String col(String table, String col0) {
        String col = StrUtils.camelToUnderscore(col0);
        return StrUtils.isNotBlank(table) && !col.contains(".") ? table + "." + col : col;
    }

    void setCriterion(Criterion criterion) {
        this.criterion = criterion;
    }

    void setHasPrevCol(boolean hasPrevCol) {
        this.hasPrevCol = hasPrevCol;
    }

    void setHasPrevOrCol(boolean hasPrevOrCol) {
        this.hasPrevOrCol = hasPrevOrCol;
    }

    String getTable() {
        return this.table;
    }

    @NonNull
    List<Object> getResult() {
        return this.result;
    }

    Criterion getCriterion() {
        return this.criterion;
    }

    boolean isHasPrevCol() {
        return this.hasPrevCol;
    }

    boolean isHasPrevOrCol() {
        return this.hasPrevOrCol;
    }

    public ProcArg(String table, @NonNull List<Object> result) {
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        this.table = table;
        this.result = result;
    }
}

