/*
 * Decompiled with CFR 0.152.
 */
package me.chenzz.java.script.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import me.chenzz.java.script.util.AssertUtil;
import org.apache.commons.io.FileUtils;

public class FileUtil {
    public static String readContent(String filePath) {
        String content = FileUtils.readFileToString((File)new File(filePath));
        return content;
    }

    public static String findOneLine(String filePath, String keyword) {
        String[] lineArr;
        AssertUtil.notEmpty(keyword, "keyword");
        String content = FileUtil.readContent(filePath);
        for (String line : lineArr = content.split("\\n")) {
            if (null == line || !line.contains(keyword)) continue;
            return line;
        }
        return null;
    }

    public static void replaceText(String filePath, String originRegex, String replacedStr) {
        String content = FileUtil.readContent(filePath);
        content = content.replaceAll(originRegex, replacedStr);
        FileUtils.writeStringToFile((File)new File(filePath), (String)content);
    }

    public static List<Path> findFilesRecursivelyByWildcard(String rootDirPath, final String wildcardPattern) {
        Path startDir = Paths.get(rootDirPath, new String[0]);
        final ArrayList<Path> resultList = new ArrayList<Path>();
        Files.walkFileTree(startDir, EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + wildcardPattern);
                if (matcher.matches(file.getFileName())) {
                    resultList.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        return resultList;
    }
}

