package me.chatgame.uisdk.entity;


import me.chatgame.uisdk.R;

/**
 * Created by rth on 16/7/28.
 * 正在直播时的消息
 */
public class LivingMessage {


    private String level;

    private String messageContent;
    private String name;

    private int colorId;

    public LivingMessage(String level, String message, String name) {
        setLevel(level);
        setMessageContent(message);
        setName(name);
    }


    public void setMessageContent(String messageContent) {
        this.messageContent = messageContent;
    }


    public String getMessageContent() {
        return messageContent;
    }

    public void setLevel(String level) {
        this.level = level;
        setColorId();
    }

    public void setColorId() {
        int id = 0;
        switch (this.level) {
            case "1" :
                id = R.color.handwin_level_1;
                break;
            case "2" :
                id = R.color.handwin_level_2;
                break;
            case "3" :
                id = R.color.handwin_level_3;
                break;
            case "4" :
                id = R.color.handwin_level_4;
                break;
            case "5" :
                id = R.color.handwin_level_5;
                break;
            case "6" :
                id = R.color.handwin_level_6;
                break;
            case "7" :
                id = R.color.handwin_level_7;
                break;
            case "8" :
                id = R.color.handwin_level_8;
                break;
            case "9" :
                id = R.color.handwin_level_9;
                break;
            default:
                id = R.color.handwin_level_9;
                break;
        }
        setColorId(id);
    }

    public void setColorId(int colorId) {
        this.colorId = colorId;
    }

    public int getColorId() {
        return colorId;
    }

    public String getLevel() {
        return level;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }
}
