package me.chatgame.uisdk.activity.view;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;

import me.chatgame.mobilecg.activity.view.BaseRelativeLayout;
import me.chatgame.mobilecg.activity.view.interfaces.IView;
import me.chatgame.mobilecg.call.CallService;
import me.chatgame.mobilecg.call.CallState;
import me.chatgame.mobilecg.constant.BroadcastActions;
import me.chatgame.mobilecg.constant.ExtraInfo;
import me.chatgame.mobilecg.database.entity.DuduContact;
import me.chatgame.mobilecg.handler.EventSender;
import me.chatgame.mobilecg.handler.interfaces.IEventSender;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.views.CGImageView;
import me.chatgame.uisdk.R;

/**
 * Created by star on 16/7/23.
 */
public class VideoResponseView extends BaseRelativeLayout implements IView {
    private TextView nameTv;
    private boolean hasResponsed = false;
    View btnAccept;
    View btnReject;
    CGImageView avatarView;

    IEventSender eventSender;
    public VideoResponseView(Context context) {
        super(context);
        init();
    }

    public VideoResponseView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public VideoResponseView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    private void init() {
        eventSender = EventSender.getInstance_();
        inflate(getContext(), R.layout.handwin_view_video_response, this);
        nameTv = (TextView) findViewById(R.id.calling_name);
        avatarView = (CGImageView) findViewById(R.id.img_avatar);
        btnAccept = findViewById(R.id.btn_accept);
        btnReject = findViewById(R.id.btn_hangup);
        View btnVoice = findViewById(R.id.btn_voice);

        btnAccept.setOnClickListener(v -> videoAcceptClick());
        btnVoice.setOnClickListener(v -> voiceAcceptClick());
        btnReject.setOnClickListener(v -> hangupClick());
    }

    void videoAcceptClick() {
        if (hasResponsed || Utils.isFastDoubleClick()) {
            return;
        }
        hasResponsed = true;
        LocalBroadcastManager.getInstance(getContext()).sendBroadcast(
                new Intent(BroadcastActions.LIVE_ACCPET));
    }

    void voiceAcceptClick() {
        if (hasResponsed || Utils.isFastDoubleClick()) {
            return;
        }
        hasResponsed = true;
        Intent intent = new Intent(BroadcastActions.LIVE_ACCPET);
        intent.putExtra(ExtraInfo.IS_VIDEO, false);
        LocalBroadcastManager.getInstance(getContext()).sendBroadcast(intent);
    }


    void hangupClick() {
        if (hasResponsed || Utils.isFastDoubleClick()) {
            return;
        }
        btnAccept.setVisibility(View.GONE);
        btnReject.setVisibility(View.GONE);
        hasResponsed = true;
        // 显示拒接菜单
        eventSender.sendRejectEvent();
    }

    @Override
    public void show() {
        setVisibility(VISIBLE);
    }

    @Override
    public void hide() {
        setVisibility(GONE);
        hasResponsed = false;
    }

    public void showCallingInfo() {
        DuduContact contact = CallState.getInstance().getContactInfo();
        if (contact != null) {
            nameTv.setText(contact.getShowName());
            avatarView.load(contact.getAvatarUrl());
        } else {
            nameTv.setText("");
            avatarView.load(null);
        }
    }

    @Override
    public void showCameraStatus(boolean cameraOpen) {

    }

    @Override
    public void onStateChanged() {

    }

    @Override
    public void onPeerProximityChanged() {

    }

    @Override
    public void exit() {

    }

    @Override
    public void waitClose() {

    }
}
