package me.chatgame.uisdk.activity.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.TextView;


import me.chatgame.mobilecg.activity.view.RecordVideoView;
import me.chatgame.mobilecg.activity.view.interfaces.ILiveActivity;
import me.chatgame.mobilecg.call.CallState;
import me.chatgame.mobilecg.handler.VoipAndroidManager;
import me.chatgame.mobilecg.handler.interfaces.IVoipAndroidManager;
import me.chatgame.mobilecg.model.ShortVideoType;
import me.chatgame.mobilecg.util.BackgroundExecutor;
import me.chatgame.mobilecg.util.ReflectInterfaceProxy;
import me.chatgame.mobilecg.views.AudioRecordWaveView;
import me.chatgame.mobilecg.views.IconFontTextView;
import me.chatgame.mobilecg.views.ProgressWheel;
import me.chatgame.uisdk.R;
import me.chatgame.voip.VoipAndroid;


/**
 * Created by star on 15/12/8.
 */
public class VideoRecorderView extends BaseVideoRecorderView {
    private RecordVideoView recordVideoView;
    private boolean alreadyInflated_ = false;

    public VideoRecorderView(Context context) {
        super(context);
        init_();
    }

    public VideoRecorderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init_();
    }

    public VideoRecorderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init_();
    }

    public static VideoRecorderView build(Context context) {
        VideoRecorderView instance = new VideoRecorderView(context);
        instance.onFinishInflate();
        return instance;
    }

    /**
     * The mAlreadyInflated_ hack is needed because of an Android bug
     * which leads to infinite calls of onFinishInflate()
     * when inflating a layout with a parent and using
     * the <merge /> tag.
     *
     */
    @java.lang.Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_view_video_recorder, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    private void init_() {
        liveActivity = ((ILiveActivity) ReflectInterfaceProxy.newInstance(ILiveActivity.class, getContext()));
    }

    public static VideoRecorderView build(Context context, AttributeSet attrs) {
        VideoRecorderView instance = new VideoRecorderView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static VideoRecorderView build(Context context, AttributeSet attrs, int defStyleAttr) {
        VideoRecorderView instance = new VideoRecorderView(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        btnStart = ((IconFontTextView) hasViews.findViewById(R.id.id_btn_video_recorder));
        sendText = ((TextView) hasViews.findViewById(R.id.id_text_video_send));
        btnCancel = ((TextView) hasViews.findViewById(R.id.id_btn_video_record_cancel));
        wheelProgress = ((ProgressWheel) hasViews.findViewById(R.id.whellprogress));
        tvStartDeleteRecord = ((TextView) hasViews.findViewById(R.id.tv_start_delete_record));
        recordWaveView = ((AudioRecordWaveView) hasViews.findViewById(R.id.record_waveview));
        if (btnCancel!= null) {
            btnCancel.setOnClickListener(view -> VideoRecorderView.this.onBtnRecordCancelClick()
            );
        }
        if (wheelProgress!= null) {
            wheelProgress.setOnClickListener(view -> VideoRecorderView.this.onBtnRecordSendClick()
            );
        }
        afterViews();
    }
    
    
    void afterViews() {
        super.afterViews();
    }

    @Override
    protected View createPreviewView() {
        recordVideoView = RecordVideoView.build(getContext());
        if (videoAudioRecorderView != null) {
            recordVideoView.setTexture2(videoAudioRecorderView.isBurned());
        }
        return recordVideoView;
    }

    @Override
    public void showPreviewView(boolean startCamera, boolean forceFrontCamera) {
        if (recordVideoView != null && previewContainer != null && !isPreviewShow()) {
            if (CallState.getInstance().isNotIdle()){
                return;
            }
            stopVideoAudioPlay();
            setIsPreviewShow(true);
            recordVideoView.showImage(null);
            recordVideoView.setVisibility(View.VISIBLE);
            recordVideoView.startPreview();
            float pivotX = previewContainer.getWidth() / 2;
            float pivotY = previewContainer.getHeight() - recorderViewHeight;

            recordVideoView.setPivotX(pivotX);
            recordVideoView.setPivotY(pivotY);
            float s1 = 0.7f;
            float s2 = 1.1f;
            float s3 = 1f;
            ObjectAnimator scaleX = ObjectAnimator.ofFloat(recordVideoView, View.SCALE_X, s1, s2, s3);
            ObjectAnimator scaleY = ObjectAnimator.ofFloat(recordVideoView, View.SCALE_Y, s1, s2, s3);

            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.setDuration(300);
            animatorSet.setInterpolator(new AccelerateDecelerateInterpolator());

            animatorSet.playTogether(scaleX, scaleY);

            animatorSet.addListener(new AnimatorListenerAdapter() {
                @Override
                public void onAnimationEnd(Animator animation) {
                    if (forceFrontCamera && !isFrontCamera()) {
                        switchCamera(true);
                    } else if (!cameraHandler.isActive() && !isFrontCamera()) {
                        // if previous camera is back, switch to back still
                        switchCamera(isFrontCamera());
                    }
                    startPreview(startCamera);
                }
            });
            animatorSet.start();
        }
    }

    @Override
    public void hidePreviewView(boolean stopCamera) {
        if (previewContainer != null && recordVideoView != null && isPreviewShow()) {
            restartVideoPlay();
            setIsPreviewShow(false);
            playFadeAinimation(previewContainer, false);
            float pivotX = previewContainer.getWidth() / 2;
            float pivotY = previewContainer.getHeight() - recorderViewHeight;
            recordVideoView.setPivotX(pivotX);
            recordVideoView.setPivotY(pivotY);
            recordVideoView.showImage(null);
            recordVideoView.stopPreview();
            float s1 = 1f;
            float s2 = 0.7f;
            ObjectAnimator scaleX = ObjectAnimator.ofFloat(recordVideoView, View.SCALE_X, s1, s2);
            ObjectAnimator scaleY = ObjectAnimator.ofFloat(recordVideoView, View.SCALE_Y, s1, s2);

            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.setDuration(200);
            animatorSet.setInterpolator(new AccelerateDecelerateInterpolator());
            animatorSet.playTogether(scaleX, scaleY);
            if (stopCamera) {
                animatorSet.addListener(new AnimatorListenerAdapter() {
                    @Override
                    public void onAnimationEnd(Animator animation) {
                        stopPreview();
                    }
                });
            }
            animatorSet.start();
        } else if (stopCamera) {
            stopPreview();
        }
    }

    @Override
    protected void changeAvatar(boolean isBurned) {
        // 改变形象
        if (recordVideoView != null) {
            recordVideoView.setTexture2(isBurned);
        }
    }

    @Override
    protected int getConfigColor() {
        return getResources().getColor(R.color.handwin_video_recorder_color);
    }

    @Override
    protected int getPreviewContainerColor() {
        return getResources().getColor(R.color.handwin_recorder_preview_bg);
    }

    @Override
    void startPreview(boolean startCamera) {
        BackgroundExecutor.execute(()->startPreview_(startCamera),"",0,"video_record",BackgroundExecutor.ThreadType.CALCULATION);
    }
    void startPreview_(boolean startCamera) {
        if (videoAudioRecorderView != null) {
            videoAudioRecorderView.prepareVideoRecorder(false);
        }
        super.startPreview(startCamera);
    }

    @Override
    void stopPreview() {
        BackgroundExecutor.execute(this::stopPreview_,"",0,"video_record", BackgroundExecutor.ThreadType.CALCULATION);
    }
    void stopPreview_() {
        super.stopPreview();
        if (videoAudioRecorderView != null) {
            videoAudioRecorderView.unprepareVideoRecorder();
        }
    }

    @Override
    protected int getVideoType() {
        return ShortVideoType.JUMP;
    }

    @Override
    protected int getAlertBgResId() {
        return isBurned ? R.drawable.handwin_shape_bg_burn_toast : R.drawable.handwin_shape_bg_video_record_toast;
    }

    @Override
    protected int getRecordButtonBgRes() {
        return R.drawable.handwin_video_recorder_inner_circle;
    }

    @Override
    public ColorStateList getTabColor() {
        return getResources().getColorStateList(R.color.handwin_selector_color_video_recorder_bottom_text);
    }

    @Override
    public void switchCamera(boolean isFrontCamera) {
        super.switchCamera(isFrontCamera);
        recordVideoView.setBack(!isFrontCamera);
    }
}
