package me.chatgame.uisdk.activity.view;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;

import me.chatgame.mobilecg.activity.view.BaseRelativeLayout;
import me.chatgame.mobilecg.activity.view.interfaces.IView;
import me.chatgame.mobilecg.call.CallState;
import me.chatgame.mobilecg.constant.BroadcastActions;
import me.chatgame.mobilecg.database.entity.DuduContact;
import me.chatgame.mobilecg.handler.EventSender;
import me.chatgame.mobilecg.handler.interfaces.IEventSender;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.views.CGImageView;
import me.chatgame.uisdk.R;

/**
 * Created by star on 16/7/23.
 */
public class VideoCallingView extends BaseRelativeLayout implements IView {
    IEventSender eventSender;
    View hangupBtn;
    private TextView nameTv;
    private CGImageView avatarView;

    public VideoCallingView(Context context) {
        super(context);
        init();
    }

    public VideoCallingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public VideoCallingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    private void init() {
        eventSender = EventSender.getInstance_();
        inflate(getContext(), R.layout.handwin_view_video_calling, this);
        nameTv = (TextView) findViewById(R.id.calling_name);
        avatarView = (CGImageView) findViewById(R.id.img_avatar);

        hangupBtn = findViewById(R.id.btn_hangup);
        hangupBtn.setOnClickListener(v -> {
            if (Utils.isFastDoubleClick("hangupClick")) {
                return;
            }
            Intent intent = new Intent(
                    BroadcastActions.LIVE_USER_HUNGUP);
            LocalBroadcastManager.getInstance(getContext()).sendBroadcast(
                    intent);
            CallState.getInstance().setStatus(CallState.Status.Idle);
            eventSender.sendUserHangupEvent();
            hangupBtn.setVisibility(View.GONE);
        });
    }

    public void setUserInfo(DuduContact contact) {
        if (contact == null) {
            nameTv.setText("");
            avatarView.load(null);
            return;
        }
        nameTv.setText(contact.getShowName());
        avatarView.load(contact.getAvatarUrl());
    }

    @Override
    public void show() {
        setVisibility(VISIBLE);
    }

    @Override
    public void hide() {
        setVisibility(GONE);
    }

    @Override
    public void showCameraStatus(boolean cameraOpen) {

    }

    @Override
    public void onStateChanged() {

    }

    @Override
    public void onPeerProximityChanged() {

    }

    @Override
    public void exit() {

    }

    @Override
    public void waitClose() {
        hangupBtn.setVisibility(GONE);
    }
}
