package me.chatgame.uisdk.activity.view;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.media.SoundPool;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.LinearInterpolator;
import android.view.animation.ScaleAnimation;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.List;

import me.chatgame.mobilecg.adapter.ViewPagerAdapter;
import me.chatgame.mobilecg.constant.Constant;
import me.chatgame.mobilecg.constant.RecorderMode;
import me.chatgame.mobilecg.constant.RecorderStatus;
import me.chatgame.mobilecg.database.entity.DuduContact;
import me.chatgame.mobilecg.handler.ConfigHandler;
import me.chatgame.mobilecg.handler.FileHandler;
import me.chatgame.mobilecg.handler.VoipAndroidManager;
import me.chatgame.mobilecg.handler.interfaces.IConfig;
import me.chatgame.mobilecg.handler.interfaces.IFileHandler;
import me.chatgame.mobilecg.listener.OnPageChangeListenerAdapter;
import me.chatgame.mobilecg.util.AnimUtils;
import me.chatgame.mobilecg.util.AudioUtils;
import me.chatgame.mobilecg.util.BackgroundExecutor;
import me.chatgame.mobilecg.util.DialogHandle;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.interfaces.IAnimUtils;
import me.chatgame.mobilecg.util.interfaces.IDialogHandle;
import me.chatgame.uisdk.R;

/**
 * Created by star on 15/12/7.
 */
public class VideoAudioRecorderView extends RelativeLayout implements ViewPager.OnPageChangeListener {

    ViewPager viewPager;
    RadioGroup recorderSelectionGroup;
    RelativeLayout videoAudioBar;
    RelativeLayout rlBurnAfterRead;
    ImageView ivBurnCheck;
    RelativeLayout rlInputSwitchBtn;

    ViewPagerAdapter adapterPager;
    AudioUtils audioUtils;
    VoipAndroidManager voipAndroidManager;
    IAnimUtils animUtils;
    IFileHandler fileHandler;
    IDialogHandle dialogHandle;
    IConfig config;


    private VideoRecorderView videoRecorderView;
    private AudioRecordView audioRecordView;
    private BaseRecorderView currentRecorderView;
    private BaseSendEditorView editView;
    private View alertView;
    private RelativeLayout chatView;

    private boolean destroy = false;
    private boolean firstInit = true;
    private int currentTab = -1;
    private boolean isShowingTip = false;
    private LayoutInflater layoutInflater;
    private Resources resources;
    private SoundPool soundPool;
//    private int recordStartSoundId;
    private int recordSendSoundId;
    private boolean isBurned = false;
    private int tabConfigHashcode;
    private RecorderMode recorderMode = RecorderMode.NORMAL;
    private int recorderViewH;
    private SparseArray<BaseRecorderView> viewMap = new SparseArray<>();
    private SparseArray<RadioButton> radioButtonMap = new SparseArray<>();
    private List<Integer> configTabList = new ArrayList<>();
    private boolean videoRecorderPrepared = false;
    private int tabGroupInitOffset;
	private DuduContact contact;

    private boolean alreadyInflated_ = false;

    public VideoAudioRecorderView(Context context) {
        super(context);
    }

    public VideoAudioRecorderView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public static VideoAudioRecorderView build(Context context) {
        VideoAudioRecorderView instance = new VideoAudioRecorderView(context);
        instance.onFinishInflate();
        return instance;
    }

    /**
     * The mAlreadyInflated_ hack is needed because of an Android bug
     * which leads to infinite calls of onFinishInflate()
     * when inflating a layout with a parent and using
     * the <merge /> tag.
     *
     */
    @Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_view_video_audio_recorder, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }


    public static VideoAudioRecorderView build(Context context, AttributeSet attrs) {
        VideoAudioRecorderView instance = new VideoAudioRecorderView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        rlBurnAfterRead = ((RelativeLayout) hasViews.findViewById(R.id.rl_burn_after_read));
        viewPager = ((ViewPager) hasViews.findViewById(R.id.id_video_audio_recorder_viewpager));
        rlInputSwitchBtn = ((RelativeLayout) hasViews.findViewById(R.id.id_input_switch_btn));
        videoAudioBar = ((RelativeLayout) hasViews.findViewById(R.id.id_video_audio_recorder_bar));
        recorderSelectionGroup = ((RadioGroup) hasViews.findViewById(R.id.id_recorder_selection_group));
        ivBurnCheck = ((ImageView) hasViews.findViewById(R.id.iv_burn_check));
        if (rlBurnAfterRead!= null) {
            rlBurnAfterRead.setOnClickListener(view -> checkBurnAfterRead());
        }
        if (rlInputSwitchBtn!= null) {
            rlInputSwitchBtn.setOnClickListener(view -> onInputSwitchClick());
        }
        afterViews();
    }
    
    void afterViews() {
        init();
        layoutInflater = LayoutInflater.from(getContext());
        resources = getResources();
        setBackgroundColor(Color.WHITE);
        recorderViewH = resources.getDimensionPixelSize(R.dimen.handwin_video_audio_recorder_view_h);

        rlBurnAfterRead.setVisibility(View.GONE);
        adapterPager.init();
        adapterPager.removeAll();

        viewPager.setAdapter(adapterPager);
        viewPager.setOnPageChangeListener(this);
        viewPager.setPageTransformer(false, (page, position) -> {
            BaseRecorderView recorderView = (BaseRecorderView) page;
            float alpha;
            float p = Math.abs(position * 3);
            p = p > 1 ? 1 : p;
            alpha = 1 - p;
            recorderView.setInfoTextAlpha(alpha);
        });
    }

    private void init() {
        config = ConfigHandler.getInstance_(getContext()) ;
        voipAndroidManager = VoipAndroidManager.getInstance_(getContext());
        fileHandler = FileHandler.getInstance_(getContext()) ;
        audioUtils = AudioUtils.getInstance_(getContext()) ;
        animUtils = AnimUtils.getInstance_(getContext());
        dialogHandle = DialogHandle.getInstance_() ;
        adapterPager = ViewPagerAdapter.getInstance_();
    }

    public void configTabs(int... tabs) {
        int hashcode = tabs.hashCode();
        if (tabConfigHashcode == hashcode) {
            return;
        }
        tabConfigHashcode = hashcode;

        videoRecorderView = null;
        audioRecordView = null;
        configTabList.clear();
        viewMap.clear();
        radioButtonMap.clear();
        recorderSelectionGroup.removeAllViews();
        adapterPager.removeAll();

        List<View> views = new ArrayList<>();
        int rbWidth = resources.getDimensionPixelOffset(R.dimen.handwin_recorder_bottom_text_width);
        for (int tab : tabs) {
            BaseRecorderView view = createViewByTab(tab);
            if (view != null) {
                configTabList.add(tab);

                view.setVideoAudioRecorderView(this);
                if (chatView != null) {
                    view.setChatView(chatView);
                }
                if (editView != null) {
                    view.setSendEditorView(editView);
                }
                viewMap.put(tab, view);
                views.add(view);

                RadioButton rb = createRadioButtonByTab(tab);
                RadioGroup.LayoutParams lp = new RadioGroup.LayoutParams(rbWidth, ViewGroup.LayoutParams.WRAP_CONTENT);
                recorderSelectionGroup.addView(rb, lp);
                radioButtonMap.put(tab, rb);
            }
        }
        viewPager.addOnPageChangeListener(new OnPageChangeListenerAdapter(){
            @Override
            public void onPageSelected(int page) {
                currentRecorderView=(BaseRecorderView)adapterPager.getView(page);
            }
        });
        adapterPager.removeAll();
        adapterPager.addAll(views);
    }

    private BaseRecorderView createViewByTab(int tab) {
        switch (tab) {
            case Constant.TAB_RECORD_VIDEO:
                videoRecorderView = VideoRecorderView.build(getContext());
                return videoRecorderView;
            case Constant.TAB_RECORD_AUDIO:
                audioRecordView = AudioRecordView.build(getContext());
                return audioRecordView;
        }
        return null;
    }

    private RadioButton createRadioButtonByTab(int tab) {
        RadioButton rb = (RadioButton) layoutInflater.inflate(R.layout.handwin_recorder_tab_radio_button, recorderSelectionGroup, false);
        switch (tab) {
            case Constant.TAB_RECORD_VIDEO:
                rb.setText(R.string.handwin_chatgame_video_record);
                rb.setTextColor(resources.getColorStateList(R.color.handwin_selector_color_video_recorder_bottom_text));
                rb.setOnCheckedChangeListener(onCheckedChangeListener);
                break;
            case Constant.TAB_RECORD_AUDIO:
                rb.setText(R.string.handwin_chatgame_audio_record);
                rb.setTextColor(resources.getColorStateList(R.color.handwin_selector_color_audio_recorder_bottom_text));
                rb.setOnCheckedChangeListener(onCheckedChangeListener);
                break;
        }
        return rb;
    }

    private CompoundButton.OnCheckedChangeListener onCheckedChangeListener = (buttonView, isChecked) -> {
        int pos = recorderSelectionGroup.indexOfChild(buttonView);
        int tab = configTabList.get(pos);
        if (currentTab == tab || !isChecked) {
            return;
        }
        viewPager.setCurrentItem(pos);
    };

    public void initSoundPool() {
        if (soundPool == null) {
            soundPool = new SoundPool(2, AudioManager.STREAM_MUSIC, 0);
//            recordStartSoundId = soundPool.load(getContext(), R.raw.record_start, 1);
            recordSendSoundId = soundPool.load(getContext(), R.raw.record_send, 1);
        }
    }

    public void releaseSoundPool() {
        if (soundPool != null) {
            soundPool.release();
            soundPool = null;
        }
    }

    public VideoRecorderView getVideoRecorderView() {
        return videoRecorderView;
    }

    public AudioRecordView getAudioRecordView() {
        return audioRecordView;
    }

    public void onInputSwitchClick() {
        if (Utils.isFastDoubleClick("onInputSwitchClick")) {
            return;
        }
        if ((videoRecorderView != null && videoRecorderView.isStatus(RecorderStatus.recording)) ||
                (audioRecordView != null && audioRecordView.isStatus(RecorderStatus.recording))) {
            return;
        }

        if (editView != null) {
            editView.showOrHideRecorderView(false, true);

        }
    }

    public boolean isRecording() {
        return (videoRecorderView != null && videoRecorderView.isStatus(RecorderStatus.recording))
                || (audioRecordView != null && audioRecordView.isStatus(RecorderStatus.recording));
    }

    public void setEditView(BaseSendEditorView editView) {
        this.editView = editView;
        for (int i = 0; i < viewMap.size(); i++) {
            BaseRecorderView view = viewMap.valueAt(i);
            view.setSendEditorView(editView);
        }
    }

    public void initialize(int preferRecordTab) {
        destroy = false;
        if(recorderMode == RecorderMode.NORMAL){
            setBurnState(config.isRecordingBurn());
        }
        if (configTabList.size() <= 0) {
            return;
        }
        initVideoRecorderView(preferRecordTab);
        resetBottomTextPos(preferRecordTab);
    }

    private void initVideoRecorderView(int preferRecordTab) {
        int lastTab = recorderMode != RecorderMode.NORMAL ? config.getLastShareRecordTab() : config.getLastRecordTab();
        if (videoRecorderView != null) {
            boolean show = preferRecordTab == Constant.TAB_RECORD_VIDEO
                    || (preferRecordTab == Constant.TAB_RECORD_CHECK_BY_LAST && lastTab == Constant.TAB_RECORD_VIDEO);
            videoRecorderView.initPreviewView(v -> onInputSwitchClick(), show);
        }
    }

    public void showPlayRlBurn(boolean show, boolean needAnimation) {
        if (recorderMode != RecorderMode.NORMAL) {
            rlBurnAfterRead.setVisibility(View.GONE);
            return;
        }
        if ((show && rlBurnAfterRead.getVisibility() == View.VISIBLE) || (!show && rlBurnAfterRead.getVisibility() != View.VISIBLE)) {
            return;
        }
        if (needAnimation) {
            animUtils.animFadeView(rlBurnAfterRead, show);
        } else {
            rlBurnAfterRead.setVisibility(show ? View.VISIBLE : View.GONE);
        }
    }

    public void enableBurnCheck(boolean enable) {
        if (recorderMode != RecorderMode.NORMAL) return;
        ivBurnCheck.setEnabled(enable);
        rlBurnAfterRead.setEnabled(enable);
    }

    void checkBurnAfterRead(){
        isBurned = !isBurned;
        changeCheckBurn(isBurned, true);
        config.setRecordingBurn(isBurned);
    }

    private void changeCheckBurn(boolean check, boolean showAlertTip) {
		ivBurnCheck.setImageResource(check
                ? R.drawable.handwin_selector_burn_check
                : R.drawable.handwin_selector_burn_uncheck);
        if(isBurned && showAlertTip){
            showRecordAlertTips(resources.getString(R.string.handwin_burn_after_read), resources.getDrawable(R.drawable.handwin_shape_bg_burn_toast), null);
        }
//        BaseRecorderView recorderView = viewMap.get(currentTab);
        for (int i = 0; i < viewMap.size(); i++) {
            BaseRecorderView view = viewMap.valueAt(i);
            if (view instanceof BaseVideoRecorderView) {
                ((BaseVideoRecorderView) view).setVideoRecorder(isBurned);
                int tab = viewMap.keyAt(i);
                setTabColor(isBurned ? getResources().getColorStateList(R.color.handwin_selector_color_burn_recorder_bottom_text) : view.getTabColor(),
                        tab);
            }
        }
    }

    private void setBurnState(boolean burn) {
        isBurned = burn;
        changeCheckBurn(burn, false);
    }

    public void stopVideoAudioPlay() {
        BackgroundExecutor.execute(this::stopVideoAudioPlay_, BackgroundExecutor.ThreadType.CALCULATION);
    }

    public void stopVideoAudioPlay_() {
        Utils.debug("[VideoAudioRecorderView] stopVideoAudioPlay");
        audioUtils.stopPlay(null);
        voipAndroidManager.stopAllPlayingVideoMessage();
    }

    public void restartVideoPlay() {
        BackgroundExecutor.execute(this::restartVideoPlay_, BackgroundExecutor.ThreadType.CALCULATION);
    }

    public void restartVideoPlay_() {
        Utils.debug("[VideoAudioRecorderView] restartVideoPlay");
        voipAndroidManager.restartAllPlayingVideoMessage();
    }

    void resetBottomTextPos(int preferRecordTab) {
        UiThreadExecutor.runTask(()->resetBottomTextPos_(preferRecordTab));
    }

    void resetBottomTextPos_(int preferRecordTab) {
        int lastTab = recorderMode != RecorderMode.NORMAL ? config.getLastShareRecordTab() : config.getLastRecordTab();
        Utils.debugFormat("VideoAudioRecordDebug recordMode %s, lastShareRecordTab %d, lastRecordTab %d", recorderMode, config.getLastShareRecordTab(), config.getLastRecordTab());
        int targetTab = lastTab;
        if (preferRecordTab != Constant.TAB_RECORD_CHECK_BY_LAST) {
            targetTab = preferRecordTab;
        }
        if (!configTabList.contains(targetTab)) {
            targetTab = configTabList.get(0);
        }
        currentTab = targetTab;
        updateRecordTab2Record();

        recorderSelectionGroup.setVisibility(View.VISIBLE);
        if (firstInit || targetTab != lastTab) {
            firstInit = false;
            int center = getWidth() / 2;
            int x = center - recorderSelectionGroup.getWidth() / (2 * configTabList.size());
            tabGroupInitOffset = x;
            recorderSelectionGroup.setTranslationX(getTranslationXByTab(targetTab));
            AlphaAnimation alphaAnimation = new AlphaAnimation(0, 1);
            alphaAnimation.setDuration(150);
            recorderSelectionGroup.startAnimation(alphaAnimation);
        }

        int pos = configTabList.indexOf(targetTab);
        if (pos != -1) {
            viewPager.setCurrentItem(pos, false);
        }
        RadioButton rb = radioButtonMap.get(targetTab);
        rb.setChecked(true);
        if (targetTab == Constant.TAB_RECORD_VIDEO) {
            showPlayRlBurn(true, false);
        } else {
            showPlayRlBurn(false, false);
        }
        BaseRecorderView recorderView = viewMap.get(targetTab);
        recorderView.setInfoTextAlpha(1.0f);

    }

    public void destroy(boolean stopCamera) {
        destroy = true;
        if (videoRecorderView != null) {
            videoRecorderView.destroyPreviewView(stopCamera);
        }
        if (!stopCamera) {
            unprepareVideoRecorder();
        }

        if (audioRecordView != null) {
            audioRecordView.destroy();
        }
    }

    public boolean isDestroy() {
        return destroy;
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
//        int currentPos = configTabList.indexOf(currentTab);
        int width = recorderSelectionGroup.getWidth() / configTabList.size();
        int moveOffsetPx = (int) (width * (position + positionOffset));
//        Utils.debugFormat("onPageScrolled - width: %d moveOffsetPx: %d position: %d positionOffset: %f currentPos: %d", width, moveOffsetPx, position, positionOffset, currentPos);
        if (moveOffsetPx > 0) {
            recorderSelectionGroup.setTranslationX(tabGroupInitOffset - moveOffsetPx);
        }
    }

    @Override
    public void onPageSelected(int position) {
//        Utils.debugFormat("[VideoAudioPagerView] onPageSelected pos: %d", position);

        int previousTab = currentTab;
        int currentPos = configTabList.indexOf(currentTab);
        if (currentPos == position) {
            return;
        }
        currentTab = configTabList.get(position);
        RadioButton rb = radioButtonMap.get(currentTab);
        rb.setChecked(true);
        updateRecordTab2Record();
        recorderSelectionGroup.setTranslationX(getTranslationXByTab(currentTab));
        BaseRecorderView recorderView = viewMap.get(currentTab);
        recorderView.setInfoTextAlpha(1.0f);
        switch (currentTab) {
            case Constant.TAB_RECORD_VIDEO:
                showPlayRlBurn(true, true);
                videoRecorderView.initPreviewView(v -> onInputSwitchClick(), true);
                delayToResumeVideoRecorderView(true);
                stopVideoAudioPlay();
                break;
            case Constant.TAB_RECORD_AUDIO:
                showPlayRlBurn(false, true);
                if (previousTab == Constant.TAB_RECORD_VIDEO) {
                    delayToPauseVideoPreviewView(true);
                }
                break;
        }
    }

    private void updateRecordTab2Record() {
        if (recorderMode != RecorderMode.NORMAL) {
            config.setLastShareRecordTab(currentTab);
        } else {
            config.setLastRecordTab(currentTab);
        }
    }

    private float getTranslationXByTab(int tab) {
        if (configTabList.size() == 0) {
            return tabGroupInitOffset;
        }
        int currPos = configTabList.indexOf(tab);
        if (currPos < 0) {
            return tabGroupInitOffset;
        }
        return (float) (tabGroupInitOffset - recorderSelectionGroup.getWidth() * currPos / configTabList.size());
    }

    void delayToResumeVideoRecorderView(boolean startCamera) {
        UiThreadExecutor.runTask(()->delayToResumeVideoRecorderView_(startCamera),150);
    }
    void delayToResumeVideoRecorderView_(boolean startCamera) {
        if (destroy) return;
        if (videoRecorderView != null) {
            videoRecorderView.resumePreview(startCamera, false);
        }
    }

    void delayToPauseVideoPreviewView(boolean stopCamera) {
        UiThreadExecutor.runTask(()->delayToPauseVideoPreviewView_(stopCamera),150);
    }
    void delayToPauseVideoPreviewView_(boolean stopCamera) {
        if (videoRecorderView != null) {
            videoRecorderView.pausePreview(stopCamera);
        }
    }

    @Override
    public void onPageScrollStateChanged(int state) {
//        Utils.debugFormat("[VideoAudioPagerView] - onPageScrollStateChanged - state: %d", state);
    }

    public void enableViewPagerTouch() {
        viewPager.setOnTouchListener(null);
        recorderSelectionGroup.setVisibility(View.VISIBLE);
    }

    public void disableViewPagerTouch() {
        viewPager.setOnTouchListener((v, event) -> true);
        recorderSelectionGroup.setVisibility(View.INVISIBLE);
    }

    /**
     * 显示录音异常提示
     * @param tips
     */
    public void showRecordAlertTips(String tips){
        showRecordAlertTips(tips, resources.getDrawable(R.drawable.handwin_shape_bg_toast), resources.getDrawable(R.drawable.handwin_ic_toast_img));
    }

    public void showRecordAlertTips(String tips, int bgResId) {
        showRecordAlertTips(tips, bgResId, R.drawable.handwin_ic_toast_img);
    }


    public void showRecordAlertTips(String tips, int bgResId, int iconResId) {
        showRecordAlertTips(tips, bgResId != 0 ? resources.getDrawable(bgResId) : null, iconResId != 0 ? resources.getDrawable(iconResId) : null);
    }
    public void showRecordAlertTips(String tips, Drawable backgroundDrwable, Drawable leftIconDrawble){
        UiThreadExecutor.runTask(()->showRecordAlertTips_(tips, backgroundDrwable, leftIconDrawble));
    }
    public void showRecordAlertTips_(String tips, Drawable backgroundDrwable, Drawable leftIconDrawble){
        if (isShowingTip || videoAudioBar == null) {
            return;
        }
        isShowingTip = true;
        if (null == alertView) {
            alertView = layoutInflater.inflate(R.layout.handwin_layout_toast_alert,
                    null, false);
        }
        ImageView leftIcon = (ImageView)alertView.findViewById(R.id.img_tips);
        if (leftIconDrawble == null) {
            leftIcon.setVisibility(View.GONE);
        }
        else {
            leftIcon.setVisibility(View.VISIBLE);
            leftIcon.setBackgroundDrawable(leftIconDrawble);
        }
        alertView.setBackgroundDrawable(backgroundDrwable);
        TextView txt = (TextView) alertView.findViewById(R.id.txt_toast);
        txt.setText(tips);
        txt.setEllipsize(TextUtils.TruncateAt.END);
        int height = resources.getDimensionPixelSize(
                R.dimen.handwin_chat_voice_toast_out_h);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, height);
        lp.addRule(RelativeLayout.CENTER_IN_PARENT);
        int audioH = resources.getDimensionPixelSize(
                R.dimen.handwin_chat_face_out_h);
        int margin = resources.getDimensionPixelSize(
                R.dimen.handwin_chat_record_tip_b);
        lp.bottomMargin = (audioH + margin);
        if (alertView.getParent() != null && alertView.getParent() instanceof ViewGroup){
            ((ViewGroup)alertView.getParent()).removeView(alertView);
        }
        videoAudioBar.addView(alertView, lp);
        showOrHideRecordTips(alertView, true);
        animBgOpaqueOfVideoAudioBar(true);
        delayToHideRecordTips();
    }

    void delayToHideRecordTips() {
        UiThreadExecutor.runTask(this::delayToHideRecordTips_, 1500);
    }

    void delayToHideRecordTips_() {
        if (null == alertView || videoAudioBar == null) {
            return;
        }
        animBgOpaqueOfVideoAudioBar(false);
        showOrHideRecordTips(alertView, false);
        videoAudioBar.removeView(alertView);
        isShowingTip = false;
    }

    private void animBgOpaqueOfVideoAudioBar(boolean opaque) {
        int aS = opaque ? 0 : 0xff;
        int aE = opaque ? 0xff : 0;

        ValueAnimator valueAnimator = ValueAnimator.ofInt(aS, aE);
        valueAnimator.addUpdateListener(animation -> {
			try {
				int alpha = Integer.parseInt(String.valueOf(animation.getAnimatedValue()));
				int bgColor = (alpha << 24) | 0xffffff;
				videoAudioBar.setBackgroundColor(bgColor);
			} catch (Exception e) {
				e.printStackTrace();
			}
		});
//        valueAnimator.addListener(new AnimatorListenerAdapter() {
//			@Override
//			public void onAnimationEnd(Animator animation) {
////                videoAudioBar.setBackgroundColor(opaque ? Color.WHITE : Color.TRANSPARENT);
//			}
//		});
        valueAnimator.setDuration(200);
        valueAnimator.start();
    }

    private void showOrHideRecordTips(View view, boolean show) {
        float alphaS = show ? 0.0f : 1.0f;
        float alphaE = show ? 1.0f : 0f;
        float scaleS = show ? 0.7f : 1f;
        float scaleE = show ? 1.0f : 0.7f;
        long time = 200;

        view.setVisibility(show ? View.VISIBLE : View.GONE);

        AnimationSet set = new AnimationSet(true);
        set.setInterpolator(new LinearInterpolator());
        set.setDuration(time);

        AlphaAnimation alphaAnimation = new AlphaAnimation(alphaS, alphaE);
        ScaleAnimation scaleAnimation = new ScaleAnimation(scaleS, scaleE, scaleS, scaleE,
                Animation.RELATIVE_TO_SELF, 0.5f, Animation.RELATIVE_TO_SELF, 0.5f);
        set.addAnimation(alphaAnimation);
        set.addAnimation(scaleAnimation);
        view.startAnimation(set);
    }

    public void onResume() {
        BaseRecorderView view = viewMap.get(currentTab);
        if (view != null) {
            view.onResume();
        }
    }

    public void onPause() {
        BaseRecorderView view = viewMap.get(currentTab);
        if (view != null) {
            view.onPause();
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        initSoundPool();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        releaseSoundPool();
    }


    public void playRecordSendSound() {
        BackgroundExecutor.execute(this::playRecordSendSound_, BackgroundExecutor.ThreadType.CALCULATION);
    }
    public void playRecordSendSound_() {
        if (soundPool != null) {
            soundPool.play(recordSendSoundId, 0.5f, 0.5f, 1, 0, 1);
        }
    }

    public boolean isBurned() {
        return isBurned;
    }


    public void setChatView(RelativeLayout chatView) {
        this.chatView = chatView;
        if (videoRecorderView != null) {
            videoRecorderView.setChatView(chatView);
        }
        if (audioRecordView != null) {
            audioRecordView.setChatView(chatView);
        }
    }

    public boolean isShowingPreview() {
        BaseRecorderView view = viewMap.get(currentTab);
        if (view instanceof BaseVideoRecorderView) {
            return ((BaseVideoRecorderView) view).isPreviewShow();
        }
        return false;
    }

    public void hidePreviewView() {
        BaseRecorderView view = viewMap.get(currentTab);
        if (view instanceof BaseVideoRecorderView) {
            ((BaseVideoRecorderView) view).hidePreviewView(false);
        }
    }

    public void setRecorderMode(RecorderMode recorderMode) {
        this.recorderMode = recorderMode;
        if (recorderMode != RecorderMode.NORMAL && rlBurnAfterRead.getVisibility() == View.VISIBLE) {
            rlBurnAfterRead.setVisibility(View.GONE);
        }
    }

    public RecorderMode getRecorderMode() {
        return recorderMode;
    }

    public void setImgButtonVisiabe(boolean show){
        if (recorderMode == RecorderMode.NORMAL) {
            boolean showBurn = show || isBurned;
            if (currentTab == Constant.TAB_RECORD_VIDEO) {
                rlBurnAfterRead.setVisibility(showBurn ? View.VISIBLE : View.GONE);
            }
        }
        rlInputSwitchBtn.setVisibility(show ? View.VISIBLE : View.GONE);
    }

    public synchronized void prepareVideoRecorder(boolean faceAvatar) {
        if (videoRecorderPrepared) {
            return;
        }
        Utils.debugFormat("[VideoAudioRecorderView] prepareVideoRecorder faceAvatar: %s", faceAvatar);
        if (faceAvatar) {
            if (!TextUtils.isEmpty(config.getLastFaceAvatarPath())) {
                int ret = voipAndroidManager.prepareRecordingVideoMessage(faceAvatar, fileHandler.getFaceFileDirByType(IFileHandler.FaceDir.MODEL), config.getLastFaceAvatarPath());
                if (ret == 0) {
                    videoRecorderPrepared = true;
                }
            }
        } else {
            voipAndroidManager.prepareRecordingVideoMessage(faceAvatar, "", "");
            videoRecorderPrepared = true;
        }
        if(isDestroy()){
            unprepareVideoRecorder();
        }
    }

    public synchronized void unprepareVideoRecorder() {
        if (videoRecorderPrepared) {
            Utils.debug("[VideoAudioRecorderView] unprepareVideoRecorder");
            videoRecorderPrepared = false;
            voipAndroidManager.unprepareRecordingVideoMessage();
        }
    }

    public synchronized boolean isVideoRecorderPrepared() {
        return videoRecorderPrepared;
    }

    public void setTabColor(ColorStateList color, int tab) {
        RadioButton button = radioButtonMap.get(tab);
        button.setTextColor(color);
    }
    
    public void cancel() {
        if(currentRecorderView != null && isRecording()){
            currentRecorderView.setRecorderStatus(RecorderStatus.idle);
        }
    }
}
