package me.chatgame.uisdk.activity.view;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.Paint;
import android.support.v7.widget.RecyclerView;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;
import java.util.List;

import me.chatgame.mobilecg.actions.ContactsActions;
import me.chatgame.mobilecg.actions.interfaces.IContactsActions;
import me.chatgame.mobilecg.activity.view.interfaces.IChatEvent;
import me.chatgame.mobilecg.activity.view.interfaces.ILiveActivity;
import me.chatgame.mobilecg.activity.view.interfaces.KeyboardStateListener;
import me.chatgame.mobilecg.adapter.SingleChatListAdapter;
import me.chatgame.mobilecg.call.CallService;
import me.chatgame.mobilecg.call.CallState;
import me.chatgame.mobilecg.constant.Constant;
import me.chatgame.mobilecg.constant.MessageType;
import me.chatgame.mobilecg.constant.MsgStatus;
import me.chatgame.mobilecg.constant.RecorderMode;
import me.chatgame.mobilecg.constant.SceneConstant;
import me.chatgame.mobilecg.database.entity.BaseContact;
import me.chatgame.mobilecg.database.entity.DuduContact;
import me.chatgame.mobilecg.database.entity.DuduMessage;
import me.chatgame.mobilecg.events.CallStartEvent;
import me.chatgame.mobilecg.events.ChatPreviewSurfaceChangedEvent;
import me.chatgame.mobilecg.events.HideKeyboardAndEmojiPanelEvent;
import me.chatgame.mobilecg.events.ShowTextSendButtonEvent;
import me.chatgame.mobilecg.net.protocol.VideoSceneInfo;
import me.chatgame.mobilecg.sdk.CGSDKClientImpl;
import me.chatgame.mobilecg.util.BackgroundExecutor;
import me.chatgame.mobilecg.util.ContactCacheManager;
import me.chatgame.mobilecg.util.ReflectInterfaceProxy;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.interfaces.IContactCacheManager;
import me.chatgame.mobilecg.viewinterfaces.IContactInfoView;
import me.chatgame.mobilecg.views.IconFontTextView;
import me.chatgame.mobilecg.views.refresh.PullToRefreshRecyclerView;
import me.chatgame.uisdk.R;

/**
 * Created by star on 15/11/5.
 */
public class SingleChatView extends BaseChatView<SingleChatListAdapter, DuduContact>
        implements KeyboardStateListener, IContactInfoView {


    TextView txtTitle;
    ImageView imgEmpty;
    TextView txtPlaceHolder;
    RelativeLayout rlTitleAvatar;
    IconFontTextView iconVideoCall;

    IContactsActions contactsAction;
    IContactCacheManager contactCacheManager;


    private SingleChatSendEditorView editorView;
    private ProgressDialog pDialog;
    private DuduContact contact;
    private RecorderMode recorderMode = RecorderMode.NORMAL;


    private boolean alreadyInflated_ = false;

    public SingleChatView(Context context) {
        super(context);
        init_();
    }

    public SingleChatView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init_();
    }

    public SingleChatView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init_();
    }

    public static SingleChatView build(Context context) {
        SingleChatView instance = new SingleChatView(context);
        instance.onFinishInflate();
        return instance;
    }

    /**
     * The mAlreadyInflated_ hack is needed because of an Android bug
     * which leads to infinite calls of onFinishInflate()
     * when inflating a layout with a parent and using
     * the <merge /> tag.
     *
     */
    @Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_view_single_chat, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    void init_() {
        init();

        liveActivity = ((ILiveActivity) ReflectInterfaceProxy.newInstance(ILiveActivity.class, getContext()));
        chatEvent = ((IChatEvent) ReflectInterfaceProxy.newInstance(IChatEvent.class, getContext()));
    }

    public static SingleChatView build(Context context, AttributeSet attrs) {
        SingleChatView instance = new SingleChatView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static SingleChatView build(Context context, AttributeSet attrs, int defStyleAttr) {
        SingleChatView instance = new SingleChatView(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        listDatas = ((PullToRefreshRecyclerView) hasViews.findViewById(R.id.list_datas));
        txtIconBack = ((TextView) hasViews.findViewById(R.id.txt_icon_back));
        ivChatLoading = ((ProgressBar) hasViews.findViewById(R.id.iv_chat_loading));
        newTipLayout = hasViews.findViewById(R.id.linear_new_tip);
        tvNewMessage = ((TextView) hasViews.findViewById(R.id.tv_new_message));
        iconVideoCall = ((IconFontTextView) hasViews.findViewById(R.id.txt_icon_video_call));
        imgEmpty = ((ImageView) hasViews.findViewById(R.id.img_empty));
        rlTitleAvatar = ((RelativeLayout) hasViews.findViewById(R.id.relative_title_avatar));
        txtPlaceHolder = ((TextView) hasViews.findViewById(R.id.txt_place_holder));
        txtTitle = ((TextView) hasViews.findViewById(R.id.txt_title_single));
        if (txtTitle != null) {
            txtTitle.setOnClickListener(v -> onTitleClick());
        }

        if (tvNewMessage!= null) {
            tvNewMessage.setOnClickListener(view -> SingleChatView.this.newMessageTipsClicked()
            );
        }
        if (txtIconBack!= null) {
            txtIconBack.setOnClickListener(view -> SingleChatView.this.titleBackClick()
            );
        }
        if (newTipLayout!= null) {
            newTipLayout.setOnClickListener(view -> SingleChatView.this.newMessageTipClick()
            );
        }
        if (iconVideoCall!= null) {
            iconVideoCall.setOnClickListener(view -> SingleChatView.this.iconVideoCallClick()
            );
        }
        afterViews();
    }
    
    @Override
    protected void afterViews() {
        contactsAction = ContactsActions.getInstance_(getContext(), this);
        contactCacheManager = ContactCacheManager.getInstance_(getContext()) ;


        setBaseImgEmpty(imgEmpty);
        // 设置顶部字体为斜体
        TextPaint tp = txtTitle.getPaint();
        tp.setTextSkewX(-0.25f);

        super.afterViews();
    }

    private void onTitleClick() {
        CGSDKClientImpl.getInternalInstance().notifyChatViewTitleClick(false, getConversationId(), getContext());
    }

    @Override
    protected BaseSendEditorView createSendEditorView() {
        editorView = SingleChatSendEditorView.build(getContext());
        RelativeLayout.LayoutParams lp = new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        lp.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        editorView.setId(R.id.chat_send_editor);
        addView(editorView, lp);
        return editorView;
    }

    @Override
    protected SingleChatListAdapter createAdapter() {
        return SingleChatListAdapter.getInstance_(getContext());
    }

    @Override
    protected void initChatListAdapter(RecyclerView recyclerView, SingleChatListAdapter adapter) {
        adapter.init(recyclerView);
        adapter.setChatNow("");
        adapter.removeAll();
        adapter.setChatListEventListener(this);
    }

    public void setContact(DuduContact contact) {
        txtTitle.setText(faceUtils.getFaceTextImage("", txtTitle));
        // 避免『我的分享』界面 当前contact的更新
		if (this.contact != null && this.contact.getDuduUid().equals(configHandler.getUid()) && contact != null && contact.getDuduUid().equals(configHandler.getUid())) {
			return;
		}

		this.contact = contact;
        if (editorView != null) {
            editorView.setContact(contact);
        }
        adapter.setChatEntity(contact);
        fillUserInfo();
        if (contact == null) {
            return;
        }

        messageCache.setLastSeq((int) contact.getMessageSeqRec());
        if (contact.isNeedUpdate()) {
            Utils.debug("Contact need update in Chat " + contact.getDuduUid());
            contactsAction.getRemoteUserInfo(contact.getDuduUid());
        }
        if (contact.getDuduUid().equals(unReadMessageUser)) {
            tvNewMessage.setVisibility(View.GONE);
        }
    }

    /**
     * 更新联系人信息
     *
     * @param uid
     */
    public void updateContact(String uid) {
        if (contact == null) {
            return;
        }
		// 避免『我的分享』界面 当前contact的更新
        if (contact.getDuduUid().equals(uid) && !configHandler.getUid().equals(uid)) {
            contactsAction.getUserInfo(uid);
        }
        Utils.debug("updateContact : " + uid);
    }

    public void getUserInfoResultResp(String uid, DuduContact contact) {
        UiThreadExecutor.runTask(()->getUserInfoResultResp_(uid, contact));
    }

    @Override
    public void updateContactInfoResp(String uid, DuduContact contact) {
    }

    public void getUserInfoResultResp_(String uid, DuduContact contact) {

        if (null == contact) {
            return;
        }

        if (!uid.equals(contact.getDuduUid())) {
            return;
        }

		// 『我的分享』界面 不更新contact
		if (uid.equals(configHandler.getUid())) {
			return;
		}
		
		this.contact = contact;

        adapter.setChatEntity(contact);
        messageCache.setLastSeq((int) contact.getMessageSeqRec());

        fillUserInfo();

    }

	private void fillUserInfo() {
		txtTitle.setText(contact != null ? faceUtils.getFaceTextImage(contact.getShowName(), txtTitle) : "");
		if (contact != null && !contact.getDuduUid().equals(configHandler.getUid())) {
			Utils.debug("fillUserInfo : " + contact.toString());
		}
        if(contact==null) return;
        if (contact.getDuduUid().equals(Constant.FRIEND_INVITE_ID)){
            iconVideoCall.setVisibility(View.INVISIBLE);
            enableTxtTitleUnderline(false);
        }else {
            iconVideoCall.setVisibility(View.VISIBLE);
            enableTxtTitleUnderline(true);
        }
	}

    private void enableTxtTitleUnderline(boolean enable) {
        if (enable) {
            txtTitle.setPaintFlags(txtTitle.getPaintFlags() | Paint.UNDERLINE_TEXT_FLAG);
        } else {
            txtTitle.setPaintFlags((txtTitle.getPaintFlags() | Paint.UNDERLINE_TEXT_FLAG) - Paint.UNDERLINE_TEXT_FLAG);
        }
    }

    @Override
    public void onEnter(DuduContact contact) {
        super.onEnter(contact);

        setContact(contact);
		initViews(contact);

		notifyUtils.cancelUserNotifications(contact.getDuduUid());
        showChatList();
        if (!app.isChating()) {
            show(true);
            playEnterAnimation();
        } else {
            show(false);
        }
        voipAndroidManager.clearAllPlayingVideo();
        setAdapter();
        setReady(true);

        if (tempFirstLoadedMessages != null) {
//            Utils.debug("cgtest set single chat tempFirstLoadedMessages");
            showChatDatas(false, tempFirstLoadedMessages);
            tempFirstLoadedMessages = null;
        }

        if (isNeedOpenRecorderViewOnEnter()) {
            if (recorderMode == RecorderMode.NORMAL) {
                showRecorderView(Constant.TAB_RECORD_VIDEO);
            } else {
                showRecorderView(configHandler.getLastShareRecordTab());
            }
        } else {
            restartAllVideoPlaying();
        }
        setNeedOpenRecorderViewOnEnter(false);
        eventSender.register(this);
    }

	private void initViews(DuduContact contact) {
        recorderMode = RecorderMode.NORMAL;
        boolean isVideoOnly = false;
        if (isMyself(contact)) {
            recorderMode = RecorderMode.SHARE;
            isVideoOnly = true;
        } else if (isLocal(contact)) {
            recorderMode = RecorderMode.LOCAL_CONTACT;
            isVideoOnly = true;
        }
		editorView.setRecorderMode(recorderMode);
//		editorView.showMyShareVideoRecordBar(isVideoOnly);

		rlTitleAvatar.setEnabled(!isMyself(contact));
	}
	private boolean isMyself(DuduContact contact) {
        return contact.getDuduUid().equals(configHandler.getUid());
	}
	private boolean isLocal(DuduContact contact) {
		return contact.isLocal();
	}

    @Override
    public void saveUnSendMessage(boolean clearEditText) {
        SingleChatSendEditorView singleChatSendEditorView = editorView;
        if (singleChatSendEditorView == null) return;
        DuduContact duduContact = contact;
        EditText editChat = singleChatSendEditorView.getEditText();
        if (editChat == null || duduContact == null) {
            return;
        }
        String message = editChat.getText().toString();
        // 保存未发送的文本内容
        asyncSaveUnsentMessage(duduContact.getDuduUid(), message);
        if (clearEditText) {
            // 重置输入框
            editChat.setText("");
        }
    }

    @Override
    protected void loadData(boolean more, long minMessageId, int size) {
        DuduContact duduContact = contact;
        if (duduContact != null) {
            loadData(duduContact.getDuduUid(), more, minMessageId, size);
        } else {
            showChatDatas(more, null);
        }
    }

    @Override
    public void refreshOfflineData() {
        if (this.contact != null) {
            refreshData(contact.getDuduUid());
        }
    }

    /**
     * 过滤消息
     *
     * @param datas
     * @return
     */
    protected List<DuduMessage> filterMessages(List<DuduMessage> datas) {
        List<DuduMessage> temps = new ArrayList<DuduMessage>();
        for (DuduMessage data : datas) {
            // 游戏指令消息
            if (isHiddenMessage(data)) {
                continue;
            }
            temps.add(data);
        }
        return temps;
    }

    /**
     * 是否是需要隐藏的消息<br>
     * (俘虏捕获释放等)
     *
     * @param data
     * @return
     */
    private boolean isHiddenMessage(DuduMessage data) {

        return false;
    }

    @Override
    public void batchSend(DuduMessage message, BaseContact[] baseContacts) {
        duduMessageAction.batchSendMessage(baseContacts, message,
                contact != null ? contact.getDuduUid() : "");
    }

    @Override
    protected boolean checkAddNewMessageCondition(DuduMessage[] datas) {
        return !(datas == null || datas.length == 0 || contact == null
                || (null == datas[0]) || isHiddenMessage(datas[0]));
    }

    protected void iconVideoCallClick(){
        if (null == contact){
            return;
        }

        if (Utils.isFastDoubleClick("chat.call")) {
            return;
        }

        if (editorView != null){
//            editorView.showTextSendButton(true);
            liveActivity.startCall(contact);
        }
    }

    public void switch2chat() {
        if (editorView != null) {
            editorView.setVideoChatMode(true);
        }
        ViewGroup.LayoutParams layoutParams = txtPlaceHolder.getLayoutParams();
        layoutParams.height = LiveChatContainerView.getVideoPreviewHeight(getContext(), configHandler.getScreenWidth());
        txtPlaceHolder.setLayoutParams(layoutParams);
        initSlideInfo();
    }

    private void initSlideInfo() {
        VideoSceneInfo videoSceneInfo = CallState.getInstance().getVideoSceneInfo();
        Utils.debugFormat("SlideDebugTest initSlideInfo " + videoSceneInfo);
        if (videoSceneInfo != null) {
            this.setIsSlideSceneMode(true);
            this.setVideoSceneInfo(videoSceneInfo);
            showPptOngoingProgress(true);
            showPresentationView(true);
        } else {
            resetSlideInfo();
        }
    }

    public void switch2Presentation(VideoSceneInfo videoSceneInfo) {
        Utils.debug("CallSceneDebug switch2Presentation");
        if (editorView != null) {
            editorView.setVideoChatMode(true);
        }
        ViewGroup.LayoutParams layoutParams = txtPlaceHolder.getLayoutParams();
        layoutParams.height = 0;
        txtPlaceHolder.setLayoutParams(layoutParams);
        setVideoSceneInfo(videoSceneInfo);
        showImageShareStartTips();
        this.showPresentationView(true);
    }

    private void showImageShareStartTips() {
        DuduContact peerContact = contactCacheManager.getDuduContact(CallState.getInstance().getPeerId());
        if (peerContact != null) {
            app.toast(String.format(app.getString(R.string.handwin_ppt_start_tip), peerContact.getShowName()));
        }
    }

    public void hangupLive(boolean needClosePresentationView) {
		resetSlideInfo();
		showPptOngoingProgress(false);
        if (needClosePresentationView) {
            showPresentationView(false);
        }
    }

    @Override
    protected void doExit() {
        super.doExit();
        if (contact != null) {
            cleanUnreadAndRefreshConversation(contact.getDuduUid());
        }
        editorView = null;
        contact = null;
    }

    @Override
    protected EditText getEditText() {
        if(editorView==null ) return null;
        return editorView.getEditText();
    }

    @Override
    public boolean couldBack() {
        return CallState.getInstance().isStatus(CallState.Status.Idle) || CallService.getInstance().isVideoFloat();
    }

    public boolean switchToEditMode() {
        if (editorView != null) {
            Utils.autoCloseKeyboard((Activity) getContext(), editorView);
            if (editorView.isFaceShow()) {
                editorView.showOrHideFacesView(false, false);
            }
            if (editorView.isFunctionMenuViewShow()) {
                editorView.showOrHideFunctionMenuView(false, false);
            }
            if (editorView.isRecorderViewShow()) {
                return !(editorView.isShowingVideoPreview() || editorView.isRecording());
            }
            editorView.setVideoChatMode(false);
        }
        return true;
    }

    public void switch2Full() {
        if (editorView != null){
            editorView.setVideoChatMode(CallState.getInstance().isStatus(CallState.Status.ChatLiving)
                    || CallState.getInstance().isStatus(CallState.Status.Living));
        }
        ViewGroup.LayoutParams layoutParams=txtPlaceHolder.getLayoutParams();
        layoutParams.height=0;
        txtPlaceHolder.setLayoutParams(layoutParams);
    }

    public void onChatVideoTrans(int translantionY) {
        ViewGroup.LayoutParams layoutParams=txtPlaceHolder.getLayoutParams();
        layoutParams.height=chatPreviewHeight+translantionY;
        txtPlaceHolder.setLayoutParams(layoutParams);
    }

    @Override
    public String getConversationId() {
        return contact != null ? contact.getDuduUid() : null;
    }

    @Override
    public DuduContact getChatEntity() {
        return contact;
    }

    @Override
    protected BaseChatPresentationView createChatPresentationView() {
        return SingleChatPresentationView.build(getContext());
    }

    @Override
    protected void doCreateSceneSuccess(VideoSceneInfo videoSceneInfo) {
        super.doCreateSceneSuccess(videoSceneInfo);
        CallState.getInstance().setVideoSceneInfo(videoSceneInfo);
    }

    @Override
    protected void doCreateCreateScene() {
        super.doCreateCreateScene();
        createSceneOnBackground();
    }

    void createSceneOnBackground() {
        BackgroundExecutor.execute(this::createSceneOnBackground_, BackgroundExecutor.ThreadType.CALCULATION);
    }

    void createSceneOnBackground_() {
        Utils.debugFormat("CallSceneDebug createSceneOnBackground roomId %s", CallState.getInstance().getRoomId());
        String roomId = CallState.getInstance().getRoomId();
        VideoSceneInfo videoSceneInfo = null;
        if (!TextUtils.isEmpty(roomId) && isLiving()) {
            videoSceneInfo = sceneActions.createNewScene(CallService.getInstance().getSceneRegion(), roomId, null, SceneConstant.SLIDE_SCENE);
        }
        processCreateSceneResult(videoSceneInfo);
    }

    @Override
    protected void handleSceneCreate(VideoSceneInfo videoSceneInfo) {
		super.handleSceneCreate(videoSceneInfo);
        if (videoSceneInfo == null) {
            return;
        }
        if (videoSceneInfo.getRoomId().equals(CallState.getInstance().getRoomId())) {
            this.setVideoSceneInfo(videoSceneInfo);
            CallState.getInstance().setVideoSceneInfo(videoSceneInfo);
            liveActivity.hideLivePreviewContainerView();
            showImageShareStartTips();
            showPresentationView(true);
        }
    }

    @Override
    protected void handleSceneEnd(VideoSceneInfo videoSceneInfo) {
        Utils.debug("CallSceneDebug handleSceneEnd");
        if (videoSceneInfo == null) {
            resetSlideInfo();
            return;
        }
        if (videoSceneInfo.getRoomId().equals(CallState.getInstance().getRoomId())) {
            super.handleSceneEnd(videoSceneInfo);
            Utils.debug("CallSceneDebug handleSceneEnd same room id " +
                    isLiving() + " " + isSlideSceneMode());
            if (isLiving() && isSlideSceneMode()) {
				resetSlideInfo();
                onExitPresentation();
                showPresentationView(false);
                Utils.debug("CallSceneDebug handleSceneEnd presentation is show");
            }
        }

        handleBackFromPresentation();
    }

    private void handleBackFromPresentation() {
        liveActivity.back2live();
    }

    private boolean isLiving() {
        return CallState.getInstance().isStatus(CallState.Status.Living) || CallState.getInstance().isStatus(CallState.Status.ChatLiving);
    }

    @Override
    public void onExitPresentation() {
        super.onExitPresentation();
        if (isPresentationViewShow()) {
            eventSender.sendExitSingleChatPresentationEvent();
        }

        handleBackFromPresentation();
    }

    @Override
    public void onClosePresentation() {
        super.onClosePresentation();
        stopSceneOnBackground();
        handleBackFromPresentation();
    }

    void stopSceneOnBackground() {
        BackgroundExecutor.execute(this::stopSceneOnBackground_, BackgroundExecutor.ThreadType.CALCULATION);
    }
    void stopSceneOnBackground_() {
        if (videoSceneInfo == null) {
            dialogHandle.closeProgressDialog();
            return;
        }

        // String region, String roomId, VideoSceneInfo videoSceneInfo, String groupId
        boolean ret = sceneActions.stopScene(CallService.getInstance().getSceneRegion(), CallState.getInstance().getRoomId(), videoSceneInfo, null);
        processStopSceneResult(ret);
    }

    void processStopSceneResult(boolean ret) {
        UiThreadExecutor.runTask(()->processStopSceneResult_(ret));
    }
    void processStopSceneResult_(boolean ret) {
        dialogHandle.closeProgressDialog();
        if (ret) {
            resetSlideInfo();
            showPptOngoingProgress(false);
        } else {
            app.toast(R.string.handwin_close_image_share_fail);
        }
        onExitPresentation();
        showPresentationView(false);
    }

    @Override
    protected void doShowPresentationView() {
        super.doShowPresentationView();
        eventSender.sendEnterSingleChatPresentationEvent();
    }

    @Override
    public void onEmojiPannelHide() {
        super.onEmojiPannelHide();
        onKeyboardOrEmojiPanelHide();
    }

    @Override
    public void onEmojiPannelShow() {
        super.onEmojiPannelShow();
        onKeyboardOrEmojiPanelShow(true);
    }

    @Override
    public void onFunctionMenuViewShow() {
        super.onFunctionMenuViewShow();
        onKeyboardOrEmojiPanelShow(true);
    }

    @Override
    public void onFunctionMenuViewHide() {
        super.onFunctionMenuViewHide();
        onKeyboardOrEmojiPanelHide();
    }

    private void onKeyboardOrEmojiPanelShow(boolean emojiPanel) {
        if(chatPreviewHeight==0){
            chatPreviewHeight=getWidth()*2/3;
        }
        if (CallState.getInstance().isStatus(CallState.Status.ChatLiving)||CallState.getInstance().isStatus(CallState.Status.Calling)) {
            int facePanelHeight = emojiPanel ? app
                    .getPxFromDp(R.dimen.handwin_chat_face_out_h) : 0;
            int leftHeight = this.getHeight()
                    - app.getPxFromDp(R.dimen.handwin_chat_min_height) - chatPreviewHeight- facePanelHeight;
            if (leftHeight > 0) {
                leftHeight = 0;
            }
            int translationY = 0 - app.getPxFromDp(R.dimen.handwin_chat_video_head_height)
                    + leftHeight;
            if(chatPreviewHeight<getWidth()*2/3){
                translationY=0-app.getPxFromDp(R.dimen.handwin_chat_min_height);
            }
            onChatVideoTrans(translationY);
            liveActivity.getLivePreviewContainer().handleLiveChatViewTranslationY(translationY);
        }
    }
    private int chatPreviewHeight=0;
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onChatPreviewSurfaceChanged(ChatPreviewSurfaceChangedEvent event){
        //对键盘超高的时候，视频大小被压缩的处理
        chatPreviewHeight=event.getHeight();
        if(editorView.isKeyboardShow()){
            onKeyboardShow();
        }else{
            onKeyboardHide();
        }

    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void showTextSendButton(ShowTextSendButtonEvent event){
        boolean show = event.isShow();
//        editorView.showTextSendButton(show);
    }

    private void onKeyboardOrEmojiPanelHide() {
        liveActivity.getLivePreviewContainer().handleLiveChatViewTranslationY(0);
        if (CallState.getInstance().isStatus(CallState.Status.ChatLiving)) {
            onChatVideoTrans(0);
        }
    }

    @Override
    public void onKeyboardShow() {
        super.onKeyboardShow();
        onKeyboardOrEmojiPanelShow(false);
    }

    @Override
    public void onKeyboardHide() {
        super.onKeyboardHide();
        onKeyboardOrEmojiPanelHide();
        if(emojiShow){
            onKeyboardOrEmojiPanelShow(true);
        }
    }

    @Override
    protected DuduMessage createLocalShareMessage() {
        String msgContent = getContext().getString(R.string.handwin_friends_invite_first_message);
        DuduMessage message =  new DuduMessage().setMsgType(MessageType.SYSTEM_NOTIFY)
                .setSendTime(System.currentTimeMillis())
                .setConversationId(Constant.FRIEND_INVITE_ID)
                .setMsgUUID(Utils.getUUID())
                .setSender(contact.getDuduUid())
                .setMsgStatus(MsgStatus.READED)
                .setNickname(contact.getDuduNickname()).setMsgRaw(msgContent)
                .setAvatarUrl(contact.getAvatarUrl());
        saveLocalShareMessage(message);
        return message;
    }

    void saveLocalShareMessage(DuduMessage message) {
        BackgroundExecutor.execute(()->saveLocalShareMessage_(message), BackgroundExecutor.ThreadType.IO);
    }
    void saveLocalShareMessage_(DuduMessage message) {
        dbHandler.addDuduMessage(message, contact.getSetting());
    }
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onCallStart(CallStartEvent event){
       editorView.showOrHideFacesView(false, false);
    }
    protected String getRoomId() {
        return CallState.getInstance().getRoomId();
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void hidekeyBoardEmojiPanel(HideKeyboardAndEmojiPanelEvent event){
        boolean hide = event.isHide();
        if (hide){
            Utils.autoCloseKeyboard((Activity) getContext(), this);
            if (null != editorView){
                editorView.showOrHideFacesView(false,false);
            }
        }
    }
}
