package me.chatgame.uisdk.activity.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;


import java.util.ArrayList;
import java.util.List;

import me.chatgame.mobilecg.activity.view.interfaces.IChatEvent;
import me.chatgame.mobilecg.activity.view.interfaces.ILiveActivity;
import me.chatgame.mobilecg.call.CallState;
import me.chatgame.mobilecg.constant.ChatType;
import me.chatgame.mobilecg.constant.Constant;
import me.chatgame.mobilecg.constant.RecorderMode;
import me.chatgame.mobilecg.database.entity.ConversationType;
import me.chatgame.mobilecg.database.entity.DuduContact;
import me.chatgame.mobilecg.database.entity.DuduMessage;
import me.chatgame.mobilecg.handler.EventSender;
import me.chatgame.mobilecg.handler.interfaces.IEventSender;
import me.chatgame.mobilecg.sdk.CGSDKClientImpl;
import me.chatgame.mobilecg.sdk.EmoticonHandler;
import me.chatgame.mobilecg.sdk.EmoticonHandler.GifEmotionData;
import me.chatgame.mobilecg.sdk.FunctionMenuHandler;
import me.chatgame.mobilecg.util.CallUtils;
import me.chatgame.mobilecg.util.DialogHandle;
import me.chatgame.mobilecg.util.NetworkUtils;
import me.chatgame.mobilecg.util.ReflectInterfaceProxy;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.interfaces.ICallUtils;
import me.chatgame.mobilecg.util.interfaces.IDialogHandle;
import me.chatgame.mobilecg.util.interfaces.INetwork;
import me.chatgame.mobilecg.views.IconFontTextView;
import me.chatgame.mobilecg.views.MonitoringEditText;
import me.chatgame.uisdk.R;
import me.chatgame.mobilecg.bean.FunctionMenuData;

/**
 * Created by star on 15/11/3.
 */
public class SingleChatSendEditorView extends BaseSendEditorView {

	MonitoringEditText editChat;    // edit field
	TextView btnChatSend;          // send msg button
//	TextView btnAudio;
    View btnFunctionMenu;
	TextView btnChatEmoji;         // emoji panel open button
	View editRegion;
	View functionRegion;

    ICallUtils callUtils;
	IDialogHandle dialogHandle;
    IChatEvent chatEvent;
	INetwork network;
    IEventSender eventSender;

	private DuduContact contact;

	// 保存当前DuduMessage
	private DuduMessage currentMessage;

    private boolean alreadyInflated_ = false;

    public SingleChatSendEditorView(Context context) {
        super(context);
        init_();
    }

    public SingleChatSendEditorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init_();
    }

    public SingleChatSendEditorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init_();
    }

    public static SingleChatSendEditorView build(Context context) {
        SingleChatSendEditorView instance = new SingleChatSendEditorView(context);
        instance.onFinishInflate();
        return instance;
    }

    /**
     * The mAlreadyInflated_ hack is needed because of an Android bug
     * which leads to infinite calls of onFinishInflate()
     * when inflating a layout with a parent and using
     * the <merge /> tag.
     *
     */
    @java.lang.Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_view_chat_send_editor, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    private void init_() {
        init();
        imm = ((InputMethodManager) getContext().getSystemService(Context.INPUT_METHOD_SERVICE));
        liveActivity = ((ILiveActivity) ReflectInterfaceProxy.newInstance(ILiveActivity.class, getContext()));
        chatEvent = ((IChatEvent) ReflectInterfaceProxy.newInstance(IChatEvent.class, getContext()));
    }

    public static SingleChatSendEditorView build(Context context, AttributeSet attrs) {
        SingleChatSendEditorView instance = new SingleChatSendEditorView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static SingleChatSendEditorView build(Context context, AttributeSet attrs, int defStyleAttr) {
        SingleChatSendEditorView instance = new SingleChatSendEditorView(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        startPptBtn = ((TextView) hasViews.findViewById(R.id.more_item_start_ppt));
//        btnChatImage = ((TextView) hasViews.findViewById(R.id.btn_chat_image));
        funcPptView = hasViews.findViewById(R.id.func_ppt);
        funcInputSwitchView = hasViews.findViewById(R.id.func_input_switch);
        functionRegion = hasViews.findViewById(R.id.id_editview_function_region);
//        btnAudio = ((TextView) hasViews.findViewById(R.id.btn_chat_audio));
        btnFunctionMenu = hasViews.findViewById(R.id.btn_function_menu);
        editChat = ((MonitoringEditText) hasViews.findViewById(R.id.edit_chat));
        btnChatEmoji = (TextView) hasViews.findViewById(R.id.btn_chat_emoji);
        btnChatSend = ((TextView) hasViews.findViewById(R.id.btn_chat_send));
        editRegion = hasViews.findViewById(R.id.id_edit_region);
        audioRecordBtn = (TextView) hasViews.findViewById(R.id.btn_audio_record) ;
        audioOrInputBtn = (IconFontTextView) hasViews.findViewById(R.id.btn_audio_or_input) ;
        if (startPptBtn!= null) {
            startPptBtn.setOnClickListener(view -> btnStartPpt()
            );
        }
//        if (btnChatImage!= null) {
//            btnChatImage.setOnClickListener(view -> SingleChatSendEditorView.this.btnImageClick()
//            );
//        }
        if (btnChatEmoji!= null) {
            btnChatEmoji.setOnClickListener(view -> btnEmojiClick());
        }
        {
            View view = hasViews.findViewById(R.id.more_item_input);
            if (view != null) {
                view.setOnClickListener(view1 -> btnMoreItemInputClick()
                );
            }
        }
        if (btnChatSend!= null) {
            btnChatSend.setOnClickListener(view -> btnSendMsgClick());
        }
//        if (btnAudio!= null) {
//            btnAudio.setOnClickListener(view -> SingleChatSendEditorView.this.btnRecorderClick()
//            );
//        }
        if (btnFunctionMenu != null) {
            btnFunctionMenu.setOnClickListener(v -> btnFunctionMenuEntryClick());
        }
        afterViews();
    }



    public void setContact(DuduContact contact) {
        this.contact = contact;
    }

	public DuduContact getContact() {
		return contact;
	}

    private void init(){
        network = NetworkUtils.getInstance(getContext()) ;
        eventSender = EventSender.getInstance_();
        callUtils = CallUtils.getInstance_(getContext()) ;
        dialogHandle = DialogHandle.getInstance_() ;

    }

    @Override
    public void afterViews() {
		baseEditChat = editChat;
		baseBtnEmoji = btnChatEmoji;
		baseBtnFunctionMenu = btnFunctionMenu;
		baseBtnSend = btnChatSend;
		baseEditRegion = editRegion;
		baseFunctionRegion = functionRegion;

		configFuncButtons();
		super.afterViews();

        editRegion.setOnTouchListener((v, event) -> true);
        if (CallState.getInstance().isStatus(CallState.Status.ChatLiving)) {
			setVideoChatMode(true);
        }

    }

	@Override
	protected void configFuncButtons() {
		functionRegion.setPadding(0, 0, 0, 0);
		funcInputSwitchView.setVisibility(View.VISIBLE);
		funcPptView.setVisibility(View.VISIBLE);
	}

    @Override
    public void sendMessageResponse(DuduMessage message) {
        UiThreadExecutor.runTask(()->sendMessageResponse_(message));
    }

    @Override
    protected List<FunctionMenuData> createFunctionMenuDatas() {
        List<FunctionMenuData> menuDatas = new ArrayList<>();
        FunctionMenuHandler functionMenuHandler = CGSDKClientImpl.getInternalInstance().getFunctionMenuHandler();
        boolean needDefault = true;
        List<FunctionMenuData> userDefinedMenuData = null;
        if (functionMenuHandler != null) {
            needDefault = functionMenuHandler.needDefaultSingleChatFunctionMenuItem();
            userDefinedMenuData = functionMenuHandler.getSingleChatFunctionMenu(getContext());
        }
        if (needDefault) {
            menuDatas.addAll(super.createFunctionMenuDatas());
        }
        if (userDefinedMenuData != null && userDefinedMenuData.size() > 0) {
            menuDatas.addAll(userDefinedMenuData);
        }
        return menuDatas;
    }

    @Override
    public boolean onItemClick(FunctionMenuData functionMenuData) {
        if (!super.onItemClick(functionMenuData)) {
            FunctionMenuHandler functionMenuHandler = CGSDKClientImpl.getInternalInstance().getFunctionMenuHandler();
            if (functionMenuHandler != null) {
                functionMenuHandler.onMenuItemClick(getContext(), contact != null ? contact.getDuduUid() : "", ChatType.SINGLE_CHAT, functionMenuData);
            }
        }
        return true;
    }

    public void sendMessageResponse_(DuduMessage message) {
        Utils.debug("sendMessageResponse");
		if (contact == null) return;
        if (message.getConversationId().equals(contact.getDuduUid()) && messageAddListener != null) {
            messageAddListener.onAddOneMessage(message);
        }
    }

    @Override
    public void onAudioRecorded(int duration, String audioPath) {
        super.onAudioRecorded(duration, audioPath);
        if (contact == null) return;
        duduMessageAction.sendAudioMessage(audioPath, contact.getDuduUid(),
				false, contact.getSetting(), duration);
    }

	@Override
    public void onVideoRecorded(String videoFile, String thumbFile, int duration, boolean isBurned, int videoType, boolean frontCamera) {
        super.onVideoRecorded(videoFile, thumbFile, duration, isBurned, videoType, frontCamera);

		if (contact == null)
			return;
		duduMessageAction.sendJumpVideoMessage(videoFile, thumbFile,
				duration, contact.getDuduUid(), false,
				contact.getSetting(), isBurned, videoType, frontCamera);

    }

	@Override
	public void showOrHideRecorderView(boolean show, boolean needAnimation){
		// 收起ShareMoreView之前，先将消息加入列表
		if (!show) {
			refreshChatList(currentMessage);
		}
		super.showOrHideRecorderView(show, needAnimation);
	}

	void refreshChatList(DuduMessage message) {
        UiThreadExecutor.runTask(()->refreshChatList_(message),300);
    }
	void refreshChatList_(DuduMessage message) {
		if (!(contact != null && contact.isLocal())) {
			return;
		}
		if (message == null) {
			return;
		}
		//  加入列表的时候才播放发送音效
		videoAudioRecorderView.playRecordSendSound();
		// 刷新聊天界面
        eventSender.newMessages(new DuduMessage[]{message}, false);

		currentMessage = null;
		Utils.debug("CurrentMessage: reset to null >> " + currentMessage);
	}

    @Override
    public void setRecorderMode(RecorderMode recorderMode) {
        super.setRecorderMode(recorderMode);
//        if (recorderMode == RecorderMode.SHARE || recorderMode == RecorderMode.LOCAL_CONTACT) {
            configRecorderTabs(/*Constant.TAB_RECORD_FACE,*/ Constant.TAB_RECORD_VIDEO);
//        } else {
//            configRecorderTabs(/*Constant.TAB_RECORD_FACE,*/ Constant.TAB_RECORD_VIDEO, Constant.TAB_RECORD_AUDIO);
//        }
    }

	@Override
	public void onKeyBoardShow() {
		super.onKeyBoardShow();
	}

	/**
     * 键盘隐藏
     */
    @Override
    public void onKeyBoardHide() {
        super.onKeyBoardHide();
        if (isAddEmoji()) {
            return;
        }
    }

    @Override
    protected void sendTextMessage(String str) {
        if (contact == null) return;
        sendTextMessage(str, contact.getDuduUid(), contact.getSetting(), ConversationType.USER, 0);
    }

    @Override
    protected void sendImage(String[] paths) {
        if (contact == null) return;
        duduMessageAction.compressImagesAndSend(paths,
                new DuduContact[]{contact}, null);
    }

    @Override
    public EditText getEditText() {
        return editChat;
    }

	@Override
	public void setVideoChatMode(boolean videoChatMode) {
		super.setVideoChatMode(videoChatMode);
//		showTextSendButton(!needShowRecordButtonOnTextChange());
	}

    @Override
    public void setMessageExtraResp(DuduMessage message) {
        super.setMessageExtraResp(message);
    }

//    @Override
//	protected boolean needShowRecordButtonOnTextChange() {
//        if (isVideoChatMode()) {
//            return false;
//        }
//        return CallState.getInstance().isIdle();
//	}


    @Override
    public void onDynamicEmojiSelected(GifEmotionData gifEmotionData) {
        if (contact != null) {
            duduMessageAction.sendGifMessage(gifEmotionData, contact.getDuduUid(), false, contact.getSetting());
        }
    }

}
