package me.chatgame.uisdk.activity.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import me.chatgame.mobilecg.activity.view.ChatPresentationPreview;
import me.chatgame.mobilecg.activity.view.interfaces.IChatPresentationPreview;
import me.chatgame.mobilecg.activity.view.interfaces.ILiveActivity;
import me.chatgame.mobilecg.activity.view.interfaces.IOpenGLView;
import me.chatgame.mobilecg.database.entity.DuduContact;
import me.chatgame.mobilecg.events.ConnectionEvent;
import me.chatgame.mobilecg.util.BackgroundExecutor;
import me.chatgame.mobilecg.util.ReflectInterfaceProxy;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.views.CustomViewPager;
import me.chatgame.uisdk.R;

/**
 * Created by star on 16/3/16.
 */
public class SingleChatPresentationView extends BaseChatPresentationView<DuduContact> {
    IChatPresentationPreview chatPresentationPreview;

    private boolean alreadyInflated_ = false;

    public SingleChatPresentationView(Context context) {
        super(context);
        init_();
    }

    public SingleChatPresentationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init_();
    }

    public SingleChatPresentationView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init_();
    }

    public static SingleChatPresentationView build(Context context) {
        SingleChatPresentationView instance = new SingleChatPresentationView(context);
        instance.onFinishInflate();
        return instance;
    }

    @Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_view_chat_presentation, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    private void init_() {
        init__();
        init();
        liveActivity = ((ILiveActivity) ReflectInterfaceProxy.newInstance(ILiveActivity.class, getContext()));
    }

    public static SingleChatPresentationView build(Context context, AttributeSet attrs) {
        SingleChatPresentationView instance = new SingleChatPresentationView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static SingleChatPresentationView build(Context context, AttributeSet attrs, int defStyleAttr) {
        SingleChatPresentationView instance = new SingleChatPresentationView(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        btnPaintBack = ((TextView) hasViews.findViewById(R.id.btn_paint_back));
        txtWatcherCount = ((TextView) hasViews.findViewById(R.id.txt_watcher_count));
        linearCounts = ((LinearLayout) hasViews.findViewById(R.id.linear_counts));
        btnShowKeyBoard = ((TextView) hasViews.findViewById(R.id.btn_show_keyboard));
        rootLayout = ((RelativeLayout) hasViews.findViewById(R.id.root_layout));
        groupVideoRequestView = ((GroupVideoRequestView) hasViews.findViewById(R.id.view_group_video_request));
        btnPenColor = ((TextView) hasViews.findViewById(R.id.btn_pen_color));
        btnMoreItem = ((TextView) hasViews.findViewById(R.id.btn_more_items));
        videoContainer = ((ViewGroup) hasViews.findViewById(R.id.id_presentation_video_container));
        btnPaintClose = ((TextView) hasViews.findViewById(R.id.btn_paint_close));
        btnPenRevoke = ((TextView) hasViews.findViewById(R.id.btn_pen_revoke));
        viewPager = ((CustomViewPager) hasViews.findViewById(R.id.pager_img));
        btnAddMore = ((TextView) hasViews.findViewById(R.id.btn_add_more));
        txtPageInfo = ((TextView) hasViews.findViewById(R.id.txt_page_info));
        if (btnPaintClose!= null) {
            btnPaintClose.setOnClickListener(view -> SingleChatPresentationView.this.btnPaintCloseClick()
            );
        }
        if (btnPaintBack!= null) {
            btnPaintBack.setOnClickListener(view -> SingleChatPresentationView.this.btnPaintBackClick()
            );
        }
        if (btnAddMore!= null) {
            btnAddMore.setOnClickListener(view -> SingleChatPresentationView.this.btnAddMoreClick()
            );
        }
        if (btnShowKeyBoard!= null) {
            btnShowKeyBoard.setOnClickListener(view -> SingleChatPresentationView.this.showKeyBoard()
            );
        }
        if (btnPenRevoke!= null) {
            btnPenRevoke.setOnClickListener(view -> SingleChatPresentationView.this.btnPenRevokeClick()
            );
        }
        if (btnPenColor!= null) {
            btnPenColor.setOnClickListener(view -> SingleChatPresentationView.this.btnPenColorClick()
            );
        }
        if (btnMoreItem!= null) {
            btnMoreItem.setOnClickListener(view -> SingleChatPresentationView.this.btnMoreItemsClick()
            );
        }
    }
    

    void init(){
        chatPresentationPreview = ChatPresentationPreview.getInstance_(getContext()) ;
    }


    @Override
    protected IOpenGLView createOpenGlViewManager() {
        return chatPresentationPreview;
    }

    @Override
    public void onEnter() {
        super.onEnter();
        if (isStartSlideSceneByMe()) {
            sendSlideInfoPeriod();
        }
    }

    void sendSlideInfoPeriod() {
        BackgroundExecutor.execute(this::sendSlideInfoPeriod_,"send_slide_info_period",2000,"", BackgroundExecutor.ThreadType.NETWORK);
    }

    void sendSlideInfoPeriod_() {
		Utils.debug("CallSceneDebug sendSlideInfoPeriod single");
		if (null == videoSceneInfo || null == currentSceneResource) {
            sendSlideInfoPeriod();
			return;
		}
		sceneActions.broadcastSceneUrlInfo(videoSceneInfo.getSceneId(),
				currentSceneResource.getPageNumber(),
				currentSceneResource.getTotalPageNumber(),
				currentSceneResource.getUrl());
		sendSlideInfoPeriod();
        Utils.debug("CallSceneDebug sendSlideInfoPeriod single send success");
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceiveConnectionChanged(ConnectionEvent event) {
        chatPresentationPreview.handleConnectionChanged(event.getData());
    }
}
