package me.chatgame.uisdk.activity.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;


import me.chatgame.mobilecg.activity.view.interfaces.ILiveActivity;
import me.chatgame.mobilecg.database.entity.ConversationType;
import me.chatgame.mobilecg.database.entity.DuduContact;
import me.chatgame.mobilecg.database.entity.DuduMessage;
import me.chatgame.mobilecg.util.ReflectInterfaceProxy;
import me.chatgame.mobilecg.views.IconFontTextView;
import me.chatgame.mobilecg.views.MonitoringEditText;
import me.chatgame.uisdk.R;

/**
 * Created by scofield on 16/3/16.
 */
public class PPTSingleSendEditView extends PPTBaseSendEditView <DuduContact> {
    

    private boolean alreadyInflated_ = false;

    public PPTSingleSendEditView(Context context) {
        super(context);
        init_();
    }

    public PPTSingleSendEditView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init_();
    }

    public PPTSingleSendEditView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init_();
    }

    public static PPTSingleSendEditView build(Context context) {
        PPTSingleSendEditView instance = new PPTSingleSendEditView(context);
        instance.onFinishInflate();
        return instance;
    }

    /**
     * The mAlreadyInflated_ hack is needed because of an Android bug
     * which leads to infinite calls of onFinishInflate()
     * when inflating a layout with a parent and using
     * the <merge /> tag.
     *
     */
    @Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_view_ppt_send_editor, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    private void init_() {
        imm = ((InputMethodManager) getContext().getSystemService(Context.INPUT_METHOD_SERVICE));
        liveActivity = ((ILiveActivity) ReflectInterfaceProxy.newInstance(ILiveActivity.class, getContext()));
    }

    public static PPTSingleSendEditView build(Context context, AttributeSet attrs) {
        PPTSingleSendEditView instance = new PPTSingleSendEditView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static PPTSingleSendEditView build(Context context, AttributeSet attrs, int defStyleAttr) {
        PPTSingleSendEditView instance = new PPTSingleSendEditView(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        funcInputSwitchView = hasViews.findViewById(R.id.func_input_switch);
        btnChatSend = ((IconFontTextView) hasViews.findViewById(R.id.btn_chat_send));
        funcPptView = hasViews.findViewById(R.id.func_ppt);
//        btnChatImage = ((TextView) hasViews.findViewById(R.id.btn_chat_image));
        startPptBtn = ((TextView) hasViews.findViewById(R.id.more_item_start_ppt));
        editText = ((MonitoringEditText) hasViews.findViewById(R.id.edit_chat));
//        if (btnChatImage!= null) {
//            btnChatImage.setOnClickListener(view -> PPTSingleSendEditView.this.btnImageClick()
//            );
//        }
        if (startPptBtn!= null) {
            startPptBtn.setOnClickListener(view -> PPTSingleSendEditView.this.btnStartPpt()
            );
        }
//        {
//            View view = hasViews.findViewById(R.id.btn_chat_audio);
//            if (view!= null) {
//                view.setOnClickListener(view1 -> PPTSingleSendEditView.this.btnRecorderClick()
//                );
//            }
//        }
        if (btnChatSend!= null) {
            btnChatSend.setOnClickListener(view -> PPTSingleSendEditView.this.btnSendMsgClick()
            );
        }
        {
            View view = hasViews.findViewById(R.id.rl_place_click);
            if (view!= null) {
                view.setOnClickListener(view1 -> PPTSingleSendEditView.this.closeKeyboard()
                );
            }
        }
        {
            View view = hasViews.findViewById(R.id.more_item_input);
            if (view!= null) {
                view.setOnClickListener(view1 -> PPTSingleSendEditView.this.btnMoreItemInputClick()
                );
            }
        }
        {
            View view = hasViews.findViewById(R.id.btn_chat_emoji);
            if (view!= null) {
                view.setOnClickListener(view1 -> PPTSingleSendEditView.this.btnEmojiClick()
                );
            }
        }
        afterViews();
    }

    @Override
    public void setMessageExtraResp(DuduMessage message) {
        super.setMessageExtraResp(message);
    }

    @Override
    protected void sendTextMessage(String str) {
        if (null == getChatEntity()) return;
        sendTextMessage(str, getChatEntity().getDuduUid(), getChatEntity().getSetting(), ConversationType.USER, 0);
    }
}
