package me.chatgame.uisdk.activity.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;


import java.util.regex.Matcher;
import java.util.regex.Pattern;

import me.chatgame.mobilecg.activity.GroupContactsAtSelectionActivity;
import me.chatgame.mobilecg.activity.view.interfaces.ILiveActivity;
import me.chatgame.mobilecg.constant.MessageExtraTypeValue;
import me.chatgame.mobilecg.constant.RegexStrings;
import me.chatgame.mobilecg.constant.ReqCode;
import me.chatgame.mobilecg.database.entity.ConversationType;
import me.chatgame.mobilecg.database.entity.DuduGroup;
import me.chatgame.mobilecg.database.entity.DuduMessage;
import me.chatgame.mobilecg.util.ReflectInterfaceProxy;
import me.chatgame.mobilecg.views.IconFontTextView;
import me.chatgame.mobilecg.views.MonitoringEditText;
import me.chatgame.uisdk.R;

/**
 * Created by scofield on 16/3/16.
 */
public class PPTGroupSendEditView extends PPTBaseSendEditView <DuduGroup>{
    private OnAtInputListener atInputListener;

    public interface OnAtInputListener {
        void onSelectAtContacts();
    }

    private boolean alreadyInflated_ = false;

    public PPTGroupSendEditView(Context context) {
        super(context);
        init_();
    }

    public PPTGroupSendEditView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init_();
    }

    public PPTGroupSendEditView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init_();
    }

    public static PPTGroupSendEditView build(Context context) {
        PPTGroupSendEditView instance = new PPTGroupSendEditView(context);
        instance.onFinishInflate();
        return instance;
    }

    /**
     * The mAlreadyInflated_ hack is needed because of an Android bug
     * which leads to infinite calls of onFinishInflate()
     * when inflating a layout with a parent and using
     * the <merge /> tag.
     *
     */
    @Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_view_ppt_send_editor, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    private void init_() {
        imm = ((InputMethodManager) getContext().getSystemService(Context.INPUT_METHOD_SERVICE));
        liveActivity = ((ILiveActivity) ReflectInterfaceProxy.newInstance(ILiveActivity.class, getContext()));
    }

    public static PPTGroupSendEditView build(Context context, AttributeSet attrs) {
        PPTGroupSendEditView instance = new PPTGroupSendEditView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static PPTGroupSendEditView build(Context context, AttributeSet attrs, int defStyleAttr) {
        PPTGroupSendEditView instance = new PPTGroupSendEditView(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        editText = ((MonitoringEditText) hasViews.findViewById(R.id.edit_chat));
        startPptBtn = ((TextView) hasViews.findViewById(R.id.more_item_start_ppt));
        btnChatSend = ((IconFontTextView) hasViews.findViewById(R.id.btn_chat_send));
        funcPptView = hasViews.findViewById(R.id.func_ppt);
        funcInputSwitchView = hasViews.findViewById(R.id.func_input_switch);
//        btnChatImage = ((TextView) hasViews.findViewById(R.id.btn_chat_image));
        if (startPptBtn!= null) {
            startPptBtn.setOnClickListener(view -> PPTGroupSendEditView.this.btnStartPpt()
            );
        }
        {
            View view = hasViews.findViewById(R.id.more_item_input);
            if (view!= null) {
                view.setOnClickListener(view1 -> PPTGroupSendEditView.this.btnMoreItemInputClick()
                );
            }
        }
        {
            View view = hasViews.findViewById(R.id.btn_chat_emoji);
            if (view!= null) {
                view.setOnClickListener(view1 -> PPTGroupSendEditView.this.btnEmojiClick()
                );
            }
        }
//        {
//            View view = hasViews.findViewById(R.id.btn_chat_audio);
//            if (view!= null) {
//                view.setOnClickListener(view1 -> PPTGroupSendEditView.this.btnRecorderClick()
//                );
//            }
//        }
        {
            View view = hasViews.findViewById(R.id.rl_place_click);
            if (view!= null) {
                view.setOnClickListener(view1 -> PPTGroupSendEditView.this.closeKeyboard()
                );
            }
        }
//        if (btnChatImage!= null) {
//            btnChatImage.setOnClickListener(view -> PPTGroupSendEditView.this.btnImageClick()
//            );
//        }
        if (btnChatSend!= null) {
            btnChatSend.setOnClickListener(view -> PPTGroupSendEditView.this.btnSendMsgClick()
            );
        }
        afterViews();
    }



    @Override
    protected void sendTextMessage(String str) {
        if (null == getChatEntity()) return;
        int extraType = MessageExtraTypeValue.NORMAL;
        if (!TextUtils.isEmpty(str)) {
            Pattern pattern = Pattern.compile(RegexStrings.MATCH_AT);
            Matcher matcher = pattern.matcher(str);
            while (matcher.find()) {
                extraType = MessageExtraTypeValue.AT_MSG;
                break;
            }
        }
        sendTextMessage(str, getChatEntity().getGroupId(), getChatEntity().getSetting(), ConversationType.GROUP, extraType);
    }


    @Override
    void afterTextChange(EditText editText) {
        if (isEditTextReady){
            String text = editText.getText().toString();
            int cursorPos = editText.getSelectionStart();
            //Utils.debug("[CGTEST] cursor pos: " + cursorPos);
            if (needShowAtSelectPage(text, cursorPos)) {
                //Utils.debug("[CGTEST] needShowAtSelectPage");
                if (atInputListener != null) {
                    atInputListener.onSelectAtContacts();
                }
                Intent intent = new Intent(getContext(), GroupContactsAtSelectionActivity.class);
                intent.putExtra(GroupContactsAtSelectionActivity.DUDU_GROUP_EXTRA, getChatEntity());
                ((Activity) getContext()).startActivityForResult(intent, ReqCode.CHOOSE_AT_CONTACTS);
            }
        }else {
            isEditTextReady = true;
        }

    }

    @Override
    public void setMessageExtraResp(DuduMessage message) {
        super.setMessageExtraResp(message);
    }

    public void setAtInputListener(OnAtInputListener atInputListener) {
        this.atInputListener = atInputListener;
    }
}
