package me.chatgame.uisdk.activity.view;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;

import me.chatgame.mobilecg.database.entity.BaseContact;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.views.IconFontTextView;
import me.chatgame.mobilecg.views.MonitoringEditText;

/**
 * Created by scofield on 16/3/16.
 */
public class PPTBaseSendEditView<CHAT_ENTITY extends BaseContact> extends BaseSendEditorView {


    MonitoringEditText editText;
    IconFontTextView btnChatSend;

    private CHAT_ENTITY chatEntity;

    public PPTBaseSendEditView(Context context) {
        super(context);
    }

    public PPTBaseSendEditView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PPTBaseSendEditView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void afterViews(){
        baseBtnSend = btnChatSend;
        baseEditChat = editText;
        super.afterViews();
    }

    void closeKeyboard(){
        Utils.autoCloseKeyboard((Activity) getContext(), editText);
    }

    public CHAT_ENTITY getChatEntity() {
        return chatEntity;
    }

    public void setChatEntity(CHAT_ENTITY chatEntity) {
        this.chatEntity = chatEntity;
    }

    @Override
    public MonitoringEditText getEditText() {
        return editText;
    }

    @Override
    protected boolean needShowRecordButtonOnTextChange() {
        return false;
    }

}
