package me.chatgame.uisdk.activity.view;

import android.app.Activity;
import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;
import java.util.List;

import me.chatgame.mobilecg.IMService;
import me.chatgame.mobilecg.MainApp;
import me.chatgame.mobilecg.activity.ImageChooseActivity;
import me.chatgame.mobilecg.activity.view.BaseRelativeLayout;
import me.chatgame.mobilecg.activity.view.interfaces.ILiveActivity;
import me.chatgame.mobilecg.activity.view.interfaces.IShowTime;
import me.chatgame.mobilecg.activity.view.interfaces.IView;
import me.chatgame.mobilecg.call.CallService;
import me.chatgame.mobilecg.call.CallState;
import me.chatgame.mobilecg.constant.Constant;
import me.chatgame.mobilecg.constant.ExtraInfo;
import me.chatgame.mobilecg.constant.ReqCode;
import me.chatgame.mobilecg.events.CallSceneInfo;
import me.chatgame.mobilecg.events.CameraStatusEvent;
import me.chatgame.mobilecg.events.ConnectionEvent;
import me.chatgame.mobilecg.events.LiveDurationTimeEvent;
import me.chatgame.mobilecg.events.LivePeerCameraChangeEvent;
import me.chatgame.mobilecg.events.LivePreviewSingleTapEvent;
import me.chatgame.mobilecg.events.MessageUpdateEvent;
import me.chatgame.mobilecg.events.SceneCreateResultEvent;
import me.chatgame.mobilecg.events.ScreenShareEvent;
import me.chatgame.mobilecg.handler.DBHandler;
import me.chatgame.mobilecg.handler.EventSender;
import me.chatgame.mobilecg.handler.SlideSceneHandler;
import me.chatgame.mobilecg.handler.SpeakerHandler;
import me.chatgame.mobilecg.handler.SystemStatus;
import me.chatgame.mobilecg.handler.VoipAndroidManager;
import me.chatgame.mobilecg.handler.interfaces.IDBHandler;
import me.chatgame.mobilecg.handler.interfaces.IEventSender;
import me.chatgame.mobilecg.handler.interfaces.ISpeakerHandler;
import me.chatgame.mobilecg.handler.interfaces.ISystemStatus;
import me.chatgame.mobilecg.handler.interfaces.IVoipAndroidManager;
import me.chatgame.mobilecg.util.AnimUtils;
import me.chatgame.mobilecg.util.BackgroundExecutor;
import me.chatgame.mobilecg.util.FileUtils;
import me.chatgame.mobilecg.util.FuncList;
import me.chatgame.mobilecg.util.ReflectInterfaceProxy;
import me.chatgame.mobilecg.util.TimeUtils;
import me.chatgame.mobilecg.util.ToastUtils;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.interfaces.IAnimUtils;
import me.chatgame.mobilecg.util.interfaces.IFile;
import me.chatgame.mobilecg.util.interfaces.ITimeUtils;
import me.chatgame.mobilecg.util.interfaces.IToastUtils;
import me.chatgame.uisdk.R;


public class LivingView extends BaseRelativeLayout
		implements
			IShowTime,
			IView {

    public static final String LIVE_HIDE_VIEWS = "live_hide_views";
    TextView txtStatistics;
    ImageView btnMute;
    ImageView btnCameraSwitch;
    ImageView btnCameraRotate;
    ImageView btnPpt;
    View btnFloat;
    TextView txtTime;
    View statusBarHolder;

    List<View> autoHideViews=new ArrayList<>();

	IAnimUtils animUtils;
	IToastUtils toastUtils;
	ITimeUtils timeUtils;
	IFile fileUtils;
	IMService imService;
	ISystemStatus systemStatus;
    IDBHandler dbHandler;
    SlideSceneHandler slideSceneHandler;
    protected IEventSender eventSender;
	ILiveActivity liveActivity;
    IVoipAndroidManager voipAndroidManager;

    MainApp app;

	private boolean isAnalyticsOn = false;// 是否需要显示通话统计

    private boolean alreadyInflated_ = false;
    private boolean isLoudSpeaker = true;
    private ISpeakerHandler speakerHandler;
    private ImageView btnSpeakerSwitch;

    public LivingView(Context context) {
        super(context);
        init_();
    }

    public LivingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init_();
    }

    public LivingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init_();
    }

    public static LivingView build(Context context) {
        LivingView instance = new LivingView(context);
        instance.onFinishInflate();
        return instance;
    }

    @Override
    public void onStart() {
        super.onStart();
        eventSender.register(this);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        BackgroundExecutor.cancelAll(LIVE_HIDE_VIEWS,true);
        eventSender.unregister(this);
    }

    /**
     * The mAlreadyInflated_ hack is needed because of an Android bug
     * which leads to infinite calls of onFinishInflate()
     * when inflating a layout with a parent and using
     * the <merge /> tag.
     *
     */
    @Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_view_live, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    private void init_() {
        init();
        liveActivity = ((ILiveActivity) ReflectInterfaceProxy.newInstance(ILiveActivity.class, getContext()));
        voipAndroidManager= VoipAndroidManager.getInstance_(getContext());
    }

    public static LivingView build(Context context, AttributeSet attrs) {
        LivingView instance = new LivingView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static LivingView build(Context context, AttributeSet attrs, int defStyleAttr) {
        LivingView instance = new LivingView(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        btnSpeakerSwitch = (ImageView) hasViews.findViewById(R.id.btn_switch_speaker);
        btnSpeakerSwitch.setOnClickListener(v -> switchSpeaker());
        statusBarHolder=hasViews.findViewById(R.id.statusbar_placeholder);
        btnCameraRotate = (ImageView) hasViews.findViewById(R.id.btn_camera_rotate);
        btnCameraSwitch = (ImageView) hasViews.findViewById(R.id.btn_camera_switch);
        btnPpt = (ImageView) hasViews.findViewById(R.id.img_ppt);
        txtStatistics = ((TextView) hasViews.findViewById(R.id.txt_statistics));
        txtTime = (TextView)hasViews.findViewById(R.id.txt_time);
        btnFloat=hasViews.findViewById(R.id.img_float);
        btnMute = (ImageView) hasViews.findViewById(R.id.img_mute);
        {
            View view = hasViews.findViewById(R.id.btn_hangup);
            if (view!= null) {
                view.setOnClickListener(view1 -> LivingView.this.hangupClick()
                );
            }
        }
        if (btnCameraSwitch!= null) {
            btnCameraSwitch.setOnClickListener(view -> LivingView.this.cameraSwitchClick()
            );
        }
        if (btnCameraRotate!= null) {
            btnCameraRotate.setOnClickListener(view -> LivingView.this.cameraRotateClick()
            );
        }
        if (btnPpt != null) {
            btnPpt.setOnClickListener(view -> goToPptPage());
        }

        btnFloat.setOnClickListener(view->LivingView.this.switch2Float());
        if(CallState.getInstance().isMute()){
            mute();
        }else {
            unmute();
        }

        autoHideViews.add(hasViews.findViewById(R.id.layout_buttons));
        autoHideViews.add(txtTime);
        autoHideViews.add(hasViews.findViewById(R.id.btn_hangup));
        autoHideViews.add(btnPpt);
        autoHideViews.add(btnFloat);
        delayHideViews();
    }

    private void switchSpeaker() {
        if (speakerHandler.isEarphoneOn()) {
            return;
        }

        isLoudSpeaker = !isLoudSpeaker;
        speakerHandler.changeSpeaker(!isLoudSpeaker);
        if (isLoudSpeaker) {
            btnSpeakerSwitch.setImageResource(R.drawable.handwin_ic_speaker_on);
            app.onProximityChangedNeedPowerLock(false);
        } else {
            btnSpeakerSwitch.setImageResource(R.drawable.handwin_selector_speaker);
            app.onProximityChangedNeedPowerLock(true);
        }
    }

    private void delayHideViews(){
        BackgroundExecutor.cancelAll(LIVE_HIDE_VIEWS,true);
        BackgroundExecutor.execute(()->{
            UiThreadExecutor.runTask(()->{
                FuncList.from(autoHideViews).iterate(view -> view.setVisibility(INVISIBLE));
            });
        },LIVE_HIDE_VIEWS,5000,"", BackgroundExecutor.ThreadType.CALCULATION);
    }
    private void switch2Float() {
        CallService.getInstance().openFloatVideo();
        app.onProximityChangedNeedPowerLock(false);
        isLoudSpeaker = true;
        speakerHandler.changeSpeaker(!isLoudSpeaker);
        liveActivity.switch2Float();
    }

    void init(){
        fileUtils = FileUtils.getInstance_(getContext()) ;
        timeUtils = TimeUtils.getInstance_(getContext()) ;
        systemStatus = SystemStatus.getInstance_() ;
        eventSender = EventSender.getInstance_();
        animUtils = AnimUtils.getInstance_(getContext());
        toastUtils = ToastUtils.getInstance_(getContext()) ;
        dbHandler = DBHandler.getInstance_(getContext());
        imService = IMService.getInstance_(getContext());
        slideSceneHandler = SlideSceneHandler.getInstance_(getContext());
        app = MainApp.getInstance();
        speakerHandler = SpeakerHandler.getInstance_(getContext());
    }

	public void afterViews() {
		resetUi();

		isAnalyticsOn = isAnalyticsOn();

		if (isAnalyticsOn) {
			txtStatistics.setVisibility(View.VISIBLE);
		}

		this.showCameraStatus(CallState.getInstance().isMyCameraOpen());

		onStateChanged();

		playFullscreenTip();
        registerLifeCycle();
        eventSender.register(this);
        btnCameraRotate.setEnabled(CallState.getInstance().isMyCameraOpen());

    }

	private void resetUi() {
	}

	/**
	 * 播放提示动画
	 */
	private void playFullscreenTip() {
	}

	public void showTime(long durationTime) {
		// 监测音频数据，100ms一次
	}

	public void onWind(int volume) {

	}

	/**
	 * 是否需要显示通话统计
	 *
	 * @return
	 */
	private boolean isAnalyticsOn() {
		return false;
	}

	@Override
	public void hide() {
		this.setVisibility(View.GONE);
	}

	@Override
	public void show() {
		this.setVisibility(View.VISIBLE);
        handleCameraStatusChanged(CallState.getInstance().isMyCameraOpen());
        handleConnectionChanged(CallState.getInstance().isConnBad());
	}

    private void goToPptPage() {
        if (CallState.getInstance().isScreenShare()) {
            return;
        }
        delayHideViews();
        if (CallState.getInstance().getVideoSceneInfo() != null) {
            liveActivity.switch2Chat();
        } else {
            selectSlidePictures((Activity) getContext(), null);
        }
    }

    void mute(){
        // 统计，切换到聊天
        delayHideViews();
        btnMute.setImageResource(R.drawable.handwin_ic_mute_mic_press);
        btnMute.setOnClickListener(v -> unmute());
        voipAndroidManager.muteMicrophone();
        CallState.getInstance().setMute(true);
    }

    void unmute(){
        delayHideViews();
        btnMute.setImageResource(R.drawable.handwin_selector_mute_mic);
        btnMute.setOnClickListener(v -> mute());
        voipAndroidManager.unmuteMicrophone();
        CallState.getInstance().setMute(false);
    }
    void cameraSwitchClick(){
        delayHideViews();
//        if (CallState.getInstance().isVideoCall()) {
            if (CallState.getInstance().isMyCameraOpen()) {
                CallService.getInstance().closeCamera();
            } else {
                CallService.getInstance().openCamera();
            }
//        }
        handleCameraStatusChanged(CallState.getInstance().isMyCameraOpen());

    }
    void hangupClick(){
        delayHideViews();
        CallService.getInstance().onReceiveHungup();
        CallState.getInstance().setStatus(CallState.Status.Idle);
    }
    void cameraRotateClick(){
        delayHideViews();
        if (Utils.isFastDoubleClick("live.cameraswitch")) {
            return;
        }
        if(CallState.getInstance().isMyCameraOpen()) {
            if (CallState.getInstance().isVideoCall()) {
                //自己是前摄像头的时候，如果切到后，需要变为全屏
                CallService.getInstance().rotateCamera(true);
            }

        }
    }
	@Override
	public void showCameraStatus(boolean cameraOpen) {
		// Camera开关按钮状态切换
		// imgCameraOnoff.setBackgroundResource(cameraOpen?R.drawable.selector_btn_call_ca:R.drawable.selector_btn_call_camera_off);
		// imgWindowSwitch.setVisibility(cameraOpen ? View.VISIBLE :
		// View.INVISIBLE);
	}

	@Override
	public void onStateChanged() {
	}

    @Override
    public void onPeerProximityChanged() {

    }

    public void exit(){
		unregisterLifeCycle();
        eventSender.unregister(this);
    }
	public String toString() {
		return "LivingView";
	}

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onMessageUpdate(MessageUpdateEvent event){
        //以后可能会用到，用弹幕显示新消息
    }

    @Override
    public void waitClose() {

    }
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceiveConnectionChanged(ConnectionEvent event) {
        handleConnectionChanged(event.getData());
    }

    private void handleConnectionChanged(boolean   connectionBad) {
        synchronized (this) {
            String tipMy = getContext().getString(R.string.handwin_tips_tcp_is_disconnected);
            String tipPeer = getContext().getString(R.string.handwin_tips_peer_tcp_is_disconnected);

            if (connectionBad) {
                if(systemStatus.isTcpConnected()){
                    liveActivity.showFixedTip(tipPeer);
                }else{
                    liveActivity.showFixedTip(tipMy);
                }
            }else{
                liveActivity.hideFixedTip(tipMy);
                liveActivity.hideFixedTip(tipPeer);
            }
        }
    }


    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceivePeerCameraChanged(LivePeerCameraChangeEvent event) {
        if (!CallState.getInstance().isPeerCameraOpen() && event.isNeedToast()){
            toastUtils.toast(getContext().getString(R.string.handwin_other_camera_off));
        }
    }
    @Subscribe(threadMode = ThreadMode.MAIN)
	public void handleSceneStatus(CallSceneInfo callSceneInfo) {
		Utils.debugFormat("CallSceneDebug handleSceneStatus in livingView");
		if (callSceneInfo.getVideoSceneInfo().getRoomId().equals(CallState.getInstance().getRoomId())) {
			liveActivity.processSceneStatus(callSceneInfo);
		} else {
			Utils.debugFormat("CallSceneDebug handleSceneStatus room id not match");
		}
	}
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceiveCameraStatus(CameraStatusEvent event){
        handleCameraStatusChanged(event.getData());
    }
    private long liveSeconds=0;
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceiveLivingTime(LiveDurationTimeEvent event){
        if(event.getDuration()/1000>liveSeconds){
            liveSeconds=event.getDuration()/1000;
            txtTime.setText(timeUtils.getCallingTime(event.getDuration(),false));
        }
    }
    private void handleCameraStatusChanged(boolean cameraOpen){
        btnCameraSwitch.setImageResource(cameraOpen ? R.drawable.handwin_selector_camera_close : R.drawable.handwin_ic_camera_close_press);
        btnCameraRotate.setEnabled(cameraOpen);
    }

    public void onPPTImageChooseResult(int resultCode, Intent data) {
        Utils.debugFormat("SlideDebugTest onPPTImageChooseResult");
        processSelectImagesResult(resultCode, data);
    }

    /**
     * 打开图片选取
     */
    protected void selectSlidePictures(Activity activity, Fragment fragment) {
        Intent intent = new Intent();
        intent.putExtra(ExtraInfo.IMAGE_PICK_MULTI, true);
        intent.putExtra(ExtraInfo.NEED_CAMERA, false);
        intent.putExtra(ExtraInfo.MAX_IMAGE_NUMBER, Constant.MAX_IMG_SLIDE_NUMBER);
        intent.putExtra(ExtraInfo.IS_SHOW_SELECT_ORDER, true);
        intent.putExtra(ExtraInfo.NEED_SELECTED_PREVIEW, true);
        intent.putExtra(ExtraInfo.IS_GROUP, false);
        intent.putExtra(ExtraInfo.ROOM_ID, CallState.getInstance().getRoomId());
        intent.putExtra(ExtraInfo.ACTION_TEXT, app.getString(R.string.handwin_app_yes));
        try {
            if (activity != null) {
                intent.setClass(activity, ImageChooseActivity.class);
                activity.startActivityForResult(intent, ReqCode.PPT_SELECT_IMG);
            } else if (fragment != null) {
                intent.setClass(fragment.getActivity(), ImageChooseActivity.class);
                fragment.startActivityForResult(intent, ReqCode.PPT_SELECT_IMG);
            }
        } catch (ActivityNotFoundException e) {
            e.printStackTrace();
        }
    }


    public void processSelectImagesResult(int resultCode, Intent data) {
        switch (resultCode) {
            case Activity.RESULT_OK:
                String[] paths = data.getStringArrayExtra(ExtraInfo.ALL_PATH);
                if (null == paths || paths.length < 1) {
                    app.toast(R.string.handwin_tips_image_load_fail);
                    return;
                }
                Utils.debugFormat("SlideDebugTest processSelectImagesResult ok");
                uploadImage(paths);
                slideSceneHandler.createScene();
                break;
            case Activity.RESULT_CANCELED:
                break;
            default:
                app.toast(R.string.handwin_tips_image_load_fail);
                break;
        }
    }

    void uploadImage(String[] paths) {
        BackgroundExecutor.execute(()->uploadImage_(paths), BackgroundExecutor.ThreadType.IO);
    }

    void uploadImage_(String[] paths) {
        if (paths == null) {
            return;
        }

        slideSceneHandler.addSlideImages(paths);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onSceneCreateSuccess(SceneCreateResultEvent event) {
        Utils.debugFormat("SlideDebugTest onSceneCreateSuccess");
        liveActivity.switch2Chat();
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onClick(LivePreviewSingleTapEvent event) {
        if(autoHideViews.get(0).getVisibility()==VISIBLE){
            FuncList.from(autoHideViews).iterate(view -> view.setVisibility(INVISIBLE));
        }else {
            FuncList.from(autoHideViews).iterate(view -> view.setVisibility(VISIBLE));
            delayHideViews();
        }
    }
    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onReceiveScreenShareEvent(ScreenShareEvent event){
       if(event.isOn()){
           statusBarHolder.setVisibility(GONE);
       }else{
           statusBarHolder.setVisibility(VISIBLE);
       }
    }
}
