package me.chatgame.uisdk.activity.view;

import android.content.Context;
import android.util.AttributeSet;

import java.util.LinkedList;

import me.chatgame.mobilecg.activity.view.BasePreviewContainerView;
import me.chatgame.mobilecg.activity.view.LiveVideoPreview;
import me.chatgame.mobilecg.activity.view.interfaces.ILiveVideoPreview;
import me.chatgame.mobilecg.call.LinePlayer;
import me.chatgame.voip.VoipImage;

/**
 * Created by zjchai on 16/7/26.
 */
public class LiveVideoPreviewContainerView extends BasePreviewContainerView<ILiveVideoPreview> {

    public LiveVideoPreviewContainerView(Context context) {
        super(context);
    }

    public LiveVideoPreviewContainerView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public LiveVideoPreviewContainerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected ILiveVideoPreview createOpenGlViewManager() {
        ILiveVideoPreview preview = new LiveVideoPreview(getContext());
        return preview;
    }

    public void stopLive(){
        ILiveVideoPreview p = getOpenGLViewManager();
        if (p != null) {
            p.stopLive();
        }
    }


    public void destroy() {
        ILiveVideoPreview p = getOpenGLViewManager();
        if (p != null) {
            p.destroy();
        }
    }

    public void startLive(){
        ILiveVideoPreview p = getOpenGLViewManager();
        if (p != null) {
            p.startLive();
        }
    }

    public void render(VoipImage image,boolean myVideo){
        ILiveVideoPreview preview = getOpenGLViewManager() ;
        preview.render(image,myVideo);
    }

    public void linePlayerChanged(LinkedList<LinePlayer> linePlayers) {
        ILiveVideoPreview preview = getOpenGLViewManager() ;
        preview.linePlayerChanged(linePlayers) ;
    }

    public void setHasVideo(boolean hasVideo) {
        ILiveVideoPreview preview = getOpenGLViewManager() ;
        preview.setHasVideo(hasVideo) ;
    }

    public void resetOpenGLViews(){
        ILiveVideoPreview preview = getOpenGLViewManager() ;
        preview.setInvalidate(true);
    }
}
