package me.chatgame.uisdk.activity.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;
import java.util.List;

import me.chatgame.mobilecg.MainApp;
import me.chatgame.mobilecg.actions.DuduMessageActions;
import me.chatgame.mobilecg.actions.interfaces.IDuduMessageActions;
import me.chatgame.mobilecg.activity.view.BasePreviewContainerView;
import me.chatgame.mobilecg.activity.view.LivePreview;
import me.chatgame.mobilecg.activity.view.interfaces.IAbstractLivePreview;
import me.chatgame.mobilecg.activity.view.interfaces.ILiveActivity;
import me.chatgame.mobilecg.activity.view.interfaces.ILivePreview;
import me.chatgame.mobilecg.activity.view.interfaces.ILivePreviewContainerView;
import me.chatgame.mobilecg.activity.view.interfaces.IOpenGLView;
import me.chatgame.mobilecg.activity.view.interfaces.IShowTime;
import me.chatgame.mobilecg.activity.view.interfaces.IView;
import me.chatgame.mobilecg.call.CallService;
import me.chatgame.mobilecg.call.CallState;
import me.chatgame.mobilecg.call.ICallService;
import me.chatgame.mobilecg.constant.MessageType;
import me.chatgame.mobilecg.database.entity.DuduContact;
import me.chatgame.mobilecg.events.CallRejectEvent;
import me.chatgame.mobilecg.events.CallTimeoutHangupEvent;
import me.chatgame.mobilecg.events.ConnectionEvent;
import me.chatgame.mobilecg.events.DismissMessagePanelEvent;
import me.chatgame.mobilecg.events.EnterSingleChatPresentationEvent;
import me.chatgame.mobilecg.events.ExitSingleChatPresentationEvent;
import me.chatgame.mobilecg.events.LiveCallBusyEvent;
import me.chatgame.mobilecg.events.LiveDurationTimeEvent;
import me.chatgame.mobilecg.events.LiveFirstVideoFrameEvent;
import me.chatgame.mobilecg.events.LiveMyCameraChangeEvent;
import me.chatgame.mobilecg.events.LivePeerCameraChangeEvent;
import me.chatgame.mobilecg.events.LivePeerProximityChangeEvent;
import me.chatgame.mobilecg.events.LivePeerSwitch2VoiceEvent;
import me.chatgame.mobilecg.events.LiveStateChangeEvent;
import me.chatgame.mobilecg.events.LivingStartEvent;
import me.chatgame.mobilecg.events.ScreenShareEvent;
import me.chatgame.mobilecg.events.Switch2VoiceEvent;
import me.chatgame.mobilecg.events.UserHangupEvent;
import me.chatgame.mobilecg.handler.CallServiceHandler;
import me.chatgame.mobilecg.handler.CameraHandler;
import me.chatgame.mobilecg.handler.ConfigHandler;
import me.chatgame.mobilecg.handler.DBHandler;
import me.chatgame.mobilecg.handler.SystemStatus;
import me.chatgame.mobilecg.handler.VoipAndroidManager;
import me.chatgame.mobilecg.handler.interfaces.ICamera;
import me.chatgame.mobilecg.handler.interfaces.IConfig;
import me.chatgame.mobilecg.handler.interfaces.IDBHandler;
import me.chatgame.mobilecg.handler.interfaces.ISystemStatus;
import me.chatgame.mobilecg.handler.interfaces.IVoipAndroidManager;
import me.chatgame.mobilecg.util.AudioUtils;
import me.chatgame.mobilecg.util.BackgroundExecutor;
import me.chatgame.mobilecg.util.ContactCacheManager;
import me.chatgame.mobilecg.util.DialogHandle;
import me.chatgame.mobilecg.util.ReflectInterfaceProxy;
import me.chatgame.mobilecg.util.ToastUtils;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.interfaces.IContactCacheManager;
import me.chatgame.mobilecg.util.interfaces.IDialogHandle;
import me.chatgame.mobilecg.util.interfaces.IMessagePannel;
import me.chatgame.mobilecg.util.interfaces.IToastUtils;
import me.chatgame.mobilecg.views.MessagePannel;
import me.chatgame.uisdk.R;
import me.chatgame.voip.VoipAndroid;

/**
 * Created by star on 16/3/24.
 */
public class LivePreviewContainerView extends BasePreviewContainerView<ILivePreview> implements ILivePreviewContainerView {

    FrameLayout surfaceViewContainer;

    LivePreview livePreview;
    IVoipAndroidManager voipAndroidManager;
    IToastUtils toastUtils;
    ISystemStatus systemStatus;
    AudioUtils audioUtils;
    IDBHandler dbHandler;
    IConfig config ;
    IMessagePannel messagePannel;
    IDuduMessageActions duduMessageActions;
    IDialogHandle dialogHandler;
    IContactCacheManager contactCacheManager;
    ICallService callService;
    ICamera cameraHandler;

    MainApp app;

    ILiveActivity liveActivity;

    private boolean isLiving = false ;
    private boolean isChatLiving = false ;
    private boolean isCalling = false;
    private boolean inVideoChatting = false;
    private IView currentView;
    private int screenWidth;
    private int screenHeight;
    private DuduContact contact;



    private boolean alreadyInflated_ = false;

    public LivePreviewContainerView(Context context) {
        super(context);
        init_();
    }

    public LivePreviewContainerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init_();
    }

    public LivePreviewContainerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init_();
    }

    public static LivePreviewContainerView build(Context context) {
        LivePreviewContainerView instance = new LivePreviewContainerView(context);
        instance.onFinishInflate();
        return instance;
    }

    @Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_layout_live_preview_container, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    private void init_() {
        liveActivity = ((ILiveActivity) ReflectInterfaceProxy.newInstance(ILiveActivity.class, getContext()));
    }

    public static LivePreviewContainerView build(Context context, AttributeSet attrs) {
        LivePreviewContainerView instance = new LivePreviewContainerView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static LivePreviewContainerView build(Context context, AttributeSet attrs, int defStyleAttr) {
        LivePreviewContainerView instance = new LivePreviewContainerView(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        surfaceViewContainer = ((FrameLayout) hasViews.findViewById(R.id.live_surface_view_container));
        afterViews();
    }

    void afterViews() {
        init();
        screenWidth = config.getScreenWidth();
        screenHeight = config.getScreenHeight();
    }

    private void init() {
        app = MainApp.getInstance();
        config = ConfigHandler.getInstance_(getContext()) ;
        voipAndroidManager = VoipAndroidManager.getInstance_(getContext());
        duduMessageActions = DuduMessageActions.getInstance_(getContext(), this);
        systemStatus = SystemStatus.getInstance_() ;
        cameraHandler = CameraHandler.getInstance_(getContext()) ;
        audioUtils = AudioUtils.getInstance_(getContext()) ;
        dialogHandler = DialogHandle.getInstance_() ;
        toastUtils = ToastUtils.getInstance_(getContext()) ;
        contactCacheManager = ContactCacheManager.getInstance_(getContext()) ;
        callService = CallServiceHandler.getInstance_();
        dbHandler = DBHandler.getInstance_(getContext());

        livePreview = LivePreview.getInstance_(getContext()) ;
        messagePannel = MessagePannel.getInstance_(getContext());
    }

    public void begin() {
        eventSender.register(this);
        registerLifeCycle();
        messagePannel.cancelMessagePannel();
        setVisibility(View.VISIBLE);
        inVideoChatting = true;
    }

    public void end(boolean hideView) {
        unregisterLifeCycle();
        if (hideView) {
            setVisibility(View.GONE);
        }
        if (currentOpenGLView != null) {
            currentOpenGLView.end();
        }
        inVideoChatting = false;
        eventSender.unregister(this);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        hideCurrentView();
        eventSender.unregister(this);
    }

    @Override
    protected ILivePreview createOpenGlViewManager() {
        return livePreview;
    }

    @Override
    public FrameLayout getSurfaceViewContainer() {
        return surfaceViewContainer;
    }

    private void sendLocalBroadCast(Intent intent) {
        LocalBroadcastManager.getInstance(getContext()).sendBroadcast(intent);
    }


    /**
     * 显示切换成语音通话提示
     */
    private void showSwitch2VoiceTip() {
        String msg = getContext().getString(R.string.handwin_tips_peer_switch_to_voice);
        toastUtils.toast(msg);
    }

    private void doSwitch2Voice() {
        CallState callState = CallState.getInstance();
        // 不要打开 voip有坑
//		voipAndroidManager.setCostumeMode(true);
        callState.setMyCameraOpen(false);
        callState.setPeerCameraOpen(false);
        callService.closeCamera(false);
        IOpenGLView currentOpenGLView = previewActivity.getCurrentOpenGLView();
        if(currentOpenGLView !=null && currentOpenGLView instanceof IAbstractLivePreview) {
            ((IAbstractLivePreview) currentOpenGLView).switch2Voice();
        }

        if (currentView != null) {
            currentView.onStateChanged();
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void livePeerSwitch2voice(LivePeerSwitch2VoiceEvent event) {
        synchronized (this) {
            doSwitch2Voice();
            if (livePreview != null && isLiving) {
                showSwitch2VoiceTip();
            }
        }
    }

    @Subscribe
    public void switch2Voice(Switch2VoiceEvent event) {
        doSwitch2Voice();
    }

    public void setChatLiving(boolean isChatLiving) {
        this.isChatLiving = isChatLiving;
        systemStatus.setIsChatLiving(isChatLiving);
    }

    public boolean isChatLiving() {
        return isChatLiving;
    }

    private void hideCurrentView() {
        liveActivity.cancelRecord();
        Utils.autoCloseKeyboard((Activity) getContext(), this);
        if(messagePannel != null) {
            messagePannel.cancelMessagePannel();
        }
        if (currentView != null) {
            if (currentView instanceof BasePreviewContainerView) {
                ((BasePreviewContainerView) currentView).hideSurfaceView();
            }
            currentView.hide();
            currentView.exit();

            if (currentView instanceof View) {
                removeView((View) currentView);
            }

            currentView = null;
        }
    }

    private void showView(View view, int height) {
        Utils.debugFormat("CallService ShowView %s", view.getClass().getName());
        LayoutParams lp = new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, height);
        addView(view, lp);
    }

    private void showLiveChatContainerView() {
        if (currentView instanceof LiveChatContainerView) {
            if (((LiveChatContainerView) currentView).getOpenGLViewManager() == null
                    || previewActivity.getCurrentOpenGLView() == null ||
                    ((LiveChatContainerView) currentView).getOpenGLViewManager() != previewActivity.getCurrentOpenGLView()) {
                ((LiveChatContainerView) currentView).showSurfaceView();
            }
            return;
        }

        Utils.debug("CallService showLiveChatView");
        hideCurrentView();
        setChatLiving(true);

        LiveChatContainerView liveChatView = LiveChatContainerView.build(getContext());
        liveChatView.resizeVideoRegion(screenWidth);
        showView(liveChatView, ViewGroup.LayoutParams.MATCH_PARENT);

        hideSurfaceView();
        liveChatView.show();
        liveChatView.showSurfaceView();

        currentView = liveChatView;
    }

    private void showLiveView() {
        hideCurrentView();
        setChatLiving(false);
        LivingView livingView = LivingView.build(getContext());
        livingView.afterViews();
        showView(livingView, LayoutParams.MATCH_PARENT);
        livingView.show();
        currentView = livingView;
        livingView.setOnTouchListener(livePreview);
        livingView.setOnLongClickListener(livePreview);
        eventSender.updateLivingUnRead();

        isLiving = true;
    }

    private void showResponseView() {
//        showLiveChatContainerView();
//        if (currentView instanceof LiveChatContainerView) {
//            ((LiveChatContainerView) currentView).showResponseView();
//        }
        hideCurrentView();
        setChatLiving(false);

        VideoResponseView responseView = new VideoResponseView(getContext());
        showView(responseView, LayoutParams.MATCH_PARENT);
        responseView.showCallingInfo();
        responseView.show();
        currentView = responseView;

    }

    protected String getCountryCode() {
        return CallState.getInstance().getCountryCode();
    }

    /**
     * 获取电话号码
     *
     * @return
     */
    protected String getMobileNumber() {
        return CallState.getInstance().getMobile();
    }
    @Subscribe
    public void onCallReject(CallRejectEvent event){
        showResponseWaitCloseMenu();
    }
    private void showResponseWaitCloseMenu(){
        String[] arrays = app.getResources()
                .getStringArray(R.array.handwin_call_reject);
        int length = arrays.length;
        int[] colors = new int[length];
        int color = getResources().getColor(R.color.handwin_txt_pannel_cancel);
        for (int i = 0; i < length; i++) {
            colors[i] = color;
        }
        OnClickListener listener= view->{
            messagePannel.cancelMessagePannel();
            callService.closeLiveView();
        };
        eventSender.sendLiveChatPopupMenuEvent();
        messagePannel.showMessagePannel(this, arrays, colors, (
                parent, view, position, id) -> {
            if (Utils.isFastDoubleClick()) {
                return;
            }
            sendMessageFromMessagePannel(view.getTag().toString());
            listener.onClick(view);
            return;
        }, listener, null, null, IMessagePannel.Style.White, false);
    }

    private void showCallWaitCloseMenu(){
        Utils.autoCloseKeyboard((Activity) this.getContext(),this);
        List<String> menus=new ArrayList<>();
        menus.add(app.getResources().getString(R.string.handwin_menu_recall));

        final String[] arrays=menus.toArray(new String[0]);
        int length = arrays.length;
        int[] colors = new int[length];
        int color = getResources().getColor(R.color.handwin_A1);
        for (int i = 0; i < length; i++) {
            colors[i] = color;
        }
        OnClickListener listener= view->{
            messagePannel.cancelMessagePannel();
            callService.closeLiveView();
        };
        eventSender.sendLiveChatPopupMenuEvent();
        messagePannel.showMessagePannel(this, arrays, colors, (
                parent, view, position, id) -> {
            if (Utils.isFastDoubleClick()) {
                return;
            }
            callWaitCloseMenuClick(arrays[position], view);
            return;
        }, listener, getResources().getString(R.string.handwin_video_record_message), v -> {
            switchToVideoRecordView();
            messagePannel.cancelMessagePannel();
        }, IMessagePannel.Style.White, false);
    }

    private void switchToVideoRecordView() {
        String peerUid = CallState.getInstance().getPeerId();
        liveActivity.switchToRecordVideo(peerUid);
    }

    private void callWaitCloseMenuClick(String label,View view) {
        if(label.equals(app.getResources().getString(R.string.handwin_menu_recall))){
            liveActivity.reCall();
            messagePannel.cancelMessagePannel();
            return;
        }
//        if (label.equals(app.getResources().getString(R.string.handwin_menu_iwant2cu))) {
//            messagePannel.cancelMessagePannel();
//            sendMessageFromMessagePannel(view.getTag().toString());
//            liveActivity.closeLive();
//            return;
//        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onMessagePanelDismissEvent(DismissMessagePanelEvent event) {
        if (messagePannel != null) {
            messagePannel.cancelMessagePannel();
        }
        liveActivity.closeLive();
    }

    private void sendMessageFromMessagePannel(String message) {
        message = message + " ";
        if (contact != null) {
            duduMessageActions.sendMessage(message, contact, MessageType.TEXT);
        } else {
            duduMessageActions.sendMessage(message, liveActivity.getFrom(),
                    MessageType.TEXT);
        }
    }

    private void showCallingView(DuduContact duduContact) {
//        showLiveChatContainerView();
//        liveActivity.switch2Chat();
//        if (currentView instanceof LiveChatContainerView) {
//            ((LiveChatContainerView) currentView).showCallingView();
//        }

        hideCurrentView();
        setChatLiving(false);

        VideoCallingView callingView = new VideoCallingView(getContext());
        callingView.setUserInfo(duduContact);
        showView(callingView, LayoutParams.MATCH_PARENT);
        callingView.show();
        currentView = callingView;

        callingView.setOnTouchListener(livePreview);
    }

    public void handleBack2Live() {
        voipAndroidManager.stopAllPlayingVideoMessage();
        audioUtils.stopPlay(null);

        isCalling = false;
        livePreview.switchToLive();
        showLiveView();
        showSurfaceView();
        CallState.getInstance().setStatus(CallState.Status.Living);
        asyncSwitchLive();
    }

    private void handleHangup(String endTipStr,int iconColor) {
        synchronized (this) {
            if(!TextUtils.isEmpty(endTipStr))
            {
                if (currentView instanceof LiveChatContainerView) {
                    ((LiveChatContainerView) currentView).showTip(endTipStr,iconColor);
                }
            }
            if (currentView instanceof LiveChatContainerView) {
                ((LiveChatContainerView) currentView).hideSurfaceView();
                cameraHandler.stopCamera(null);
            }
            eventSender.sendHideKeyBoardEmojiPanel(true);
            showCallWaitCloseMenu();
            if (currentView != null) {
                currentView.waitClose();
            }
        }

    }

    public void handleShowCallingView(DuduContact duduContact){
        Utils.debug("CallService handleShowCallingView");
        synchronized (this) {
            begin();
            this.contact=duduContact;
            showSurfaceView();
            cameraHandler.startCamera(null, false, true);
            if (CallState.getInstance().isStatus(CallState.Status.Living) || CallState.getInstance().isStatus(CallState.Status.ChatLiving)) {
                // 防止接通太快,而呼叫界面才开始调用, 这时就不能再显示呼叫页面了
                handleStartLiving();
            } else {
                voipAndroidManager.setLocalVideo(VoipAndroid.WindowSizeLevel.LARGE,-1);
                showCallingView(duduContact);
            }
        }
    }

    public void handleReceiveIncoming() {
        synchronized (this) {
            begin();
            showSurfaceView();
            contact=contactCacheManager.getDuduContact(CallState.getInstance().getPeerId());
            voipAndroidManager.setLocalVideo(VoipAndroid.WindowSizeLevel.LARGE,-1);
            showResponseView();
            isCalling = true;
            isLiving = false;
        }
    }

    private void handleStartLiving() {
        synchronized (this) {
            Utils.debug("CallService handleStartLiving");
            liveActivity.clearFixTip();

            isCalling = false;

            showLiveView();
            if (livePreview != null) {
                livePreview.handleStartLiving();
            }

//            liveActivity.switch2Chat();
//            showLiveChatContainerView();
//            if(currentView instanceof LiveChatContainerView){
//                isLiving = false;
//                isCalling = false;
//                liveActivity.clearFixTip();
//                CallState.getInstance().setStatus(CallState.Status.ChatLiving);
//                asyncSwitchLive();
//                ((LiveChatContainerView) currentView).handleStartLive();
//            }
            if (!CallState.getInstance().isPeerCameraOpen()
                    && CallState.getInstance().isPeerManualCloseCamera()
                    && CallState.getInstance().isStatus(CallState.Status.ChatLiving)
                    /*&& CallState.getInstance().isVideoCall()*/) {
                Utils.debugFormat("CallService handleReceiveLiving peer camera open :%s ;peer manual close camera:%s;status : %s;video call:%s"
                        , CallState.getInstance().isPeerCameraOpen()
                        , CallState.getInstance().isPeerManualCloseCamera()
                        , CallState.getInstance().getStatus()
                        , CallState.getInstance().isVideoCall()
                );
                toastUtils.toast(getContext().getString(R.string.handwin_other_camera_off));
            }
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceiveConnectionChanged(ConnectionEvent event) {
        synchronized (this) {
            CallState callState = CallState.getInstance();
            if (livePreview != null /*&& callState.isVideoCall()*/ && callState.isPeerCameraOpen()) {
                livePreview.handleConnectionChanged(event.getData());
            }
        }
    }
    public void handleCloseLive(boolean hideView) {
        isLiving = false;
        isCalling = false;
        setChatLiving(false);
        liveActivity.clearFixTip();
        if (hideView) {
            hideCurrentView();
            hideSurfaceView();
        }
        end(hideView);
    }

    public void handleShowChatLive() {
        if(currentView instanceof LiveChatContainerView){
            return;
        }
        Utils.debug("CallService handleShowChatLive");
        isLiving = false;
        isCalling = false;
        liveActivity.clearFixTip();
        showLiveChatContainerView();
        ((LiveChatContainerView)currentView).showLivingView();
        CallState.getInstance().setStatus(CallState.Status.ChatLiving);
        asyncSwitchLive();
    }

    void asyncSwitchLive() {
        BackgroundExecutor.execute(this::asyncSwitchLive_,"",0,"asyncSwitchLive", BackgroundExecutor.ThreadType.NETWORK);
    }
    void asyncSwitchLive_() {
        CallService.getInstance().onLiveSwitch();
    }

    public void handleLiveChatViewTranslationY(int translationY) {
        if (currentView instanceof LiveChatContainerView) {
            View liveChatView = (View) currentView;
            liveChatView.setTranslationY(translationY);
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onUserHangup(UserHangupEvent event) {
        handleHangup(getResources().getString(R.string.handwin_cancel_call),getResources().getColor(R.color.handwin_B2));
    }

    private void livePreviewPeerCameraStateChanged(){
        if (CallState.getInstance().isNotStatus(CallState.Status.Living)&&CallState.getInstance().isNotStatus(CallState.Status.ChatLiving)) {
            return;
        }
        if(currentView != null) {
            currentView.onStateChanged();
        }
        IOpenGLView currentOpenGLView = previewActivity.getCurrentOpenGLView();
        if(currentOpenGLView !=null && currentOpenGLView instanceof IAbstractLivePreview) {
            ((IAbstractLivePreview) currentOpenGLView).handlePeerCameraStateChanged();
        }
    }

    /**
     * 收到对方的视频第一帧的时候
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceiveFirstVideoFrame(LiveFirstVideoFrameEvent event) {
        Utils.debug("CallService onReceiveFirstVideoFrame");
        CallState.getInstance().setPeerCameraOpen(true);
        livePreviewPeerCameraStateChanged();
    }

    /**
     * 当对方靠近手机的时候
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onPeerProximityChange(LivePeerProximityChangeEvent event) {
        livePreviewPeerCameraStateChanged();
        if(currentView!=null){
            currentView.onPeerProximityChanged();
        }
    }

    /**
     * 当对方的摄像打开或者关闭的时候
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceivePeerCameraChanged(LivePeerCameraChangeEvent event) {
        livePreviewPeerCameraStateChanged();

    }

    /**
     * 当我的相机打开或关闭时
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceiveMyCameraChanged(LiveMyCameraChangeEvent event) {
        IOpenGLView currentOpenGLView = previewActivity.getCurrentOpenGLView();
        if (currentOpenGLView != null) {
            if (currentOpenGLView instanceof IAbstractLivePreview) {
                ((IAbstractLivePreview) currentOpenGLView).handleMyCameraChanged();
            }
        }
        if (currentView != null) {
            currentView.onStateChanged();
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceiveTalkTime(LiveDurationTimeEvent event) {
        long durationTime = event.getDuration();
        if (currentView instanceof IShowTime) {
            ((IShowTime) currentView).showTime(durationTime);
        }
    }

    @Subscribe
    public void onStateChange(LiveStateChangeEvent event){
        IOpenGLView currentOpenGLView = previewActivity.getCurrentOpenGLView();
        if(currentOpenGLView!=null && currentOpenGLView instanceof IAbstractLivePreview){
            ((IAbstractLivePreview)currentOpenGLView).onStateChange();
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceiveLiving(LivingStartEvent event) {
        Utils.debug("CallService onReceiveLiveConneted " + CallState.getInstance().getStatus());
        handleStartLiving();
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onCallTimeoutHangup(CallTimeoutHangupEvent event) {
        handleHangup(getResources().getString(R.string.handwin_peer_not_respond),getResources().getColor(R.color.handwin_B2));
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceiveCallBusy(LiveCallBusyEvent event) {
        handleHangup(getResources().getString(R.string.handwin_peer_in_calling),getResources().getColor(R.color.handwin_B2));
    }

    public void onReceiveCallRejectedByPeer() {
        handleHangup(getResources().getString(R.string.handwin_peer_reject_call),getResources().getColor(R.color.handwin_B2));
    }

    public boolean isLiving() {
        return isLiving;
    }

    public boolean isCalling() {
        return isCalling;
    }

    public boolean isInVideoChatting() {
        return inVideoChatting;
    }

    @Subscribe
    public void onExitSingleChatPresentation(ExitSingleChatPresentationEvent event) {
        setVisibility(View.VISIBLE);
        if (currentView instanceof LiveChatContainerView) {
            currentView.show();
            ((LiveChatContainerView) currentView).showSurfaceView();
        }
    }

    @Subscribe
    public void onEnterSingleChatPresentation(EnterSingleChatPresentationEvent event) {
        if (currentView instanceof LiveChatContainerView) {
            currentView.hide();
            ((LiveChatContainerView) currentView).hideSurfaceView();
        }
    }

    public void switch2Float() {
        hideSurfaceView();
        this.end(true);
    }
    public void switch2Live() {
        begin();
    }

    public void onPPTImageChooseResult(int resultCode, Intent data) {
        Utils.debugFormat("SlideDebugTest onPPTImageChooseResult in container");
        if (currentView instanceof LivingView) {
            ((LivingView)currentView).onPPTImageChooseResult(resultCode, data);
        }
    }

    public void onBackKeyPress() {
        livePreview.onBackKeyPress();
    }

    @Subscribe
    public void handleScreenShareOnOffEvent(ScreenShareEvent event){
        livePreview.screenShareOnOff(event.isOn());
    }
}
