package me.chatgame.uisdk.activity.view;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.TextView;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import me.chatgame.mobilecg.activity.view.BasePreviewContainerView;
import me.chatgame.mobilecg.activity.view.ChatCallingView;
import me.chatgame.mobilecg.activity.view.ChatLivingView;
import me.chatgame.mobilecg.activity.view.ChatPreview;
import me.chatgame.mobilecg.activity.view.ChatResponseView;
import me.chatgame.mobilecg.activity.view.interfaces.IChatPreview;
import me.chatgame.mobilecg.activity.view.interfaces.ILiveActivity;
import me.chatgame.mobilecg.activity.view.interfaces.IView;
import me.chatgame.mobilecg.adapter.AnimationListenerAdapter;
import me.chatgame.mobilecg.call.CallState;
import me.chatgame.mobilecg.events.ConnectionEvent;
import me.chatgame.mobilecg.events.LiveChatPopupMenuEvent;
import me.chatgame.mobilecg.events.LivePeerCameraChangeEvent;
import me.chatgame.mobilecg.events.UserHangupEvent;
import me.chatgame.mobilecg.handler.CameraHandler;
import me.chatgame.mobilecg.handler.SystemStatus;
import me.chatgame.mobilecg.handler.interfaces.ICamera;
import me.chatgame.mobilecg.handler.interfaces.ISystemStatus;
import me.chatgame.mobilecg.util.ReflectInterfaceProxy;
import me.chatgame.mobilecg.util.ToastUtils;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.interfaces.IToastUtils;
import me.chatgame.mobilecg.views.IconFontTextView;
import me.chatgame.uisdk.R;

/**
 * Created by star on 16/6/8.
 */
public class LiveChatContainerView extends BasePreviewContainerView<IChatPreview> implements IView {
    private IView currentView;

    FrameLayout videoContainer;
    ViewGroup layoutChatTip;
    View txtTipLeft;
    View txtTipRight;
    View tipArea;
    TextView tipTv;
    View maskCover;
    View videoRegion;
    IconFontTextView liveChatTipsIcon;

    IChatPreview chatPreview;
    ICamera cameraHandler;
    ISystemStatus systemStatus;
    IToastUtils toastUtils;

    ILiveActivity liveActivity;

    private int videoRegionH;
    private Animation transAnim;


    private boolean alreadyInflated_ = false;

    public LiveChatContainerView(Context context) {
        super(context);
        init_();
    }

    public LiveChatContainerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init_();
    }

    public LiveChatContainerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init_();
    }

    public static LiveChatContainerView build(Context context) {
        LiveChatContainerView instance = new LiveChatContainerView(context);
        instance.onFinishInflate();
        return instance;
    }

    /**
     * The mAlreadyInflated_ hack is needed because of an Android bug
     * which leads to infinite calls of onFinishInflate()
     * when inflating a layout with a parent and using
     * the <merge /> tag.
     *
     */
    @Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_layout_chat_live_preview_container, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    private void init_() {
        liveActivity = ((ILiveActivity) ReflectInterfaceProxy.newInstance(ILiveActivity.class, getContext()));
    }

    public static LiveChatContainerView build(Context context, AttributeSet attrs) {
        LiveChatContainerView instance = new LiveChatContainerView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static LiveChatContainerView build(Context context, AttributeSet attrs, int defStyleAttr) {
        LiveChatContainerView instance = new LiveChatContainerView(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        videoRegion = hasViews.findViewById(R.id.video_region);
        txtTipRight = hasViews.findViewById(R.id.txt_icon_tip_right);
        tipArea = hasViews.findViewById(R.id.live_chat_tip_area);
        tipTv = ((TextView) hasViews.findViewById(R.id.live_chat_tip));
        txtTipLeft = hasViews.findViewById(R.id.txt_icon_tip_left);
        liveChatTipsIcon = ((IconFontTextView) hasViews.findViewById(R.id.live_chat_tip_icon));
        maskCover = hasViews.findViewById(R.id.popup_menu_mask_cover);
        layoutChatTip = ((ViewGroup) hasViews.findViewById(R.id.layout_chat_tip));
        videoContainer = ((FrameLayout) hasViews.findViewById(R.id.chat_live_surface_view_container));
        if (maskCover!= null) {
            maskCover.setOnClickListener(view -> LiveChatContainerView.this.maskCoverClick()
            );
        }
        afterViews();
    }
    
    
    void afterViews() {
        init();
        eventSender.register(this);
    }

    private void init() {
        systemStatus = SystemStatus.getInstance_() ;
        cameraHandler = CameraHandler.getInstance_(getContext()) ;
        toastUtils = ToastUtils.getInstance_(getContext()) ;

        chatPreview = ChatPreview.getInstance_(getContext()) ;
    }

    @Override
    protected IChatPreview createOpenGlViewManager() {
        return chatPreview;
    }

    @Override
    protected ViewGroup getSurfaceViewContainer() {
        return videoContainer;
    }

    private void hideCurrentView() {
        if (currentView != null) {
            if (currentView instanceof BasePreviewContainerView) {
                ((BasePreviewContainerView) currentView).hideSurfaceView();
            }
            currentView.hide();
            currentView.exit();

            if (currentView instanceof View) {
                removeView((View) currentView);
            }

            currentView = null;
        }
    }

    private void showView(View view, int height) {
        Utils.debugFormat("CallService chat live ShowView %s", view.getClass().getName());
        LayoutParams lp = new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, height);
        addView(view, lp);
        handleConnectionChanged(CallState.getInstance().isConnBad());
    }

    public void showCallingView() {
        resetUi();
        hideCurrentView();

        ChatCallingView chatCallingView = ChatCallingView.build(getContext());
        showView(chatCallingView, ViewGroup.LayoutParams.MATCH_PARENT);
        chatCallingView.show();

        currentView = chatCallingView;
        videoRegion.setBackgroundColor(Color.TRANSPARENT);
        // do transition animation for video container
        transAnim = AnimationUtils.loadAnimation(getContext(), R.anim.handwin_slide_in_from_top);
        transAnim.setDuration(300);
        transAnim.setInterpolator(new DecelerateInterpolator());
        transAnim.setFillAfter(false);
        transAnim.setAnimationListener(new AnimationListenerAdapter() {
            @Override
            public void onAnimationEnd(Animation animation) {
                if (CallState.getInstance().isStatus(CallState.Status.Calling)) {
                    cameraHandler.startCamera(null, false, true);
                }
            }
        });
        videoContainer.startAnimation(transAnim);

    }

    private void cancelTransAnimation() {
        if (transAnim != null) {
            transAnim.cancel();
            transAnim = null;
        }
        videoRegion.setBackgroundColor(getResources().getColor(R.color.handwin_group_video_background));
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onUserHangup(UserHangupEvent event) {
        cancelTransAnimation();
    }

    public void showLivingView() {
        resetUi();
        hideCurrentView();
        ChatLivingView chatLivingView = ChatLivingView.build(getContext());
        showView(chatLivingView, ViewGroup.LayoutParams.MATCH_PARENT);
        chatLivingView.show();

        currentView = chatLivingView;

    }

    public void showResponseView() {
        resetUi();
        hideCurrentView();
        ChatResponseView chatResponseView = ChatResponseView.build(getContext());
        showView(chatResponseView, ViewGroup.LayoutParams.MATCH_PARENT);
        chatResponseView.resizeBody(videoRegionH);
        chatResponseView.show();

        currentView = chatResponseView;

    }

    public int resizeVideoRegion(int screenWidth) {
        ViewGroup.LayoutParams layoutParams = videoContainer.getLayoutParams();
        layoutParams.height = getVideoPreviewHeight(getContext(), screenWidth);
        videoRegionH = layoutParams.height;
        videoContainer.setLayoutParams(layoutParams);
        layoutChatTip.setLayoutParams(layoutParams);
        return layoutParams.height;
    }
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceiveConnectionChanged(ConnectionEvent event) {
        handleConnectionChanged(event.getData());
        chatPreview.handleConnectionChanged(event.getData());

    }

    private void handleConnectionChanged(boolean disconnected) {
        if(systemStatus.isTcpConnected()){
            txtTipLeft.setVisibility(View.INVISIBLE);
            txtTipRight.setVisibility(disconnected?View.VISIBLE:View.INVISIBLE);
        }else{
            txtTipLeft.setVisibility(disconnected?View.VISIBLE:View.INVISIBLE);
            txtTipRight.setVisibility(View.INVISIBLE);
        }
    }

    public static int getVideoPreviewHeight(Context context, int screenWidth) {
        int padding = context.getResources().getDimensionPixelSize(R.dimen.handwin_dimen_10);
        int videoWidth = (screenWidth - 3 * padding) / 2;
        int videoHeight = videoWidth * 3 / 2;
        int height = videoHeight + padding * 2;
        return height;
    }

    @Override
    public void show() {
        setVisibility(VISIBLE);
    }

    @Override
    public void hide() {
        setVisibility(GONE);
        resetUi();
    }

    private void resetUi() {
        maskCover.setVisibility(GONE);
        hideTip();
        setBackgroundColor(Color.TRANSPARENT);
    }


    @Override
    public void showCameraStatus(boolean cameraOpen) {

    }

    @Override
    public void onStateChanged() {

    }

    @Override
    public void onPeerProximityChanged() {

    }

    @Override
    public void exit() {
        eventSender.unregister(this);
        hideCurrentView();
    }

    @Override
    public void waitClose() {

    }

    public void handleStartLive() {
        UiThreadExecutor.runTask(this::handleStartLive_);
    }
    public void handleStartLive_() {
        chatPreview.invalidate();
        showLivingView();
        liveActivity.editorSwitch2Chat();
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onPopupMenuEvent(LiveChatPopupMenuEvent event) {
        setBackgroundColor(getResources().getColor(R.color.handwin_bg_chat_list));
        maskCover.setVisibility(VISIBLE);
        if (currentView != null) {
            currentView.hide();
        }
    }
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceivePeerCameraChanged(LivePeerCameraChangeEvent event) {
        if(!CallState.getInstance().isPeerCameraOpen() && event.isNeedToast()){
            toastUtils.toast(getContext().getString(R.string.handwin_other_camera_off));
        }

    }

    public void showTip(String tip,int iconColor) {
        liveChatTipsIcon.setTextColor(iconColor);
        tipArea.setVisibility(VISIBLE);
        tipTv.setText(tip);
    }

    public void hideTip() {
        tipArea.setVisibility(GONE);
    }

    void maskCoverClick() {
        eventSender.sendMessagePanelDismissEvent();
    }

    @Override
    public void showSurfaceView() {
        if (previewActivity.getCurrentOpenGLView() != chatPreview) {
            super.showSurfaceView();
        }
    }
}
