package me.chatgame.uisdk.activity.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import java.util.List;

import me.chatgame.mobilecg.MainApp;
import me.chatgame.mobilecg.activity.view.interfaces.IGroupViewActionListener;
import me.chatgame.mobilecg.adapter.GroupVideoWatcherAdapter;
import me.chatgame.mobilecg.bean.VideoWatcherItemAnimator;
import me.chatgame.mobilecg.database.entity.DuduGroup;
import me.chatgame.mobilecg.database.entity.DuduGroupContact;
import me.chatgame.mobilecg.handler.GroupVideoContactsHandler;
import me.chatgame.mobilecg.handler.GroupVideoManager;
import me.chatgame.mobilecg.handler.SystemStatus;
import me.chatgame.mobilecg.handler.VoipAndroidManager;
import me.chatgame.mobilecg.handler.interfaces.IGroupVideoContactsHandler;
import me.chatgame.mobilecg.handler.interfaces.IGroupVideoManager;
import me.chatgame.mobilecg.handler.interfaces.ISystemStatus;
import me.chatgame.mobilecg.handler.interfaces.IVoipAndroidManager;
import me.chatgame.mobilecg.listener.GroupVideoContactsListener;
import me.chatgame.mobilecg.model.MemberInfo;
import me.chatgame.mobilecg.util.DialogHandle;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.interfaces.IDialogHandle;
import me.chatgame.uisdk.R;

public class GroupVideoWatchView extends RelativeLayout implements GroupVideoContactsListener {

	RecyclerView recyclerGroupWatchers;
	TextView tvWatcherCount;
	TextView tvWatcherCountNew;
	View vCircleBackground;
	TextView txtNone;
    View rlJoinGroupVideo;
    View rlInviteJoinGroupVideo;

	ISystemStatus systemStatus;
	GroupVideoWatcherAdapter adapterWatchers;
	IVoipAndroidManager voipAndroidManager;
	IGroupVideoContactsHandler groupVideoContactsHandler;
    IDialogHandle dialogHandle;
    IGroupVideoManager groupVideoManager;

	MainApp app;

	private IGroupViewActionListener actionListener;
	LinearLayoutManager layoutManager;
	private int avatarWidth;
	private int avatarWidthHalf;
    private Object watcherLock=new Object();
	private DuduGroup group;

    private boolean alreadyInflated_ = false;

    public GroupVideoWatchView(Context context) {
        super(context);
        init_();
    }

    public GroupVideoWatchView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init_();
    }

    public GroupVideoWatchView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init_();
    }

    public static GroupVideoWatchView build(Context context) {
        GroupVideoWatchView instance = new GroupVideoWatchView(context);
        instance.onFinishInflate();
        return instance;
    }

    /**
     * The mAlreadyInflated_ hack is needed because of an Android bug
     * which leads to infinite calls of onFinishInflate()
     * when inflating a layout with a parent and using
     * the <merge /> tag.
     *
     */
    @java.lang.Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_view_group_watch_video, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    private void init_() {
    }

    public static GroupVideoWatchView build(Context context, AttributeSet attrs) {
        GroupVideoWatchView instance = new GroupVideoWatchView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static GroupVideoWatchView build(Context context, AttributeSet attrs, int defStyleAttr) {
        GroupVideoWatchView instance = new GroupVideoWatchView(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        tvWatcherCount = ((TextView) hasViews.findViewById(R.id.tv_watcher_count));
        rlInviteJoinGroupVideo = hasViews.findViewById(R.id.rl_invite_join_group_video);
        recyclerGroupWatchers = ((RecyclerView) hasViews.findViewById(R.id.recycler_group_watchers));
        tvWatcherCountNew = ((TextView) hasViews.findViewById(R.id.tv_watcher_count_new));
        vCircleBackground = hasViews.findViewById(R.id.v_circle_background);
        rlJoinGroupVideo = hasViews.findViewById(R.id.rl_join_group_video);
        txtNone = ((TextView) hasViews.findViewById(R.id.txt_none));
        if (rlInviteJoinGroupVideo!= null) {
            rlInviteJoinGroupVideo.setOnClickListener(view -> GroupVideoWatchView.this.inviteOthersClick()
            );
        }
        if (rlJoinGroupVideo!= null) rlJoinGroupVideo.setOnClickListener(view -> GroupVideoWatchView.this.joinGroupVideoClick()
        );
        {
            View view = hasViews.findViewById(R.id.rl_watcher_count);
            if (view!= null) {
                view.setOnClickListener(view1 -> GroupVideoWatchView.this.backToFirstPos()
                );
            }
        }
        afterViews();
    }



    public void setGroupVideoActionListener(
			IGroupViewActionListener actionListener) {
		this.actionListener = actionListener;
	}

	public void setGroup(DuduGroup group) {
		this.group = group;
	}

	void afterViews() {
		init();
		avatarWidth = app
				.getPxFromDp(R.dimen.handwin_group_video_watcher_item_avatar_w) / 2;
		avatarWidthHalf = avatarWidth / 2;
		tvWatcherCountNew.setTranslationY(avatarWidthHalf);

		layoutManager = new LinearLayoutManager(getContext(),
				LinearLayoutManager.HORIZONTAL, false);
		recyclerGroupWatchers.setLayoutManager(layoutManager);
		recyclerGroupWatchers.setAdapter(adapterWatchers);
		recyclerGroupWatchers.setItemAnimator(new VideoWatcherItemAnimator());
		adapterWatchers
				.setWatcherCountCallback(count -> playNumberChangeAnim(String
						.valueOf(count)));

		List<DuduGroupContact> duduGroupContacts = groupVideoContactsHandler.getAllWatchers(this.getGroupId());
		if (duduGroupContacts != null) {
			refreshWatchers(duduGroupContacts);
		}
	}

	private void init() {
		app = MainApp.getInstance();
		voipAndroidManager = VoipAndroidManager.getInstance_(getContext());
        systemStatus = SystemStatus.getInstance_() ;
        dialogHandle = DialogHandle.getInstance_() ;
        groupVideoContactsHandler = GroupVideoContactsHandler.getInstance_();
		groupVideoManager = GroupVideoManager.getInstance_();
        adapterWatchers = GroupVideoWatcherAdapter.getInstance_(getContext()) ;
    }

	@Override
	protected void onAttachedToWindow() {
		super.onAttachedToWindow();
		groupVideoContactsHandler.addListener(this);
	}

	@Override
	protected void onDetachedFromWindow() {
		super.onDetachedFromWindow();
		Utils.debug("GroupVideoWatch >>> onDetachedFromWindow");
		groupVideoContactsHandler.removeListener(this);
	}

	private void playNumberChangeAnim(String number) {
		tvWatcherCount.clearAnimation();
		tvWatcherCountNew.clearAnimation();
		tvWatcherCount.animate().alpha(0).translationY(-avatarWidthHalf)
				.setDuration(100).setListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                tvWatcherCount.setText(number);
            }
        });

		tvWatcherCountNew.animate().alpha(1).translationY(0).setDuration(330)
				.setStartDelay(70).setListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationStart(Animator animation) {
                tvWatcherCountNew.setText(number);
            }

            @Override
            public void onAnimationEnd(Animator animation) {
                resetAnim();
            }
        });
	}

	private void resetAnim() {
		tvWatcherCount.setTranslationY(0);
		tvWatcherCount.setAlpha(1);

		tvWatcherCountNew.setAlpha(0);
		tvWatcherCountNew.setTranslationY(avatarWidthHalf);
	}

	public void showQuitButton(boolean isShow) {
		rlJoinGroupVideo.setVisibility(isShow ? VISIBLE : INVISIBLE);
        rlInviteJoinGroupVideo.setVisibility(isShow ? INVISIBLE : VISIBLE);
	}

    void joinGroupVideoClick(){
        if (Utils.isFastDoubleClick()){
            return;
        }
        actionListener.joinGroupVideo();
    }

    void inviteOthersClick() {
        if (Utils.isFastDoubleClick()) {
            return;
        }
        actionListener.inviteOthers();
    }

	void backToFirstPos() {
		layoutManager.smoothScrollToPosition(recyclerGroupWatchers, null, 0);
		// recyclerGroupWatchers.smoothScrollToPosition(0);
	}

	/**
	 * 刷新当前观看者
	 *
	 * @param groupContacts
	 */
	public void refreshWatchers(List<DuduGroupContact> groupContacts) {
        synchronized (watcherLock) {
            for(int i =0 ;i< groupContacts.size();++i){
                DuduGroupContact duduGroupContact = groupContacts.get(i);
                if (duduGroupContact.getContactId().equals(groupVideoManager.
                        getGroupVideoInformation(duduGroupContact.getGroupId()).
                        getFromUserId())){
                    groupContacts.remove(i);
                    groupContacts.add(0,duduGroupContact);
                    break;
                }
            }
            adapterWatchers.addAll(groupContacts);
            checkWatcherNumbers();
        }
	}

	/**
	 * 移除所有观看者
	 */
	public void removeAllWatchers() {
        synchronized (watcherLock) {
            adapterWatchers.removeAll();
            checkWatcherNumbers();
        }
	}

	/**
	 * 检查是否需要显示为空提示
	 */
	private void checkWatcherNumbers() {
		boolean empty = (adapterWatchers.getItemCount() == 0);
		txtNone.setVisibility(empty ? VISIBLE : GONE);
		recyclerGroupWatchers.setVisibility(empty ? GONE : VISIBLE);
	}

	private boolean isAtHead() {
		int pComplete = layoutManager.findFirstCompletelyVisibleItemPosition();
		int p = layoutManager.findFirstVisibleItemPosition();
		return (pComplete <= 0) && (p <= 0);
	}

	@Override
	public void removeOneActor(MemberInfo memberInfo) {

	}

	@Override
	public void addOneActor(MemberInfo memberInfo) {

	}

	@Override
	public void addOneWatcher(DuduGroupContact groupContact) {
        UiThreadExecutor.runTask(()->addOneWatcher_(groupContact));
    }
	public void addOneWatcher_(DuduGroupContact groupContact) {
		if (groupContact.getGroupId().equals(getGroupId())) {
			synchronized (watcherLock) {
				Utils.debug("GroupVideo >> addOneWatcher " + groupContact.getShowName());
				adapterWatchers.addOne(groupContact);
				checkWatcherNumbers();
				if (isAtHead()) {
					layoutManager.scrollToPosition(0);
					// recyclerGroupWatchers.smoothScrollToPosition(0);
				}
			}
		}
	}

	@Override
	public void removeOneWatcher(DuduGroupContact groupContact) {
        UiThreadExecutor.runTask(()->removeOneWatcher_(groupContact));
    }
	public void removeOneWatcher_(DuduGroupContact groupContact) {
		if (groupContact.getGroupId().equals(getGroupId())) {
			synchronized (watcherLock) {
				Utils.debug("GroupVideo >> removeOneWatcher " + groupContact.getShowName());
				adapterWatchers.removeOne(groupContact);
				checkWatcherNumbers();
			}
		}
	}

	private String getGroupId() {
		if (this.group != null) {
			return group.getGroupId();
		}
		return systemStatus.getChattingGroup();
	}
}