package me.chatgame.uisdk.activity.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.widget.RelativeLayout;

import me.chatgame.mobilecg.util.AnimationBuilder;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.views.IconFontTextView;
import me.chatgame.uisdk.R;

public class GroupVideoWaitingView extends RelativeLayout {

	View viewBubbleOuter;
	View viewBubbleMiddle;
	IconFontTextView txtGroupVideoWait;

	private AnimatorSet animationSet;
	private boolean isAnimationCancel = false;
	private AnimationBuilder animationBuilder;

    private boolean alreadyInflated_ = false;

    public GroupVideoWaitingView(Context context) {
        super(context);
        init_();
    }

    public GroupVideoWaitingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init_();
    }

    public GroupVideoWaitingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init_();
    }

    public static GroupVideoWaitingView build(Context context) {
        GroupVideoWaitingView instance = new GroupVideoWaitingView(context);
        instance.onFinishInflate();
        return instance;
    }

    /**
     * The mAlreadyInflated_ hack is needed because of an Android bug
     * which leads to infinite calls of onFinishInflate()
     * when inflating a layout with a parent and using
     * the <merge /> tag.
     *
     */
    @Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_view_group_video_waiting, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    private void init_() {
    }

    public static GroupVideoWaitingView build(Context context, AttributeSet attrs) {
        GroupVideoWaitingView instance = new GroupVideoWaitingView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static GroupVideoWaitingView build(Context context, AttributeSet attrs, int defStyleAttr) {
        GroupVideoWaitingView instance = new GroupVideoWaitingView(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        viewBubbleMiddle = hasViews.findViewById(R.id.view_bubble_middle);
        viewBubbleOuter = hasViews.findViewById(R.id.view_bubble_outer);
        txtGroupVideoWait = ((IconFontTextView) hasViews.findViewById(R.id.txt_group_video_wait));
    }



    @Override
	protected void onAttachedToWindow() {
		super.onAttachedToWindow();
		isAnimationCancel = false;
	}

	@Override
	protected void onDetachedFromWindow() {
		super.onDetachedFromWindow();
		isAnimationCancel = true;
		showViewButtons(false);
	}

	public void showView(int viewHeight, AnimatorListenerAdapter animatorListenerAdapter) {
		clearShowAnimation();
		animationBuilder = AnimationBuilder.newInstance();
		ObjectAnimator translationY = ObjectAnimator.ofFloat(this, View.TRANSLATION_Y, 0 - viewHeight, 0);
		animationBuilder.addAnimator(translationY).setDuration(400);
		if (animatorListenerAdapter != null) {
			animationBuilder.addListener(animatorListenerAdapter);
		}
		animationBuilder.start();
		playAnimation();
	}

	public void clearShowAnimation() {
		if (animationBuilder != null) {
			animationBuilder.cancel();
			animationBuilder = null;
		}
	}

	void playAnimation() {
        UiThreadExecutor.runTask(this::playAnimation_,2500);
    }
	void playAnimation_() {
		showViewAnimation(new AnimatorListenerAdapter() {
			@Override
			public void onAnimationEnd(Animator animation) {
				playWaitAnimation();
			}
		});
	}

	private void playWaitAnimation() {
		int duration = 1500;
		float sS = 1.0f;
		float sM = 1.4f;
		float sOutM = 1.2f;
		animationSet = new AnimatorSet();
		ObjectAnimator animationOuterX = ObjectAnimator.ofFloat(viewBubbleOuter,
				View.SCALE_X, sS, sOutM);
		ObjectAnimator animationOuterY = ObjectAnimator.ofFloat(viewBubbleOuter,
				View.SCALE_Y, sS, sOutM);
		ObjectAnimator animationMiddleX = ObjectAnimator.ofFloat(viewBubbleMiddle,
				View.SCALE_X, sS, sM);
		ObjectAnimator animationMiddleY = ObjectAnimator.ofFloat(viewBubbleMiddle,
				View.SCALE_Y, sS, sM);
		ObjectAnimator animationAlphaMiddle = ObjectAnimator.ofFloat(viewBubbleMiddle,
				View.ALPHA, 0.1f, 0.2f, 0f);
		ObjectAnimator animationAlpahOuter = ObjectAnimator.ofFloat(viewBubbleOuter,
				View.ALPHA, 0f, 0.1f, 0f);

		animationOuterX.setDuration(duration);
		animationOuterY.setDuration(duration);
		animationMiddleX.setDuration(duration);
		animationMiddleY.setDuration(duration);
		animationAlphaMiddle.setDuration(duration);
		animationAlpahOuter.setDuration(duration);
		animationAlpahOuter.setStartDelay(duration / 5);
		animationSet.setInterpolator(new DecelerateInterpolator());
		animationSet.playTogether(animationOuterX, animationOuterY, animationMiddleX, animationMiddleY, animationAlphaMiddle, animationAlpahOuter);
		animationSet.addListener(new AnimatorListenerAdapter() {
			@Override
			public void onAnimationEnd(Animator animation) {
				super.onAnimationEnd(animation);
				if (!isAnimationCancel) {
					animationSet.start();
				}
			}
		});

		animationSet.start();
	}

	private void showViewButtons(boolean isShow) {
		txtGroupVideoWait.setVisibility(isShow ? VISIBLE : INVISIBLE);
		viewBubbleOuter.setVisibility(isShow ? VISIBLE : INVISIBLE);
		viewBubbleMiddle.setVisibility(isShow ? VISIBLE : INVISIBLE);
	}

	private void showViewAnimation(AnimatorListenerAdapter animatorListenerAdapter) {
		showViewButtons(true);
		ObjectAnimator animationAlphaMiddle = ObjectAnimator.ofFloat(viewBubbleMiddle,
				View.ALPHA, 0, 0.2f);
		ObjectAnimator animationAlpahOuter = ObjectAnimator.ofFloat(viewBubbleOuter,
				View.ALPHA, 0f, 0.1f);
		ObjectAnimator animationGroupWait = ObjectAnimator.ofFloat(txtGroupVideoWait,
				View.ALPHA, 0f, 1);
		AnimationBuilder animationBuilder = AnimationBuilder.newInstance();
		animationBuilder.addAnimator(animationAlpahOuter).addAnimator(animationAlphaMiddle).addAnimator(animationGroupWait)
				.setDuration(1000).addListener(animatorListenerAdapter).start();
	}
}
