package me.chatgame.uisdk.activity.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import org.greenrobot.eventbus.Subscribe;

import me.chatgame.mobilecg.MainApp;
import me.chatgame.mobilecg.activity.view.BasePreviewContainerView;
import me.chatgame.mobilecg.activity.view.GroupVideoPreview;
import me.chatgame.mobilecg.activity.view.interfaces.IGroupVideoPreview;
import me.chatgame.mobilecg.activity.view.interfaces.IGroupVideoView;
import me.chatgame.mobilecg.activity.view.interfaces.IGroupViewActionListener;
import me.chatgame.mobilecg.events.OnCreateGroupVideoResult;
import me.chatgame.mobilecg.handler.CameraHandler;
import me.chatgame.mobilecg.handler.GroupVideoContactsHandler;
import me.chatgame.mobilecg.handler.SystemStatus;
import me.chatgame.mobilecg.handler.VoipAndroidManager;
import me.chatgame.mobilecg.handler.interfaces.ICamera;
import me.chatgame.mobilecg.handler.interfaces.IGroupVideoContactsHandler;
import me.chatgame.mobilecg.handler.interfaces.ISystemStatus;
import me.chatgame.mobilecg.handler.interfaces.IVoipAndroidManager;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.uisdk.R;

/**
 * Created by gongyingjun on 11/10/15.
 */
public class GroupVideoView extends BasePreviewContainerView<IGroupVideoPreview> implements IGroupVideoView {

	RelativeLayout relativeVideoPreview;

	ICamera cameraHandler;
	IGroupVideoPreview groupVideoPreview;
	IVoipAndroidManager voipAndroidManager;
	ISystemStatus systemStatus;
	IGroupVideoContactsHandler groupVideoContactsHandler;

	MainApp app;


	private IGroupViewActionListener actionListener;

    private boolean alreadyInflated_ = false;

    public GroupVideoView(Context context) {
        super(context);
    }

    public GroupVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public GroupVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public static GroupVideoView build(Context context) {
        GroupVideoView instance = new GroupVideoView(context);
        instance.onFinishInflate();
        return instance;
    }

    /**
     * The mAlreadyInflated_ hack is needed because of an Android bug
     * which leads to infinite calls of onFinishInflate()
     * when inflating a layout with a parent and using
     * the <merge /> tag.
     *
     */
    @Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_view_group_video, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    public static GroupVideoView build(Context context, AttributeSet attrs) {
        GroupVideoView instance = new GroupVideoView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static GroupVideoView build(Context context, AttributeSet attrs, int defStyleAttr) {
        GroupVideoView instance = new GroupVideoView(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        relativeVideoPreview = ((RelativeLayout) hasViews.findViewById(R.id.relative_video_preview));
        afterViews();
    }
    
    
	@Override
	protected ViewGroup getSurfaceViewContainer() {
		return relativeVideoPreview;
	}

	@Override
	protected IGroupVideoPreview createOpenGlViewManager() {
		return groupVideoPreview;
	}

	public void setGroupVideoActionListener(IGroupViewActionListener actionListener) {
		this.actionListener = actionListener;
	}


	void afterViews() {
		init();
		int itemM = app.getPxFromDp(R.dimen.handwin_group_video_item_m);
		int itemP = app.getPxFromDp(R.dimen.handwin_group_video_item_p);
		groupVideoPreview.setPadding(itemM, itemP);
	}

	private void init() {
		app = MainApp.getInstance();
		voipAndroidManager = VoipAndroidManager.getInstance_(getContext());
        systemStatus = SystemStatus.getInstance_();
        cameraHandler = CameraHandler.getInstance_(app) ;
        groupVideoContactsHandler = GroupVideoContactsHandler.getInstance_();

        groupVideoPreview = GroupVideoPreview.getInstance_(getContext()) ;
    }


	/**
     * 添加视频预览
     */
	public void addVideoPreview() {
		showSurfaceView();
		cameraHandler.cancelStopCamera();
		cameraHandler.startCamera(null, false, false);
	}

	/**
	 * 移除视频预览
	 */
	public void removeVideoPreview() {
		hideSurfaceView();
	}

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        eventSender.register(this);
    }

    @Override
	protected void onDetachedFromWindow() {
		super.onDetachedFromWindow();
        eventSender.unregister(this);
		removeVideoPreview();
	}

	public void groupCallFinish() {
		groupVideoPreview.groupCallFinish();
	}

	public void memberCameraStatusChange(int innerId, boolean isVideoPause) {
		groupVideoPreview.memberCameraStateChanged(innerId, !isVideoPause);
	}

	@Override
	public void memberCostumeUpdate(int innerId, String costume,
			boolean isCostumeEnable) {
		// 显示costume，并且本地不存在，则下载；否则直接更新。下载成功刷新所有同名costume
//        groupVideoPreview.memberUpdate(innerId, false, costume,
//                isCostumeEnable);
	}

    @Subscribe
    public void onGroupVideoInfoResult(OnCreateGroupVideoResult event){
        Utils.debug("GroupVideoView onGroupVideoInfoResult");
        groupVideoPreview.refreshAllMembers(event.getData());
    }
}
