package me.chatgame.uisdk.activity.view;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import me.chatgame.mobilecg.MainApp;
import me.chatgame.mobilecg.actions.GroupVideoActions;
import me.chatgame.mobilecg.actions.interfaces.IGroupVideoActions;
import me.chatgame.mobilecg.bean.GroupVideoRequestItem;
import me.chatgame.mobilecg.constant.ErrorCode;
import me.chatgame.mobilecg.database.entity.DuduContact;
import me.chatgame.mobilecg.database.entity.DuduGroup;
import me.chatgame.mobilecg.handler.GroupVideoManager;
import me.chatgame.mobilecg.handler.interfaces.IGroupVideoManager;
import me.chatgame.mobilecg.net.protocol.BaseResult;
import me.chatgame.mobilecg.util.BackgroundExecutor;
import me.chatgame.mobilecg.util.ContactCacheManager;
import me.chatgame.mobilecg.util.FaceUtils;
import me.chatgame.mobilecg.util.LocalMessageUtils;
import me.chatgame.mobilecg.util.NetworkUtils;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.interfaces.IContactCacheManager;
import me.chatgame.mobilecg.util.interfaces.IFaceUtils;
import me.chatgame.mobilecg.util.interfaces.ILocalMessageUtils;
import me.chatgame.mobilecg.util.interfaces.INetwork;
import me.chatgame.uisdk.R;

/**
 * Created by scofield on 16/6/23.
 */
public class GroupVideoRequestView extends RelativeLayout {

    TextView txtGroupVideoRequest;

    MainApp app;

    IFaceUtils faceUtils;
    IGroupVideoActions groupVideoActions;
    IGroupVideoManager groupVideoManager;
    ILocalMessageUtils localMessageUtils;
    IContactCacheManager contactCacheManager;
    INetwork netWorkUtils;

    private GroupVideoRequestItem groupVideoRequestItem;
    private DuduGroup group;
    private String roomId;
    private boolean alreadyInflated_ = false;

    public GroupVideoRequestView(Context context) {
        super(context);
        init_();
    }

    public GroupVideoRequestView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init_();
    }

    public GroupVideoRequestView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init_();
    }

    public static GroupVideoRequestView build(Context context) {
        GroupVideoRequestView instance = new GroupVideoRequestView(context);
        instance.onFinishInflate();
        return instance;
    }

    /**
     * The mAlreadyInflated_ hack is needed because of an Android bug
     * which leads to infinite calls of onFinishInflate()
     * when inflating a layout with a parent and using
     * the <merge /> tag.
     *
     */
    @Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_view_group_video_reqeust, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    private void init_() {
        init();
    }

    public static GroupVideoRequestView build(Context context, AttributeSet attrs) {
        GroupVideoRequestView instance = new GroupVideoRequestView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static GroupVideoRequestView build(Context context, AttributeSet attrs, int defStyleAttr) {
        GroupVideoRequestView instance = new GroupVideoRequestView(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        txtGroupVideoRequest = ((TextView) hasViews.findViewById(R.id.txt_group_video_request));
        {
            View view = hasViews.findViewById(R.id.btn_request_ignore);
            if (view!= null) {
                view.setOnClickListener(view1 -> GroupVideoRequestView.this.btnRequestIgnoreClick()
                );
            }
        }
        {
            View view = hasViews.findViewById(R.id.btn_request_confirm);
            if (view!= null) {
                view.setOnClickListener(view1 -> GroupVideoRequestView.this.btnRequestConfirmClick()
                );
            }
        }
    }

    void init() {
        app = MainApp.getInstance();
        groupVideoActions = GroupVideoActions.getInstance_(getContext(), this);
        netWorkUtils = NetworkUtils.getInstance(getContext());
        faceUtils = FaceUtils.getInstance_(getContext());
        contactCacheManager = ContactCacheManager.getInstance_(getContext());
        localMessageUtils = LocalMessageUtils.getInstance_(getContext());
        groupVideoManager = GroupVideoManager.getInstance_();
    }

    public void setGroupRequestInfo(DuduGroup group) {
        this.group = group;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public void showView() {
        showNextRequestInfo();
    }

    private void fillGroupRequestView(GroupVideoRequestItem groupVideoRequestItem) {
        this.groupVideoRequestItem = groupVideoRequestItem;
        DuduContact contact = contactCacheManager.getDuduContact(groupVideoRequestItem.getRequestUserId());
        txtGroupVideoRequest.setText(faceUtils.getFaceTextImage(
                String.format(app.getString(R.string.handwin_group_request_join_as_actor), contact.getShowName()),
                txtGroupVideoRequest));
    }

    void btnRequestConfirmClick() {
        if (Utils.isFastDoubleClick("request.confirm.click")) {
            return;
        }
        if (groupVideoRequestItem != null) {
            groupVideoManager.removeOneGroupVideoRequest(groupVideoRequestItem);
        }
        if (!netWorkUtils.isNetworkAvailable()) {
            app.toast(R.string.handwin_need_network);
            showNextRequestInfo();
            return;
        }
        Utils.debug("GroupVideoDebug btnRequestConfirmClick");
        acceptRequestInBackground();
    }

    void acceptRequestInBackground() {
        BackgroundExecutor.execute(this::acceptRequestInBackground_, BackgroundExecutor.ThreadType.NETWORK);
    }
    void acceptRequestInBackground_() {
        if (null != group && groupVideoRequestItem != null) {
            BaseResult baseResult = groupVideoActions.acceptJoinAsActorRequest(group.getGroupId(), groupVideoRequestItem.getRequestUserId());
            processAcceptResult(baseResult);
        }
    }

    void processAcceptResult(BaseResult baseResult) {
        UiThreadExecutor.runTask(()->processAcceptResult_(baseResult));
    }
    void processAcceptResult_(BaseResult baseResult) {
        if (baseResult != null) {
            int status = baseResult.getResultCode();
            Utils.debugFormat("GroupVideoDebug processAcceptResult result code %d", status);
            if (status == ErrorCode.GROUP_VIDEO_EXCEED_LIMIT) {
                app.toast(R.string.handwin_group_video_approve_exceed_limit);
            } else if (status == ErrorCode.GROUP_VIDEO_CREATER_HAS_EXIT) {
                groupVideoManager.clearAllGroupVideoRequest();
            } else if (status == ErrorCode.GROUP_REQUEST_HAS_EXIT) {
                app.toast(R.string.handwin_group_video_approve_left);
            } else if (status == ErrorCode.OK) {
            } else if (status == ErrorCode.GROUP_VIDEO_EXCEED_LIMIT) {
                localMessageUtils.sendGroupVideoExceedLimit(group, false);
            } else if (status == ErrorCode.GROUP_VIDEO_ACTOR_EXCEED_LIMIT) {
                localMessageUtils.sendGroupVideoExceedLimit(group, true);
            } else if (status == ErrorCode.NO_NETWORK) {
                app.toast(R.string.handwin_need_network);
            } else if (status == ErrorCode.NO_GROUP_CALL_NOW
                    || status == ErrorCode.GROUP_VIDEO_NOT_EXIST) {
                app.toast(R.string.handwin_group_video_not_exist);
            } else {
                app.toast(R.string.handwin_server_error);
            }
        } else {
            Utils.debug("GroupVideoDebug processAcceptResult result is null");
            app.toast(R.string.handwin_server_error);
        }
        showNextRequestInfo();
    }

    void btnRequestIgnoreClick() {
        Utils.debug("GroupVideoDebug btnRequestIgnoreClick");
        if (groupVideoRequestItem != null) {
            groupVideoManager.removeOneGroupVideoRequest(groupVideoRequestItem);
        }
        showNextRequestInfo();
    }

    private void showNextRequestInfo() {
        groupVideoRequestItem = groupVideoManager.getFirstGroupVideoRequest();
        Utils.debug("GroupVideoRequestView showNextRequestInfo " + groupVideoRequestItem);
        if (groupVideoRequestItem != null) {
            if (isValidRequest(groupVideoRequestItem)) {
                this.setVisibility(VISIBLE);
                this.fillGroupRequestView(groupVideoRequestItem);
            } else {
                groupVideoManager.removeOneGroupVideoRequest(groupVideoRequestItem);
                showNextRequestInfo();
            }
        } else {
            this.setVisibility(GONE);
        }
    }

    private boolean isValidRequest(GroupVideoRequestItem groupVideoRequestItem) {
        if (TextUtils.isEmpty(roomId)) {
            return false;
        }
        if (groupVideoRequestItem == null) {
            return false;
        }

        if (!roomId.equals(groupVideoRequestItem.getRoomId())) {
            return false;
        }
        DuduContact contact = contactCacheManager.getDuduContact(groupVideoRequestItem.getRequestUserId());
        if (contact == null) {
            return false;
        }

        return true;
    }
}
