package me.chatgame.uisdk.activity.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Paint;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.widget.RecyclerView;
import android.text.Spannable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.palmwin.proxy.JsonProxy;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;
import java.util.List;

import me.chatgame.mobilecg.actions.GroupActions;
import me.chatgame.mobilecg.actions.GroupVideoActions;
import me.chatgame.mobilecg.actions.interfaces.IGroupActions;
import me.chatgame.mobilecg.actions.interfaces.IGroupVideoActions;
import me.chatgame.mobilecg.activity.GroupContactsAtSelectionActivity;
import me.chatgame.mobilecg.activity.view.interfaces.IChatEvent;
import me.chatgame.mobilecg.activity.view.interfaces.IGroupChatView;
import me.chatgame.mobilecg.activity.view.interfaces.IGroupVideoView;
import me.chatgame.mobilecg.activity.view.interfaces.IGroupViewActionListener;
import me.chatgame.mobilecg.activity.view.interfaces.ILiveActivity;
import me.chatgame.mobilecg.activity.view.interfaces.KeyboardStateListener;
import me.chatgame.mobilecg.adapter.GroupChatListAdapter;
import me.chatgame.mobilecg.bean.GroupVideoRequestItem;
import me.chatgame.mobilecg.call.CallService;
import me.chatgame.mobilecg.call.CallState;
import me.chatgame.mobilecg.call.CallState.Status;
import me.chatgame.mobilecg.constant.BroadcastActions;
import me.chatgame.mobilecg.constant.ContactRoleInGroupCall;
import me.chatgame.mobilecg.constant.ErrorCode;
import me.chatgame.mobilecg.constant.ExtraInfo;
import me.chatgame.mobilecg.constant.GroupCallCommandType;
import me.chatgame.mobilecg.constant.MessageType;
import me.chatgame.mobilecg.constant.ReqCode;
import me.chatgame.mobilecg.constant.SceneConstant;
import me.chatgame.mobilecg.database.entity.BaseContact;
import me.chatgame.mobilecg.database.entity.DuduContact;
import me.chatgame.mobilecg.database.entity.DuduGroup;
import me.chatgame.mobilecg.database.entity.DuduGroupContact;
import me.chatgame.mobilecg.database.entity.DuduMessage;
import me.chatgame.mobilecg.events.GroupCallCommand;
import me.chatgame.mobilecg.events.GroupDismissEvent;
import me.chatgame.mobilecg.events.GroupInfoUpdateEvent;
import me.chatgame.mobilecg.events.GroupRefreshEvent;
import me.chatgame.mobilecg.events.GroupVideoActorApplyEvent;
import me.chatgame.mobilecg.events.GroupVideoActorApprovedEvent;
import me.chatgame.mobilecg.events.GroupVideoEvent;
import me.chatgame.mobilecg.events.GroupVideoJoinEvent;
import me.chatgame.mobilecg.events.GroupVideoResultEvent;
import me.chatgame.mobilecg.events.MessageUpdateEvent;
import me.chatgame.mobilecg.handler.GroupVideoContactsHandler;
import me.chatgame.mobilecg.handler.GroupVideoManager;
import me.chatgame.mobilecg.handler.SystemStatus;
import me.chatgame.mobilecg.handler.interfaces.IGroupVideoContactsHandler;
import me.chatgame.mobilecg.handler.interfaces.IGroupVideoManager;
import me.chatgame.mobilecg.handler.interfaces.ISystemStatus;
import me.chatgame.mobilecg.listener.DialogCallback;
import me.chatgame.mobilecg.model.MemberInfo;
import me.chatgame.mobilecg.model.PraiseVideoExtra;
import me.chatgame.mobilecg.model.VideoMessageData;
import me.chatgame.mobilecg.model.VideoMessageExtra;
import me.chatgame.mobilecg.net.protocol.CreateGroupVideoResult;
import me.chatgame.mobilecg.net.protocol.GroupVideoResult;
import me.chatgame.mobilecg.net.protocol.VideoSceneInfo;
import me.chatgame.mobilecg.richedit.TagAt;
import me.chatgame.mobilecg.sdk.CGSDKClientImpl;
import me.chatgame.mobilecg.spans.ApngSpan;
import me.chatgame.mobilecg.util.AnimationBuilder;
import me.chatgame.mobilecg.util.BackgroundExecutor;
import me.chatgame.mobilecg.util.ContactCacheManager;
import me.chatgame.mobilecg.util.FuncList;
import me.chatgame.mobilecg.util.JsonUtils;
import me.chatgame.mobilecg.util.LocalMessageUtils;
import me.chatgame.mobilecg.util.NetworkUtils;
import me.chatgame.mobilecg.util.ReflectInterfaceProxy;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.UtilsImpl;
import me.chatgame.mobilecg.util.interfaces.IContactCacheManager;
import me.chatgame.mobilecg.util.interfaces.IJsonUtils;
import me.chatgame.mobilecg.util.interfaces.ILocalMessageUtils;
import me.chatgame.mobilecg.util.interfaces.INetwork;
import me.chatgame.mobilecg.util.interfaces.IUtils;
import me.chatgame.mobilecg.views.IconFontTextView;
import me.chatgame.mobilecg.views.refresh.PullToRefreshRecyclerView;
import me.chatgame.uisdk.R;

/**
 * Created by star on 15/11/6.
 */
public class GroupChatView extends BaseChatView<GroupChatListAdapter, DuduGroup>
        implements
        KeyboardStateListener,
        IGroupViewActionListener,
        IGroupChatView,
        me.chatgame.mobilecg.viewinterfaces.IGroupVideoView {

    FrameLayout frameTitle;
    View layoutTitle;
    TextView txtPlaceHolder;
    View layoutTitleVideo;
    TextView txtTitleGroup;
    TextView txtTitleGroupVideo;
    ImageView imgEmpty;
    TextView txtGroupVideoInfo;
    RelativeLayout rlGroupVideoTips;
    IconFontTextView btnIconHangup;
    ImageView btnIconSwitch;
    ImageView btnMute;
    RelativeLayout rlGroupTitle;
    TextView txtAnalytics;
    IconFontTextView btnIconExit;
    IconFontTextView btnIconGroupCall;
    GroupVideoRequestView groupVideoRequestView;
    TextView txtIconBack;
    View titleSplit;

    IJsonUtils jsonUtils;
    ISystemStatus systemStatus;
    IGroupActions groupActions;
    IGroupVideoActions groupVideoActions;
    ILocalMessageUtils localMessageUtils;
    IGroupVideoManager groupVideoManager;
    INetwork networkUtils;
    IUtils utils;
    IGroupVideoContactsHandler groupVideoContactsHandler;
    IContactCacheManager contactCacheManager;

    GroupChatSendEditorView editorView;

    DuduGroup group;

    private int currentRole;

    private GroupVideoView groupVideoView;

    private GroupVideoWatchView groupVideoWatchView;

    private GroupVideoWaitingView groupVideoWaitingView;

    private GroupVideoResult groupVideoResult;

    private DuduGroupContact myGroupContactInfo;

    private boolean isFrontCamera = true;

    private ApngSpan apngSpan;


    private int titleHeight;
    private int actorHeight;

    private static final String BG_SERIAL_ANALYTICS_CALL = "bg_serial_analytics_call";

    private boolean alreadyInflated_ = false;
    private boolean isMute = false;

    public GroupChatView(Context context) {
        super(context);
        init_();
    }

    public GroupChatView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init_();
    }

    public GroupChatView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init_();
    }

    public static GroupChatView build(Context context) {
        GroupChatView instance = new GroupChatView(context);
        instance.onFinishInflate();
        return instance;
    }

    @Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_view_group_chat, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    private void init_() {
        init();
        chatEvent = ((IChatEvent) ReflectInterfaceProxy.newInstance(IChatEvent.class, getContext()));
        liveActivity = ((ILiveActivity) ReflectInterfaceProxy.newInstance(ILiveActivity.class, getContext()));
    }

    public static GroupChatView build(Context context, AttributeSet attrs) {
        GroupChatView instance = new GroupChatView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static GroupChatView build(Context context, AttributeSet attrs, int defStyleAttr) {
        GroupChatView instance = new GroupChatView(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        txtIconBack = ((TextView) hasViews.findViewById(R.id.txt_icon_back));
        newTipLayout = hasViews.findViewById(R.id.linear_new_tip);
        listDatas = ((PullToRefreshRecyclerView) hasViews.findViewById(R.id.list_datas));
        tvNewMessage = ((TextView) hasViews.findViewById(R.id.tv_new_message));
        ivChatLoading = ((ProgressBar) hasViews.findViewById(R.id.iv_chat_loading));
        btnIconGroupCall = ((IconFontTextView) hasViews.findViewById(R.id.txt_icon_group_video));
        rlGroupVideoTips = ((RelativeLayout) hasViews.findViewById(R.id.rl_group_video_tips));
        btnIconExit = ((IconFontTextView) hasViews.findViewById(R.id.txt_icon_exit));
        layoutTitleVideo = hasViews.findViewById(R.id.layout_title_video);
        btnIconSwitch = (ImageView) hasViews.findViewById(R.id.txt_icon_switch);
        btnMute = (ImageView) hasViews.findViewById(R.id.txt_mute);
        rlGroupTitle = ((RelativeLayout) hasViews.findViewById(R.id.rl_title));
        txtGroupVideoInfo = ((TextView) hasViews.findViewById(R.id.txt_group_video_info));
        layoutTitle = hasViews.findViewById(R.id.layout_title);
        frameTitle = ((FrameLayout) hasViews.findViewById(R.id.frame_title));
        txtTitleGroup = ((TextView) hasViews.findViewById(R.id.txt_title_group));
        imgEmpty = ((ImageView) hasViews.findViewById(R.id.img_empty));
        txtAnalytics = ((TextView) hasViews.findViewById(R.id.txt_analytics));
        txtPlaceHolder = ((TextView) hasViews.findViewById(R.id.txt_place_holder));
        titleSplit = hasViews.findViewById(R.id.title_split);
        txtTitleGroupVideo = ((TextView) hasViews.findViewById(R.id.txt_title_group_video));
        btnIconHangup = ((IconFontTextView) hasViews.findViewById(R.id.txt_icon_hangup));
        groupVideoRequestView = ((GroupVideoRequestView) hasViews.findViewById(R.id.rl_group_video_request));
        if (newTipLayout != null) {
            newTipLayout.setOnClickListener(view -> GroupChatView.this.newMessageTipClick()
            );
        }
        if (tvNewMessage != null) {
            tvNewMessage.setOnClickListener(view -> GroupChatView.this.newMessageTipsClicked()
            );
        }
        if (txtIconBack != null) {
            txtIconBack.setOnClickListener(view -> GroupChatView.this.titleBackClick()
            );
        }
        if (btnIconGroupCall != null) {
            btnIconGroupCall.setOnClickListener(view -> GroupChatView.this.groupTitleRightClick()
            );
        }
        if (btnIconExit != null) {
            btnIconExit.setOnClickListener(view -> GroupChatView.this.exitWatchGroupVideoClick()
            );
        }
        if (btnIconSwitch != null) {
            btnIconSwitch.setOnClickListener(view -> GroupChatView.this.groupVideoCameraSwitchClick()
            );
        }
        if (btnMute != null) {
            btnMute.setOnClickListener(view -> {
                isMute = !isMute;
                setVoiceState(isMute);
            });
        }
        {
            View view = hasViews.findViewById(R.id.rl_watch_group_video);
            if (view != null) {
                view.setOnClickListener(view1 -> GroupChatView.this.joinVideoGroup()
                );
            }
        }
        if (btnIconHangup != null) {
            btnIconHangup.setOnClickListener(view -> GroupChatView.this.groupVideoHangupClick()
            );
        }
        if (txtTitleGroup != null) {
            txtTitleGroup.setOnClickListener(v -> onTitleClick());
        }
        afterViews();
    }

    private void setVoiceState(boolean isMute) {
        // 当前是mute,
        if (isMute) {
            voipAndroidManager.muteMicrophone();
            btnMute.setImageResource(R.drawable.handwin_ic_mute_mic_press);
        } else {
            voipAndroidManager.unmuteMicrophone();
            btnMute.setImageResource(R.drawable.handwin_selector_mute_mic);
        }
    }


    public void setGroup(DuduGroup group) {
        txtTitleGroup.setText(faceUtils.getFaceTextImage("", txtTitleGroup));
        txtTitleGroupVideo.setText(faceUtils.getFaceTextImage("", txtTitleGroupVideo));
        if (group == null) {
            Thread.dumpStack();
        }
        this.group = group;
        if (adapter != null) {
            adapter.setChatEntity(group);
        }
        if (editorView != null) {
            editorView.setGroup(group);
        }
        if (group == null) {
            txtTitleGroup.setText("");
            enableTxtTitleGroupUnderline(false);
            txtTitleGroupVideo.setText("");
            return;
        }

        txtTitleGroup.setText(getTitleStr(txtTitleGroup));
        enableTxtTitleGroupUnderline(true);
        txtTitleGroupVideo.setText(getTitleStr(txtTitleGroupVideo));
        groupVideoRequestView.setGroupRequestInfo(group);
    }

    private void enableTxtTitleGroupUnderline(boolean enable) {
        if (enable) {
            txtTitleGroup.setPaintFlags(txtTitleGroup.getPaintFlags() | Paint.UNDERLINE_TEXT_FLAG);
        } else {
            txtTitleGroup.setPaintFlags((txtTitleGroup.getPaintFlags() | Paint.UNDERLINE_TEXT_FLAG) - Paint.UNDERLINE_TEXT_FLAG);
        }
    }

    /**
     * 标题文本内容
     *
     * @return
     */
    private Spannable getTitleStr(TextView v) {
        return faceUtils.getFaceTextImage(
                Utils.isNull(group) ? "" : group.getGroupName() + " ", v);
    }

    @Override
    protected void init() {
        super.init();
        networkUtils = NetworkUtils.getInstance(getContext());
        jsonUtils = JsonUtils.getInstance_();
        systemStatus = SystemStatus.getInstance_();
        utils = UtilsImpl.getInstance_(getContext());
        contactCacheManager = ContactCacheManager.getInstance_(getContext());
        localMessageUtils = LocalMessageUtils.getInstance_(getContext());
        groupVideoContactsHandler = GroupVideoContactsHandler.getInstance_();

    }

    @Override
    protected void afterViews() {
        groupActions = GroupActions.getInstance_(getContext(), this);
        groupVideoActions = GroupVideoActions.getInstance_(getContext(), this);
        groupVideoManager = GroupVideoManager.getInstance_();

        setBaseImgEmpty(imgEmpty);

        // 设置顶部字体为斜体
        TextPaint tp = txtTitleGroup.getPaint();
        tp.setTextSkewX(-0.25f);
        tp = txtTitleGroupVideo.getPaint();
        tp.setTextSkewX(-0.25f);
        super.afterViews();

        titleHeight = app.getPxFromDp(R.dimen.handwin_title_h);
        actorHeight = configHandler.getScreenWidth() * 2 / 3
                + app.getPxFromDp(R.dimen.handwin_group_video_btn_h);
        layoutTitle.setOnTouchListener((v1, event1) -> true);
        layoutTitleVideo.setOnTouchListener((v1, event1) -> true);
        rlGroupVideoTips.setOnTouchListener((v, event) -> true);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        // 取消通话统计显示
        BackgroundExecutor.cancelAll(BG_SERIAL_ANALYTICS_CALL, true);
    }

    @Override
    protected BaseSendEditorView createSendEditorView() {
        editorView = GroupChatSendEditorView.build(getContext());
        RelativeLayout.LayoutParams lp = new LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT);
        lp.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        editorView.setId(R.id.chat_send_editor);
        addView(editorView, lp);
        return editorView;
    }

    @Override
    protected GroupChatListAdapter createAdapter() {
        return GroupChatListAdapter.getInstance_(getContext());
    }

    @Override
    protected void initChatListAdapter(RecyclerView recyclerView,
                                       GroupChatListAdapter adapter) {
        adapter.init(recyclerView);
        adapter.removeAll();
        adapter.setChatListEventListener(this);
    }

    @Override
    public void refreshOfflineData() {
        if (this.group != null) {
            refreshData(group.getGroupId());
        }
    }

    @Override
    protected void loadData(boolean more, long messageId, int size) {
        if (group != null) {
            loadData(group.getGroupId(), more, messageId, size);
        } else {
            showChatDatas(more, null);
        }
    }

    @Override
    public boolean couldBack() {
        if (CallState.getInstance().isStatus(Status.Idle) || CallService.getInstance().isVideoFloat()) {
            return true;
        } else {
            return currentRole != ContactRoleInGroupCall.CONTACT_ACTOR;
        }
    }

    public void updateGroup() {
        if (group == null) {
            return;
        }
        DuduGroup group = groupCacheManager.getDuduGroup(this.group.getGroupId());
        if (group == null) {
            return;
        }
        this.group = group;
        if (editorView != null) {
            editorView.setGroup(group);
        }
        groupVideoRequestView.setGroupRequestInfo(group);
    }

    private boolean isSingleVideoChattingStart() {
        return CallState.getInstance().isStatus(Status.Calling) ||
                CallState.getInstance().isStatus(Status.Living) ||
                CallState.getInstance().isStatus(Status.Incoming) ||
                CallState.getInstance().isStatus(Status.ChatLiving);
    }

    /**
     * 创建群视频聊天
     */
    void groupTitleRightClick() {
        if (group == null) {
            return;
        }

        if (Utils.isFastDoubleClick("group_send_recorder_click") || Utils.isFastDoubleClick("chat.exit") ||
                isSingleVideoChattingStart()
                ) {
            return;
        }
        if (networkUtils.isNetworkDown()) {
            app.toast(R.string.handwin_need_network);
            return;
        }
        cancelRecordAudio();
        cancelRecordVideo();

        Utils.debugFormat("GroupVideo groupTitleRightClick currentRole %d", currentRole);
        boolean isIdle = (currentRole == ContactRoleInGroupCall.CONTACT_NO_GROUP_CALL);
        if (isIdle) {
            createGroupVideo();
        } else {
            showGroupVideoIncomingView();
        }
    }

    void exitWatchGroupVideoClick() {
        if (Utils.isFastDoubleClick()) {
            return;
        }
        exitGroupVideo(ContactRoleInGroupCall.CONTACT_WATCHER);
    }

    private void createGroupVideo() {
        setCurrentRole(ContactRoleInGroupCall.CONTACT_ACTOR_WAIT_RESPONSE);
        if (editorView != null && editorView.isRecorderViewShow()) {
            editorView.showOrHideRecorderView(false, false);
        }
        audioHandler.stopPlay();
        videoMessagePlayUtils.stopPlayCurrentVideoAudio();

        showGroupVideoWaitingView();
        initGroupVideoPanel();

        CallService.getInstance().startGroupVideo(group.getGroupId(), group.getRegion(), getMyInnerId());
    }

    /**
     * 作为表演者加入群聊
     */
    private void joinGroupVideoAsActor() {
        //等待成为表演者、观察看、或者从观看者转为表演者，均不能点击
        if (currentRole == ContactRoleInGroupCall.CONTACT_WATCHER_TO_ACTOR_WAIT_RESPONSE
                || currentRole == ContactRoleInGroupCall.CONTACT_WATCHER_WAIT_RESPONSE
                || currentRole == ContactRoleInGroupCall.CONTACT_ACTOR_WAIT_RESPONSE) {
            return;
        }

        if (this.currentRole != ContactRoleInGroupCall.CONTACT_WATCHER) {
            this.showGroupVideoWaitingView();
        }

        initGroupVideoPanel();

        if (editorView != null && editorView.isRecorderViewShow()) {
            editorView.showOrHideRecorderView(false, false);
        }

        audioHandler.stopPlay();
        videoMessagePlayUtils.stopPlayCurrentVideoAudio();

        if (currentRole == ContactRoleInGroupCall.CONTACT_WATCHER) {
            setCurrentRole(ContactRoleInGroupCall.CONTACT_WATCHER_TO_ACTOR_WAIT_RESPONSE);
        } else {
            setCurrentRole(ContactRoleInGroupCall.CONTACT_ACTOR_WAIT_RESPONSE);
        }
        CallService.getInstance().joinGroupVideo(group.getGroupId(), getMyInnerId());
    }

    private void hideGroupVideoWaitingView() {
        Utils.debug("showGroupVideoWaitingView false");
        if (groupVideoWaitingView != null) {
            groupVideoWaitingView.clearShowAnimation();
            this.removeView(groupVideoWaitingView);
            groupVideoWaitingView = null;
        }
    }

    private void hideKeyBoardAndFacePanel() {
        GroupChatSendEditorView editorView = this.editorView;
        if (editorView == null) {
            return;
        }

        if (editorView.isFaceShow()) {
            editorView.showOrHideFacesView(false, false);
            editorView.onKeyBoardHide();
            return;
        }
        if (editorView.isFunctionMenuViewShow()) {
            editorView.showOrHideFunctionMenuView(false, false);
            editorView.onKeyBoardHide();
            return;
        }

        if (!editorView.isKeyboardShow()) {
            return;
        }
        Utils.autoCloseKeyboard((Activity) getContext(),
                editorView.getEditText());
        editorView.showOrHideFacesView(false);
        EditText editText = editorView.getEditText();
        if (editText != null) {
            editText.clearFocus();
        }
    }


    /**
     * 作为观看者加入群视频
     */
    void joinVideoGroup() {
        DuduGroup group = this.group;
        if (group == null) {
            return;
        }
        if (Utils.isFastDoubleClick("chat.exit") || isSingleVideoChattingStart()) {
            return;
        }
        if (networkUtils.isNetworkDown()) {
            app.toast(R.string.handwin_need_network);
            return;
        }

        if (editorView != null && editorView.isRecorderViewShow()) {
            editorView.showOrHideRecorderView(false, false);
        }

        audioHandler.stopPlay();
        videoMessagePlayUtils.stopPlayCurrentVideoAudio();

        this.setCurrentRole(ContactRoleInGroupCall.CONTACT_WATCHER_WAIT_RESPONSE);

        initGroupVideoPanel();

        showGroupVideoWaitingView();

        CallService.getInstance().watchGroupVideo(group.getGroupId(), getMyInnerId());
    }

    /**
     * 挂断群视频, 退出当前群视频
     */
    void groupVideoHangupClick() {
        if (Utils.isFastDoubleClick("exit.groupVideo")) {
            return;
        }
        Utils.debug("GroupVideoDebug hangup groupVideo click");
        dialogHandle.showNormalDialog(getContext(),
                R.string.handwin_tip_dialog_title_normal,
                R.string.handwin_group_video_hangup_dialog_content, R.string.handwin_app_quit,
                R.string.handwin_app_cancel, true, new DialogCallback() {
                    @Override
                    public void onOkClick() {
                        showPresentationView(false);
                        groupVideoManager.clearAllGroupVideoRequest();
                        showGroupRequestView(false);
                        hangupGroupCall(true);
                    }

                    @Override
                    public void onCancelClick() {
                    }
                });

    }

    /**
     * 退出群视频
     *
     * @param needGetRoomInfo
     */
    private void hangupGroupCall(boolean needGetRoomInfo) {
        Utils.debugFormat("GroupVideo hangupGroupCall needGetRoomInfo : %s, currentRole %d",
                needGetRoomInfo, currentRole);
        CallService.getInstance().finishGroupCall();
        if (group != null && groupVideoManager.hasGroupVideo(group.getGroupId())) {
            setCurrentRole(ContactRoleInGroupCall.CONTACT_WAIT_JOIN);
        } else {
            setCurrentRole(ContactRoleInGroupCall.CONTACT_NO_GROUP_CALL);
        }
        if (needGetRoomInfo) {
            showGroupVideoIncomingView();
        } else {
            showNoGroupVideoCallView();
        }
        if (group != null) {
            groupVideoContactsHandler.clearAllMembers(group.getGroupId());
        }
        isMute = false;
        setVoiceState(isMute);
        resetSlideInfo();
        this.myGroupContactInfo = null;
        delayStopVideoAudio();
    }

    void delayStopVideoAudio() {
        UiThreadExecutor.runTask(this::delayStopVideoAudio_);
    }

    void delayStopVideoAudio_() {
        audioHandler.stopPlay();
        videoMessagePlayUtils.stopPlayCurrentVideoAudio();
    }

    /**
     * 设置当前群视频聊天角色类型
     *
     * @param role
     */
    private void setCurrentRole(int role) {
        Utils.debugFormat(
                "GroupVideo setCurrentRole currentRole %d, targetRole %d",
                currentRole, role);
        this.currentRole = role;
        this.groupVideoHandler.setCurrentRole(this.currentRole);
        if (groupVideoWatchView != null) {
            groupVideoWatchView
                    .showQuitButton(role == ContactRoleInGroupCall.CONTACT_WATCHER || role == ContactRoleInGroupCall.CONTACT_WATCHER_TO_ACTOR_WAIT_RESPONSE);
        }
        if (editorView != null && !editorView.isRecorderViewShow()) {
//            this.editorView.showTextSendButton(this.groupVideoHandler
//                    .isInGroupVideo());
            this.editorView.setVideoChatMode(currentRole == ContactRoleInGroupCall.CONTACT_ACTOR
                    || (currentRole == ContactRoleInGroupCall.CONTACT_WATCHER));
        }
        setTitleStyle(role);
    }

    void groupVideoCameraSwitchClick() {
        if (Utils.isFastDoubleClick()) {
            return;
        }
        LocalBroadcastManager.getInstance(this.getContext()).sendBroadcast(
                new Intent(BroadcastActions.LIVE_SWITCH_CAMERA));
        isFrontCamera = !isFrontCamera;
        CallState.getInstance().setGroupVideoFrontCamera(isFrontCamera);
    }


    @Override
    protected void doExit() {
        super.doExit();
        Utils.debug("GroupChatView doExit");
        if (group != null) {
            cleanUnreadAndRefreshConversation(group.getGroupId());
        }

        hangupGroupCall(false);
        BackgroundExecutor.cancelAll("id_send_costume", true);
        clearSceneInfo();
        setCurrentRole(ContactRoleInGroupCall.CONTACT_NO_GROUP_CALL);
        editorView = null;
        groupVideoResult = null;
        myGroupContactInfo = null;
        group = null;
    }

    @Override
    public void saveUnSendMessage(boolean clearEditText) {
        GroupChatSendEditorView groupSendEditorView = editorView;
        DuduGroup duduGroup = group;
        if (groupSendEditorView == null)
            return;
        EditText editChat = groupSendEditorView.getEditText();
        if (editChat == null || duduGroup == null) {
            return;
        }
        String message = editChat.getText().toString();
        // 保存未发送的文本内容
        asyncSaveUnsentMessage(duduGroup.getGroupId(), message);
        if (clearEditText) {
            // 重置输入框
            editChat.setText("");
        }
    }

    @Override
    public void onEnter(DuduGroup group) {
        super.onEnter(group);
        if (!group.isLoadContacts()) {
            Utils.debug("GroupDebug enter group here need load contacts");
            userHandler.addContactsIntoGroup(group, group.getGroupId(), false);
        }
        setGroup(group);
        notifyUtils.cancelUserNotifications(group.getGroupId());
        showChatList();
        if (systemStatus.getChattingGroup() == null) {
            show(true);
            playEnterAnimation();
        } else {
            show(false);
        }
        voipAndroidManager.clearAllPlayingVideo();
        setAdapter();
        setReady(true);

        if (tempFirstLoadedMessages != null) {
//			Utils.debug("cgtest set group chat tempFirstLoadedMessages");
            showChatDatas(false, tempFirstLoadedMessages);
            tempFirstLoadedMessages = null;
        }

        showGroupVideoPanel(false);
        this.groupVideoResult = groupVideoManager
                .getGroupVideoInformation(group.getGroupId());
        if (groupVideoResult != null) {
            this.showGroupVideoIncomingView();
        } else {
            this.loadGroupVideoInfo();
        }
        if (groupVideoManager.hasGroupVideo(group.getGroupId())) {
            setCurrentRole(ContactRoleInGroupCall.CONTACT_WAIT_JOIN);
        }
        restartAllVideoPlaying();
        eventSender.register(this);

    }

    public void changeMessageStatus(String msg_uuid, long uuid,
                                    DuduMessage message) {
        if (MessageType.GROUP_VIDEO_PRAISE.equals(message.getMsgType())) {
            handlePraiseMessage(message);
        } else {
            super.changeMessageStatus(msg_uuid, uuid, message);
        }
    }

    void handlePraiseMessage(DuduMessage message) {
        BackgroundExecutor.execute(() -> handlePraiseMessage_(message), BackgroundExecutor.ThreadType.CALCULATION);
    }

    void handlePraiseMessage_(DuduMessage message) {
        PraiseVideoExtra extra = JsonProxy.fromJson(message.getMsgRaw(),
                PraiseVideoExtra.class);
        if (extra == null) {
            return;
        }
        long videoMsgId = extra.getVideo();
        int action = extra.getAction();
        DuduMessage videoMsg = getVideoMsgById(videoMsgId);
        refreshChatListAndConversation(message.getSender(), message,
                group.getSetting(), true);
        changeMessageExtra(videoMsg, action);
    }

    private void changeMessageExtra(DuduMessage data, int action) {
        VideoMessageData videoData = JsonProxy.fromJson(data.getMsgRaw(),
                VideoMessageData.class);
        if (videoData == null) {
            return;
        }
        VideoMessageExtra extra = videoData.getExtra();
        extra.setPraise(action);
        videoData.setExtra(extra);
        data.setMsgRaw(videoData.toJsonString());
        updateDuduMessage(data);
    }

    DuduMessage getVideoMsgById(long msgId) {
        return dbHandler.getDuduMessageByMsgId(msgId);
    }

    void updateDuduMessage(DuduMessage data) {
        dbHandler.updateDuduMessage(data);
    }

    void notifyVideoChanged() {
        UiThreadExecutor.runTask(this::notifyVideoChanged_);
    }

    void notifyVideoChanged_() {
        adapter.notifyDataSetChanged();
    }

    @Override
    public void batchSend(DuduMessage message, BaseContact[] baseContacts) {
        DuduGroup duduGroup = group;
        if (duduGroup != null) {
            duduMessageAction.batchSendMessage(baseContacts, message,
                    duduGroup != null ? duduGroup.getGroupId() : "");
        }
    }

    public void onAtContactsSelectedForAt(int resultCode, Intent data) {
        if (!isPresentationViewShow()) {
            if (editorView != null) {
                editorView.onAtContactsSelected(resultCode, data);
            }
        }
    }

    public void onAtContactsSelectedForInvite(int resultCode, Intent data) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer
                .append(getContext().getString(R.string.handwin_group_video_invite));
        stringBuffer.append("    ");
        if (resultCode == Activity.RESULT_OK) {
            List<DuduContact> contacts = (List<DuduContact>) data
                    .getSerializableExtra(ExtraInfo.SELECTED_CONTACTS);
            if (contacts != null) {
                FuncList.from(contacts).iterate(
                        contact -> {
                            stringBuffer.append(new TagAt().setContact(contact)
                                    .getXml());
                        });
                editorView.sendTextMessage(stringBuffer.toString());
            }
        }
    }

    @Override
    protected EditText getEditText() {
        if (editorView == null)
            return null;
        return editorView.getEditText();
    }

    public void atOneContact(DuduContact contact) {
        if (editorView != null) {
            editorView.atOneContact(contact);
        }
    }

    @Override
    public void exitGroupVideo(int currentRole) {
        hangupGroupCall(true);
        frameTitle.setTranslationY(0);
        groupVideoResult = null;
    }

    private int lastGroupVideoViewHeight = 0;

    private void initGroupVideoPanel() {
        if (null == groupVideoView) {
            groupVideoView = GroupVideoView.build(this.getContext());
            groupVideoView.setId(R.id.id_group_video_preview);
            groupVideoView.setGroupVideoActionListener(this);
        }
        groupVideoView.getViewTreeObserver().addOnGlobalLayoutListener(() -> {
            if (groupVideoView == null || lastGroupVideoViewHeight == groupVideoView.getHeight()) {
                return;
            }
            lastGroupVideoViewHeight = groupVideoView.getHeight();
            if (editorView.isKeyboardShow()) {
                onKeyboardShow();
            } else {
                onKeyboardHide();
            }
        });
        initGroupVideoWatchPanel();
        frameTitle.bringToFront();
        isFrontCamera = true;
        hideKeyBoardAndFacePanel();
    }

    private void initGroupVideoWatchPanel() {
        if (null == groupVideoWatchView && groupVideoView != null) {
            groupVideoWatchView = GroupVideoWatchView.build(getContext());
            groupVideoWatchView.setId(R.id.id_group_video_watcher);
            groupVideoWatchView.setGroupVideoActionListener(this);
            groupVideoWatchView.setGroup(group);
        }
    }

    void delayChangePlaceHolder() {
        UiThreadExecutor.runTask(this::delayChangePlaceHolder_, 500);
    }

    void delayChangePlaceHolder_() {
        if (null == txtPlaceHolder || null == groupVideoView
                || null == groupVideoWatchView) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = txtPlaceHolder.getLayoutParams();
        layoutParams.height = groupVideoView.getHeight()
                + groupVideoWatchView.getHeight();
        txtPlaceHolder.setLayoutParams(layoutParams);
    }

    /**
     * 显示隐藏视频通话
     *
     * @param show
     */
    public void showGroupVideoPanel(boolean show) {
        Utils.debugFormat("GroupVideo showGroupVideoPanel show : %s", show);
        if (show) {
            if (groupVideoView == null) {
                initGroupVideoPanel();
            }

            ViewParent parent = groupVideoView.getParent();
            if (parent == this) {
                return;
            }

            if (parent instanceof ViewGroup) {
                ((ViewGroup) parent).removeView(groupVideoView);
            }

            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(
                    RelativeLayout.LayoutParams.MATCH_PARENT,
                    ViewGroup.LayoutParams.WRAP_CONTENT);
            lp.addRule(RelativeLayout.BELOW, R.id.frame_title);
            lp.height = actorHeight;
            this.addView(groupVideoView, lp);

            showGroupVideoWatchPanel();
            groupVideoView.addVideoPreview();
            expandPlaceHolderTop(true);
            frameTitle.bringToFront();
            isFrontCamera = true;
        } else {
            if (null != groupVideoView) {
                this.removeView(groupVideoView);
                groupVideoView.groupCallFinish();
                groupVideoView = null;
            }
            if (null != groupVideoWatchView) {
                this.removeView(groupVideoWatchView);
                groupVideoWatchView = null;
            }
            expandPlaceHolderTop(false);
        }

        setTitleStyle(currentRole);

    }

    /**
     * 显示观看者列表
     */
    private void showGroupVideoWatchPanel() {
        int btnHeight = app.getPxFromDp(R.dimen.handwin_group_video_btn_h);
        ViewParent parent = groupVideoWatchView.getParent();
        if (parent instanceof ViewGroup) {
            ((ViewGroup) parent).removeView(groupVideoWatchView);
        }

        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(
                RelativeLayout.LayoutParams.MATCH_PARENT, btnHeight);
        lp.addRule(RelativeLayout.ALIGN_BOTTOM, groupVideoView.getId());
        this.addView(groupVideoWatchView, lp);

        // 重新设置按钮样式
        groupVideoWatchView
                .showQuitButton(currentRole == ContactRoleInGroupCall.CONTACT_WATCHER);
        // 重新加载观看者列表
        List<DuduGroupContact> duduGroupContacts = groupVideoContactsHandler
                .getAllWatchers(systemStatus.getChattingGroup());
        if (null == duduGroupContacts) {
            duduGroupContacts = new ArrayList<>();
        }
        groupVideoWatchView.refreshWatchers(duduGroupContacts);

    }

    /**
     * 设置标题样式
     *
     * @param currentRole
     */
    private void setTitleStyle(int currentRole) {
        Utils.debug("GroupVideoTitle current " + currentRole);
        if (isActorStyle()) {
            // 表演者
            if (layoutTitleVideo.getVisibility() != VISIBLE) {
                layoutTitle.setVisibility(GONE);
                layoutTitleVideo.setVisibility(View.VISIBLE);
                txtIconBack.setVisibility(GONE);
                playTitleAnimation();
            }
        } else {
            if (currentRole == ContactRoleInGroupCall.CONTACT_WATCHER || currentRole == ContactRoleInGroupCall.CONTACT_WATCHER_TO_ACTOR_WAIT_RESPONSE) {
                btnIconExit.setVisibility(View.VISIBLE);
                btnIconGroupCall.setVisibility(View.INVISIBLE);
                btnIconGroupCall.setEnabled(false);

            } else if (currentRole == ContactRoleInGroupCall.CONTACT_WAIT_JOIN || currentRole == ContactRoleInGroupCall.CONTACT_WATCHER_WAIT_RESPONSE) {
                btnIconGroupCall.setEnabled(false);
                btnIconGroupCall.setVisibility(View.VISIBLE);
                btnIconGroupCall.setTextColor(getResources().getColor(R.color.handwin_bg_white_60));
                btnIconExit.setVisibility(View.GONE);
            } else {
                btnIconExit.setVisibility(View.GONE);
                btnIconGroupCall.setVisibility(View.VISIBLE);
                btnIconGroupCall.setEnabled(true);
                btnIconGroupCall.setTextColor(getResources().getColor(R.color.handwin_bg_white));
            }
            layoutTitle.setVisibility(VISIBLE);
            layoutTitleVideo.setVisibility(GONE);
            txtIconBack.setVisibility(VISIBLE);

            showLivingMenuButton(false);
        }
        changeTitleBackground(currentRole);
        //让状态栏文字下划线与能够点击事件同步
        enableTxtTitleGroupUnderline(!isPrepareInGroupVideo());
    }

    private void changeTitleBackground(int currentRole) {
        if (currentRole == ContactRoleInGroupCall.CONTACT_NO_GROUP_CALL || currentRole == ContactRoleInGroupCall.CONTACT_WAIT_JOIN) {
            layoutTitle.setBackgroundColor(getResources().getColor(R.color.handwin_color_title));
            getStatusbarColorSetter().setDefaultStatusBarColor();
            txtIconBack.setTextColor(getResources().getColor(R.color.handwin_bg_white));
            if (rlGroupVideoTips.getVisibility() != View.VISIBLE) {
                titleSplit.setVisibility(View.VISIBLE);
            }
        } else {
            layoutTitle.setBackgroundColor(getResources().getColor(R.color.handwin_group_video_background));
            getStatusbarColorSetter().setStatusBarBackgroundColor(getResources().getColor(R.color.handwin_group_video_background));
            txtIconBack.setTextColor(getResources().getColor(R.color.handwin_bg_white));
            titleSplit.setVisibility(View.INVISIBLE);
        }
    }

    private void showLivingMenuButton(boolean isShow) {
//		btnIconMute.setVisibility(isShow ? VISIBLE : GONE);
        btnIconHangup.setVisibility(isShow ? VISIBLE : GONE);
        btnIconSwitch.setVisibility(isShow ? VISIBLE : GONE);
        btnMute.setVisibility(isShow ? VISIBLE : GONE);
    }

    private void playTitleAnimation() {
        float hangupX = btnIconHangup.getX();
		float muteX = btnMute.getX();
        float switchX = btnIconSwitch.getX();

        AnimationBuilder titleAnimationBuilder = AnimationBuilder.newInstance();
        AnimationBuilder animationBuilder = AnimationBuilder.newInstance();
		ObjectAnimator muteAnimation = ObjectAnimator.ofFloat(btnMute, View.TRANSLATION_X, configHandler.getScreenWidth() - muteX, 0);
		muteAnimation.setDuration(500);
        ObjectAnimator switchAnimation = ObjectAnimator.ofFloat(btnIconSwitch, View.TRANSLATION_X, configHandler.getScreenWidth() - switchX, 0);
        switchAnimation.setDuration(550);
        ObjectAnimator hangupAnimation = ObjectAnimator.ofFloat(btnIconHangup, View.TRANSLATION_X, configHandler.getScreenWidth() - hangupX, 0);
        hangupAnimation.setDuration(600);
		animationBuilder.addAnimator(muteAnimation);
        animationBuilder.addAnimator(switchAnimation);
        animationBuilder.addAnimator(hangupAnimation);
        titleAnimationBuilder.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                // 动画做完，有可能加入失败
                if (isActorStyle()) {
                    showLivingMenuButton(true);
                    animationBuilder.start();
                } else {
                    setTitleStyle(currentRole);
                }
            }
        });
        titleAnimationBuilder.start();
    }

    public void titleBackClick() {
        if (Utils.isFastDoubleClick("chat.exit")) {
            return;
        }
        Utils.debug("GroupVideo titleBackClick currentRole " + currentRole);
        if (group == null) {
            return;
        }
        if (currentRole != ContactRoleInGroupCall.CONTACT_ACTOR) {
            exitGroupVideo(currentRole);
        }
        super.titleBackClick();
    }

    @Override
    public void showNoGroupVideoCallView() {
        Utils.debug("GroupVideoShowView showNoGroupVideoCallView");
        hideGroupVideoWaitingView();
        showSmallGroupVideoInviteTips(false);
        showGroupVideoPanel(false);
    }

    @Override
    public void showGroupVideoIncomingView() {
        Utils.debug("GroupVideoShowView showGroupVideoIncomingView");
        hideGroupVideoWaitingView();
        showGroupVideoPanel(false);
        this.showGroupVideoNotification();
    }

    @Override
    public void showGroupVideoWaitingView() {
        Utils.debug("GroupVideoShowView showGroupVideoWaitingView");
        if (groupVideoWaitingView == null) {
            groupVideoWaitingView = GroupVideoWaitingView.build(this.getContext());
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(
                    RelativeLayout.LayoutParams.MATCH_PARENT,
                    ViewGroup.LayoutParams.WRAP_CONTENT);
            groupVideoWaitingView.setId(R.id.id_group_video_waiting);
            lp.addRule(RelativeLayout.BELOW, R.id.frame_title);
            lp.height = this.actorHeight;
            this.addView(groupVideoWaitingView, lp);
            frameTitle.bringToFront();
        }

        //groupVideoWaitingView.showView(0, actorHeight, animatorListenerAdapter);
        groupVideoWaitingView.showView(actorHeight, new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                expandPlaceHolderTop(true);
            }
        });
        // 不显示其他的群组视频界面
        this.showSmallGroupVideoInviteTips(false);
    }

    @Override
    public void showGroupVideoView() {
        Utils.debug("GroupVideoShowView showGroupVideoView");
        cancelRecordAudio();
        cancelRecordVideo();
        this.hideGroupVideoWaitingView();
        this.showSmallGroupVideoInviteTips(false);
        showGroupVideoPanel(true);
    }

    /**
     * 单行显示群组视频邀请提示
     *
     * @param enable
     */
    private void showSmallGroupVideoInviteTips(boolean enable) {
        boolean show = (enable && (null != groupVideoResult));
        if (show == (rlGroupVideoTips.getVisibility() == VISIBLE)) {
            return;
        }
        int top = show
                ? (app.getPxFromDp(R.dimen.handwin_chat_top_message_h) + titleHeight)
                : titleHeight;
        if (show) {
            fillGroupVideoInfo(groupVideoResult.getFromUserId());
            titleSplit.setVisibility(View.INVISIBLE);
        }
        rlGroupVideoTips.setVisibility(show ? VISIBLE : GONE);
        changePlaceHolderTop(top);
    }


    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceiveActorApprovedEvent(GroupVideoActorApprovedEvent event) {
        Utils.debug("GroupVideoDebug onReceiveActorApprovedEvent " + event + " currentRole " + currentRole);
        if (this.isPrepareInGroupVideo() && event != null && isSameGroupVideo(event.getData())) {
            CallService.getInstance().setGroupVideoInfo(event.getData());
            processJoinGroupVideoResult(event.getData(), ErrorCode.OK, ContactRoleInGroupCall.CONTACT_ACTOR);
        } else {
            Utils.debug("GroupVideoDebug onReceiveActorApprovedEvent condition not match");
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceiveActorApplyEvent(GroupVideoActorApplyEvent event) {
        Utils.debug("GroupVideoDebug onReceiveActorApplyEvent " + event + " slideSceneMode " + isSlideSceneMode());
        if (event != null && currentRole == ContactRoleInGroupCall.CONTACT_ACTOR) {
            this.showGroupRequestView(true);
        }
    }

    private void showGroupRequestView(boolean show) {
        Utils.debug("GroupChatView showGroupRequestView " + show);
        if (show) {
            if (chatPresentationView == null || chatPresentationView.getVisibility() != View.VISIBLE) {
                GroupVideoRequestItem groupVideoRequestItem = groupVideoManager.getFirstGroupVideoRequest();
                Utils.debug("GroupVideoDebug showGroupRequestView " + groupVideoRequestItem);
                if (groupVideoResult != null) {
                    groupVideoRequestView.setRoomId(groupVideoResult.getRoomId());
                    groupVideoRequestView.showView();
                    groupVideoRequestView.bringToFront();
                }
            } else {
                chatPresentationView.showGroupRequestView(groupVideoResult, show);
            }

        } else {
            Utils.debug("GroupVideoDebug showGroupRequestView hide it");
            groupVideoRequestView.setVisibility(GONE);
        }
    }

    private void showGroupRequestViewFromPresentation(boolean show) {
        if (show) {
            if (groupVideoResult != null) {
                groupVideoRequestView.setRoomId(groupVideoResult.getRoomId());
                groupVideoRequestView.showView();
                groupVideoRequestView.bringToFront();
            }
        } else {
            groupVideoRequestView.setVisibility(GONE);
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void createGroupVideoStatus(GroupVideoEvent event) {
        Utils.debug("GroupVideo createGroupVideoStatus");
        boolean isCreateSuccess = false;
        if (event.getData() == null) {
            app.toast(R.string.handwin_need_network);
        } else {
            this.groupVideoResult = event.getData().getGroupVideoResult();
            if (event.getData().getResultCode() == ErrorCode.OK && groupVideoResult.getFromUserId().equals(configHandler.getUid())) {
                isCreateSuccess = true;
            }
            DuduContact contact = userHandler.getUserInfo(configHandler.getUid());
            if (isCreateSuccess) {
                this.updateGroupVideoInfo(event.getData().getGroupVideoResult(),
                        GroupCallCommandType.GROUP_CALL_INFO_CHANGED);
                groupVideoManager.addOneGroupVideoInformation(group.getGroupId(),
                        groupVideoResult);
                processRoleChange(currentRole, ContactRoleInGroupCall.CONTACT_ACTOR);
                if (configHandler.getUid().equals(event.getData().getGroupVideoResult().getFromUserId())) {
                    localMessageUtils.sendGroupVideoCreateMessage(group, contact,
                            true, System.currentTimeMillis());
                }
            } else {
                if (event.getData().getResultCode() == ErrorCode.GROUP_CALL_HAS_EXIST) {
                    // 群视频已经存在
                    //TODO 创建失败的提醒
                    localMessageUtils.sendGroupVideoCreateMessage(group, contact,
                            false, System.currentTimeMillis());
                } else {
                    localMessageUtils.sendGroupVideoCreateMessage(group, contact,
                            false, System.currentTimeMillis());
                }
            }
        }

        if (!isCreateSuccess) {
            this.showGroupVideoIncomingView();
            this.handleChangeFailedCase(ContactRoleInGroupCall.CONTACT_ACTOR, false);
        }
    }

    @Override
    public void createGroupVideoResp(int status, CreateGroupVideoResult result) {

    }

    @Override
    public void getGroupVideoInfoResp(DuduGroup group, GroupVideoResult result, int status) {
        UiThreadExecutor.runTask(() -> getGroupVideoInfoResp_(group, result, status));
    }

    @Override
    public void changeContactRoleResp(GroupVideoResult result, int status, int currentRole, int targetRole) {

    }

    @Override
    public void changeContactRoleResp(GroupVideoResult result, int status, int targetRole) {

    }

    public void getGroupVideoInfoResp_(DuduGroup group, GroupVideoResult result, int status) {
        if (status == ErrorCode.NO_NETWORK) {
            Utils.debug("GroupVideo getGroupVideoInfoResp with no network");
            return;
        }
        if (result == null) {
            Utils.debug("GroupVideo getGroupVideoInfoResp no group video info");
            return;
        }
        if (group == null || this.group == null) {
            Utils.debug("GroupVideo getGroupVideoInfoResp no group info");
            return;
        }
        if (!TextUtils.equals(this.group.getGroupId(), group.getGroupId())) {
            Utils.debug("GroupVideo not same group");
            return;
        }
        Utils.debugFormat("GroupVideo getGroupVideoInfoResp currentRole %d, has group video info "
                + result, currentRole);
        Utils.debug("GroupVideo getGroupVideoInfoResp current group video info "
                + groupVideoResult);
        refreshGroupVideo(result);
        getVideoSceneInfoFromGroupVideoInfo(result);
        this.groupVideoResult = result;
        //通话中
        if (CallState.getInstance().isNotIdle()) {
            Utils.debug("GroupVideo not idle,return");
            return;
        }
        if (isSameGroupCall(result) && isPrepareInGroupVideo()) {
            // 什么都不做， 正在准备或者已经进入了群聊
            Utils.debug("GroupVideo already in video group");
        } else {
            Utils.debug("GroupVideo wait to join the group video");
            groupVideoManager.addOneGroupVideoInformation(group.getGroupId(),
                    groupVideoResult);

            this.showGroupVideoIncomingView();
        }
        if (currentRole == ContactRoleInGroupCall.CONTACT_NO_GROUP_CALL) {
            this.setCurrentRole(ContactRoleInGroupCall.CONTACT_WAIT_JOIN);
        }
    }

    private void getVideoSceneInfoFromGroupVideoInfo(GroupVideoResult groupVideoResult) {
        VideoSceneInfo[] videoSceneInfos = groupVideoResult.getVideoSceneInfo();
        if (videoSceneInfos != null && videoSceneInfos.length > 0) {
            Utils.debug("CallSceneDebug getVideoSceneInfoFromGroupVideoInfo has scene info");
            this.setVideoSceneInfo(videoSceneInfos[0]);
            this.setIsSlideSceneMode(true);
            showPptOngoingProgress(true);
            groupVideoManager.addOneGroupCallSceneInformation(group.getGroupId(), videoSceneInfos[0]);
        } else {
            Utils.debug("CallSceneDebug getVideoSceneInfoFromGroupVideoInfo no video scene info");
            this.setVideoSceneInfo(null);
            this.setIsSlideSceneMode(false);
            showPptOngoingProgress(false);
            groupVideoManager.removeOneGroupCallSceneInformation(group.getGroupId());
        }
    }

    /*
     * 群视频通知
     */
    private void showGroupVideoNotification() {
        DuduGroup group = this.group;
        if (group == null) {
            return;
        }
        Utils.debug("GroupVideo showGroupVideoNotification");
        if (groupVideoManager.hasGroupVideo(group.getGroupId())) {
            this.showSmallGroupVideoInviteTips(true);
        } else {
            this.showNoGroupVideoCallView();
        }
    }

    /**
     * 填充群组视频通知内容
     *
     * @param fromUserId
     */
    private void fillGroupVideoInfo(String fromUserId) {
        txtGroupVideoInfo.setText(faceUtils.getFaceTextImage(
                getVideoTipsContent(userHandler.getUserInfo(fromUserId)),
                txtGroupVideoInfo));
    }


    private String getVideoTipsContent(DuduContact groupVideoCreator) {
        if (null == groupVideoCreator) {
            return "";
        }
        String content;
        if (TextUtils.equals(configHandler.getUid(),
                groupVideoCreator.getDuduUid())) {
            content = app.getString(R.string.handwin_group_video_you_reminder_tips);
        } else {
            content = String.format(
                    app.getString(R.string.handwin_group_video_reminder_tips),
                    groupVideoCreator.getShowName());
        }
        return content;
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onJoinGroupVideoResult(GroupVideoJoinEvent event) {
        processJoinGroupVideoResult(event.getResult(), event.getStatus(), event.getTargetRole());
    }

    public void processJoinGroupVideoResult(GroupVideoResult result, int status, int targetRole) {
        boolean isChangeSuccess = false;
        boolean needAddMessage = false;
        Utils.debugFormat("GroupVideo changeContactRoleResp status %d, currentRole %d, targetRole %d",
                status, currentRole, targetRole);
        if (status == ErrorCode.NO_NETWORK) {
            app.toast(R.string.handwin_need_network);
        } else if (status == ErrorCode.OK) {
            isChangeSuccess = true;
            getVideoSceneInfoFromGroupVideoInfo(result);
            processRoleChange(currentRole, targetRole);
            this.updateGroupVideoInfo(result,
                    GroupCallCommandType.GROUP_CALL_INFO_CHANGED);
        } else if (status == ErrorCode.GROUP_FAIL_TO_CHANGE_ROLE) {
            // TODO: 2/17/16
        } else if (status == ErrorCode.NO_GROUP_CALL_NOW
                || status == ErrorCode.GROUP_VIDEO_NOT_EXIST) {
            app.toast(R.string.handwin_group_video_not_exist);
            this.showNoGroupVideoCallView();
            this.setCurrentRole(ContactRoleInGroupCall.CONTACT_NO_GROUP_CALL);
            this.groupVideoManager.removeOneGroupVideoInformation(group
                    .getGroupId());
        } else if (status == ErrorCode.GROUP_VIDEO_EXCEED_LIMIT) {
            localMessageUtils.sendGroupVideoExceedLimit(group, false);
        } else if (status == ErrorCode.GROUP_VIDEO_ACTOR_EXCEED_LIMIT) {
            localMessageUtils.sendGroupVideoExceedLimit(group, true);
        } else if (status == ErrorCode.GROUP_VIDEO_JOIN_NO_PERMISSION) {
            Utils.debug("GroupVideoDebug request has sent");
        } else if (status == ErrorCode.SERVER_ERROR) {
            needAddMessage = true;
        } else {
            Utils.debug("Error!!!! GroupVideo not process the change");
        }

        if (!isChangeSuccess) {
            if (currentRole != ContactRoleInGroupCall.CONTACT_WATCHER_TO_ACTOR_WAIT_RESPONSE) {
                this.showGroupVideoIncomingView();
            }
            handleChangeFailedCase(targetRole, needAddMessage);
        }
    }

    /**
     * 处理加入群视频或者发起群视频失败后的逻辑，此处应当考虑状态切换的时候， 如果服务端有推送的时候, 应当考虑状态的冲突。
     *
     * @param targetRole
     * @param isAddMessage
     */
    private void handleChangeFailedCase(int targetRole, boolean isAddMessage) {
        // 如果是异常，
        if (targetRole == ContactRoleInGroupCall.CONTACT_ACTOR) {
            if (currentRole == ContactRoleInGroupCall.CONTACT_WATCHER_TO_ACTOR_WAIT_RESPONSE) {
                setCurrentRole(ContactRoleInGroupCall.CONTACT_WATCHER);
                if (isAddMessage) {
                    localMessageUtils.sendGroupVideoJoinFail(group, true);
                }
            } else if (currentRole == ContactRoleInGroupCall.CONTACT_ACTOR_WAIT_RESPONSE) {
                this.showGroupVideoIncomingView();
                if (groupVideoManager.hasGroupVideo(group.getGroupId())) {
                    this.setCurrentRole(ContactRoleInGroupCall.CONTACT_WAIT_JOIN);
                } else {
                    this.setCurrentRole(ContactRoleInGroupCall.CONTACT_NO_GROUP_CALL);
                }
                if (isAddMessage) {
                    localMessageUtils.sendGroupVideoJoinFail(group, true);
                }
            }
        } else if (targetRole == ContactRoleInGroupCall.CONTACT_WATCHER) {
            this.setCurrentRole(ContactRoleInGroupCall.CONTACT_WAIT_JOIN);
            if (isAddMessage) {
                localMessageUtils.sendGroupVideoJoinFail(group, false);
            }
        }
    }

    /**
     * 角色变化导致 界面 和 视频流 变化
     *
     * @param currentRole
     * @param targetRole
     */
    private void processRoleChange(int currentRole, int targetRole) {
        Utils.debugFormat(
                "GroupVideo processRoleChange currentRole %d, targetRole %d",
                currentRole, targetRole);
        // 之前没有参与
        if (this.isNotInGroupVideo()) {
            CallState.getInstance().setPeerId(group.getGroupId());
        } else if (currentRole == ContactRoleInGroupCall.CONTACT_WATCHER
                || currentRole == ContactRoleInGroupCall.CONTACT_ACTOR_WAIT_RESPONSE
                || currentRole == ContactRoleInGroupCall.CONTACT_WATCHER_TO_ACTOR_WAIT_RESPONSE) { // 旁观者
            if (targetRole == ContactRoleInGroupCall.CONTACT_ACTOR) {
                changeActorFromWatch();
            } else if (targetRole == ContactRoleInGroupCall.CONTACT_NO_GROUP_CALL) {
                handleStopVideoCall();
            }
        } else if (currentRole == ContactRoleInGroupCall.CONTACT_ACTOR) {
            if (targetRole == ContactRoleInGroupCall.CONTACT_WATCHER) {
                // VOIP 接口，接收但不发送
                changeWatchFromActor();
            } else if (targetRole == ContactRoleInGroupCall.CONTACT_NO_GROUP_CALL) {
                handleStopVideoCall();
            }
        }

        setCurrentRole(targetRole);
        showImageShareView();
        if (targetRole == ContactRoleInGroupCall.CONTACT_WATCHER ||
                currentRole == ContactRoleInGroupCall.CONTACT_ACTOR_WAIT_RESPONSE
                        && targetRole == ContactRoleInGroupCall.CONTACT_ACTOR) {
            showImageShareStartTips();
        }
    }

    private void showImageShareView() {
        Utils.debugFormat("CallSceneDebug showImageShareView currentRole %d videoSceneInfo: " + videoSceneInfo, currentRole);
        if (videoSceneInfo != null && isInGroupVideo()) {
            showPresentationView(true);
            this.editorView.setVideoChatMode(currentRole == ContactRoleInGroupCall.CONTACT_ACTOR
                    || (currentRole == ContactRoleInGroupCall.CONTACT_WATCHER));
        }
    }

    private void showImageShareStartTips() {
        if (videoSceneInfo != null) {
            DuduContact contact = contactCacheManager.getDuduContact(videoSceneInfo.getSponsorId());
            if (contact != null) {
                app.toast(String.format(app.getString(R.string.handwin_ppt_start_tip), contact.getShowName()));
            }
        }
    }

    private void changeActorFromWatch() {
        //VOIP 接口， 发送且接收
        voipAndroidManager.changeWatcherToActorInGroupVideo();
        if (null != groupVideoView) {
            groupVideoContactsHandler.addOneActor(getMyGroupContactInfo());
        }
        if (null != groupVideoWatchView) {
            groupVideoContactsHandler.removeOneWatcher(getMyGroupContactInfo());
        }
        sendMyVideoInfoPeriod();
    }

    private void changeWatchFromActor() {
        // VOIP 接口， 发送但不接收
        voipAndroidManager.setReceiveOnly(true);
        if (null != groupVideoView) {
            groupVideoContactsHandler.removeOneActor(getMyGroupContactInfo());
        }
        if (null != groupVideoWatchView) {
            groupVideoContactsHandler.addOneWatcher(getMyGroupContactInfo());
        }
    }

    public void handleStopVideoCall() {
        Utils.debug("GroupVideo handleStopVideoCall");
        this.showNoGroupVideoCallView();
        setCurrentRole(ContactRoleInGroupCall.CONTACT_NO_GROUP_CALL);
        resetSlideInfo();
        this.showPresentationView(false);
        BackgroundExecutor.cancelAll("id_send_costume", true);
        groupVideoContactsHandler.clearAllMembers(group.getGroupId());
    }

    public void updateGroupVideoInfo(GroupVideoResult groupVideoResult,
                                     int commandType) {
        Utils.debug("GroupVideo updateGroupVideoInfo " + commandType);

        if (commandType == GroupCallCommandType.GROUP_CALL_CREATE) {
            if (app.isLoadingOfflineMsg()) {
                Utils.debug("GroupVideo updateGroupVideoInfo return with isLoadingOfflineMsg is true");
                groupVideoManager.removeOneGroupVideoInformation(group.getGroupId());
                return;
            }

            if (isSameGroupCall(groupVideoResult) && isPrepareInGroupVideo()) {
                // 如果是同一个视频，什么都不做
            } else {
                this.groupVideoResult = groupVideoResult;
                /*if (groupVideoManager.getShowType(group.getGroupId())){
					hideKeyBoardAndFacePanel();
				}*/
//				fillGroupVideoBigPanelInfo(groupVideoResult.getFromUserId());
                fillGroupVideoInfo(groupVideoResult.getFromUserId());
                this.showGroupVideoIncomingView();
                setCurrentRole(ContactRoleInGroupCall.CONTACT_WAIT_JOIN);
            }
        } else if (commandType == GroupCallCommandType.GROUP_CALL_FINISH) {
            if (isSameGroupVideo(groupVideoResult)) {
                // 被动挂断
                if (isPrepareInGroupVideo()) {
                    showGroupVideoFinishTips();
                } else { // 主动挂断
                    String[] participants = groupVideoResult.getParticipant();
                    if (participants != null && participants.length > 0) {
                        if (configHandler.getUid().equals(participants[0])) {
                            showGroupVideoFinishTips();
                        }
                    }
                }
                setGroupVideoViewTrans(false, true);
                frameTitle.setTranslationY(0);
                resetSlideInfo();
                hangupGroupCall(false);
            }
        } else if (commandType == GroupCallCommandType.GROUP_CALL_INFO_CHANGED) {
            this.groupVideoResult = groupVideoResult;
            refreshParticipants(groupVideoResult);
            refreshWatchers(groupVideoResult);
        }
    }

    private boolean isSameGroupVideo(GroupVideoResult groupVideoResult) {
        if (this.groupVideoResult == null) {
            return true;
        }
        if (this.groupVideoResult.getRoomId().equals(groupVideoResult.getRoomId())) {
            return true;
        }
        return false;
    }

    void showGroupVideoFinishTips() {
        UiThreadExecutor.runTask(this::showGroupVideoFinishTips_);
    }

    void showGroupVideoFinishTips_() {
        app.toast(R.string.handwin_group_video_close);
    }

    /**
     * 判断是否是同一个群视频
     *
     * @param inComingGroupVideoResult
     * @return
     */
    private boolean isSameGroupCall(GroupVideoResult inComingGroupVideoResult) {
        // 1. 如果正在申请群视频
        if (currentRole == ContactRoleInGroupCall.CONTACT_ACTOR_WAIT_RESPONSE) {
            return true;
        }
        // 2. 如果本地没有群视频信息，说明没有申请过群信息(条件1)或者没有拿到群信息
        if (groupVideoResult == null) {
            return false;
        }
        // roomId一样，肯定是同一个
        return groupVideoResult.getRoomId().equals(inComingGroupVideoResult.getRoomId());

    }

    void refreshGroupVideo(GroupVideoResult groupVideoResult) {
        if (handleBanner(groupVideoResult)) {
            return;
        }
        // 我参与，刷新视频界面
        // 刷新表演者
        if (groupVideoView == null) {
            // 视频流1分钟超时；命令流2分钟超时；视频流超时就会关闭视频窗口
            return;
        }
        refreshParticipants(groupVideoResult);
        refreshWatchers(groupVideoResult);
    }

    /**
     * 我没参与，显示提示横幅
     *
     * @param groupVideoResult
     * @return true-显示横幅；
     */
    private boolean handleBanner(GroupVideoResult groupVideoResult) {
        String[] participants = groupVideoResult.getParticipant();
        String[] watchers = groupVideoResult.getHears();

        // 既不是表演者 也不是观察者
        if (!containsMe(participants) && !containsMe(watchers)) {
            Utils.debugFormat("GroupVideo handleBanner showGroupVideoIncomingView currentRole %d", currentRole);
            // 和服务端状态不匹配
            if (isPrepareInGroupVideo()) {
                app.toast(R.string.handwin_group_call_interrupt);
                CallService.getInstance().finishGroupCall();
                setCurrentRole(ContactRoleInGroupCall.CONTACT_WAIT_JOIN);
            }
            showGroupVideoIncomingView();
            return true;
        } else {
            // TODO: 4/21/16  观察者和表演者状态不一致
        }
        return false;
    }

    private void refreshParticipants(GroupVideoResult groupVideoResult) {
        if (null == groupVideoResult) {
            return;
        }
        String[] participants = groupVideoResult.getParticipant();
        if (participants == null || participants.length == 0) {
            // should not happen
            return;
        }

        List<MemberInfo> memberList = new ArrayList<>();
        List<MemberInfo> memberListTemp = new ArrayList<>();

        Utils.debug("GroupVideo handleParticipant actor count: "
                + participants.length);
        for (int i = 0; i < participants.length; i++) {
            DuduGroupContact groupContact = dbHandler.getGroupContact(
                    group.getGroupId(), participants[i]);
            if (groupContact != null) {
                groupVideoContactsHandler.addOneActor(groupContact);
                groupVideoContactsHandler.addOneWatcher(groupContact);
            }
        }

        memberList.addAll(memberListTemp);
    }

    private void refreshWatchers(GroupVideoResult groupVideoResult) {
        if (groupVideoResult == null) {
            return;
        }
        String[] watchers = groupVideoResult.getHears();
        if (watchers == null || watchers.length == 0 && groupVideoWatchView != null) {
//			groupVideoWatchView.removeAllWatchers();
            return;
        }
        Utils.debug("GroupVideo refreshGroupVideo watcher count: "
                + watchers.length);
        List<DuduGroupContact> contactList = new ArrayList<>();
        for (int i = 0; i < watchers.length; i++) {
            DuduGroupContact groupContact = dbHandler.getGroupContact(
                    group.getGroupId(), watchers[i]);
            if (null == groupContact) {
                continue;
            }
            contactList.add(groupContact);

            if (groupContact.getContactId().equals(configHandler.getUid())) {
                groupVideoContactsHandler.addOneWatcher(groupContact);
            } else {
                groupVideoContactsHandler.addOneWatcher(0, groupContact);
            }
        }
    }

    private boolean containsMe(String[] participants) {
        if (participants == null || participants.length == 0) {
            return false;
        }
        for (int i = 0; i < participants.length; i++) {
            if (participants[i].equals(configHandler.getUid())) {
                return true;
            }
        }
        return false;
    }

    private DuduGroupContact getMyGroupContactInfo() {
        if (myGroupContactInfo == null) {
            myGroupContactInfo = dbHandler.getGroupContact(group.getGroupId(),
                    configHandler.getUid());
        }

        return myGroupContactInfo;
    }

    private int getMyInnerId() {
        int seq = 0;
        if (myGroupContactInfo != null) {
            seq = myGroupContactInfo.getInnerId();
        } else {
            seq = getMyGroupContactInfo() != null ? getMyGroupContactInfo()
                    .getInnerId() : 0;
        }

        Utils.debugFormat("GroupVideo getMyInnerId %d", seq);
        return seq;
    }

    public void loadGroupVideoInfo() {
        Utils.debug("GroupVideo connectTCP and loadGroupVideoInfo");
        groupVideoActions.getGroupVideoRoomInfo(group);
    }

    public void onGroupLiveStart(boolean isJoinVideo) {
        Utils.debugFormat("GroupVideo onGroupLiveStart current %d", currentRole);
        // 群组视频已经被取消
        if (currentRole == ContactRoleInGroupCall.CONTACT_NO_GROUP_CALL) {
            this.showNoGroupVideoCallView();
        } else {
            switch (currentRole) {
                case ContactRoleInGroupCall.CONTACT_ACTOR_WAIT_RESPONSE:
                    processRoleChange(currentRole, ContactRoleInGroupCall.CONTACT_ACTOR);
                    break;
                case ContactRoleInGroupCall.CONTACT_WATCHER_TO_ACTOR_WAIT_RESPONSE:
                    processRoleChange(currentRole, ContactRoleInGroupCall.CONTACT_ACTOR);
                    break;
                case ContactRoleInGroupCall.CONTACT_WATCHER_WAIT_RESPONSE:
                    processRoleChange(currentRole, ContactRoleInGroupCall.CONTACT_WATCHER);
                    break;
                case ContactRoleInGroupCall.CONTACT_ACTOR:
                    // 当前role为表演者时,更新完status同时,更新当前ui
                    setCurrentRole(currentRole);
                    break;
            }
            if (!isPresentationViewShow()) {
                this.showGroupVideoView();
            }
            if (isJoinVideo) {
                sendMyVideoInfoPeriod();
            }
            if (isJoinVideo && (null != this.groupVideoView)) {
                groupVideoContactsHandler.addOneActor(getMyGroupContactInfo());
                groupVideoContactsHandler.addOneWatcher(getMyGroupContactInfo());
            }
            if (editorView != null && !editorView.isRecorderViewShow()) {
//                this.editorView.showTextSendButton(this.groupVideoHandler
//                        .isInGroupVideo());
                this.editorView.setVideoChatMode(currentRole == ContactRoleInGroupCall.CONTACT_ACTOR
                        || currentRole == ContactRoleInGroupCall.CONTACT_WATCHER);
            }
        }
    }

    public void onGroupCallBusy() {
        this.showGroupVideoIncomingView();
        Utils.debug("GroupVideo onGroupCallBusy");
    }

    /**
     * 刷新聊天消息列表和会话列表
     *
     * @param from
     * @param data
     * @param setting
     * @param needPlusOne 未读消息+1
     */
    private void refreshChatListAndConversation(String from, DuduMessage data,
                                                int setting, boolean needPlusOne) {
        // 保存消息到数据库
        dbHandler.addDuduMessage(data, setting);
        // 未读消息+1
        // 如果是收到游戏邀请，一定未读+1
        if ((!TextUtils.equals(systemStatus.getChattingGroup(), from) && needPlusOne)) {
            dbHandler.unReadSumPlus(from, 1, data.getMsgType());
            // 刷新会话列表
            eventSender.conversationUpdate();
        }
        // 刷新聊天界面
        eventSender.newMessages(new DuduMessage[]{data}, true);
    }

    @Override
    public String getConversationId() {
        return group != null ? group.getGroupId() : null;
    }

    @Override
    public void costumeEnableChanged(boolean isEnable) {
        // 及时通知其他成员
        sendMyVideoInfo();
    }

    public void updateGroupCallInfo(int innerId, String roomId, String costume,
                                    boolean isVideoPause, boolean isCostumeEnable) {
        updateCameraStatus(innerId, roomId, isVideoPause);
    }

    public void updateCameraStatus(int innerId, String roomId,
                                   boolean isVideoPause) {
        if (groupVideoView != null) {
            groupVideoView.memberCameraStatusChange(innerId, isVideoPause);
        }
        if(chatPresentationView!=null){
            chatPresentationView.memberCameraStatusChange(innerId, isVideoPause);
        }
    }

    protected void handleSceneCreate(VideoSceneInfo videoSceneInfo) {
        Utils.debug("CallSceneDebug handleSceneCreate in groupChatView");
        super.handleSceneCreate(videoSceneInfo);
        if (groupVideoResult == null) {
            Utils.debug("CallSceneDebug handleSceneCreate return with no group video");
            return;
        }
        if (videoSceneInfo.getRoomId().equals(groupVideoResult.getRoomId())) {
            Utils.debug("CallSceneDebug handleSceneCreate showPresentationView");
            this.setVideoSceneInfo(videoSceneInfo);
            if (isInGroupVideo()) {
                showImageShareView();
                showImageShareStartTips();
            }
        } else {
            // TODO roomID不同的异常处理

        }
    }

    protected void handleSceneEnd(VideoSceneInfo videoSceneInfo) {
        Utils.debug("CallSceneDebug handleSceneEnd in groupChatView");
        this.editorView.setVideoChatMode(currentRole == ContactRoleInGroupCall.CONTACT_ACTOR);
        resetSlideInfo();
        if (videoSceneInfo == null) {
            return;
        }
        if (group == null) {
            return;
        }
        if (groupVideoResult == null) {
            Utils.debug("CallSceneDebug handleSceneEnd return with no group video");
            if (videoSceneInfo.getGroupId().equals(group.getGroupId())) {
                showPptOngoingProgress(false);
            }
            return;
        }
        if (videoSceneInfo.getRoomId().equals(groupVideoResult.getRoomId())) {
            super.handleSceneEnd(videoSceneInfo);
            Utils.debug("CallSceneDebug handleSceneEnd showPresentationView");
            showPresentationView(false);
            if (isPrepareInGroupVideo()) {
                showGroupVideoView();
            } else if (currentRole == ContactRoleInGroupCall.CONTACT_WAIT_JOIN) {
//				showGroupVideoNotification();
            } else {
                showNoGroupVideoCallView();
            }
            resetSlideInfo();
        } else {

        }
    }

    @Override
    protected void doResetSlideInfo() {
        if (group != null) {
            groupVideoManager.removeOneGroupCallSceneInformation(group.getGroupId());
        }
        if (groupVideoResult != null) {
            groupVideoResult.setVideoSceneInfo(null);
        }
    }

    @Override
    protected void doCreateCreateScene() {
        super.doCreateCreateScene();
        createSceneOnBackground(group, groupVideoResult);
    }

    @Override
    public void onExitPresentation() {
        super.onExitPresentation();
        if (isPresentationViewShow()) {
            this.showGroupVideoView();
        }
        showGroupRequestViewFromPresentation(true);
    }

    @Override
    public void onClosePresentation() {
        super.onClosePresentation();
        stopSceneOnBackground(group, groupVideoResult, true);
    }

    void createSceneOnBackground(DuduGroup group, GroupVideoResult groupVideoResult) {
        BackgroundExecutor.execute(() -> createSceneOnBackground_(group, groupVideoResult), BackgroundExecutor.ThreadType.CALCULATION);
    }

    void createSceneOnBackground_(DuduGroup group, GroupVideoResult groupVideoResult) {
        if (group == null) {
            dialogHandle.closeProgressDialog();
            Utils.debug("CallSceneDebug createScene with group is null");
            return;
        }
        if (groupVideoResult == null) {
            dialogHandle.closeProgressDialog();
            Utils.debug("CallSceneDebug createScene with groupVideoResult is null");
            return;
        }
        VideoSceneInfo videoSceneInfo = sceneActions.createNewScene(group.getRegion(), groupVideoResult.getRoomId(), group.getGroupId(), SceneConstant.SLIDE_SCENE);
        processCreateSceneResult(videoSceneInfo);
    }

    void stopSceneOnBackground(DuduGroup group, GroupVideoResult groupVideoResult, boolean needStartVideoView) {
        BackgroundExecutor.execute(() -> stopSceneOnBackground_(group, groupVideoResult, needStartVideoView), BackgroundExecutor.ThreadType.CALCULATION);
    }

    void stopSceneOnBackground_(DuduGroup group, GroupVideoResult groupVideoResult, boolean needStartVideoView) {
        if (group == null) {
            dialogHandle.closeProgressDialog();
            Utils.debug("CallSceneDebug stopScene with group is null");
            return;
        }
        if (groupVideoResult == null) {
            dialogHandle.closeProgressDialog();
            Utils.debug("CallSceneDebug stopScene with groupVideoResult is null");
            return;
        }

        if (videoSceneInfo == null) {
            dialogHandle.closeProgressDialog();
            Utils.debug("CallSceneDebug stopScene with videoSceneInfo is null");
            return;
        }
        boolean ret = sceneActions.stopScene(group.getRegion(), groupVideoResult.getRoomId(), videoSceneInfo, group.getGroupId());
        processStopSceneResult(ret, needStartVideoView);
    }

    void processStopSceneResult(boolean ret, boolean needStartVideoView) {
        UiThreadExecutor.runTask(() -> processStopSceneResult_(ret, needStartVideoView));
    }

    void processStopSceneResult_(boolean ret, boolean needStartVideoView) {
        dialogHandle.closeProgressDialog();
        if (ret) {
            resetSlideInfo();
            if (needStartVideoView) {
                this.showGroupVideoView();
            }
        } else {
            app.toast(R.string.handwin_close_image_share_fail);
        }
        onExitPresentation();
        showPresentationView(false);
    }

    @Override
    protected void doShowPresentationView() {
        super.doShowPresentationView();
        this.showGroupVideoPanel(false);
        showGroupRequestView(false);
        if (chatPresentationView != null) {
            chatPresentationView.showGroupRequestView(groupVideoResult, true);
        }
    }

    private boolean isActorStyle() {
        return (currentRole == ContactRoleInGroupCall.CONTACT_ACTOR
                || currentRole == ContactRoleInGroupCall.CONTACT_ACTOR_WAIT_RESPONSE);
    }

    private boolean isPrepareInGroupVideo() {
        return isInGroupVideo() || currentRole == ContactRoleInGroupCall.CONTACT_ACTOR_WAIT_RESPONSE
                || currentRole == ContactRoleInGroupCall.CONTACT_WATCHER_WAIT_RESPONSE
                || currentRole == ContactRoleInGroupCall.CONTACT_WATCHER_TO_ACTOR_WAIT_RESPONSE;
    }

    private boolean isInGroupVideo() {
        return (currentRole == ContactRoleInGroupCall.CONTACT_ACTOR
                || currentRole == ContactRoleInGroupCall.CONTACT_WATCHER);
    }

    private boolean isNotInGroupVideo() {
        return (currentRole == ContactRoleInGroupCall.CONTACT_NO_GROUP_CALL
                || currentRole == ContactRoleInGroupCall.CONTACT_WAIT_JOIN);
    }

    @Override
    public void onPause() {
        super.onPause();
        if (currentRole == ContactRoleInGroupCall.CONTACT_ACTOR
                && groupVideoResult != null) {
            sendMyVideoInfo();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (currentRole == ContactRoleInGroupCall.CONTACT_ACTOR
                && groupVideoResult != null) {
            sendMyVideoInfo();
        }
    }

    void sendMyVideoInfoPeriod() {
        BackgroundExecutor.execute(this::sendMyVideoInfoPeriod_, "id_send_costume", 3000, "", BackgroundExecutor.ThreadType.NETWORK);
    }

    void sendMyVideoInfoPeriod_() {
        if (currentRole == ContactRoleInGroupCall.CONTACT_ACTOR) {
            sendMyVideoInfo();
            sendMyVideoInfoPeriod();
        }
    }

    private Object sendMyVideoInfoLock = new Object();

    private void sendMyVideoInfo() {
        synchronized (sendMyVideoInfoLock) {
            if (CallState.getInstance().isNotStatus(Status.GroupLiving)) {
                return;
            }
            if (currentRole != ContactRoleInGroupCall.CONTACT_ACTOR) {
                return;
            }
            if (groupVideoResult != null) {
                groupVideoActions.sendMyVideoInfoToVideoGroup(
                        group.getGroupId(),
                        groupVideoResult.getRoomId().substring(
                                groupVideoResult.getRoomId().length() - 8),
                        cameraHandler.isRunning());
            }
        }
    }

    @Override
    public void onEmojiPannelShow() {
        super.onEmojiPannelShow();
        setGroupVideoViewTrans(true, false);
    }

    @Override
    public void onEmojiPannelHide() {
        super.onEmojiPannelHide();
        setGroupVideoViewTrans(false, false);
    }

    @Override
    public void onFunctionMenuViewShow() {
        super.onFunctionMenuViewShow();
        setGroupVideoViewTrans(true, false);
    }

    @Override
    public void onFunctionMenuViewHide() {
        super.onFunctionMenuViewHide();
        setGroupVideoViewTrans(false, false);
    }

    @Override
    public void onKeyboardShow() {
        super.onKeyboardShow();
        setGroupVideoViewTrans(true, true);
    }

    @Override
    public void onKeyboardHide() {
        super.onKeyboardHide();
        setGroupVideoViewTrans(false, true);
        if (emojiShow) {
            setGroupVideoViewTrans(true, false);
        }
    }

    public void setGroupVideoViewTrans(boolean isFaceAndKeyboardPanelShow, boolean isKeyBoard) {
        if (groupVideoView == null) {
            return;
        }
        if (!isFaceAndKeyboardPanelShow) {
            frameTitle.setTranslationY(0);
        }
        if (currentRole == ContactRoleInGroupCall.CONTACT_WAIT_JOIN && isFaceAndKeyboardPanelShow) {
            showSmallGroupVideoInviteTips(true);
        }
        if (!isPrepareInGroupVideo()) {
            return;
        }
        int actualActorHeight = groupVideoView.getHeight();
        int facePanelHeight = isKeyBoard ? 0 : app
                .getPxFromDp(R.dimen.handwin_chat_face_out_h);
        int deltaHeight = this.getHeight()
                - app.getPxFromDp(R.dimen.handwin_chat_min_height) - actorHeight
                - facePanelHeight;
        if (deltaHeight > 0) {
            deltaHeight = 0;
        }
        Utils.debugFormat("setGroupVideoViewTrans %d,%d", actualActorHeight, actorHeight);
        int deltaY = 0 - app.getPxFromDp(R.dimen.handwin_chat_video_head_height)
                + deltaHeight;
        if (actualActorHeight < actorHeight) {
            deltaY = 0 - app.getPxFromDp(R.dimen.handwin_chat_min_height);
        }
        int translationY = isFaceAndKeyboardPanelShow ? deltaY : 0;

        int placeHolderTop = (actorHeight + titleHeight + translationY);
        if (actualActorHeight < actorHeight) {
            placeHolderTop = actualActorHeight + titleHeight + translationY;
        }
        boolean needTitleTranslate = false;
        if (groupVideoView != null) {
            groupVideoView.setTranslationY(translationY);
            groupVideoWatchView.setTranslationY(translationY);
            needTitleTranslate = true;
        }
        if (groupVideoWaitingView != null) {
            groupVideoWaitingView.setTranslationY(translationY);
            needTitleTranslate = true;
        }
        Utils.debug("changePlaceHolderTop " + translationY);
        if (needTitleTranslate) {
            frameTitle.setTranslationY(translationY);

            changePlaceHolderTop(placeHolderTop);
        }
    }

    /**
     * 打开关闭PlaceHolder布局
     *
     * @param expand
     */
    private void expandPlaceHolderTop(boolean expand) {
        int placeholderTop = titleHeight;
        if (currentRole != ContactRoleInGroupCall.CONTACT_NO_GROUP_CALL && expand) {
            placeholderTop = actorHeight + titleHeight;
        }
        changePlaceHolderTop(placeholderTop);
    }

    /**
     * 更改PlaceHolder顶部距离
     *
     * @param top
     */
    private void changePlaceHolderTop(int top) {

        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams) txtPlaceHolder
                .getLayoutParams();
        lp.topMargin = top;
        txtPlaceHolder.setLayoutParams(lp);
    }

    @Override
    public DuduGroup getChatEntity() {
        return group;
    }

    @Override
    protected boolean isGroupChat() {
        return true;
    }

    @Override
    protected String getRoomId() {
        if (groupVideoResult != null) {
            return groupVideoResult.getRoomId();
        }
        return null;
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void receiveRefresh(MessageUpdateEvent event) {
        updateGroup();
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onGroupCallCommand(GroupCallCommand groupCallCommand) {
        if (groupCallCommand != null) {
            String groupId = groupCallCommand.getGroupId();
            if (isSameGroup(group, groupId)) {
                updateGroupVideoInfo(groupCallCommand.getGroupVideoResult(), groupCallCommand.getCommandType());
            } else {
                Utils.debug("GroupVideo groupId is not match");
            }
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onGroupDismissEvent(GroupDismissEvent groupDismissEvent) {
        Utils.debug("Group onGroupDismissEvent");
        if (groupDismissEvent != null) {
            String groupId = (String) groupDismissEvent.getData();
            Utils.debugFormat("Group onGroupDismissEvent groupId %s", groupId);
            if (isSameGroup(group, groupId)) {
                performExitChat(false, true);
            }
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onGroupVideoResult(GroupVideoResultEvent event) {
        refreshWatchers(event.getData());
    }

    private boolean isSameGroup(DuduGroup group, String groupId) {
        if (group == null) {
            return false;
        }
        return group.getGroupId().equals(groupId);
    }

    @Override
    protected BaseChatPresentationView createChatPresentationView() {
        return GroupChatPresentationView.build(getContext());
    }

    @Override
    public void inviteOthers() {
        if (group != null) {
            Intent intent = new Intent(getContext(), GroupContactsAtSelectionActivity.class);
            intent.putExtra(GroupContactsAtSelectionActivity.DUDU_GROUP_EXTRA, group);
            ((Activity) getContext()).startActivityForResult(intent, ReqCode.REQUEST_CODE_SEND_GROUP_VIDEO_TO_OTHERS);
        }
    }


    /**
     * 请求加入群视频
     */
    @Override
    public void joinGroupVideo() {
        if (group == null) {
            return;
        }

        cancelRecordAudio();
        cancelRecordVideo();

        if (needShowDialog()) {
            dialogHandle.showNormalDialog(getContext(), R.string.handwin_tip_dialog_title_normal,
                    R.string.handwin_group_video_request_wait_tips, R.string.handwin_app_yes,
                    R.string.handwin_app_cancel, true, new DialogCallback() {
                        @Override
                        public void onOkClick() {
                            joinGroupVideoAsActor();
                        }

                        @Override
                        public void onCancelClick() {
                        }
                    });
        } else {
            joinGroupVideoAsActor();
        }
    }

    private boolean needShowDialog() {
        if (groupVideoResult == null) {
            return false;
        }

        if (configHandler.getUid().equals(groupVideoResult.getFromUserId())) {
            return false;
        }

        List<MemberInfo> memberInfos = groupVideoContactsHandler.getAllActors(group.getGroupId());
        if (memberInfos != null) {
            for (MemberInfo actor : memberInfos) {
                if (groupVideoResult.getFromUserId().equals(actor.getUid())) {
                    return true;
                }
            }
        }
        return false;
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onGroupRefresh(GroupRefreshEvent event) {
        String groupId = event.getData();
        updateGroupAndRefresh(groupId);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onGroupInfoUpdate(GroupInfoUpdateEvent event) {
        updateGroupAndRefresh(event.getData());
    }

    private void updateGroupAndRefresh(String groupId) {
        if (group != null && TextUtils.equals(groupId, group.getGroupId())) {
            DuduGroup newGroup = dbHandler.getDuduGroup(groupId);
            if (newGroup != null) {
                setGroup(newGroup);
                refreshTalkDatas(false, true);
            }
        }
    }

    private void onTitleClick() {
        if (CallState.getInstance().isStatus(Status.GroupLiving)) {
            return;
        }
        CGSDKClientImpl.getInternalInstance().notifyChatViewTitleClick(true, getConversationId(), getContext());
    }
}
