package me.chatgame.uisdk.activity.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;


import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import me.chatgame.mobilecg.activity.GroupContactsAtSelectionActivity;
import me.chatgame.mobilecg.activity.view.interfaces.ILiveActivity;
import me.chatgame.mobilecg.call.CallState;
import me.chatgame.mobilecg.constant.ChatType;
import me.chatgame.mobilecg.constant.ContactRoleInGroupCall;
import me.chatgame.mobilecg.constant.MessageExtraTypeValue;
import me.chatgame.mobilecg.constant.RegexStrings;
import me.chatgame.mobilecg.constant.ReqCode;
import me.chatgame.mobilecg.database.entity.ConversationType;
import me.chatgame.mobilecg.database.entity.DuduGroup;
import me.chatgame.mobilecg.database.entity.DuduMessage;
import me.chatgame.mobilecg.sdk.CGSDKClientImpl;
import me.chatgame.mobilecg.sdk.EmoticonHandler;
import me.chatgame.mobilecg.sdk.EmoticonHandler.GifEmotionData;
import me.chatgame.mobilecg.sdk.FunctionMenuHandler;
import me.chatgame.mobilecg.util.ReflectInterfaceProxy;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.views.IconFontTextView;
import me.chatgame.mobilecg.views.MonitoringEditText;
import me.chatgame.uisdk.R;
import me.chatgame.mobilecg.bean.FunctionMenuData;

/**
 * Created by star on 15/11/6.
 */
public class GroupChatSendEditorView extends BaseSendEditorView {

    MonitoringEditText editChat;    // edit field
    TextView btnChatSend;          // send msg button
//    TextView btnAudio;
    View btnFunctionMenu;
    TextView btnChatEmoji;         // emoji panel open button

    View editRegion;
    View functionRegion;

    private DuduGroup group;

    private boolean alreadyInflated_ = false;

    public GroupChatSendEditorView(Context context) {
        super(context);
        init_();
    }

    public GroupChatSendEditorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init_();
    }

    public GroupChatSendEditorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init_();
    }

    public static GroupChatSendEditorView build(Context context) {
        GroupChatSendEditorView instance = new GroupChatSendEditorView(context);
        instance.onFinishInflate();
        return instance;
    }

    /**
     * The mAlreadyInflated_ hack is needed because of an Android bug
     * which leads to infinite calls of onFinishInflate()
     * when inflating a layout with a parent and using
     * the <merge /> tag.
     *
     */
    @java.lang.Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_view_chat_send_editor, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    private void init_() {
        imm = ((InputMethodManager) getContext().getSystemService(Context.INPUT_METHOD_SERVICE));
        liveActivity = ((ILiveActivity) ReflectInterfaceProxy.newInstance(ILiveActivity.class, getContext()));
    }

    public static GroupChatSendEditorView build(Context context, AttributeSet attrs) {
        GroupChatSendEditorView instance = new GroupChatSendEditorView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static GroupChatSendEditorView build(Context context, AttributeSet attrs, int defStyleAttr) {
        GroupChatSendEditorView instance = new GroupChatSendEditorView(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        funcPptView = hasViews.findViewById(R.id.func_ppt);
        funcInputSwitchView = hasViews.findViewById(R.id.func_input_switch);
        startPptBtn = ((TextView) hasViews.findViewById(R.id.more_item_start_ppt));
//        btnChatImage = ((TextView) hasViews.findViewById(R.id.btn_chat_image));
        functionRegion = hasViews.findViewById(R.id.id_editview_function_region);
//        btnAudio = ((TextView) hasViews.findViewById(R.id.btn_chat_audio));
        btnFunctionMenu = hasViews.findViewById(R.id.btn_function_menu);
        editChat = ((MonitoringEditText) hasViews.findViewById(R.id.edit_chat));
        editRegion = hasViews.findViewById(R.id.id_edit_region);
        btnChatEmoji = (TextView) hasViews.findViewById(R.id.btn_chat_emoji);
        btnChatSend = ((TextView) hasViews.findViewById(R.id.btn_chat_send));
        audioRecordBtn = (TextView) hasViews.findViewById(R.id.btn_audio_record) ;
        audioOrInputBtn = (IconFontTextView) hasViews.findViewById(R.id.btn_audio_or_input) ;

        {
            View view = hasViews.findViewById(R.id.more_item_input);
            if (view!= null) {
                view.setOnClickListener(view1 -> GroupChatSendEditorView.this.btnMoreItemInputClick()
                );
            }
        }
        if (btnChatEmoji!= null) {
            btnChatEmoji.setOnClickListener(view -> GroupChatSendEditorView.this.btnEmojiClick()
            );
        }
//        if (btnChatImage!= null) {
//            btnChatImage.setOnClickListener(view -> GroupChatSendEditorView.this.btnImageClick()
//            );
//        }
        if (btnFunctionMenu!= null) {
            btnFunctionMenu.setOnClickListener(view -> GroupChatSendEditorView.this.btnFunctionMenuEntryClick()
            );
        }
        if (startPptBtn!= null) {
            startPptBtn.setOnClickListener(view -> GroupChatSendEditorView.this.btnStartPpt()
            );
        }
        if (btnChatSend!= null) {
            btnChatSend.setOnClickListener(view -> GroupChatSendEditorView.this.btnSendMsgClick()
            );
        }
        afterViews();
    }



    public void setGroup(DuduGroup group) {
        this.group = group;
    }

    public void afterViews() {
        baseEditChat = editChat;
        baseBtnEmoji = btnChatEmoji;
        baseBtnFunctionMenu = btnFunctionMenu;
        baseBtnSend = btnChatSend;
        baseEditRegion = editRegion;
        baseFunctionRegion = functionRegion;
        configFuncButtons();
        super.afterViews();
    }

    @Override
    protected void configFuncButtons() {
        funcInputSwitchView.setVisibility(View.VISIBLE);
        funcPptView.setVisibility(View.VISIBLE);
    }

    @Override
    protected void sendTextMessage(String str) {
        if (group == null) return;
        //Utils.debugFormat("[CGTEST] send text: %s", str);
        int extraType = MessageExtraTypeValue.NORMAL;
        if (!TextUtils.isEmpty(str)) {
            Pattern pattern = Pattern.compile(RegexStrings.MATCH_AT);
            Matcher matcher = pattern.matcher(str);
            while (matcher.find()) {
                extraType = MessageExtraTypeValue.AT_MSG;
                break;
            }
        }
        //Utils.debugFormat("[CGTEST] send group text message extra type: %d", extraType);
        sendTextMessage(str, group.getGroupId(), group.getSetting(), ConversationType.GROUP, extraType);
    }

    @Override
    void afterTextChange(EditText editText) {
        if (isEditTextReady) {
            String text = editChat.getText().toString();
            int cursorPos = editChat.getSelectionStart();
            //Utils.debug("[CGTEST] cursor pos: " + cursorPos);
            if (needShowAtSelectPage(text, cursorPos)) {
                //Utils.debug("[CGTEST] needShowAtSelectPage");
                Intent intent = new Intent(getContext(), GroupContactsAtSelectionActivity.class);
                intent.putExtra(GroupContactsAtSelectionActivity.DUDU_GROUP_EXTRA, group);
                ((Activity) getContext()).startActivityForResult(intent, ReqCode.CHOOSE_AT_CONTACTS);
            }
        } else {
            isEditTextReady = true;
        }
    }


    @Override
    public void onAudioRecorded(int duration, String audioPath) {
        super.onAudioRecorded(duration, audioPath);
        if (group == null) return;
        duduMessageAction.sendAudioMessage(audioPath, group.getGroupId(),
                true, group.getSetting(), duration);
    }

    @Override
    public void onVideoRecorded(String videoFile, String thumbFile, int duration, boolean isBurned, int videoType, boolean frontCamera) {
        super.onVideoRecorded(videoFile, thumbFile, duration, isBurned, videoType, frontCamera);
        if (group == null) return;
        duduMessageAction.sendJumpVideoMessage(videoFile, thumbFile, duration, group.getGroupId(),
                true, group.getSetting(), isBurned, videoType, frontCamera);
    }

    @Override
    protected void sendImage(String[] paths) {
        if (group == null) return;
        duduMessageAction.compressImagesAndSend(paths,null,new DuduGroup[]{group});
    }

    @Override
    public void sendMessageResponse(DuduMessage message) {
        UiThreadExecutor.runTask(()->sendMessageResponse_(message));
    }

    @Override
    protected List<FunctionMenuData> createFunctionMenuDatas() {
        List<FunctionMenuData> menuDatas = new ArrayList<>();
        FunctionMenuHandler functionMenuHandler = CGSDKClientImpl.getInternalInstance().getFunctionMenuHandler();
        boolean needDefault = true;
        List<FunctionMenuData> userDefinedMenuData = null;
        if (functionMenuHandler != null) {
            needDefault = functionMenuHandler.needDefaultGroupChatFunctionMenuItem();
            userDefinedMenuData = functionMenuHandler.getGroupChatFunctionMenu(getContext());
        }
        if (needDefault) {
            menuDatas.addAll(super.createFunctionMenuDatas());
        }
        if (userDefinedMenuData != null && userDefinedMenuData.size() > 0) {
            menuDatas.addAll(userDefinedMenuData);
        }
        return menuDatas;
    }

    @Override
    public boolean onItemClick(FunctionMenuData functionMenuData) {
        if (!super.onItemClick(functionMenuData)) {
            FunctionMenuHandler functionMenuHandler = CGSDKClientImpl.getInternalInstance().getFunctionMenuHandler();
            if (functionMenuHandler != null) {
                functionMenuHandler.onMenuItemClick(getContext(), group != null ? group.getGroupId() : "", ChatType.GROUP_CHAT, functionMenuData);
            }
        }
        return true;
    }

    public void sendMessageResponse_(DuduMessage message) {
        if (group == null) return;
        if (message.getConversationId().equals(group.getGroupId()) && messageAddListener != null) {
            messageAddListener.onAddOneMessage(message);
        }
    }

    @Override
    public void setMessageExtraResp(DuduMessage message) {
        super.setMessageExtraResp(message);
    }

    @Override
    public EditText getEditText() {
        return editChat;
    }

    @Override
    public void onDynamicEmojiSelected(GifEmotionData gifEmotionData) {
        if (group != null) {
            duduMessageAction.sendGifMessage(gifEmotionData, group.getGroupId(), true, group.getSetting());
        }
    }

    @Override
    protected boolean isFunctionBarShow() {
        return groupVideoHandler.getCurrentRole()== ContactRoleInGroupCall.CONTACT_ACTOR || (groupVideoHandler.getCurrentRole()== ContactRoleInGroupCall.CONTACT_WATCHER &&chatView.getVideoSceneInfo()!=null);
    }

    //    @Override
//    protected boolean needShowRecordButtonOnTextChange() {
//        return !groupVideoHandler.isInGroupVideo();
//    }
}
