package me.chatgame.uisdk.activity.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import org.greenrobot.eventbus.Subscribe;

import me.chatgame.mobilecg.activity.view.PresentationVideoPreview;
import me.chatgame.mobilecg.activity.view.interfaces.ILiveActivity;
import me.chatgame.mobilecg.activity.view.interfaces.IOpenGLView;
import me.chatgame.mobilecg.activity.view.interfaces.IPresentationVideoPreview;
import me.chatgame.mobilecg.database.entity.DuduGroup;
import me.chatgame.mobilecg.database.entity.DuduGroupContact;
import me.chatgame.mobilecg.events.OnCreateGroupVideoResult;
import me.chatgame.mobilecg.handler.DBHandler;
import me.chatgame.mobilecg.handler.interfaces.IDBHandler;
import me.chatgame.mobilecg.net.protocol.VideoSceneInfo;
import me.chatgame.mobilecg.util.BackgroundExecutor;
import me.chatgame.mobilecg.util.ReflectInterfaceProxy;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.views.CustomViewPager;
import me.chatgame.uisdk.R;

/**
 * Created by star on 16/3/16.
 */
public class GroupChatPresentationView extends BaseChatPresentationView<DuduGroup> {

    IPresentationVideoPreview groupVideoPreview;

    IDBHandler dbHandler ;

    private boolean alreadyInflated_ = false;

    public GroupChatPresentationView(Context context) {
        super(context);
        init_();
    }

    public GroupChatPresentationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init_();
    }

    public GroupChatPresentationView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init_();
    }

    public static GroupChatPresentationView build(Context context) {
        GroupChatPresentationView instance = new GroupChatPresentationView(context);
        instance.onFinishInflate();
        return instance;
    }

    /**
     * The mAlreadyInflated_ hack is needed because of an Android bug
     * which leads to infinite calls of onFinishInflate()
     * when inflating a layout with a parent and using
     * the <merge /> tag.
     *
     */
    @Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_view_chat_presentation, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    private void init_() {
        init__();
        init();
        liveActivity = ((ILiveActivity) ReflectInterfaceProxy.newInstance(ILiveActivity.class, getContext()));
    }

    public static GroupChatPresentationView build(Context context, AttributeSet attrs) {
        GroupChatPresentationView instance = new GroupChatPresentationView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static GroupChatPresentationView build(Context context, AttributeSet attrs, int defStyleAttr) {
        GroupChatPresentationView instance = new GroupChatPresentationView(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        linearCounts = ((LinearLayout) hasViews.findViewById(R.id.linear_counts));
        btnAddMore = ((TextView) hasViews.findViewById(R.id.btn_add_more));
        videoContainer = ((ViewGroup) hasViews.findViewById(R.id.id_presentation_video_container));
        btnPaintBack = ((TextView) hasViews.findViewById(R.id.btn_paint_back));
        rootLayout = ((RelativeLayout) hasViews.findViewById(R.id.root_layout));
        txtWatcherCount = ((TextView) hasViews.findViewById(R.id.txt_watcher_count));
        btnPenColor = ((TextView) hasViews.findViewById(R.id.btn_pen_color));
        groupVideoRequestView = ((GroupVideoRequestView) hasViews.findViewById(R.id.view_group_video_request));
        btnPenRevoke = ((TextView) hasViews.findViewById(R.id.btn_pen_revoke));
        viewPager = ((CustomViewPager) hasViews.findViewById(R.id.pager_img));
        txtPageInfo = ((TextView) hasViews.findViewById(R.id.txt_page_info));
        btnShowKeyBoard = ((TextView) hasViews.findViewById(R.id.btn_show_keyboard));
        btnMoreItem = ((TextView) hasViews.findViewById(R.id.btn_more_items));
        btnPaintClose = ((TextView) hasViews.findViewById(R.id.btn_paint_close));
        if (btnPaintClose!= null) {
            btnPaintClose.setOnClickListener(view -> GroupChatPresentationView.this.btnPaintCloseClick()
            );
        }
        if (btnPaintBack!= null) {
            btnPaintBack.setOnClickListener(view -> GroupChatPresentationView.this.btnPaintBackClick()
            );
        }
        if (btnShowKeyBoard!= null) {
            btnShowKeyBoard.setOnClickListener(view -> GroupChatPresentationView.this.showKeyBoard()
            );
        }
        if (btnMoreItem!= null) {
            btnMoreItem.setOnClickListener(view -> GroupChatPresentationView.this.btnMoreItemsClick()
            );
        }
        if (btnAddMore!= null) {
            btnAddMore.setOnClickListener(view -> GroupChatPresentationView.this.btnAddMoreClick()
            );
        }
        if (btnPenColor!= null) {
            btnPenColor.setOnClickListener(view -> GroupChatPresentationView.this.btnPenColorClick()
            );
        }
        if (btnPenRevoke!= null) {
            btnPenRevoke.setOnClickListener(view -> GroupChatPresentationView.this.btnPenRevokeClick()
            );
        }
    }
    
    void init() {
        dbHandler = DBHandler.getInstance_(getContext());

        groupVideoPreview = PresentationVideoPreview.getInstance_(getContext()) ;
    }

    @Override
    protected IOpenGLView createOpenGlViewManager() {
        return groupVideoPreview;
    }

    @Override
    protected void onInitVideoPreview(int paddingHorizontal, int paddingVertical) {
        groupVideoPreview.setPadding(paddingHorizontal, paddingVertical);
    }

    @Override
    public void onEnter() {
        super.onEnter();
        if (isStartSlideSceneByMe()) {
            sendSlideInfoPeriod();
        }
        groupVideoRequestView.setGroupRequestInfo(getChatEntity());
    }

    @Override
    public void onExit() {
        super.onExit();
        BackgroundExecutor.cancelAll("send_slide_info_period", true);
    }

    void sendSlideInfoPeriod() {
        BackgroundExecutor.execute(this::sendSlideInfoPeriod_,"send_slide_info_period",2000,"", BackgroundExecutor.ThreadType.NETWORK);
    }

    void sendSlideInfoPeriod_() {
		Utils.debug("CallSceneDebug sendSlideInfoPeriod group");
		DuduGroup group = getChatEntity();
		if (null == group || null == currentSceneResource
				|| null == videoSceneInfo) {
            sendSlideInfoPeriod();
			return;
		}
		sceneActions.broadcastSceneUrlInfo(group.getGroupId(),
                videoSceneInfo.getSceneId(),
                currentSceneResource.getPageNumber(),
                currentSceneResource.getTotalPageNumber(),
                currentSceneResource.getUrl());
		sendSlideInfoPeriod();
		Utils.debug("CallSceneDebug sendSlideInfoPeriod group send success");
    }

    @Override
    public void updateVideoSceneInfo(VideoSceneInfo videoSceneInfo) {
        super.updateVideoSceneInfo(videoSceneInfo);
        if (videoSceneInfo != null) {
            DuduGroupContact contact = dbHandler.getGroupContact(videoSceneInfo.getGroupId(), videoSceneInfo.getSponsorId()) ;
            if (contact != null) {
                groupVideoPreview.setPresentId(contact.getInnerId());
            }
        }
    }
    @Subscribe
    public void onGroupVideoInfoResult(OnCreateGroupVideoResult event){
        Utils.debug("GroupVideoView onGroupVideoInfoResult");
        groupVideoPreview.refreshAllMembers(event.getData());
    }
    @Override
    public void memberCameraStatusChange(int innerId, boolean isVideoPause) {
        groupVideoPreview.memberCameraStateChanged(innerId,!isVideoPause);
    }
}
